/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.ws.Holder;
import junit.framework.TestCase;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.NetworkFileServer;
import org.alfresco.jlan.server.filesys.PermissionDeniedException;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

@Category(value={BaseSpringTestsCategory.class})
public class ContentDiskDriverTest
extends TestCase {
    private static final String TEST_PROTOTYPE_NAME = "test";
    private static final String TEST_REMOTE_NAME = "remoteName";
    private static final String TEST_SERVER_NAME = "testServer";
    private static final String TEST_USER_AUTHORITY = "userx";
    private Repository repositoryHelper;
    private CifsHelper cifsHelper;
    private ExtendedDiskInterface driver;
    private NodeService mlAwareNodeService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ContentService contentService;
    private RuleService ruleService;
    private ActionService actionService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private OwnableService ownableService;
    private FileFolderService fileFolderService;
    private CheckOutCheckInService checkOutCheckInService;
    private static Log logger = LogFactory.getLog(ContentDiskDriverTest.class);
    final String SHARE_NAME = "test";
    final String STORE_NAME = "workspace://SpacesStore";
    final String ROOT_PATH = "/app:company_home";
    private ApplicationContext applicationContext;
    private final String TEST_ROOT_PATH = "ContentDiskDriverTest";
    private final String TEST_ROOT_DOS_PATH = "\\ContentDiskDriverTest";

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        ApplicationContextFactory fileServers = (ApplicationContextFactory)this.applicationContext.getBean("fileServers");
        this.cifsHelper = (CifsHelper)fileServers.getApplicationContext().getBean("cifsHelper");
        this.driver = (ExtendedDiskInterface)this.applicationContext.getBean("contentDiskDriver");
        this.mlAwareNodeService = (NodeService)this.applicationContext.getBean("mlAwareNodeService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.ownableService = (OwnableService)this.applicationContext.getBean("ownableService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        ContentDiskDriverTest.assertNotNull((String)"content disk driver is null", (Object)this.driver);
        ContentDiskDriverTest.assertNotNull((String)"repositoryHelper is null", (Object)this.repositoryHelper);
        ContentDiskDriverTest.assertNotNull((String)"mlAwareNodeService is null", (Object)this.mlAwareNodeService);
        ContentDiskDriverTest.assertNotNull((String)"nodeService is null", (Object)this.nodeService);
        ContentDiskDriverTest.assertNotNull((String)"transactionService is null", (Object)this.transactionService);
        ContentDiskDriverTest.assertNotNull((String)"contentService is null", (Object)this.contentService);
        ContentDiskDriverTest.assertNotNull((String)"ruleService is null", (Object)this.ruleService);
        ContentDiskDriverTest.assertNotNull((String)"actionService is null", (Object)this.actionService);
        ContentDiskDriverTest.assertNotNull((String)"cifsHelper", (Object)this.cifsHelper);
        ContentDiskDriverTest.assertNotNull((String)"checkOutCheckInService", (Object)this.checkOutCheckInService);
        AuthenticationUtil.setRunAsUserSystem();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> removeRootCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef rootNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "ContentDiskDriverTest");
                if (rootNode != null) {
                    logger.debug((Object)"Clean up test root node");
                    ContentDiskDriverTest.this.nodeService.deleteNode(rootNode);
                }
                return null;
            }
        };
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)removeRootCB, false, true);
    }

    protected void tearDown() throws Exception {
    }

    private DiskSharedDevice getDiskSharedDevice() throws DeviceContextException {
        ContentContext ctx = new ContentContext("testContext", "workspace://SpacesStore", "/app:company_home", this.repositoryHelper.getCompanyHome());
        DiskSharedDevice share = new DiskSharedDevice(TEST_PROTOTYPE_NAME, (DeviceInterface)this.driver, (DiskDeviceContext)ctx);
        return share;
    }

    public void testGetFileInformation() throws Exception {
        logger.debug((Object)"testGetFileInformation");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        new TestContext();
        org.alfresco.jlan.server.filesys.FileInfo finfo = this.driver.getFileInformation((SrvSession)testSession, testConnection, "");
        ContentDiskDriverTest.assertNotNull((String)"root info is null", (Object)finfo);
        ContentDiskDriverTest.assertEquals((String)"root has a unexpected file name", (String)"", (String)finfo.getFileName());
    }

    public void testCreateFile() throws Exception {
        logger.debug((Object)"testCreatedFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        int openAction = 16;
        FileOpenParams params = new FileOpenParams("\\testCreateFileX.new", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        ContentDiskDriverTest.assertFalse((String)"file is not closed ", (boolean)file.isClosed());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeStuffCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testCreateFileX.new");
                ContentDiskDriverTest.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"content is null", (Object)content);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
        org.alfresco.jlan.server.filesys.FileInfo info = this.driver.getFileInformation((SrvSession)testSession, testConnection, "\\testCreateFileX.new");
        ContentDiskDriverTest.assertNotNull((String)"info is null", (Object)info);
        NodeRef n2 = this.getNodeForPath(testConnection, "\\testCreateFileX.new");
        ContentDiskDriverTest.assertEquals((String)"get Node For Path returned different node", (Object)testContext.testNodeRef, (Object)n2);
        try {
            this.driver.createFile((SrvSession)testSession, testConnection, params);
            ContentDiskDriverTest.fail((String)"File exists not detected");
        }
        catch (FileExistsException fileExistsException) {}
        this.driver.deleteFile((SrvSession)testSession, testConnection, "\\testCreateFileX.new");
        String FILE2_PATH = "\\ContentDiskDriverTest\\testCreateFileX.new";
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", openAction, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        FileOpenParams file2Params = new FileOpenParams(FILE2_PATH, openAction, 0, 128, 0);
        this.driver.createFile((SrvSession)testSession, testConnection, file2Params);
        this.driver.deleteFile((SrvSession)testSession, testConnection, FILE2_PATH);
    }

    public void testDeleteFile() throws Exception {
        logger.debug((Object)"testDeleteFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        int openAction = 16;
        String FILE_PATH = "\\testDeleteFile.new";
        FileOpenParams params = new FileOpenParams(FILE_PATH, openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                file.writeFile(stuff, stuff.length, 0, 0L);
                file.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeStuffCB);
        this.driver.deleteFile((SrvSession)testSession, testConnection, FILE_PATH);
        try {
            this.driver.deleteFile((SrvSession)testSession, testConnection, FILE_PATH);
            ContentDiskDriverTest.fail((String)"delete a non existent file");
        }
        catch (IOException iOException) {}
    }

    public void testSetFileInfo() throws Exception {
        logger.debug((Object)"testSetFileInfo");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        Date now = new Date();
        final Date CREATED = new Date(now.getTime() - 21600000L);
        final Date MODIFIED = new Date(now.getTime() - 3600000L);
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        int openAction = 16;
        try {
            this.driver.deleteFile((SrvSession)testSession, testConnection, "\\testSetFileInfo.txt");
        }
        catch (IOException iOException) {}
        final FileOpenParams params = new FileOpenParams("\\testSetFileInfo.txt", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileInfo.txt");
                info.setFileInformationFlags(8);
                info.setModifyDateTime(MODIFIED.getTime());
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileInfo.txt", info);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeStuffCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileInfo.txt");
                ContentDiskDriverTest.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"content is null", (Object)content);
                Date modified = (Date)ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_MODIFIED);
                ContentDiskDriverTest.assertEquals((String)"modified time not set correctly", (Object)MODIFIED, (Object)modified);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
        logger.debug((Object)"Step 2: Change the created date");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> changeCreatedCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileInfo.txt");
                info.setFileInformationFlags(16);
                info.setCreationDateTime(CREATED.getTime());
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileInfo.txt", info);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)changeCreatedCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCreatedCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileInfo.txt");
                ContentDiskDriverTest.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"content is null", (Object)content);
                Date created = (Date)ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CREATED);
                ContentDiskDriverTest.assertEquals((String)"created time not set correctly", (Object)CREATED, (Object)created);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCreatedCB);
        logger.debug((Object)"Step 3: test deleteOnClose");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOnCloseCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, params);
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileInfo.txt");
                info.setFileInformationFlags(1024);
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileInfo.txt", info);
                file.setDeleteOnClose(true);
                byte[] stuff = "Update".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOnCloseCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateDeleteOnCloseCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileInfo.txt");
                ContentDiskDriverTest.assertNull((String)"can still find new node", (Object)newNode);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateDeleteOnCloseCB);
    }

    public void testOpenFile() throws Exception {
        logger.debug((Object)"testOpenFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testDirNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        testContext.testDirNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest");
        FileOpenParams params = new FileOpenParams("\\ContentDiskDriverTest\\testOpenFile.txt", 16, 2, 128, 0);
        try {
            this.driver.openFile((SrvSession)testSession, testConnection, params);
            ContentDiskDriverTest.fail((String)"managed to open non existant file!");
        }
        catch (IOException iOException) {}
        logger.debug((Object)"Step 2) Open file created by node service");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ChildAssociationRef ref = ContentDiskDriverTest.this.nodeService.createNode(testContext.testDirNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testOpenFile.txt"), ContentModel.TYPE_CONTENT);
                ContentDiskDriverTest.this.nodeService.setProperty(ref.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)"testOpenFile.txt"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        NetworkFile file = this.driver.openFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is closed", (boolean)file.isClosed());
        logger.debug((Object)"Step 3) Open the root directory");
        FileOpenParams rootParams = new FileOpenParams("\\", 16, 2, 128, 0);
        NetworkFile file3 = this.driver.openFile((SrvSession)testSession, testConnection, rootParams);
        ContentDiskDriverTest.assertNotNull((Object)file3);
        ContentDiskDriverTest.assertFalse((String)"file is closed", (boolean)file3.isClosed());
    }

    public void testFileExists() throws Exception {
        logger.debug((Object)"testFileExists");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TestContext() {
            }
        }
        new TestContext();
        logger.debug((Object)"Step 1, negative test dir does not exist");
        int status = this.driver.fileExists((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest");
        ContentDiskDriverTest.assertEquals((int)status, (int)0);
        logger.debug((Object)"Step 2, negative test file does not exist");
        status = this.driver.fileExists((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        ContentDiskDriverTest.assertEquals((int)status, (int)0);
        int openAction = 16;
        FileOpenParams params = new FileOpenParams("\\ContentDiskDriverTest\\testFileExists.new", openAction, 2, 128, 0);
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        final NetworkFile file = this.driver.createFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                file.writeFile(stuff, stuff.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        status = this.driver.fileExists((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        ContentDiskDriverTest.assertEquals((int)status, (int)1);
        logger.debug((Object)"Step 4, successfully delete node");
        this.driver.deleteFile((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        status = this.driver.fileExists((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        ContentDiskDriverTest.assertEquals((int)status, (int)0);
    }

    public void testRenameFile() throws Exception {
        logger.debug((Object)"testRenameFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        FileOpenParams params1 = new FileOpenParams("\\ContentDiskDriverTest\\SourceFile1.new", 0, 2, 128, 0);
        this.driver.createFile((SrvSession)testSession, testConnection, params1);
        FileOpenParams params3 = new FileOpenParams("\\ContentDiskDriverTest\\SourceFile3.new", 0, 2, 128, 0);
        this.driver.createFile((SrvSession)testSession, testConnection, params3);
        try {
            this.driver.renameFile((SrvSession)testSession, testConnection, "\\Wibble\\wobble", "\\ContentDiskDriverTest\\SourceFile1.new");
            ContentDiskDriverTest.fail((String)"rename did not detect missing file");
        }
        catch (IOException iOException) {}
        try {
            this.driver.renameFile((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\wibble\\wobble");
            ContentDiskDriverTest.fail((String)"rename did not detect missing file");
        }
        catch (IOException iOException) {}
        try {
            this.driver.renameFile((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\ContentDiskDriverTest\\SourceFile3.new");
            ContentDiskDriverTest.fail((String)"rename did not detect missing file");
        }
        catch (IOException iOException) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setPropertiesCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile1.new");
                ContentDiskDriverTest.assertNotNull((String)"node ref not found", (Object)file1NodeRef);
                ContentDiskDriverTest.this.nodeService.setProperty(file1NodeRef, ContentModel.PROP_LASTNAME, (Serializable)((Object)"Bloggs"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setPropertiesCB, false, true);
        this.driver.renameFile((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\ContentDiskDriverTest\\SourceFile2.new");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef file2NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile2.new");
                ContentDiskDriverTest.assertEquals((Object)ContentDiskDriverTest.this.nodeService.getProperty(file2NodeRef, ContentModel.PROP_LASTNAME), (Object)"Bloggs");
                ChildAssociationRef parentRef = ContentDiskDriverTest.this.nodeService.getPrimaryParent(file2NodeRef);
                ContentDiskDriverTest.assertTrue((String)"file has wrong assoc local name", (boolean)parentRef.getQName().getLocalName().equals("SourceFile2.new"));
                ContentDiskDriverTest.assertTrue((String)"not primary assoc", (boolean)parentRef.isPrimary());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
        String DIR_NEW_PATH = "\\ContentDiskDriverTest\\NewDir";
        final String NEW_PATH = String.valueOf(DIR_NEW_PATH) + "\\File2";
        FileOpenParams params5 = new FileOpenParams(DIR_NEW_PATH, 0, 2, 128, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, params5);
        final NodeRef newDirNodeRef = this.getNodeForPath(testConnection, DIR_NEW_PATH);
        this.driver.renameFile((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile2.new", NEW_PATH);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep5CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef file5NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, NEW_PATH);
                ChildAssociationRef parentRef5 = ContentDiskDriverTest.this.nodeService.getPrimaryParent(file5NodeRef);
                ContentDiskDriverTest.assertTrue((boolean)parentRef5.getParentRef().equals((Object)newDirNodeRef));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep5CB, false, true);
    }

    public void testScenarioRenameVersionableFile() throws Exception {
        logger.debug((Object)"testScenarioRenameVersionableFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TestContext() {
            }
        }
        new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        FileOpenParams params1 = new FileOpenParams("\\ContentDiskDriverTest\\SourceFile1.new", 0, 2, 128, 0);
        this.driver.createFile((SrvSession)testSession, testConnection, params1);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> makeVersionableCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile1.new");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = ContentDiskDriverTest.this.contentService.getWriter(file1NodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("test rename versionable");
                ContentDiskDriverTest.this.nodeService.setProperty(file1NodeRef, ContentModel.PROP_LASTNAME, (Serializable)((Object)"Bloggs"));
                ContentDiskDriverTest.this.nodeService.setProperty(file1NodeRef, TransferModel.PROP_ENDPOINT_PROTOCOL, (Serializable)((Object)"http"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)makeVersionableCB, false, true);
        this.driver.renameFile((SrvSession)testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\ContentDiskDriverTest\\SourceFile2.new");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateVersionableCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef file2NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile2.new");
                ContentDiskDriverTest.assertNotNull((String)"file2 node ref is null", (Object)file2NodeRef);
                ContentDiskDriverTest.assertTrue((String)"does not have versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(file2NodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertTrue((String)"sample property is null", (ContentDiskDriverTest.this.nodeService.getProperty(file2NodeRef, TransferModel.PROP_ENDPOINT_PROTOCOL) != null ? 1 : 0) != 0);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateVersionableCB, false, true);
    }

    public void testScenarioMSWord2003SaveShuffle() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffle");
        final QName RESIDUAL_MTTEXT = QName.createQName((String)"{gsxhjsx}", (String)"whatever");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NetworkFile oldFileHandle;
            NodeRef testNodeRef;
            Serializable testCreatedDate;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"Fred"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Test document"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"This is a test document to test CIFS shuffle"));
                MLText mltext = new MLText();
                mltext.addValue(Locale.FRENCH, "Bonjour");
                mltext.addValue(Locale.ENGLISH, "Hello");
                mltext.addValue(Locale.ITALY, "Buongiorno");
                ContentDiskDriverTest.this.mlAwareNodeService.setProperty(testContext.testNodeRef, RESIDUAL_MTTEXT, (Serializable)mltext);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_CLASSIFIABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "MS Word 2003 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                testContext.testCreatedDate = ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_CREATED);
                MLText multi = (MLText)ContentDiskDriverTest.this.mlAwareNodeService.getProperty(testContext.testNodeRef, RESIDUAL_MTTEXT);
                multi.getValues();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2003 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRL0002.TMP");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                }
                catch (IOException iOException) {}
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateOldFileGoneCB, false, true);
        logger.debug((Object)"Shuffle step next");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"end of shuffle step");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertTrue((boolean)props.containsKey(RESIDUAL_MTTEXT));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"TEST.DOC", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                ContentDiskDriverTest.assertEquals((String)"title wrong", (Object)"Test document", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"description wrong", (Object)"This is a test document to test CIFS shuffle", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_DESCRIPTION));
                ContentDiskDriverTest.this.mlAwareNodeService.getProperties(shuffledNodeRef);
                MLText multi = (MLText)ContentDiskDriverTest.this.mlAwareNodeService.getProperty(shuffledNodeRef, RESIDUAL_MTTEXT);
                ContentDiskDriverTest.assertTrue((String)"MLText has lost values", (multi.getValues().size() > 2 ? 1 : 0) != 0);
                ContentDiskDriverTest.assertEquals((String)"creation date not preserved", (long)((Date)testContext.testCreatedDate).getTime(), (long)((Date)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_CREATED)).getTime());
                ContentDiskDriverTest.assertEquals((String)"ADDRESSEE PROPERTY Not copied", (Object)"Fred", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_ADDRESSEE));
                ContentDiskDriverTest.assertTrue((String)"CLASSIFIABLE aspect not present", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_CLASSIFIABLE));
                ContentDiskDriverTest.assertEquals((String)"noderef changed", (Object)testContext.testNodeRef, (Object)shuffledNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRL0002.TMP");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
    }

    public void testScenarioMSWord2003SaveShuffleWithBackup() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffleWithBackup");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"Fred"));
                ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_CREATED);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_CLASSIFIABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "MS Word 2003 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2003 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\Backup of TEST.DOC");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                }
                catch (IOException iOException) {}
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateOldFileGoneCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"TEST.DOC", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testScenarioMSWord2007Save() throws Exception {
        logger.debug((Object)"testScenarioMSWord2007SaveShuffle");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2007Save", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "MS Word 2007 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\19ECA1A.tmp", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2007 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX", "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\788A1D3D.tmp");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\19ECA1A.tmp", "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\788A1D3D.tmp");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"TEST.DOCX", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void DISABLED_testScenarioEmacsSave() throws Exception {
        logger.debug((Object)"testScenarioEmacsSave");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioEmacsSave", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "Emacs shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt", "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt~");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "EMACS shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
    }

    public void testScenarioViSave() throws Exception {
        logger.debug((Object)"testScenarioViSave");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioViSave", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "Emacs shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt", "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt~");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "Vi shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.newFileHandle);
                logger.debug((Object)"delete temporary file - which will trigger shuffle");
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt~");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt");
                ContentDiskDriverTest.assertNotNull((String)"shuffledNodeRef is null", (Object)shuffledNodeRef);
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"viTest.txt", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
    }

    public void testScenarioSmultronSave() throws Exception {
        logger.debug((Object)"testScenarioSmultronSave");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioSmultronSave", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "Smultron shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioSmultronSave\\.dat04cd.004", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "Smultron shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.newFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\.dat04cd.004", "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"smultronTest.txt", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
    }

    public void testScenarioDeleteViaNodeService() throws Exception {
        logger.debug((Object)"testScenarioDeleteViaNodeService");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        int openAction = 16;
        FileOpenParams params = new FileOpenParams("\\testDeleteFileViaNodeService.new", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                file.writeFile(stuff, stuff.length, 0, 0L);
                file.close();
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testDeleteFileViaNodeService.new");
                ContentDiskDriverTest.assertNotNull((String)"can't find new node", (Object)newNode);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testDeleteFileViaNodeService.new");
                ContentDiskDriverTest.assertNotNull((String)"can't find new node", (Object)newNode);
                ContentDiskDriverTest.this.nodeService.deleteNode(newNode);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNodeCB, false, true);
        try {
            this.getNodeForPath(testConnection, "\\testDeleteFileViaNodeService.new");
            ContentDiskDriverTest.fail((String)"getNode for path unexpectedly succeeded");
        }
        catch (IOException iOException) {}
        try {
            this.driver.deleteFile((SrvSession)testSession, testConnection, "\\testDeleteFileViaNodeService.new");
            ContentDiskDriverTest.fail((String)"delete unexpectedly succeeded");
        }
        catch (IOException iOException) {}
    }

    public void testMetadataExtraction() throws Exception {
        logger.debug((Object)"testMetadataExtraction");
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef testNodeRef;
            NetworkFile firstFileHandle;
            NetworkFile secondFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteDirectory(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction");
                return null;
            }
        };
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageDirCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"create Test directory\\ContentDiskDriverTest\\testMetadataExtraction");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtraction", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                testContext.testDirNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction");
                ContentDiskDriverTest.assertNotNull((String)"testDirNodeRef is null", (Object)testContext.testDirNodeRef);
                ContentDiskDriverTest.this.transactionService.getUserTransaction();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestDirCB);
        logger.debug((Object)"Create rule on test dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createRuleCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.applyToChildren(true);
                rule.setRuleDisabled(false);
                rule.setTitle("Extract Metadata from content");
                rule.setDescription("ContentDiskDriverTest");
                HashMap props = new HashMap(1);
                Action extractAction = ContentDiskDriverTest.this.actionService.createAction("extract-metadata", props);
                ActionCondition noCondition1 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                extractAction.addActionCondition(noCondition1);
                ActionCondition noCondition2 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                CompositeAction compAction = ContentDiskDriverTest.this.actionService.createCompositeAction();
                compAction.setTitle("Extract Metadata");
                compAction.setDescription("Content Disk Driver Test - Extract Metadata");
                compAction.addAction(extractAction);
                compAction.addActionCondition(noCondition2);
                rule.setAction((Action)compAction);
                ContentDiskDriverTest.this.ruleService.saveRule(testContext.testDirNodeRef, rule);
                logger.debug((Object)"rule created");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createRuleCB, false, true);
        logger.debug((Object)"create test file in test directory");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNodeRef);
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"step b: write content to test file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest1.docx");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest1.docx", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                logger.debug((Object)"close the file, firstFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        Thread.sleep(3000L);
        logger.debug((Object)"Step c: validate metadata has been extracted.");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(testContext.testNodeRef);
                ContentDiskDriverTest.assertTrue((String)"Enabled property has been lost", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)11302L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)data.getMimetype());
                ContentDiskDriverTest.assertEquals((String)"description is not correct", (Object)"This is a test file", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION));
                ContentDiskDriverTest.assertEquals((String)"title is not correct", (Object)"ContentDiskDriverTest", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"author is not correct", (Object)"mrogers", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_AUTHOR));
                return null;
            }
        });
        logger.debug((Object)"Step d: create update file in test directory ~WRD0003.TMP");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createUpdateFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtraction\\~WRD0003.TMP", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.secondFileHandle);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createUpdateFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFile2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest2.docx");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest2.docx", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.secondFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFile2CB, false, true);
        logger.debug((Object)"move old file out of the way.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx", "\\ContentDiskDriverTest\\testMetadataExtraction\\~WRL0003.TMP");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                }
                catch (IOException iOException) {}
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateOldFileGoneCB, false, true);
        logger.debug((Object)"move new file into place.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\~WRD0003.TMP", "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"validate update has run correctly.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateUpdateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)data.getMimetype());
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)11265L, (long)data.getSize());
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateUpdateCB, true, true);
    }

    public void testMetadataExtractionForMac() throws Exception {
        logger.debug((Object)"testMetadataExtractionForMac");
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef testNodeRef;
            NetworkFile firstFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteDirectory(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtractionForMac");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageDirCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"create Test directory\\ContentDiskDriverTest\\testMetadataExtractionForMac");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtractionForMac", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                testContext.testDirNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtractionForMac");
                ContentDiskDriverTest.assertNotNull((String)"testDirNodeRef is null", (Object)testContext.testDirNodeRef);
                ContentDiskDriverTest.this.transactionService.getUserTransaction();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestDirCB);
        logger.debug((Object)"Create rule on test dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createRuleCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Rule rule = new Rule();
                rule.setRuleType("update");
                rule.applyToChildren(true);
                rule.setRuleDisabled(false);
                rule.setTitle("Extract Metadata from update content");
                rule.setDescription("ContentDiskDriverTest");
                HashMap props = new HashMap(1);
                Action extractAction = ContentDiskDriverTest.this.actionService.createAction("extract-metadata", props);
                ActionCondition noCondition1 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                extractAction.addActionCondition(noCondition1);
                ActionCondition noCondition2 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                CompositeAction compAction = ContentDiskDriverTest.this.actionService.createCompositeAction();
                compAction.setTitle("Extract Metadata");
                compAction.setDescription("Content Disk Driver Test - Extract Metadata");
                compAction.addAction(extractAction);
                compAction.addActionCondition(noCondition2);
                rule.setAction((Action)compAction);
                ContentDiskDriverTest.this.ruleService.saveRule(testContext.testDirNodeRef, rule);
                logger.debug((Object)"rule created");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createRuleCB, false, true);
        logger.debug((Object)"create test file in test directory");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtractionForMac\\Word Work File D_1725484373.tmp", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((String)"first file Handle is null", (Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtractionForMac\\Word Work File D_1725484373.tmp");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNodeRef);
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.assertTrue((String)"temporary aspect not applied", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testNodeRef, ContentModel.ASPECT_TEMPORARY));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"step b: write content to test file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest1.docx");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest1.docx", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"Step b: rename the test file.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtractionForMac\\Word Work File D_1725484373.tmp", "\\ContentDiskDriverTest\\testMetadataExtractionForMac\\ContentDiskDriver.docx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        Thread.sleep(3000L);
        logger.debug((Object)"Step c: validate metadata has been extracted.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateFirstExtractionCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(testContext.testNodeRef);
                ContentDiskDriverTest.assertTrue((String)"Enabled property has been lost", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertTrue((String)"temporary aspect has not been removed", (!ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testNodeRef, ContentModel.ASPECT_TEMPORARY) ? 1 : 0) != 0);
                ContentDiskDriverTest.assertTrue((String)"hidden aspect has not been removed", (!ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testNodeRef, ContentModel.ASPECT_HIDDEN) ? 1 : 0) != 0);
                ContentDiskDriverTest.assertEquals((String)"description is not correct", (Object)"This is a test file", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION));
                ContentDiskDriverTest.assertEquals((String)"title is not correct", (Object)"ContentDiskDriverTest", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"author is not correct", (Object)"mrogers", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_AUTHOR));
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)data.getMimetype());
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)11302L, (long)data.getSize());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateFirstExtractionCB, false, true);
    }

    public void testDirListing() throws Exception {
        logger.debug((Object)"testDirListing");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final String FOLDER_NAME = "parentFolder" + System.currentTimeMillis();
        final String HIDDEN_FOLDER_NAME = "hiddenFolder" + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodesCB = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef parentNode = ContentDiskDriverTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)FOLDER_NAME), ContentModel.TYPE_FOLDER).getChildRef();
                ContentDiskDriverTest.this.nodeService.setProperty(parentNode, ContentModel.PROP_NAME, (Serializable)((Object)FOLDER_NAME));
                NodeRef hiddenNode = ContentDiskDriverTest.this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)HIDDEN_FOLDER_NAME), ForumModel.TYPE_FORUM).getChildRef();
                ContentDiskDriverTest.this.nodeService.setProperty(hiddenNode, ContentModel.PROP_NAME, (Serializable)((Object)HIDDEN_FOLDER_NAME));
                return parentNode;
            }
        };
        final NodeRef parentFolder = (NodeRef)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodesCB);
        ArrayList<String> excludedTypes = new ArrayList<String>();
        excludedTypes.add(ForumModel.TYPE_FORUM.toString());
        this.cifsHelper.setExcludedTypes(excludedTypes);
        SearchContext result = this.driver.startSearch((SrvSession)testSession, testConnection, "\\" + FOLDER_NAME + "\\*", 0);
        while (result.hasMoreFiles()) {
            if (!result.nextFileName().equals(HIDDEN_FOLDER_NAME)) continue;
            ContentDiskDriverTest.fail((String)"Exluded types mustn't be shown in cifs");
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.nodeService.deleteNode(parentFolder);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNodeCB, false, true);
    }

    public void testFileInformationUpdatingByEditorUserForAlf8808() throws Exception {
        final Holder editorFolder = new Holder();
        final Holder testFile = new Holder();
        ServerConfiguration config = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer server = new TestServer(TEST_SERVER_NAME, config);
        DiskSharedDevice device = this.getDiskSharedDevice();
        final TreeConnection treeConnection = server.getTreeConnection((SharedDevice)device);
        final ExtendedDiskInterface deviceInterface = (ExtendedDiskInterface)treeConnection.getInterface();
        final TestSrvSession session = new TestSrvSession(13, (NetworkServer)server, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                block21: {
                    try {
                        NodeRef rootNode = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                        ContentDiskDriverTest.this.createUser(ContentDiskDriverTest.TEST_USER_AUTHORITY, ContentDiskDriverTest.TEST_USER_AUTHORITY, rootNode);
                        editorFolder.value = (FileInfo)ContentDiskDriverTest.this.getOrCreateNode(rootNode, "Editor", ContentModel.TYPE_FOLDER).getFirst();
                        testFile.value = (FileInfo)ContentDiskDriverTest.this.getOrCreateNode(rootNode, "Test.txt", ContentModel.TYPE_CONTENT).getFirst();
                        ContentDiskDriverTest.this.permissionService.setPermission(((FileInfo)testFile.value).getNodeRef(), ContentDiskDriverTest.TEST_USER_AUTHORITY, "Editor", true);
                        try {
                            final org.alfresco.jlan.server.filesys.FileInfo updatedInfo = new org.alfresco.jlan.server.filesys.FileInfo();
                            updatedInfo.setFileName(((FileInfo)testFile.value).getName());
                            updatedInfo.setFileId(DefaultTypeConverter.INSTANCE.intValue(((FileInfo)testFile.value).getProperties().get(ContentModel.PROP_NODE_DBID)));
                            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                                public Void doWork() throws Exception {
                                    deviceInterface.setFileInformation(session, treeConnection, ((FileInfo)testFile.value).getName(), updatedInfo);
                                    return null;
                                }
                            }, (String)ContentDiskDriverTest.TEST_USER_AUTHORITY);
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof AccessDeniedException) {
                                ContentDiskDriverTest.fail((String)("For user='userx' " + e.getCause().toString()));
                                break block21;
                            }
                            ContentDiskDriverTest.fail((String)("Unexpected exception was caught: " + e.toString()));
                        }
                    }
                    catch (Throwable throwable) {
                        if (ContentDiskDriverTest.this.authenticationService.authenticationExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                            ContentDiskDriverTest.this.authenticationService.deleteAuthentication(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                        }
                        if (ContentDiskDriverTest.this.personService.personExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                            ContentDiskDriverTest.this.personService.deletePerson(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                        }
                        try {
                            if (testFile.value != null) {
                                ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)testFile.value).getNodeRef());
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (editorFolder.value != null) {
                                ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)editorFolder.value).getNodeRef());
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                if (ContentDiskDriverTest.this.authenticationService.authenticationExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                    ContentDiskDriverTest.this.authenticationService.deleteAuthentication(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                }
                if (ContentDiskDriverTest.this.personService.personExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                    ContentDiskDriverTest.this.personService.deletePerson(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                }
                try {
                    if (testFile.value != null) {
                        ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)testFile.value).getNodeRef());
                    }
                }
                catch (Exception exception) {}
                try {
                    if (editorFolder.value != null) {
                        ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)editorFolder.value).getNodeRef());
                    }
                }
                catch (Exception exception) {}
                return null;
            }
        }, false, true);
    }

    private Pair<FileInfo, Boolean> getOrCreateNode(NodeRef parentRef, String name, QName type) {
        NodeRef result = this.nodeService.getChildByName(parentRef, ContentModel.ASSOC_CONTAINS, name);
        Boolean created = false;
        if (result == null) {
            result = this.nodeService.getChildByName(parentRef, ContentModel.ASSOC_CHILDREN, name);
        }
        if ((created = Boolean.valueOf(result == null)).booleanValue()) {
            result = this.fileFolderService.create(parentRef, name, type).getNodeRef();
        }
        return new Pair((Object)this.fileFolderService.getFileInfo(result), (Object)created);
    }

    private void createUser(String name, String password, NodeRef parentNodeRef) {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, name);
        Pair<FileInfo, Boolean> userHome = this.getOrCreateNode(parentNodeRef, name, ContentModel.TYPE_FOLDER);
        if (((Boolean)userHome.getSecond()).booleanValue()) {
            NodeRef nodeRef = ((FileInfo)userHome.getFirst()).getNodeRef();
            this.permissionService.setPermission(nodeRef, name, this.permissionService.getAllPermission(), true);
            this.permissionService.setPermission(nodeRef, this.permissionService.getAllAuthorities(), "Consumer", true);
            this.permissionService.setPermission(nodeRef, this.permissionService.getOwnerAuthority(), this.permissionService.getAllPermission(), true);
            this.ownableService.setOwner(nodeRef, name);
            this.permissionService.setInheritParentPermissions(nodeRef, false);
            properties.put(ContentModel.PROP_HOMEFOLDER, (String)nodeRef);
            if (!this.personService.personExists(name)) {
                this.personService.createPerson(properties);
            }
            if (!this.authenticationService.authenticationExists(name)) {
                this.authenticationService.createAuthentication(name, password.toCharArray());
            }
        }
    }

    public void testExcel2003SaveShuffle() throws Exception {
        logger.debug((Object)"testScenarioExcel2003SaveShuffle");
        final QName RESIDUAL_MTTEXT = QName.createQName((String)"{gsxhjsx}", (String)"whatever");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NetworkFile oldFileHandle;
            NodeRef testNodeRef;
            Serializable testCreatedDate;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"Fred"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Cherries"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"This is a test document to test CIFS shuffle"));
                MLText mltext = new MLText();
                mltext.addValue(Locale.FRENCH, "Bonjour");
                mltext.addValue(Locale.ENGLISH, "Hello");
                mltext.addValue(Locale.ITALY, "Buongiorno");
                ContentDiskDriverTest.this.mlAwareNodeService.setProperty(testContext.testNodeRef, RESIDUAL_MTTEXT, (Serializable)mltext);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_CLASSIFIABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "MS Excel 2003 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                testContext.testCreatedDate = ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_CREATED);
                MLText multi = (MLText)ContentDiskDriverTest.this.mlAwareNodeService.getProperty(testContext.testNodeRef, RESIDUAL_MTTEXT);
                multi.getValues();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\5EE27100", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2003 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls", "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls~RF172f241.TMP");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls");
                }
                catch (IOException iOException) {}
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateOldFileGoneCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\5EE27100", "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertTrue((boolean)props.containsKey(RESIDUAL_MTTEXT));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"Cherries.xls", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                ContentDiskDriverTest.assertEquals((String)"title wrong", (Object)"Cherries", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"description wrong", (Object)"This is a test document to test CIFS shuffle", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_DESCRIPTION));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2003SaveShuffle\\Cherries.xls~RF172f241.TMP");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
    }

    public void testExcel2013SaveShuffle() throws Exception {
        logger.debug((Object)"testScenarioExcel2013SaveShuffle");
        class TestContext {
            NetworkFile firstFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createOriginalFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                String testContent = "MS Word 2013 shuffle test. This is first file content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentDiskDriverTest.this.nodeService.removeAspect(testContext.testNodeRef, ContentModel.ASPECT_NO_CONTENT);
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Original"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createOriginalFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createUsedTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\~herries.tmp", 0, 2, 128, 0);
                NetworkFile fileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)fileHandle);
                String testContent = "MS Word 2013 shuffle test. This is used file content";
                byte[] testContentBytes = testContent.getBytes();
                fileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                fileHandle.close();
                NodeRef usedRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\~herries.tmp");
                ContentDiskDriverTest.this.nodeService.addAspect(usedRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentDiskDriverTest.this.nodeService.removeAspect(usedRef, ContentModel.ASPECT_NO_CONTENT);
                ContentDiskDriverTest.this.nodeService.setProperty(usedRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Used"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createUsedTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createUnusedTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx~RF172f241.TMP", 0, 2, 128, 0);
                NetworkFile unusedFile = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)unusedFile);
                NodeRef unusedNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx~RF172f241.TMP");
                ContentDiskDriverTest.this.nodeService.addAspect(unusedNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentDiskDriverTest.this.nodeService.setProperty(unusedNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(unusedNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Unused"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createUnusedTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteUnusedFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx~RF172f241.TMP");
                }
                catch (IOException iOException) {}
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteUnusedFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameToUnusedFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx", "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx~RF172f241.TMP");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameToUnusedFileCB, false, true);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteUnusedFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameToUsedFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\~herries.tmp", "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameToUsedFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2013SaveShuffle\\Cherries.xlsx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertTrue((String)"node doesn't contain property 'TITLE'", (boolean)props.containsKey(ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"propety 'TITLE' isn't correct", (Object)"Original", props.get(ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"Cherries.xlsx", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testCSVExcel2003SaveShuffle() throws Exception {
        logger.debug((Object)"testCSVExcel2003SaveShuffle");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;
            Serializable testCreatedDate;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestFileFirstTime = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"csv"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"This is a test document to test CIFS shuffle"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestFileFirstTime, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeToTestFileAndAddVersionableAspect = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String testContent = "MS Excel 2003 for CSV shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                testContext.testCreatedDate = ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_CREATED);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, Collections.singletonMap(ContentModel.PROP_VERSION_TYPE, VersionType.MINOR));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeToTestFileAndAddVersionableAspect, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameTestFileToTemp = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv", "\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\AAAA0000");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameTestFileToTemp, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestFileOneMore = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FileOpenParams params = new FileOpenParams("\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv", 2, 2, 128, 0);
                NetworkFile file = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, params);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestFileOneMore, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeUpdate = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2003 for CSV shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeUpdate, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validate = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv");
                ContentDiskDriverTest.assertTrue((String)"VERSIONABLE aspect not present", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"nodeRef changed", (Object)testContext.testNodeRef, (Object)shuffledNodeRef);
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"csv.csv", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                ContentDiskDriverTest.assertEquals((String)"title wrong", (Object)"csv", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_TITLE));
                ContentDiskDriverTest.assertEquals((String)"description wrong", (Object)"This is a test document to test CIFS shuffle", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_DESCRIPTION));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validate, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteTestFile = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMSExcel2003CSVShuffle\\csv.csv");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTestFile, false, true);
    }

    public void testScenarioMSWord2003SaveAsShuffle() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffle");
        class TestContext {
            NetworkFile firstFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.wbk");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testScenarioOpenCloseFile() throws Exception {
        logger.debug((Object)"start of testScenarioOpenCloseFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef targetNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        testContext.testDirNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioOpenFile.txt");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"Step 1) Create File and Open file created by node service");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                logger.debug((Object)"create file and close it immediatly");
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFile.txt", 0, 2, 128, 0);
                NetworkFile dummy = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertFalse((String)"file is closed after create", (boolean)dummy.isClosed());
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, dummy);
                logger.debug((Object)"after create and close");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        testContext.targetNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioOpenFile.txt");
        FileOpenParams openRO = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFile.txt", 16, 0, 128, 0);
        FileOpenParams openRW = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFile.txt", 16, 2, 128, 0);
        logger.debug((Object)"open file1 read only");
        NetworkFile file1 = this.driver.openFile((SrvSession)testSession, testConnection, openRO);
        ContentDiskDriverTest.assertNotNull((Object)file1);
        ContentDiskDriverTest.assertFalse((String)"file1 is closed", (boolean)file1.isClosed());
        byte[] stuff = "Yankee doodle went to town".getBytes("UTF-8");
        try {
            this.driver.writeFile((SrvSession)testSession, testConnection, file1, stuff, 0, stuff.length, 0L);
            ContentDiskDriverTest.fail((String)"can write to a read only file!");
        }
        catch (Exception exception) {}
        logger.debug((Object)"open file 2 for read write");
        NetworkFile file2 = this.driver.openFile((SrvSession)testSession, testConnection, openRW);
        ContentDiskDriverTest.assertNotNull((Object)file2);
        ContentDiskDriverTest.assertFalse((String)"file is closed", (boolean)file2.isClosed());
        this.driver.writeFile((SrvSession)testSession, testConnection, file2, stuff, 0, stuff.length, 0L);
        NetworkFile file3 = this.driver.openFile((SrvSession)testSession, testConnection, openRW);
        ContentDiskDriverTest.assertNotNull((Object)file3);
        logger.debug((Object)"first close");
        this.driver.closeFile((SrvSession)testSession, testConnection, file2);
        logger.debug((Object)"second close");
        this.driver.closeFile((SrvSession)testSession, testConnection, file3);
        logger.debug((Object)"this is a negative test - should do nothing");
        this.driver.closeFile((SrvSession)testSession, testConnection, file1);
        logger.debug((Object)"now validate");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(testContext.targetNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"data wrong length", (long)"Yankee doodle went to town".length(), (long)data.getSize());
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(testContext.targetNodeRef, ContentModel.PROP_CONTENT);
                String s = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"content not written", (String)"Yankee doodle went to town", (String)s);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testScenarioOpenCloseFileTwo() throws Exception {
        logger.debug((Object)"start of testScenarioOpenCloseFileTwo");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef targetNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        testContext.testDirNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioOpenFileTwo.txt");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"Step 1) Create File and Open file created by node service");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                logger.debug((Object)"create file and close it immediatly");
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFileTwo.txt", 0, 2, 128, 0);
                NetworkFile dummy = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, dummy);
                logger.debug((Object)"after create and close");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        testContext.targetNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioOpenFileTwo.txt");
        FileOpenParams openRO = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFileTwo.txt", 16, 0, 128, 0);
        FileOpenParams openRW = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFileTwo.txt", 16, 2, 128, 0);
        logger.debug((Object)"open file1 read only");
        NetworkFile file1 = this.driver.openFile((SrvSession)testSession, testConnection, openRW);
        ContentDiskDriverTest.assertNotNull((Object)file1);
        byte[] stuff = "Yankee doodle went to town, riding on a donkey.".getBytes("UTF-8");
        this.driver.writeFile((SrvSession)testSession, testConnection, file1, stuff, 0, stuff.length, 0L);
        logger.debug((Object)"open file 2 for read only");
        NetworkFile file2 = this.driver.openFile((SrvSession)testSession, testConnection, openRO);
        ContentDiskDriverTest.assertNotNull((Object)file2);
        ContentDiskDriverTest.assertTrue((String)"file size is 0", (file2.getFileSize() > 0L ? 1 : 0) != 0);
        this.driver.writeFile((SrvSession)testSession, testConnection, file1, stuff, 0, stuff.length, 0L);
        logger.debug((Object)"first close");
        this.driver.closeFile((SrvSession)testSession, testConnection, file2);
        logger.debug((Object)"second close");
        this.driver.closeFile((SrvSession)testSession, testConnection, file1);
        logger.debug((Object)"now validate");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(testContext.targetNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"data wrong length", (long)"Yankee doodle went to town, riding on a donkey.".length(), (long)data.getSize());
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(testContext.targetNodeRef, ContentModel.PROP_CONTENT);
                String s = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"content not written", (String)"Yankee doodle went to town, riding on a donkey.", (String)s);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testOpenCloseVersionableFile() throws Exception {
        logger.debug((Object)"testOpenCloseVersionableFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TestContext() {
            }
        }
        new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory((SrvSession)testSession, testConnection, dirParams);
        FileOpenParams params1 = new FileOpenParams("\\ContentDiskDriverTest\\OpenCloseFile.new", 0, 2, 128, 0);
        NetworkFile file1 = this.driver.createFile((SrvSession)testSession, testConnection, params1);
        this.driver.closeFile((SrvSession)testSession, testConnection, file1);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> makeVersionableCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\OpenCloseFile.new");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = ContentDiskDriverTest.this.contentService.getWriter(file1NodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("test open close versionable node");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)makeVersionableCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<String> readVersionCB = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\OpenCloseFile.new");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"versionable aspect not present", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                props.get(ContentModel.PROP_VERSION_LABEL);
                return (String)props.get(ContentModel.PROP_VERSION_LABEL);
            }
        };
        String version = (String)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readVersionCB, false, true);
        NetworkFile file = this.driver.openFile((SrvSession)testSession, testConnection, params1);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        this.driver.closeFile((SrvSession)testSession, testConnection, file);
        String version2 = (String)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readVersionCB, false, true);
        ContentDiskDriverTest.assertEquals((String)"version has incremented", (String)version, (String)version2);
        file = this.driver.openFile((SrvSession)testSession, testConnection, params1);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        byte[] stuff = "Hello World".getBytes();
        this.driver.writeFile((SrvSession)testSession, testConnection, file, stuff, 0, stuff.length, 0L);
        this.driver.closeFile((SrvSession)testSession, testConnection, file);
        String version3 = (String)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readVersionCB, false, true);
        ContentDiskDriverTest.assertFalse((String)"version not incremented", (boolean)version.equals(version3));
    }

    public void testScenarioFrameMakerShuffle() throws Exception {
        logger.debug((Object)"testScenarioFramemakerShuffle");
        class TestContext {
            NetworkFile firstFileHandle;
            String mimetype;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioFramemakerShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ClassPathResource fileResource = new ClassPathResource("filesys/X1.fm");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/X1.fm", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm.C29", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/X2.fm");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/X2.fm", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(file1NodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)166912L, (long)data.getSize());
                testContext.mimetype = data.getMimetype();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm", "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.backup.fm");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm.C29", "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.backup.fm");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)123904L, (long)data.getSize());
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                ContentDiskDriverTest.assertTrue((String)"file has lost versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)testContext.mimetype, (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testZeroByteRules() throws Exception {
        logger.debug((Object)"testZeroByteRules");
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef testZeroNodeRef;
            NodeRef testNonZeroNodeRef;
            NetworkFile firstFileHandle;
            NetworkFile secondFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteDirectory(testSession, testConnection, "\\ContentDiskDriverTest\\testZeroByteRules");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageDirCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"create Test directory\\ContentDiskDriverTest\\testZeroByteRules");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testZeroByteRules", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                testContext.testDirNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testZeroByteRules");
                ContentDiskDriverTest.assertNotNull((String)"testDirNodeRef is null", (Object)testContext.testDirNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestDirCB);
        logger.debug((Object)"Create rule on test dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createRuleCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.applyToChildren(true);
                rule.setRuleDisabled(false);
                rule.setTitle("Make Versionable");
                rule.setDescription("ContentDiskDriverTest Test Zero Byte files");
                HashMap<String, QName> props = new HashMap<String, QName>(1);
                props.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
                Action addVersionable = ContentDiskDriverTest.this.actionService.createAction("add-features", props);
                ActionCondition noCondition1 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                addVersionable.addActionCondition(noCondition1);
                ActionCondition noCondition2 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                CompositeAction compAction = ContentDiskDriverTest.this.actionService.createCompositeAction();
                compAction.setTitle("Make Versionablea");
                compAction.setDescription("Add Aspect - Versionable");
                compAction.addAction(addVersionable);
                compAction.addActionCondition(noCondition2);
                rule.setAction((Action)compAction);
                ContentDiskDriverTest.this.ruleService.saveRule(testContext.testDirNodeRef, rule);
                logger.debug((Object)"add aspect versionable rule created");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createRuleCB, false, true);
        logger.debug((Object)"create test file in test directory");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testZeroByteRules\\Zero.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testZeroByteRules\\Zero.docx");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testZeroNodeRef);
                FileOpenParams createFileParams2 = new FileOpenParams("\\ContentDiskDriverTest\\testZeroByteRules\\NonZero.docx", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams2);
                ContentDiskDriverTest.assertNotNull((Object)testContext.secondFileHandle);
                testContext.testNonZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testZeroByteRules\\NonZero.docx");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNonZeroNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"step b: close the file with zero byte content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                logger.debug((Object)"close the file, firstFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.secondFileHandle, stuff, 0, stuff.length, 0L);
                logger.debug((Object)"close the second non zero file, secondFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"Step c: validate versioble aspect has been applied.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateFirstExtractionCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.assertTrue((String)"versionable aspect not applied to non zero file.", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testNonZeroNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertTrue((String)"versionable aspect not applied to zero byte file.", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testZeroNodeRef, ContentModel.ASPECT_VERSIONABLE));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateFirstExtractionCB, false, true);
    }

    public void testEmptyContent() throws Exception {
        logger.debug((Object)"testEmptyContent");
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef testZeroNodeRef;
            NodeRef testNonZeroNodeRef;
            NetworkFile firstFileHandle;
            NetworkFile secondFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteDirectory(testSession, testConnection, "\\ContentDiskDriverTest\\testEmptyContent");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageDirCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"create Test directory\\ContentDiskDriverTest\\testEmptyContent");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testEmptyContent", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                testContext.testDirNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testEmptyContent");
                ContentDiskDriverTest.assertNotNull((String)"testDirNodeRef is null", (Object)testContext.testDirNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestDirCB);
        logger.debug((Object)"create test file in test directory");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testEmptyContent\\Zero.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testEmptyContent\\Zero.docx");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testZeroNodeRef);
                logger.debug((Object)"close the file, firstFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                FileOpenParams createFileParams2 = new FileOpenParams("\\ContentDiskDriverTest\\testEmptyContent\\NonZero.docx", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams2);
                ContentDiskDriverTest.assertNotNull((Object)testContext.secondFileHandle);
                testContext.testNonZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testEmptyContent\\NonZero.docx");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNonZeroNodeRef);
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.secondFileHandle, stuff, 0, stuff.length, 0L);
                logger.debug((Object)"close the second non zero file, secondFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkContentPropsCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.assertNotNull((String)"content missing create non zero file.", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNonZeroNodeRef, ContentModel.PROP_CONTENT));
                ContentDiskDriverTest.assertNotNull((String)"content missing create zero byte file.", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testZeroNodeRef, ContentModel.PROP_CONTENT));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkContentPropsCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> truncateFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams2 = new FileOpenParams("\\ContentDiskDriverTest\\testEmptyContent\\NonZero.docx", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, createFileParams2);
                ContentDiskDriverTest.assertNotNull((Object)testContext.secondFileHandle);
                testContext.testNonZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testEmptyContent\\NonZero.docx");
                ContentDiskDriverTest.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNonZeroNodeRef);
                ContentDiskDriverTest.this.driver.truncateFile(testSession, testConnection, testContext.secondFileHandle, 0L);
                logger.debug((Object)"close the second non zero file, secondFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)truncateFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkContentProps2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(testContext.testNonZeroNodeRef, ContentModel.PROP_CONTENT);
                String s = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"content not truncated", (String)"", (String)s);
                ContentReader reader2 = ContentDiskDriverTest.this.contentService.getReader(testContext.testZeroNodeRef, ContentModel.PROP_CONTENT);
                String s2 = reader2.getContentString();
                ContentDiskDriverTest.assertEquals((String)"content not empty", (String)"", (String)s2);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkContentProps2CB, false, true);
    }

    public void testScenarioMSWord2003SaveAsShuffleCheckedOutFile() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffleLockedFile");
        class TestContext {
            NetworkFile firstFileHandle;
            String workingFileName;
            NodeRef workingCopy;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"a) create new file and check out");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC");
                NodeRef workingCopy = ContentDiskDriverTest.this.checkOutCheckInService.checkout(shuffledNodeRef);
                ContentDiskDriverTest.assertNotNull((String)"Working copy is null", (Object)workingCopy);
                testContext.workingCopy = workingCopy;
                ChildAssociationRef ref = ContentDiskDriverTest.this.nodeService.getPrimaryParent(workingCopy);
                ref.getQName();
                testContext.workingFileName = ref.getQName().getLocalName();
                ContentDiskDriverTest.assertNotNull((String)"working file name is null", (Object)testContext.workingFileName);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\" + testContext.workingFileName, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\SAVEAS.wbk");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\" + testContext.workingFileName);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"e) now check in");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkInCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.checkOutCheckInService.checkin(testContext.workingCopy, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkInCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testSetFileScenario() throws Exception {
        logger.debug((Object)"testSetFileInfo");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        Date now = new Date();
        new Date(now.getTime() - 21600000L);
        final Date MODIFIED = new Date(now.getTime() - 3600000L);
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        int openAction = 16;
        try {
            this.driver.deleteFile((SrvSession)testSession, testConnection, "\\testSetFileScenario.txt");
        }
        catch (IOException iOException) {}
        FileOpenParams params = new FileOpenParams("\\testSetFileScenario.txt", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile((SrvSession)testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileScenario.txt");
                info.setFileInformationFlags(8);
                info.setModifyDateTime(MODIFIED.getTime());
                info.setNetworkFile(file);
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileScenario.txt", info);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeStuffCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> closeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)closeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileScenario.txt");
                ContentDiskDriverTest.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"content is null", (Object)content);
                Date modified = (Date)ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_MODIFIED);
                ContentDiskDriverTest.assertEquals((String)"modified time not set correctly", (Object)MODIFIED, (Object)modified);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteFile = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\testSetFileScenario.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteFile, false, true);
    }

    public void testScenarioMacLionTextEdit() throws Exception {
        logger.debug((Object)"testScenarioLionTextEdit");
        class TestContext {
            NetworkFile lockFileHandle;
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioLionTextEdit", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioLionTextEdit\\.Temporary Items", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioLionTextEdit\\test.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                String testContent = "Mac Lion Text";
                byte[] testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.firstFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioLionTextEdit\\.Temporary Items\\test.txt", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.tempFileHandle);
                testContent = "Mac Lion Text Updated Content";
                testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.tempFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioLionTextEdit\\.Temporary Items\\._test.txt", 0, 2, 128, 0);
                testContext.lockFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.lockFileHandle);
                testContext.lockFileHandle.closeFile();
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\test.txt");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteTargetFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\test.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTargetFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\.Temporary Items\\test.txt", "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\test.txt");
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\.Temporary Items\\._test.txt", "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\._test.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioLionTextEdit\\test.txt");
                ContentDiskDriverTest.assertEquals((String)"shuffledNode ref is different", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node is not versionable", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(shuffledNodeRef, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"Reader is null", (Object)reader);
                String s = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"content not written", (String)"Mac Lion Text Updated Content", (String)s);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testScenarioMSPowerpoint2011MacSaveShuffle() throws Exception {
        logger.debug((Object)"testScenarioMSPowerpoint2011MacSaveShuffle(");
        class TestContext {
            NetworkFile firstFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA.pptx");
                return null;
            }
        };
        try {
            logger.debug((Object)"expect to get exception - cleaning garbage");
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"0) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA.pptx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA.pptx");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) write some content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA1.pptx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) delete old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA.pptx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) rename new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA1.pptx", "\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA.pptx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSPowerpoint2011MacSaveShuffle\\FileA.pptx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                ContentDiskDriverTest.assertTrue((String)"versionable aspect missing", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertTrue((String)"hidden aspect still applied", (!ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_HIDDEN) ? 1 : 0) != 0);
                ContentDiskDriverTest.assertTrue((String)"temporary aspect still applied", (!ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_TEMPORARY) ? 1 : 0) != 0);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testScenarioMSExcel2011MacSaveShuffle() throws Exception {
        logger.debug((Object)"testScenarioMSExcel2011MacSaveShuffle(");
        class TestContext {
            NetworkFile firstFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\FileA.xlsx");
                return null;
            }
        };
        try {
            logger.debug((Object)"expect to get exception - cleaning garbage");
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"0) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\FileA.xlsx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\FileA.xlsx");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) write some content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\._A8A09200", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) delete old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\FileA.xlsx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) rename new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\._A8A09200", "\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\FileA.xlsx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSExcel2011MacSaveShuffle\\FileA.xlsx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                ContentDiskDriverTest.assertTrue((String)"versionable aspect missing", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertTrue((String)"hidden aspect still applied", (!ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_HIDDEN) ? 1 : 0) != 0);
                ContentDiskDriverTest.assertTrue((String)"temporary aspect still applied", (!ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_TEMPORARY) ? 1 : 0) != 0);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testScenarioMSWord20011MacSaveWithBackup() throws Exception {
        logger.debug((Object)"testScenarioMSWord20011MacSaveWithBackup");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        logger.debug((Object)"Step 0 - initialise");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\.Temporary Items", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\TEST.DOCX", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\TEST.DOCX");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                String testContent = "MS Word 2011 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"Step a - create a temp file in the temp dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\.Temporary Items\\Word Work File D_.tmp", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2011 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)saveNewFileCB, false, true);
        logger.debug((Object)"Step c - rename the target file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\TEST.DOCX", "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\Backup of TEST.docx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"Step d - move new file into target dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\.Temporary Items\\Word Work File D_.tmp", "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\Word Work File D_.tmp");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"Step e - rename temp file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\Word Work File D_.tmp", "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\TEST.DOCX");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord20011MacSaveWithBackup\\TEST.DOCX");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"TEST.DOCX", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testMacDragAndDrop() throws Exception {
        logger.debug((Object)"testMacDragAndDrop()");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\MacDragAndDrop\\ALF-15158.diff");
                return null;
            }
        };
        try {
            logger.debug((Object)"expect to get exception - cleaning garbage");
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"0) create new file");
        class TestContext {
            NetworkFile firstFileHandle;
            NodeRef file1NodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\MacDragAndDrop", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\MacDragAndDrop\\ALF-15158.diff", 0, 2, 128, 0);
                ctx.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)ctx.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, ctx.firstFileHandle);
                ctx.file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\MacDragAndDrop\\ALF-15158.diff");
                ContentDiskDriverTest.this.nodeService.addAspect(ctx.file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"1) delete old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\MacDragAndDrop\\ALF-15158.diff");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"2) write some content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> restoreFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\MacDragAndDrop\\ALF-15158.diff", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                try (InputStream is = fileResource.getInputStream();){
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)restoreFileCB, false, true);
        logger.debug((Object)"3) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\MacDragAndDrop\\ALF-15158.diff");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                ContentDiskDriverTest.assertTrue((String)"versionable aspect missing", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertTrue((String)"hidden aspect still applied", (!ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_HIDDEN) ? 1 : 0) != 0);
                ContentDiskDriverTest.assertTrue((String)"temporary aspect still applied", (!ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_TEMPORARY) ? 1 : 0) != 0);
                ContentDiskDriverTest.assertEquals((String)"Node ref has changed", (Object)shuffledNodeRef, (Object)testContext.file1NodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
        logger.debug((Object)"end testMacDragAndDrop");
    }

    public void testScenarioMountainLionWord2011() throws Exception {
        logger.debug((Object)"testScenarioMountainLionWord2011");
        class TestContext {
            NetworkFile firstFileHandle;
            String mimetype;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionWord2011", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\Word Work File D_2.tmp", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(file1NodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                testContext.mimetype = data.getMimetype();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx", "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\Word Work File L_5.tmp");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\Word Work File D_2.tmp", "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"d) delete the old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\Word Work File L_5.tmp");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionWord2011\\MacWord1.docx");
                ContentDiskDriverTest.assertTrue((String)"file has lost versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)testContext.mimetype, (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testScenarioMacMountainLionPreview() throws Exception {
        logger.debug((Object)"testScenarioMountainLionPreview");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\Crysanthemeum.jpg", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                String testContent = "Mac Mountain Lion Text";
                byte[] testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.firstFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\Crysanthemeum.jpg", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.tempFileHandle);
                testContent = "Mac Lion Preview Updated Content";
                testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.tempFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\Crysanthemeum.jpg");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteTargetFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\Crysanthemeum.jpg");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTargetFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\Crysanthemeum.jpg", "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\Crysanthemeum.jpg");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\Crysanthemeum.jpg");
                ContentDiskDriverTest.assertTrue((String)"node is not versionable", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"shuffledNode ref is different", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testScenarioMacMountainLionPreview_MNT_263() throws Exception {
        logger.debug((Object)"testScenarioMacMountainLionPreview_MNT_263");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                String testContent = "Mac Lion Preview Content";
                byte[] testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.firstFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\image.jpg.sb-1e5e1543-ajn3cR", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.tempFileHandle);
                testContent = "Mac Lion Preview Updated Content";
                testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.tempFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\image.jpg.sb-1e5e1543-ajn3cR", "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\image.jpg");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg", "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg.sb-1e5e1543-ajn3cR");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveRenamedTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\image.jpg", "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveRenamedTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg");
                ContentDiskDriverTest.assertTrue((String)"node is not versionable", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"shuffledNode ref is different", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                ContentDiskDriverTest.assertEquals((String)"Unexpected content size", (long)ContentDiskDriverTest.this.contentService.getReader(shuffledNodeRef, ContentModel.PROP_CONTENT).getSize(), (long)"Mac Lion Preview Updated Content".length());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testScenarioMacMountainLionPreview_MNT_317() throws Exception {
        logger.debug((Object)"testScenarioMacMountainLionPreview_MNT_317");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                String testContent = "Mac Lion Preview Content";
                byte[] testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.firstFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\image.jpg", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.tempFileHandle);
                testContent = "Mac Lion Preview Updated Content";
                testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.tempFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams openFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, openFileParams);
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg", "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.smbdeleteAAA1b994.4");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOnCloseCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                org.alfresco.jlan.server.filesys.FileInfo info = new org.alfresco.jlan.server.filesys.FileInfo();
                info.setFileInformationFlags(1024);
                info.setDeleteOnClose(true);
                testContext.tempFileHandle.setDeleteOnClose(true);
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.smbdeleteAAA1b994.4", info);
                ContentDiskDriverTest.assertNotNull((Object)testContext.tempFileHandle);
                logger.debug((Object)"this close should result in a file being deleted");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOnCloseCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveRenamedTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\.Temporary Items\\image.jpg", "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveRenamedTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionPreview\\image.jpg");
                ContentDiskDriverTest.assertTrue((String)"node is not versionable", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"shuffledNode ref is different", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                ContentDiskDriverTest.assertEquals((String)"Unexpected content size", (long)ContentDiskDriverTest.this.contentService.getReader(shuffledNodeRef, ContentModel.PROP_CONTENT).getSize(), (long)"Mac Lion Preview Updated Content".length());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testScenarioMacMountainLionKeynote_MNT_8558() throws Exception {
        logger.debug((Object)"testScenarioMacMountainLionKeynote_MNT_8558");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionKeynote", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\.Temporary Items", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test.key", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                String testContent = "Mac Mountain Lion Keynote Content";
                byte[] testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.firstFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\.Temporary Items\\test.key", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.tempFileHandle);
                testContent = "Mac Mountain Lion Keynote Updated Content";
                testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.tempFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test.key");
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test.key", "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test~.key");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\.Temporary Items\\test.key", "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test.key");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveTempFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test.key");
                ContentDiskDriverTest.assertTrue((String)"node is not versionable", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"shuffledNode ref is different", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                ContentDiskDriverTest.assertEquals((String)"Unexpected content size", (long)ContentDiskDriverTest.this.contentService.getReader(shuffledNodeRef, ContentModel.PROP_CONTENT).getSize(), (long)"Mac Mountain Lion Keynote Updated Content".length());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> prepareForSecondRunCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\test~.key");
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMountainLionKeynote\\.Temporary Items\\test.key", 0, 2, 128, 0);
                testContext.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                String testContent = "Mac Mountain Lion Keynote Updated Content";
                byte[] testContentBytes = testContent.getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.tempFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)prepareForSecondRunCB, false, true);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameFileCB, false, true);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveTempFileCB, false, true);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void testGedit() throws Exception {
        logger.debug((Object)"testGEdit");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testGEdit\\gedit12345678.txt");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestFileFirstTime = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testGEdit", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testGEdit\\gedit12345678.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testGEdit\\gedit12345678.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Gedit"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"This is a test document to test CIFS shuffle"));
                String testContent = "Gedit shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestFileFirstTime, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTempFile = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NetworkFile file;
                FileOpenParams params = new FileOpenParams("\\ContentDiskDriverTest\\testGEdit\\.goutputStream-IRYDPW", 2, 2, 128, 0);
                testContext.tempFileHandle = file = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, params);
                String testContent = "Shuffle an open file";
                byte[] testContentBytes = testContent.getBytes();
                testContext.tempFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTempFile, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameTestFileToTemp = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testGEdit\\.goutputStream-IRYDPW", "\\ContentDiskDriverTest\\testGEdit\\gedit12345678.txt");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameTestFileToTemp, false, true);
            ContentDiskDriverTest.fail((String)"should have failed");
        }
        catch (Exception exception) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteTargetFile = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testGEdit\\gedit12345678.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTargetFile, false, true);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameTestFileToTemp, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> closeTempFile = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.tempFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)closeTempFile, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validate = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testGEdit\\gedit12345678.txt");
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(shuffledNodeRef, ContentModel.PROP_CONTENT);
                String s = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"content not written", (String)"Shuffle an open file", (String)s);
                ContentDiskDriverTest.assertTrue((String)"node is not versionable", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"shuffledNode ref is different", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validate, false, true);
        logger.debug((Object)"end testGedit");
    }

    public void testWindows7Explorer() throws Exception {
        logger.debug((Object)"testWindows7Explorer");
        class TestContext {
            NodeRef testNodeRef;
            NetworkFile firstFileHandle;
            NetworkFile secondFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"0) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef file1NodeRef;
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testWindows7Explorer", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTestMark.jpg");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTestMark.jpg", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                testContext.testNodeRef = file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"a) save new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testWindows7Explorer\\~ark.tmp", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTestMark2.jpg");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTestMark2.jpg", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.secondFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg", "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg~RF5bb356.TMP");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testWindows7Explorer\\~ark.tmp", "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNewFileCB, false, true);
        logger.debug((Object)"d) delete on close the old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams openFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg~RF5bb356.TMP", 0, 131208, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, openFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.secondFileHandle);
                org.alfresco.jlan.server.filesys.FileInfo info = new org.alfresco.jlan.server.filesys.FileInfo();
                info.setFileInformationFlags(1024);
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg~RF5bb356.TMP", info);
                testContext.secondFileHandle.setDeleteOnClose(true);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testWindows7Explorer\\mark.jpg");
                ContentDiskDriverTest.assertTrue((String)"file has lost versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"node ref has changed", (Object)shuffledNodeRef, (Object)testContext.testNodeRef);
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((String)"data is null", (Object)data);
                ContentDiskDriverTest.assertEquals((String)"size is wrong", (long)10407L, (long)data.getSize());
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"image/jpeg", (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
    }

    public void testNFS() throws Exception {
        logger.debug((Object)"testNFS()");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testNFS\\test.txt");
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB2 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testNFS\\test.txt~");
                return null;
            }
        };
        try {
            logger.debug((Object)"expect to get exception - cleaning garbage");
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        try {
            logger.debug((Object)"expect to get exception - cleaning garbage");
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB2);
        }
        catch (Exception exception) {}
        logger.debug((Object)"0) create new file");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile tempFileHandle;
            NodeRef file1NodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testNFS", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testNFS\\test.txt", 0, 2, 128, 0);
                ctx.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)ctx.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, ctx.firstFileHandle);
                ctx.file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testNFS\\test.txt");
                FileOpenParams createTempFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testNFS\\test.txt~", 0, 2, 128, 0);
                ctx.tempFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createTempFileParams);
                ContentDiskDriverTest.assertNotNull((Object)ctx.tempFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, ctx.tempFileHandle);
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        logger.debug((Object)"1) delete old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testNFS\\test.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
        logger.debug((Object)"2) remame temp file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameTempFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testNFS\\test.txt~", "\\ContentDiskDriverTest\\testNFS\\test.txt");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)renameTempFileCB, false, true);
        logger.debug((Object)"3) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testNFS\\test.txt");
                ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertEquals((String)"Node ref has changed", (Object)shuffledNodeRef, (Object)testContext.file1NodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
        logger.debug((Object)"end testNFS");
    }

    private void doTransactionWorkAsEditor(final AuthenticationUtil.RunAsWork<Void> work, RetryingTransactionHelper tran) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transactionCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)ContentDiskDriverTest.TEST_USER_AUTHORITY);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof AccessDeniedException || e.getCause() instanceof PermissionDeniedException) {
                        ContentDiskDriverTest.fail((String)("For user='userx' " + e.getCause().toString()));
                    }
                    ContentDiskDriverTest.fail((String)("Unexpected exception was caught: " + e.toString()));
                }
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transactionCallback, false, true);
    }

    public void testScenarioMacLionTextEditByEditor_ALF_16257() throws Exception {
        logger.debug((Object)"test Collaborator/editor edit txt file on Mac Os Mountain Lion : Alf16257");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, "cifs", TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\test.txt");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"Step 0 - initialise");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257txt", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257txt\\.TemporaryItems", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257txt\\test.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\test.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                String testContent = "CIFS: Collaborator/editor could not edit file on Mac Os Mountain Lion";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                ContentDiskDriverTest.this.permissionService.setPermission(ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257txt"), ContentDiskDriverTest.TEST_USER_AUTHORITY, "Editor", true);
                ContentDiskDriverTest.this.permissionService.setPermission(ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\.TemporaryItems"), "GROUP_EVERYONE", "All", true);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"Step a - create a temp file in the temp dir");
        AuthenticationUtil.RunAsWork<Void> saveNewFileCB = new AuthenticationUtil.RunAsWork<Void>(){
            {
            }

            public Void doWork() throws Exception {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257txt\\.TemporaryItems\\test.txt", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.newFileHandle);
                byte[] testContentBytes = "This is new content".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.newFileHandle, testContentBytes, 0, testContentBytes.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.newFileHandle);
                NodeRef tempNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\.TemporaryItems\\test.txt");
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(tempNodeRef, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((Object)reader);
                String actualContent = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"new contents were not written to temporary file", (String)"This is new content", (String)actualContent);
                return null;
            }
        };
        this.doTransactionWorkAsEditor(saveNewFileCB, tran);
        logger.debug((Object)"Step b - rename the target file as Editor");
        AuthenticationUtil.RunAsWork<Void> renameOldFileCB = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\test.txt", "\\ContentDiskDriverTest\\testALF16257txt\\test.txt.sb-1eefba7a-rkC6XE");
                return null;
            }
        };
        this.doTransactionWorkAsEditor(renameOldFileCB, tran);
        logger.debug((Object)"Step c - move new file into target dir as Editor");
        AuthenticationUtil.RunAsWork<Void> moveNewFileCB = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\.TemporaryItems\\test.txt", "\\ContentDiskDriverTest\\testALF16257txt\\test.txt");
                return null;
            }
        };
        this.doTransactionWorkAsEditor(moveNewFileCB, tran);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257txt\\test.txt");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentDiskDriverTest.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentDiskDriverTest.assertEquals((String)"name wrong", (Object)"test.txt", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(testContext.testNodeRef, ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertNotNull((Object)reader);
                String actualContent = reader.getContentString();
                ContentDiskDriverTest.assertEquals((String)"contents were not updated", (String)"This is new content", (String)actualContent);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
        logger.debug((Object)"end testScenarioMacLionTextEditByEditor For ALF-16257");
    }

    public void testScenarioMountainLionWord2011EditByEditor_ALF_16257() throws Exception {
        logger.debug((Object)"testScenarioMountainLionWord2011 Edit By Editor ALF-16257");
        class TestContext {
            NetworkFile firstFileHandle;
            String mimetype;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257Word", 0, 2, 128, 0);
                FileOpenParams createTempDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257Word\\.TemporaryItems", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createTempDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentDiskDriverTest.this.permissionService.setPermission(ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257Word"), ContentDiskDriverTest.TEST_USER_AUTHORITY, "Editor", true);
                ContentDiskDriverTest.this.permissionService.setPermission(ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\.TemporaryItems"), "GROUP_EVERYONE", "All", true);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) rename old file");
        AuthenticationUtil.RunAsWork<Void> renameOldFileCB = new AuthenticationUtil.RunAsWork<Void>(){
            {
            }

            public Void doWork() throws Exception {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(file1NodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                testContext.mimetype = data.getMimetype();
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx", "\\ContentDiskDriverTest\\testALF16257Word\\Word Work File L_5.tmp");
                return null;
            }
        };
        this.doTransactionWorkAsEditor(renameOldFileCB, tran);
        logger.debug((Object)"c) create temp file in temp dir");
        AuthenticationUtil.RunAsWork<Void> writeFileCB = new AuthenticationUtil.RunAsWork<Void>(){
            {
            }

            public Void doWork() throws Exception {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testALF16257Word\\.TemporaryItems\\Word Work File D_2.tmp", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                ContentDiskDriverTest.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\.TemporaryItems\\Word Work File D_2.tmp", "\\ContentDiskDriverTest\\testALF16257Word\\Word Work File D_2.tmp");
                return null;
            }
        };
        this.doTransactionWorkAsEditor(writeFileCB, tran);
        logger.debug((Object)"d) move new file into place");
        AuthenticationUtil.RunAsWork<Void> moveNewFileCB = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\Word Work File D_2.tmp", "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx");
                return null;
            }
        };
        this.doTransactionWorkAsEditor(moveNewFileCB, tran);
        logger.debug((Object)"e) delete the old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\Word Work File L_5.tmp");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteOldFileCB, false, true);
        logger.debug((Object)"e) validate results");
        logger.debug((Object)"f) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testALF16257Word\\MacWord1.docx");
                ContentDiskDriverTest.assertTrue((String)"file has lost versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE));
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)testContext.mimetype, (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
        logger.debug((Object)"end testScenarioMountainLionWord2011 Edit By Editor ALF-16257");
    }

    public void testMimetypeWithSufficientData() throws Exception {
        logger.debug((Object)"testMimetypeWithInsufficiantData");
        class TestContext {
            NetworkFile firstFileHandle;
            String mimetype;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMimetypeWithSufficientData\\foo");
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteGarbageFileCB);
        }
        catch (Exception exception) {}
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testMimetypeWithSufficientData", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMimetypeWithSufficientData\\foo", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTestTxt1.txt");
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMimetypeWithSufficientData\\foo");
                ContentWriter contentWriter2 = ContentDiskDriverTest.this.contentService.getWriter(file1NodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.setMimetype("text\bar");
                contentWriter2.putContent(fileResource.getFile());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCB, false, true);
        logger.debug((Object)"b) update file via CIFS");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> updateFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMimetypeWithSufficientData\\foo", 0, 2, 128, 0);
                NetworkFile file = ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.assertNotNull((Object)file);
                String testContent = "Bar";
                byte[] testContentBytes = testContent.getBytes();
                file.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateFileCB, false, true);
        logger.debug((Object)"c) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMimetypeWithSufficientData\\foo");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                ContentDiskDriverTest.assertEquals((String)"mimeType is wrong", (String)"text/plain", (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, true, true);
        logger.debug((Object)"end testMimetypeWithSufficientData");
    }

    private NodeRef getNodeForPath(TreeConnection tree, String path) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getNodeRefForPath:" + path));
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        return this.cifsHelper.getNodeRef(ctx.getRootNode(), path);
    }

    private void writeResourceToNetworkFile(ClassPathResource resource, NetworkFile file) throws IOException {
        byte[] buffer = new byte[1000];
        try (InputStream is = resource.getInputStream();){
            long offset = 0L;
            int i = is.read(buffer, 0, buffer.length);
            while (i > 0) {
                file.writeFile(buffer, i, 0, offset);
                offset += (long)i;
                i = is.read(buffer, 0, buffer.length);
            }
        }
    }

    public class TestServer
    extends NetworkFileServer {
        public TestServer(String proto, ServerConfiguration config) {
            super(proto, config);
        }

        public void startServer() {
        }

        public void shutdownServer(boolean immediate) {
        }

        public TreeConnection getTreeConnection(SharedDevice share) {
            return new TreeConnection(share);
        }
    }

    private class TestSrvSession
    extends SrvSession {
        public TestSrvSession(int sessId, NetworkServer srv, String proto, String remName) {
            super(sessId, srv, proto, remName);
            ClientInfo cinfo = ClientInfo.createInfo((String)"fred", null);
            this.setClientInformation(cinfo);
            this.setUniqueId("test:" + sessId);
        }

        public InetAddress getRemoteAddress() {
            return null;
        }

        public boolean useCaseSensitiveSearch() {
            return false;
        }
    }
}

