/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.ImapServiceImpl;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

@Category(value={OwnJVMTestsCategory.class})
public class ImapServiceImplTest
extends TestCase {
    private static final String IMAP_ROOT = "Alfresco IMAP";
    private static final String APP_COMPANY_HOME = "/app:company_home";
    private static final String USER_NAME = "admin";
    private static final String USER_PASSWORD = "admin";
    private static final String TEST_IMAP_FOLDER_NAME = "aaa";
    private static final String MAILBOX_NAME_A = "mailbox_a";
    private static final String MAILBOX_NAME_B = "mailbox_b";
    private static final String MAILBOX_PATTERN = "mailbox*";
    private ApplicationContext ctx;
    private TransactionService transactionService;
    private NodeService nodeService;
    private ImporterService importerService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private AlfrescoImapUser user;
    private ImapService imapService;
    private UserTransaction txn;
    private ContentService contentService;
    private NodeRef testImapFolderNodeRef;
    private Flags flags;
    private ImapServiceImpl imapServiceImpl;
    String anotherUserName;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.importerService = serviceRegistry.getImporterService();
        this.personService = serviceRegistry.getPersonService();
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.imapService = serviceRegistry.getImapService();
        this.searchService = serviceRegistry.getSearchService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.contentService = serviceRegistry.getContentService();
        this.flags = new Flags();
        this.flags.add(Flags.Flag.SEEN);
        this.flags.add(Flags.Flag.FLAGGED);
        this.flags.add(Flags.Flag.ANSWERED);
        this.flags.add(Flags.Flag.DELETED);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        IntegrityChecker.setWarnInTransaction();
        this.anotherUserName = "user" + System.currentTimeMillis();
        PropertyMap testUser = new PropertyMap();
        testUser.put((Object)ContentModel.PROP_USERNAME, (Object)this.anotherUserName);
        testUser.put((Object)ContentModel.PROP_FIRSTNAME, (Object)this.anotherUserName);
        testUser.put((Object)ContentModel.PROP_LASTNAME, (Object)this.anotherUserName);
        testUser.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(this.anotherUserName) + "@alfresco.com"));
        testUser.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
        this.personService.createPerson((Map)testUser);
        this.authenticationService.createAuthentication(this.anotherUserName, this.anotherUserName.toCharArray());
        this.user = new AlfrescoImapUser(String.valueOf(this.anotherUserName) + "@alfresco.com", this.anotherUserName, this.anotherUserName);
        NodeRef companyHomeNodeRef = this.findCompanyHomeNodeRef();
        ChildApplicationContextFactory imap = (ChildApplicationContextFactory)this.ctx.getBean("imap");
        ApplicationContext imapCtx = imap.getApplicationContext();
        this.imapServiceImpl = (ImapServiceImpl)imapCtx.getBean("imapService");
        LinkedList<String> folders = new LinkedList<String>();
        folders.add(TEST_IMAP_FOLDER_NAME);
        FileFolderUtil.makeFolders((FileFolderService)this.fileFolderService, (NodeRef)companyHomeNodeRef, folders, (QName)ContentModel.TYPE_FOLDER);
        RepositoryFolderConfigBean imapHome = new RepositoryFolderConfigBean();
        imapHome.setStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString());
        imapHome.setRootPath(APP_COMPANY_HOME);
        imapHome.setFolderPath("cm:aaa");
        this.imapServiceImpl.setImapHome(imapHome);
        this.imapServiceImpl.startupInTxn(true);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, "/app:company_home/cm:aaa", null, (NamespacePrefixResolver)this.namespaceService, false);
        this.testImapFolderNodeRef = (NodeRef)nodeRefs.get(0);
        this.importInternal("imap/imapservice_test_folder_a.acp", this.testImapFolderNodeRef);
        this.reauthenticate(this.anotherUserName, this.anotherUserName);
    }

    public void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void importInternal(String acpName, NodeRef space) throws IOException {
        ClassPathResource acpResource = new ClassPathResource(acpName);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(space);
        this.importerService.importView((ImportPackageHandler)acpHandler, importLocation, null, null);
    }

    private boolean checkMailbox(AlfrescoImapUser user, String mailboxName) {
        try {
            this.imapService.getOrCreateMailbox(user, mailboxName, true, false);
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            return false;
        }
        return true;
    }

    private boolean checkSubscribedMailbox(AlfrescoImapUser user, String mailboxName) {
        List aifs = this.imapService.listMailboxes(user, mailboxName, true);
        boolean present = false;
        for (AlfrescoImapFolder aif : aifs) {
            if (!aif.getName().equals(mailboxName)) continue;
            present = true;
            break;
        }
        return present;
    }

    private void reauthenticate(final String name, final String password) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                ImapServiceImplTest.this.authenticationService.invalidateTicket(ImapServiceImplTest.this.authenticationService.getCurrentTicket());
                ImapServiceImplTest.this.authenticationService.clearCurrentSecurityContext();
                ImapServiceImplTest.this.authenticationService.authenticate(name, password.toCharArray());
                return null;
            }
        });
    }

    public void testGetFolder() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        ImapServiceImplTest.assertTrue((boolean)this.checkMailbox(this.user, MAILBOX_NAME_A));
    }

    public void testListMailbox() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_B, false, true);
        List mf = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, false);
        ImapServiceImplTest.assertEquals((int)2, (int)mf.size());
        boolean foundA = false;
        boolean foundB = false;
        for (AlfrescoImapFolder folder : mf) {
            if (MAILBOX_NAME_A.equals(folder.getName())) {
                foundA = true;
            }
            if (!MAILBOX_NAME_B.equals(folder.getName())) continue;
            foundB = true;
        }
        ImapServiceImplTest.assertTrue((String)"folder A found", (boolean)foundA);
        ImapServiceImplTest.assertTrue((String)"folder B found", (boolean)foundB);
        mf = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, false);
        ImapServiceImplTest.assertEquals((String)"can't repeat the listing of folders", (int)2, (int)mf.size());
        mf = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, false);
        ImapServiceImplTest.assertEquals((String)"can't repeat the listing of folders", (int)2, (int)mf.size());
        List aif = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, true);
        ImapServiceImplTest.assertEquals((String)"not subscribed to two mailboxes", (int)2, (int)aif.size());
        this.imapService.unsubscribe(this.user, MAILBOX_NAME_B);
        List aif2 = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, true);
        ImapServiceImplTest.assertEquals((String)"not subscribed to one mailbox", (int)1, (int)aif2.size());
    }

    public void testExcludeFoldersByComponentIt() {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true).getFolderInfo().getNodeRef();
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_B, false, true).getFolderInfo().getNodeRef();
        NodeRef imapFolderC = this.imapService.getOrCreateMailbox(this.user, "mailboxCalendarFolder", false, true).getFolderInfo().getNodeRef();
        NodeRef imapFolderD = this.imapService.getOrCreateMailbox(this.user, "mailboxDataListsFolder", false, true).getFolderInfo().getNodeRef();
        NodeRef imapFolderE = this.imapService.getOrCreateMailbox(this.user, "mailboxDocumentLibraryFolder", false, true).getFolderInfo().getNodeRef();
        List mf = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, false);
        ImapServiceImplTest.assertEquals((int)5, (int)mf.size());
        this.nodeService.setProperty(imapFolderC, SiteModel.PROP_COMPONENT_ID, (Serializable)((Object)"calendar"));
        this.nodeService.setProperty(imapFolderD, SiteModel.PROP_COMPONENT_ID, (Serializable)((Object)"dataLists"));
        this.nodeService.setProperty(imapFolderE, SiteModel.PROP_COMPONENT_ID, (Serializable)((Object)"documentLibrary"));
        mf = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, false);
        ImapServiceImplTest.assertEquals((String)"Imap folders with component IDs 'calendar' or 'dataLists' were not excluded.", (int)3, (int)mf.size());
    }

    public void testListSubscribedMailbox() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_B, false, true);
        this.imapService.subscribe(this.user, MAILBOX_NAME_A);
        this.imapService.subscribe(this.user, MAILBOX_NAME_B);
        List aif = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN, true);
        ImapServiceImplTest.assertEquals((int)aif.size(), (int)2);
        ImapServiceImplTest.assertTrue((String)"Can't subscribe mailbox A", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_A));
        ImapServiceImplTest.assertTrue((String)"Can't subscribe mailbox B", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_B));
    }

    public void testCreateMailbox() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        ImapServiceImplTest.assertTrue((String)"Mailbox isn't created", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_A));
    }

    public void testDuplicateMailboxes() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        try {
            this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
            ImapServiceImplTest.fail((String)"Duplicate Mailbox was created");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    public void testRenameMailbox() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        this.imapService.renameMailbox(this.user, MAILBOX_NAME_A, MAILBOX_NAME_B);
        ImapServiceImplTest.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_A));
        ImapServiceImplTest.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_B));
    }

    public void testRenameMailboxDuplicate() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_B, false, true);
        try {
            this.imapService.renameMailbox(this.user, MAILBOX_NAME_A, MAILBOX_NAME_B);
            ImapServiceImplTest.fail((String)"Mailbox was renamed to existing one but shouldn't");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    public void testDeleteMailbox() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_B, false, true);
        this.imapService.deleteMailbox(this.user, MAILBOX_NAME_B);
        ImapServiceImplTest.assertFalse((String)"Can't delete mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_B));
    }

    public void testSubscribe() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        this.imapService.subscribe(this.user, MAILBOX_NAME_A);
        ImapServiceImplTest.assertTrue((String)"Can't subscribe mailbox", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_A));
    }

    public void testUnsubscribe() throws Exception {
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_NAME_A, false, true);
        this.imapService.subscribe(this.user, MAILBOX_NAME_A);
        this.imapService.unsubscribe(this.user, MAILBOX_NAME_A);
        ImapServiceImplTest.assertFalse((String)"Can't unsubscribe mailbox", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_A));
    }

    private void setFlags(FileInfo messageFileInfo) throws Exception {
        this.imapService.setFlags(messageFileInfo, this.flags, true);
        NodeRef messageNodeRef = messageFileInfo.getNodeRef();
        Map props = this.nodeService.getProperties(messageNodeRef);
        ImapServiceImplTest.assertTrue((String)"Can't set SEEN flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_SEEN));
        ImapServiceImplTest.assertTrue((String)"Can't set FLAGGED flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_FLAGGED));
        ImapServiceImplTest.assertTrue((String)"Can't set ANSWERED flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_ANSWERED));
        ImapServiceImplTest.assertTrue((String)"Can't set DELETED flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_DELETED));
    }

    public void testSetFlags() throws Exception {
        NavigableMap fis = this.imapService.getFolderStatus((String)this.authenticationService.getCurrentUserName(), (NodeRef)this.testImapFolderNodeRef, (AlfrescoImapConst.ImapViewMode)AlfrescoImapConst.ImapViewMode.ARCHIVE).search;
        if (fis != null && fis.size() > 0) {
            FileInfo messageFileInfo;
            block3: {
                messageFileInfo = (FileInfo)fis.firstEntry().getValue();
                try {
                    this.setFlags(messageFileInfo);
                    ImapServiceImplTest.fail((String)"Can't set flags");
                }
                catch (Exception e) {
                    if (e instanceof AccessDeniedException) break block3;
                    throw e;
                }
            }
            this.reauthenticate("admin", "admin");
            this.permissionService.setPermission(this.testImapFolderNodeRef, this.anotherUserName, "Write", true);
            this.reauthenticate(this.anotherUserName, this.anotherUserName);
            this.setFlags(messageFileInfo);
        }
    }

    public void testSetFlag() throws Exception {
        NavigableMap fis = this.imapService.getFolderStatus((String)this.authenticationService.getCurrentUserName(), (NodeRef)this.testImapFolderNodeRef, (AlfrescoImapConst.ImapViewMode)AlfrescoImapConst.ImapViewMode.ARCHIVE).search;
        if (fis != null && fis.size() > 0) {
            FileInfo messageFileInfo = (FileInfo)fis.firstEntry().getValue();
            this.reauthenticate("admin", "admin");
            this.permissionService.setPermission(this.testImapFolderNodeRef, this.anotherUserName, "Write", true);
            this.reauthenticate(this.anotherUserName, this.anotherUserName);
            this.imapService.setFlag(messageFileInfo, Flags.Flag.RECENT, true);
            Serializable prop = this.nodeService.getProperty(messageFileInfo.getNodeRef(), ImapModel.PROP_FLAG_RECENT);
            ImapServiceImplTest.assertNotNull((String)"Can't set RECENT flag", (Object)prop);
        }
    }

    public void testGetFlags() throws Exception {
        NavigableMap fis = this.imapService.getFolderStatus((String)this.authenticationService.getCurrentUserName(), (NodeRef)this.testImapFolderNodeRef, (AlfrescoImapConst.ImapViewMode)AlfrescoImapConst.ImapViewMode.ARCHIVE).search;
        if (fis != null && fis.size() > 0) {
            FileInfo messageFileInfo = (FileInfo)fis.firstEntry().getValue();
            this.reauthenticate("admin", "admin");
            this.permissionService.setPermission(this.testImapFolderNodeRef, this.anotherUserName, "Write", true);
            this.imapService.setFlags(messageFileInfo, this.flags, true);
            this.reauthenticate(this.anotherUserName, this.anotherUserName);
            Flags fl = this.imapService.getFlags(messageFileInfo);
            ImapServiceImplTest.assertTrue((boolean)fl.contains(this.flags));
        }
    }

    public void testRenameAccentedMailbox() throws Exception {
        String MAILBOX_ACCENTED_NAME_A = "H\u00f4tel";
        String MAILBOX_ACCENTED_NAME_B = "H\u00f4telXX";
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_ACCENTED_NAME_A, false, true);
        this.imapService.deleteMailbox(this.user, MAILBOX_ACCENTED_NAME_A);
        this.imapService.getOrCreateMailbox(this.user, MAILBOX_ACCENTED_NAME_A, false, true);
        this.imapService.renameMailbox(this.user, MAILBOX_ACCENTED_NAME_A, MAILBOX_ACCENTED_NAME_B);
        ImapServiceImplTest.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_ACCENTED_NAME_A));
        ImapServiceImplTest.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_ACCENTED_NAME_B));
        this.imapService.deleteMailbox(this.user, MAILBOX_ACCENTED_NAME_B);
    }

    public void testContentRecovery() throws Exception {
        NodeRef restoredNode;
        Map props;
        this.reauthenticate("admin", "admin");
        NodeRef nodeRef = this.nodeService.createNode(this.testImapFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"content_recover"), ContentModel.TYPE_CONTENT).getChildRef();
        FileInfo fileInfo = this.fileFolderService.getFileInfo(nodeRef);
        this.imapService.setFlag(fileInfo, Flags.Flag.DELETED, true);
        this.imapService.setFlag(fileInfo, Flags.Flag.SEEN, true);
        this.fileFolderService.delete(nodeRef);
        String storePath = "archive://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef archivedNodeRef = new NodeRef(storeRef, nodeRef.getId());
        Boolean value = false;
        if (this.nodeService.exists(archivedNodeRef) && (props = this.nodeService.getProperties(restoredNode = this.nodeService.restoreNode(archivedNodeRef, this.testImapFolderNodeRef, null, null))).containsKey(ImapModel.PROP_FLAG_DELETED) && props.containsKey(ImapModel.PROP_FLAG_SEEN)) {
            value = (Boolean)props.get(ImapModel.PROP_FLAG_DELETED) == false && (Boolean)props.get(ImapModel.PROP_FLAG_SEEN) == false;
        }
        ImapServiceImplTest.assertTrue((String)"Can't set DELETED flag to false", (boolean)value);
    }

    public void testAttachmentExtraction() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        ClassPathResource fileResource = new ClassPathResource("imap/test-tnef-message.eml");
        ImapServiceImplTest.assertNotNull((String)"unable to find test resource test-tnef-message.eml", (Object)fileResource);
        FileInputStream is = new FileInputStream(fileResource.getFile());
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)is);
        NodeRef companyHomeNodeRef = this.findCompanyHomeNodeRef();
        FileInfo f1 = this.fileFolderService.create(companyHomeNodeRef, "ImapServiceImplTest", ContentModel.TYPE_FOLDER);
        FileInfo f2 = this.fileFolderService.create(f1.getNodeRef(), "test-tnef-message.eml", ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.fileFolderService.getWriter(f2.getNodeRef());
        writer.putContent((InputStream)new FileInputStream(fileResource.getFile()));
        this.imapService.extractAttachments(f2.getNodeRef(), message);
        List targetAssocs = this.nodeService.getTargetAssocs(f2.getNodeRef(), (QNamePattern)ImapModel.ASSOC_IMAP_ATTACHMENTS_FOLDER);
        ImapServiceImplTest.assertTrue((String)"attachment folder is found", (targetAssocs.size() == 1 ? 1 : 0) != 0);
        NodeRef attachmentFolderRef = ((AssociationRef)targetAssocs.get(0)).getTargetRef();
        ImapServiceImplTest.assertNotNull((Object)attachmentFolderRef);
        List files = this.fileFolderService.listFiles(attachmentFolderRef);
        ImapServiceImplTest.assertTrue((String)"three files not found", (files.size() == 3 ? 1 : 0) != 0);
    }

    public void testMailboxRenamingInTheRootForMNT9055() throws Exception {
        this.reauthenticate("admin", "admin");
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        NodeRef root = this.findCompanyHomeNodeRef();
        String targetNodeName = "Test-" + System.currentTimeMillis();
        FileInfo targetNode = this.fileFolderService.create(root, targetNodeName, ContentModel.TYPE_FOLDER);
        String renamedNodeName = "Renamed-" + System.currentTimeMillis();
        String renamedNodePath = "Alfresco IMAP/" + renamedNodeName;
        this.assertMailboxRenaming(poweredUser, root, "Alfresco IMAP/" + targetNodeName, Collections.singletonList(renamedNodeName), renamedNodePath, targetNode);
        AlfrescoImapFolder actualMailbox = this.imapService.getOrCreateMailbox(poweredUser, renamedNodePath, true, false);
        List parentAssocs = this.nodeService.getParentAssocs(actualMailbox.getFolderInfo().getNodeRef());
        ImapServiceImplTest.assertNotNull((Object)parentAssocs);
        ImapServiceImplTest.assertFalse((boolean)parentAssocs.isEmpty());
        ImapServiceImplTest.assertEquals((int)1, (int)parentAssocs.size());
        ImapServiceImplTest.assertEquals((Object)root, (Object)((ChildAssociationRef)parentAssocs.iterator().next()).getParentRef());
    }

    public void testMailboxRenamingInTheUserImapHomeForMNT9055() throws Exception {
        this.reauthenticate("admin", "admin");
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        NodeRef root = this.findCompanyHomeNodeRef();
        String targetNodeName = "Test-" + System.currentTimeMillis();
        String renamedNodeName = "Renamed-" + System.currentTimeMillis();
        AlfrescoImapFolder mailbox = this.imapService.getOrCreateMailbox(poweredUser, targetNodeName, false, true);
        this.assertMailboxNotNull(mailbox);
        List pathBeforeRenaming = this.fileFolderService.getNameOnlyPath(root, mailbox.getFolderInfo().getNodeRef());
        this.assertMailboxRenaming(poweredUser, root, targetNodeName, Collections.singletonList(renamedNodeName), renamedNodeName, null);
        mailbox = this.imapService.getOrCreateMailbox(poweredUser, renamedNodeName, true, false);
        this.assertMailboxNotNull(mailbox);
        List pathAfterRenaming = this.fileFolderService.getNameOnlyPath(root, mailbox.getFolderInfo().getNodeRef());
        this.assertPathHierarchy(pathBeforeRenaming, pathAfterRenaming);
    }

    public void testMailboxRenamingInDeepHierarchyForMNT9055() throws Exception {
        NodeRef root;
        this.reauthenticate("admin", "admin");
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        NodeRef parent = root = this.findCompanyHomeNodeRef();
        FileInfo targetNode = null;
        String targetNodeName = IMAP_ROOT;
        StringBuilder fullPath = new StringBuilder();
        LinkedList<String> fullPathList = new LinkedList<String>();
        String renamedNodeName = "Renamed-" + System.currentTimeMillis();
        int i = 0;
        while (i < 10) {
            fullPath.append(targetNodeName).append('/');
            targetNodeName = "Test" + i + "-" + System.currentTimeMillis();
            if (i < 9) {
                fullPathList.add(targetNodeName);
            }
            targetNode = this.fileFolderService.create(parent, targetNodeName, ContentModel.TYPE_FOLDER);
            ImapServiceImplTest.assertNotNull((Object)targetNode);
            parent = targetNode.getNodeRef();
            ImapServiceImplTest.assertNotNull((Object)parent);
            ++i;
        }
        String path = fullPath.toString();
        String targetNodePath = String.valueOf(path) + targetNodeName;
        String renamedNodePath = String.valueOf(path) + renamedNodeName;
        LinkedList<String> renamedFullPathList = new LinkedList<String>(fullPathList);
        renamedFullPathList.add(renamedNodeName);
        fullPathList.add(targetNodeName);
        this.assertMailboxRenaming(poweredUser, root, targetNodePath, renamedFullPathList, renamedNodePath, targetNode);
        AlfrescoImapFolder mailbox = this.imapService.getOrCreateMailbox(poweredUser, renamedNodePath, true, false);
        this.assertMailboxNotNull(mailbox);
        List pathAfterRenaming = this.fileFolderService.getNameOnlyPath(root, mailbox.getFolderInfo().getNodeRef());
        this.assertPathHierarchy(fullPathList, pathAfterRenaming);
        FileInfo renamedNode = this.fileFolderService.resolveNamePath(root, pathAfterRenaming);
        ImapServiceImplTest.assertNotNull((Object)renamedNode);
        ImapServiceImplTest.assertEquals((Object)targetNode.getNodeRef(), (Object)renamedNode.getNodeRef());
    }

    public void testMiddleMailboxRenamingInDeepHierarchyForMNT9055() throws Exception {
        NodeRef root;
        this.reauthenticate("admin", "admin");
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        NodeRef parent = root = this.findCompanyHomeNodeRef();
        String middleName = null;
        FileInfo targetNode = null;
        FileInfo middleNode = null;
        String targetNodeName = IMAP_ROOT;
        StringBuilder fullPath = new StringBuilder();
        StringBuilder fullLeftPath = new StringBuilder();
        LinkedList<String> fullLeftPathList = new LinkedList<String>();
        LinkedList<String> fullRightPathList = new LinkedList<String>();
        String renamedNodeName = "Renamed-" + System.currentTimeMillis();
        int i = 0;
        while (i < 10) {
            if (i <= 5) {
                fullLeftPath.append(targetNodeName).append('/');
            } else if (i > 6) {
                fullPath.append(targetNodeName).append('/');
            }
            targetNodeName = "Test" + i + "-" + System.currentTimeMillis();
            if (i < 5) {
                fullLeftPathList.add(targetNodeName);
            } else if (i > 5) {
                fullRightPathList.add(targetNodeName);
            }
            targetNode = this.fileFolderService.create(parent, targetNodeName, ContentModel.TYPE_FOLDER);
            ImapServiceImplTest.assertNotNull((Object)targetNode);
            ImapServiceImplTest.assertNotNull((Object)targetNode.getNodeRef());
            parent = targetNode.getNodeRef();
            if (5 == i) {
                middleName = targetNodeName;
                middleNode = targetNode;
            }
            ++i;
        }
        String path = fullLeftPath.toString();
        String targetNodePath = String.valueOf(path) + middleName;
        String renamedNodePath = String.valueOf(path) + renamedNodeName;
        LinkedList<String> renamedFullLeftPathList = new LinkedList<String>(fullLeftPathList);
        renamedFullLeftPathList.add(renamedNodeName);
        fullLeftPathList.add(middleName);
        this.assertMailboxRenaming(poweredUser, root, targetNodePath, renamedFullLeftPathList, renamedNodePath, middleNode);
        AlfrescoImapFolder mailbox = this.imapService.getOrCreateMailbox(poweredUser, renamedNodePath, true, false);
        this.assertMailboxNotNull(mailbox);
        List pathAfterRenaming = this.fileFolderService.getNameOnlyPath(root, mailbox.getFolderInfo().getNodeRef());
        this.assertPathHierarchy(fullLeftPathList, pathAfterRenaming);
        FileInfo renamedNode = this.fileFolderService.resolveNamePath(root, pathAfterRenaming);
        ImapServiceImplTest.assertNotNull((Object)renamedNode);
        ImapServiceImplTest.assertEquals((Object)middleNode.getNodeRef(), (Object)renamedNode.getNodeRef());
        String fullRenamedPath = path + renamedNodeName + '/' + fullPath + targetNodeName;
        mailbox = this.imapService.getOrCreateMailbox(poweredUser, fullRenamedPath, true, false);
        this.assertMailboxNotNull(mailbox);
        ImapServiceImplTest.assertEquals((Object)targetNode.getNodeRef(), (Object)mailbox.getFolderInfo().getNodeRef());
        pathAfterRenaming = this.fileFolderService.getNameOnlyPath(middleNode.getNodeRef(), targetNode.getNodeRef());
        this.assertPathHierarchy(fullRightPathList, pathAfterRenaming);
    }

    public void testMailboxMoving() throws Exception {
        this.reauthenticate("admin", "admin");
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        NodeRef root = this.findCompanyHomeNodeRef();
        FileInfo targetNode = null;
        String imapUserHomePath = "";
        StringBuilder fullPath = new StringBuilder();
        LinkedList<String> fullPathList = new LinkedList<String>(Arrays.asList(TEST_IMAP_FOLDER_NAME, "admin"));
        String targetNodeName = IMAP_ROOT + '/' + TEST_IMAP_FOLDER_NAME + '/' + "admin";
        int i = 0;
        while (i < 4) {
            fullPath.append(targetNodeName).append('/');
            targetNodeName = "Test" + i + "-" + System.currentTimeMillis();
            if (i < 3) {
                fullPathList.add(targetNodeName);
            }
            AlfrescoImapFolder mailbox = this.imapService.getOrCreateMailbox(poweredUser, String.valueOf(imapUserHomePath) + targetNodeName, false, true);
            ImapServiceImplTest.assertNotNull((Object)mailbox);
            targetNode = mailbox.getFolderInfo();
            imapUserHomePath = String.valueOf(fullPath.toString()) + targetNodeName + '/';
            ++i;
        }
        String path = fullPath.toString();
        String targetNodePath = String.valueOf(path) + targetNodeName;
        String newName = "Renamed-" + System.currentTimeMillis();
        String renamedNodeName = "Alfresco IMAP/" + newName;
        this.imapService.renameMailbox(poweredUser, targetNodePath, renamedNodeName);
        AlfrescoImapFolder mailbox = this.imapService.getOrCreateMailbox(poweredUser, renamedNodeName, true, false);
        this.assertMailboxNotNull(mailbox);
        targetNodePath = renamedNodeName;
        renamedNodeName = String.valueOf(path) + newName;
        this.imapService.renameMailbox(poweredUser, targetNodePath, renamedNodeName);
        mailbox = this.imapService.getOrCreateMailbox(poweredUser, renamedNodeName, true, false);
        this.assertMailboxNotNull(mailbox);
        this.assertMailboxInUserImapHomeDirectory(root, mailbox.getFolderInfo().getNodeRef());
        List pathAfterRenaming = this.fileFolderService.getNameOnlyPath(root, targetNode.getNodeRef());
        fullPathList.add(newName);
        this.assertPathHierarchy(fullPathList, pathAfterRenaming);
    }

    public void testMoveViaDeleteAndAppend() throws Exception {
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        String fileName = "testfile" + GUID.generate();
        String destinationName = "testFolder" + GUID.generate();
        String destinationPath = "Alfresco IMAP/" + destinationName;
        String nodeContent = "test content";
        NodeRef root = this.findCompanyHomeNodeRef();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        FileInfo origFile = this.fileFolderService.create(root, fileName, ContentModel.TYPE_CONTENT);
        ContentWriter contentWriter = this.contentService.getWriter(origFile.getNodeRef(), ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(nodeContent);
        FileInfo destinationNode = this.fileFolderService.create(root, destinationName, ContentModel.TYPE_FOLDER);
        this.nodeService.addAspect(origFile.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT, null);
        SimpleStoredMessage origMessage = this.imapService.getMessage(origFile);
        origMessage.getMimeMessage().saveChanges();
        this.imapService.setFlag(origFile, Flags.Flag.DELETED, true);
        this.imapService.expungeMessage(origFile);
        AlfrescoImapFolder destinationMailbox = this.imapService.getOrCreateMailbox(poweredUser, destinationPath, true, false);
        destinationMailbox.appendMessage(origMessage.getMimeMessage(), this.flags, null);
        ImapServiceImplTest.assertTrue((!this.nodeService.exists(origFile.getNodeRef()) || this.imapService.getFlags(origFile).contains(Flags.Flag.DELETED) ? 1 : 0) != 0);
        ImapServiceImplTest.assertEquals((String)"There should be only one node in the destination folder", (int)1, (int)this.nodeService.getChildAssocs(destinationNode.getNodeRef()).size());
        NodeRef newNodeRef = ((ChildAssociationRef)this.nodeService.getChildAssocs(destinationNode.getNodeRef()).get(0)).getChildRef();
        FileInfo newNodeFileInfo = this.fileFolderService.getFileInfo(newNodeRef);
        ImapServiceImplTest.assertEquals((String)"The file name should not change.", (String)fileName, (String)newNodeFileInfo.getName());
        ContentReader reader = this.contentService.getReader(newNodeRef, ContentModel.PROP_CONTENT);
        String contentString = reader.getContentString();
        ImapServiceImplTest.assertEquals((String)contentString, (String)nodeContent);
    }

    public void testMoveViaAppendAndDelete() throws Exception {
        AlfrescoImapUser poweredUser = new AlfrescoImapUser("admin@alfresco.com", "admin", "admin");
        String fileName = "testfile" + GUID.generate();
        String destinationName = "testFolder" + GUID.generate();
        String destinationPath = "Alfresco IMAP/" + destinationName;
        String nodeContent = "test content";
        NodeRef root = this.findCompanyHomeNodeRef();
        AuthenticationUtil.setRunAsUserSystem();
        FileInfo origFile = this.fileFolderService.create(root, fileName, ContentModel.TYPE_CONTENT);
        ContentWriter contentWriter = this.contentService.getWriter(origFile.getNodeRef(), ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(nodeContent);
        FileInfo destinationNode = this.fileFolderService.create(root, destinationName, ContentModel.TYPE_FOLDER);
        this.nodeService.addAspect(origFile.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT, null);
        this.nodeService.addAspect(origFile.getNodeRef(), ContentModel.ASPECT_TAGGABLE, null);
        SimpleStoredMessage origMessage = this.imapService.getMessage(origFile);
        origMessage.getMimeMessage().addHeader("X-Alfresco-NodeRef-ID", origFile.getNodeRef().getId());
        origMessage.getMimeMessage().saveChanges();
        AlfrescoImapFolder destinationMailbox = this.imapService.getOrCreateMailbox(poweredUser, destinationPath, true, false);
        long uuid = destinationMailbox.appendMessage(origMessage.getMimeMessage(), this.flags, null);
        this.imapService.setFlag(origFile, Flags.Flag.DELETED, true);
        this.imapService.expungeMessage(origFile);
        FileInfo copiedNode = this.fileFolderService.getFileInfo(this.nodeService.getNodeRef(Long.valueOf(uuid)));
        ImapServiceImplTest.assertNotNull((String)"The file should exist.", (Object)copiedNode);
        ImapServiceImplTest.assertEquals((String)"The file name should not change.", (String)fileName, (String)copiedNode.getName());
        NodeRef copiedParentNodeRef = this.nodeService.getPrimaryParent(copiedNode.getNodeRef()).getParentRef();
        ImapServiceImplTest.assertEquals((String)"The parent should change to destination.", (Object)destinationNode.getNodeRef(), (Object)copiedParentNodeRef);
        ImapServiceImplTest.assertEquals((String)"There should be only one node in the destination folder", (int)1, (int)this.nodeService.getChildAssocs(destinationNode.getNodeRef()).size());
        ImapServiceImplTest.assertTrue((String)"New node should have original node aspects", (boolean)this.nodeService.hasAspect(copiedNode.getNodeRef(), ContentModel.ASPECT_TAGGABLE));
    }

    public void testListMailboxOnStartup() {
        this.authenticationService.clearCurrentSecurityContext();
        this.imapServiceImpl.startupInTxn(true);
    }

    private void assertMailboxNotNull(AlfrescoImapFolder mailbox) {
        ImapServiceImplTest.assertNotNull((Object)mailbox);
        ImapServiceImplTest.assertNotNull((Object)mailbox.getFolderInfo());
        ImapServiceImplTest.assertNotNull((Object)mailbox.getFolderInfo().getNodeRef());
    }

    private void assertMailboxRenaming(AlfrescoImapUser user, NodeRef root, String targetNodePath, List<String> renamedNodeName, String renamedNodePath, FileInfo targetNode) throws FileNotFoundException {
        AlfrescoImapFolder mailbox = this.imapService.getOrCreateMailbox(user, targetNodePath, true, false);
        ImapServiceImplTest.assertNotNull((String)("Just created mailbox can't be received by full path via the ImapService. Path: '" + targetNodePath + "'"), (Object)mailbox);
        ImapServiceImplTest.assertNotNull((Object)mailbox.getFolderInfo());
        ImapServiceImplTest.assertNotNull((Object)mailbox.getFolderInfo().getNodeRef());
        this.imapService.renameMailbox(user, targetNodePath, renamedNodePath);
        NodeRef actualNode = null;
        if (targetNode != null) {
            FileInfo actualFileInfo = this.fileFolderService.resolveNamePath(root, renamedNodeName);
            ImapServiceImplTest.assertNotNull((Object)actualFileInfo);
            ImapServiceImplTest.assertNotNull((Object)actualFileInfo.getNodeRef());
            actualNode = actualFileInfo.getNodeRef();
        } else {
            mailbox = this.imapService.getOrCreateMailbox(user, renamedNodePath, true, false);
            ImapServiceImplTest.assertNotNull((Object)mailbox);
            actualNode = mailbox.getFolderInfo().getNodeRef();
        }
        ImapServiceImplTest.assertNotNull((String)("Can't receive renamed node by full path: '" + renamedNodePath + "'"), (Object)actualNode);
        if (targetNode != null) {
            ImapServiceImplTest.assertEquals((Object)targetNode.getNodeRef(), (Object)actualNode);
        } else {
            this.assertMailboxInUserImapHomeDirectory(root, actualNode);
        }
    }

    private void assertMailboxInUserImapHomeDirectory(NodeRef root, NodeRef actualNode) throws FileNotFoundException {
        List path = this.fileFolderService.getNameOnlyPath(root, actualNode);
        int satisfactionFlag = 0;
        for (String element : path) {
            if (TEST_IMAP_FOLDER_NAME.equals(element) || "admin".equals(element)) {
                ++satisfactionFlag;
            }
            if (satisfactionFlag > 1) break;
        }
        ImapServiceImplTest.assertTrue((satisfactionFlag > 1 ? 1 : 0) != 0);
    }

    private void assertPathHierarchy(List<String> pathBeforeRenaming, List<String> pathAfterRenaming) {
        ImapServiceImplTest.assertNotNull(pathAfterRenaming);
        ImapServiceImplTest.assertNotNull(pathBeforeRenaming);
        ImapServiceImplTest.assertEquals((int)pathBeforeRenaming.size(), (int)pathAfterRenaming.size());
        Iterator<String> before = pathBeforeRenaming.iterator();
        Iterator<String> after = pathAfterRenaming.iterator();
        int i = 0;
        while (i < pathAfterRenaming.size() - 2) {
            ImapServiceImplTest.assertTrue((boolean)before.hasNext());
            ImapServiceImplTest.assertTrue((boolean)after.hasNext());
            ImapServiceImplTest.assertEquals((String)before.next(), (String)after.next());
            ++i;
        }
    }

    private NodeRef findCompanyHomeNodeRef() {
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, APP_COMPANY_HOME, null, (NamespacePrefixResolver)this.namespaceService, false);
        return (NodeRef)nodeRefs.get(0);
    }

    public void testSearchTerms() throws AddressException {
        List mf = this.imapService.listMailboxes(this.user, "Alfresco IMAP/aaa/_*", false);
        ArrayList<Long> res = new ArrayList<Long>();
        SentDateTerm st = null;
        st = new SentDateTerm(2, new Date());
        this.extractSearchTermResultsToList(mf, (SearchTerm)st, res);
        ImapServiceImplTest.assertEquals((String)"Size of mails isn't correct. Search by sent date", (int)3, (int)res.size());
        res.clear();
        st = new SubjectTerm("For Test");
        this.extractSearchTermResultsToList(mf, (SearchTerm)st, res);
        ImapServiceImplTest.assertEquals((String)"Size of mails isn't correct. Search by subject", (int)1, (int)res.size());
        res.clear();
        st = new FromTerm((Address)new InternetAddress("admin@alfresco.com"));
        this.extractSearchTermResultsToList(mf, (SearchTerm)st, res);
        ImapServiceImplTest.assertEquals((String)"Size of mails isn't correct. Search by \"From\" term", (int)1, (int)res.size());
        res.clear();
        st = new AndTerm((SearchTerm)st, (SearchTerm)new SubjectTerm("For Test"));
        this.extractSearchTermResultsToList(mf, (SearchTerm)st, res);
        ImapServiceImplTest.assertEquals((String)"Size of mails isn't correct. Search by \"From\" and \"Subject\" terms", (int)1, (int)res.size());
    }

    private void extractSearchTermResultsToList(List<AlfrescoImapFolder> folders, SearchTerm searchTerm, ArrayList<Long> resList) {
        for (AlfrescoImapFolder folder : folders) {
            long[] lArray = folder.search(searchTerm);
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long l = lArray[n2];
                resList.add(l);
                ++n2;
            }
        }
    }
}

