/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.cleanup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.ibatis.NodeDAOImpl;
import org.alfresco.repo.node.db.DeletedNodeCleanupWorker;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.extensions.webscripts.GUID;
import org.springframework.test.annotation.DirtiesContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_EACH_TEST_METHOD)
public class DeletedNodeBatchCleanupTest
extends BaseSpringTest {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private NodeDAO nodeDAO;
    @Autowired
    @Qualifier(value="node.nodesSharedCache")
    private SimpleCache<Serializable, Serializable> nodesCache;
    @Autowired
    private DeletedNodeCleanupWorker worker;
    @Autowired
    private NamespaceService namespaceService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SearchService searchService;
    private RetryingTransactionHelper helper;
    private List<NodeRef> testNodes;

    @Before
    public void before() {
        this.helper = this.transactionService.getRetryingTransactionHelper();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        this.resetWorkerConfig();
        NodeRef companyHome = this.getCompanyHome();
        this.testNodes = IntStream.range(0, 5).mapToObj(i -> (NodeRef)this.helper.doInTransaction(this.createNodeCallback(companyHome), false, true)).collect(Collectors.toList());
        this.helper.doInTransaction(() -> this.worker.doClean(), false, true);
    }

    private void resetWorkerConfig() {
        this.worker.setMinPurgeAgeDays(0);
        this.worker.setAlgorithm("V2");
        this.worker.setDeleteBatchSize(20);
    }

    private NodeRef getCompanyHome() {
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        NodeRef storeRoot = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRoot, "/app:company_home", null, (NamespacePrefixResolver)this.namespaceService, false);
        return (NodeRef)nodeRefs.get(0);
    }

    private RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodeCallback(NodeRef companyHome) {
        return () -> this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test", (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
    }

    private void deleteNodes(NodeRef nodeRef, NodeRef ... additionalNodeRefs) {
        Stream.concat(Stream.of(nodeRef), Stream.of(additionalNodeRefs)).forEach(this::deleteNode);
    }

    private void deleteNode(NodeRef nodeRef) {
        this.helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new DeleteNode(nodeRef), false, true);
    }

    @Test
    public void testPurgeNodesDeleted() {
        NodeRef nodeRef4 = this.getNode(4);
        NodeRef nodeRef5 = this.getNode(5);
        this.deleteNodes(nodeRef4, nodeRef5);
        this.nodesCache.clear();
        DeletedNodeBatchCleanupTest.assertTrue((String)"Node 4 is deleted but not purged", (boolean)this.nodeDAO.getNodeRefStatus(nodeRef4).isDeleted());
        DeletedNodeBatchCleanupTest.assertTrue((String)"Node 5 is deleted but not purged", (boolean)this.nodeDAO.getNodeRefStatus(nodeRef5).isDeleted());
        this.worker.doClean();
        this.nodesCache.clear();
        DeletedNodeBatchCleanupTest.assertNull((String)"Node 4 was not cleaned up", (Object)this.nodeDAO.getNodeRefStatus(nodeRef4));
        DeletedNodeBatchCleanupTest.assertNull((String)"Node 5 was not cleaned up", (Object)this.nodeDAO.getNodeRefStatus(nodeRef5));
    }

    @Test
    public void testNodesDeletedNotPurgedWhenNotAfterPurgeAge() {
        NodeRef nodeRef1 = this.getNode(1);
        NodeRef nodeRef2 = this.getNode(2);
        this.deleteNodes(nodeRef1, nodeRef2);
        this.nodesCache.clear();
        DeletedNodeBatchCleanupTest.assertTrue((String)"Node 1 is deleted but not purged", (boolean)this.nodeDAO.getNodeRefStatus(nodeRef1).isDeleted());
        DeletedNodeBatchCleanupTest.assertTrue((String)"Node 2 is deleted but not purged", (boolean)this.nodeDAO.getNodeRefStatus(nodeRef2).isDeleted());
        this.worker.setMinPurgeAgeDays(1);
        this.worker.doClean();
        this.nodesCache.clear();
        DeletedNodeBatchCleanupTest.assertNotNull((String)"Node 1 was cleaned up", (Object)this.nodeDAO.getNodeRefStatus(nodeRef1));
        DeletedNodeBatchCleanupTest.assertNotNull((String)"Node 2 was cleaned up", (Object)this.nodeDAO.getNodeRefStatus(nodeRef2));
    }

    @Test
    public void testPurgeUnusedTransactions() throws Exception {
        long start = System.currentTimeMillis();
        Long minTxnId = this.nodeDAO.getMinTxnId();
        Map<NodeRef, List<String>> txnIds = this.createTransactions();
        List<String> txnIds1 = txnIds.get(this.getNode(1));
        List<String> txnIds2 = txnIds.get(this.getNode(2));
        List<String> txnIds3 = txnIds.get(this.getNode(3));
        this.nodesCache.clear();
        UserTransaction txn = this.transactionService.getUserTransaction(true);
        txn.begin();
        try {
            DeletedNodeBatchCleanupTest.assertTrue((String)"Node 4 is deleted but not purged", (boolean)this.nodeDAO.getNodeRefStatus(this.getNode(4)).isDeleted());
            DeletedNodeBatchCleanupTest.assertTrue((String)"Node 5 is deleted but not purged", (boolean)this.nodeDAO.getNodeRefStatus(this.getNode(5)).isDeleted());
        }
        finally {
            txn.rollback();
        }
        this.worker.doClean();
        RetryingTransactionHelper.RetryingTransactionCallback getTxnsCallback = () -> ((NodeDAOImpl)this.nodeDAO).selectTxns(Long.valueOf(start), Long.valueOf(Long.MAX_VALUE), Integer.valueOf(Integer.MAX_VALUE), null, null, Boolean.valueOf(true));
        List txns = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(getTxnsCallback, true, false);
        ArrayList<String> expectedUnusedTxnIds = new ArrayList<String>(10);
        expectedUnusedTxnIds.addAll(txnIds1.subList(0, txnIds1.size() - 1));
        ArrayList<String> expectedUsedTxnIds = new ArrayList<String>(5);
        expectedUsedTxnIds.add(txnIds1.get(txnIds1.size() - 1));
        expectedUsedTxnIds.addAll(txnIds2);
        expectedUsedTxnIds.addAll(txnIds3);
        List unusedTxnsNotPurged = expectedUnusedTxnIds.stream().filter(txnId -> this.containsTransaction(txns, (String)txnId)).collect(Collectors.toList());
        if (!unusedTxnsNotPurged.isEmpty()) {
            DeletedNodeBatchCleanupTest.fail((String)("Unused transaction(s) were not purged: " + unusedTxnsNotPurged));
        }
        long numFoundUnusedTxnIds = expectedUnusedTxnIds.stream().filter(txnId -> !this.containsTransaction(txns, (String)txnId)).count();
        DeletedNodeBatchCleanupTest.assertEquals((long)9L, (long)numFoundUnusedTxnIds);
        long numFoundUsedTxnIds = expectedUsedTxnIds.stream().filter(txnId -> this.containsTransaction(txns, (String)txnId)).count();
        DeletedNodeBatchCleanupTest.assertEquals((long)3L, (long)numFoundUsedTxnIds);
        RetryingTransactionHelper.RetryingTransactionCallback getTxnsUnusedCallback = () -> this.nodeDAO.getTxnsUnused(minTxnId, Long.MAX_VALUE, Integer.MAX_VALUE);
        List txnsUnused = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(getTxnsUnusedCallback, true, false);
        DeletedNodeBatchCleanupTest.assertEquals((int)0, (int)txnsUnused.size());
        this.nodesCache.clear();
        DeletedNodeBatchCleanupTest.assertNull((String)"Node 4 was not cleaned up", (Object)this.nodeDAO.getNodeRefStatus(this.getNode(4)));
        DeletedNodeBatchCleanupTest.assertNull((String)"Node 5 was not cleaned up", (Object)this.nodeDAO.getNodeRefStatus(this.getNode(5)));
    }

    private boolean containsTransaction(List<Transaction> txns, String txnId) {
        return txns.stream().map(Transaction::getChangeTxnId).filter(changeTxnId -> changeTxnId.equals(txnId)).map(match -> true).findFirst().orElse(false);
    }

    private Map<NodeRef, List<String>> createTransactions() {
        HashMap<NodeRef, List<String>> txnIds = new HashMap<NodeRef, List<String>>();
        UpdateNode updateNode1 = new UpdateNode(this.getNode(1));
        UpdateNode updateNode2 = new UpdateNode(this.getNode(2));
        UpdateNode updateNode3 = new UpdateNode(this.getNode(3));
        DeleteNode deleteNode4 = new DeleteNode(this.getNode(4));
        DeleteNode deleteNode5 = new DeleteNode(this.getNode(5));
        ArrayList<String> txnIds1 = new ArrayList<String>();
        ArrayList<String> txnIds2 = new ArrayList<String>();
        ArrayList<String> txnIds3 = new ArrayList<String>();
        ArrayList<String> txnIds4 = new ArrayList<String>();
        ArrayList<String> txnIds5 = new ArrayList<String>();
        txnIds.put(this.getNode(1), txnIds1);
        txnIds.put(this.getNode(2), txnIds2);
        txnIds.put(this.getNode(3), txnIds3);
        txnIds.put(this.getNode(4), txnIds4);
        txnIds.put(this.getNode(5), txnIds5);
        int i = 0;
        while (i < 10) {
            String txnId1 = (String)this.helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateNode1, false, true);
            txnIds1.add(txnId1);
            if (i == 0) {
                String txnId2 = (String)this.helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateNode2, false, true);
                txnIds2.add(txnId2);
            }
            if (i == 1) {
                String txnId3 = (String)this.helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateNode3, false, true);
                txnIds3.add(txnId3);
            }
            ++i;
        }
        String txnId4 = (String)this.helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNode4, false, true);
        txnIds4.add(txnId4);
        String txnId5 = (String)this.helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNode5, false, true);
        txnIds5.add(txnId5);
        return txnIds;
    }

    private NodeRef getNode(int i) {
        return this.testNodes.get(i - 1);
    }

    private class DeleteNode
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private final NodeRef nodeRef;

        DeleteNode(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public String execute() throws Throwable {
            DeletedNodeBatchCleanupTest.this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TEMPORARY, null);
            DeletedNodeBatchCleanupTest.this.nodeService.deleteNode(this.nodeRef);
            return AlfrescoTransactionSupport.getTransactionId();
        }
    }

    private class UpdateNode
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private final NodeRef nodeRef;

        UpdateNode(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public String execute() throws Throwable {
            DeletedNodeBatchCleanupTest.this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)GUID.generate()));
            return AlfrescoTransactionSupport.getTransactionId();
        }
    }
}

