/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.getchildren;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.model.filefolder.GetChildrenCannedQueryFactory;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropBoolean;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.AlfrescoCollator;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.alfresco.util.testing.category.DBTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class GetChildrenCannedQueryTest
extends TestCase {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ApplicationContext ctx;
    private Repository repositoryHelper;
    private NodeService nodeService;
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private RatingService ratingService;
    private TenantService tenantService;
    private DictionaryDAO dictionaryDAO;
    private RatingScheme fiveStarRatingScheme;
    private RatingScheme likesRatingScheme;
    private Random random = new Random();
    private static boolean setupTestData = false;
    private static final String TEST_RUN = String.valueOf(System.currentTimeMillis());
    private static final String TEST_FILE_PREFIX = "GC-CQ-File-" + TEST_RUN + "-";
    private static final String TEST_USER_PREFIX = "GC-CQ-User-" + TEST_RUN + "-";
    private static final String TEST_USER = String.valueOf(TEST_USER_PREFIX) + "user";
    private static QName TEST_CONTENT_SUBTYPE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"savedquery");
    private static QName TEST_FOLDER_SUBTYPE = ContentModel.TYPE_SYSTEM_FOLDER;
    private static final String TEST_RUN_ID = "" + System.currentTimeMillis();
    private static final String FOLDER_1 = "aaa-folder";
    private static final String FOLDER_2 = "bbb-folder";
    private static final String FOLDER_3 = "emptySystemFolder";
    private static final String FOLDER_4 = "yyy-folder";
    private static final String FOLDER_5 = "zzz-folder";
    private Set<NodeRef> permHits = new HashSet<NodeRef>(100);
    private Set<NodeRef> permMisses = new HashSet<NodeRef>(100);
    private NamedObjectRegistry<CannedQueryFactory> cannedQueryRegistry;
    private static final String CQ_FACTORY_NAME = "fileFolderGetChildrenCannedQueryFactory";

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.repositoryHelper = (Repository)this.ctx.getBean("repositoryHelper");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.contentService = (ContentService)this.ctx.getBean("ContentService");
        this.mimetypeService = (MimetypeService)this.ctx.getBean("MimetypeService");
        this.dictionaryService = (DictionaryService)this.ctx.getBean("DictionaryService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("AuthenticationService");
        this.permissionService = (PermissionService)this.ctx.getBean("PermissionService");
        this.ratingService = (RatingService)this.ctx.getBean("RatingService");
        this.dictionaryDAO = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        this.tenantService = (TenantService)this.ctx.getBean("tenantService");
        this.cannedQueryRegistry = new NamedObjectRegistry();
        this.cannedQueryRegistry.setStorageType(CannedQueryFactory.class);
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = new GetChildrenCannedQueryFactory();
        getChildrenCannedQueryFactory.setBeanName(CQ_FACTORY_NAME);
        getChildrenCannedQueryFactory.setRegistry(this.cannedQueryRegistry);
        getChildrenCannedQueryFactory.setCannedQueryDAO((CannedQueryDAO)this.ctx.getBean("cannedQueryDAO"));
        getChildrenCannedQueryFactory.setContentDataDAO((ContentDataDAO)this.ctx.getBean("contentDataDAO"));
        getChildrenCannedQueryFactory.setDictionaryService((DictionaryService)this.ctx.getBean("dictionaryService"));
        getChildrenCannedQueryFactory.setTenantService((TenantService)this.ctx.getBean("tenantService"));
        getChildrenCannedQueryFactory.setLocaleDAO((LocaleDAO)this.ctx.getBean("localeDAO"));
        getChildrenCannedQueryFactory.setNodeDAO((NodeDAO)this.ctx.getBean("nodeDAO"));
        getChildrenCannedQueryFactory.setNodeService(this.nodeService);
        getChildrenCannedQueryFactory.setQnameDAO((QNameDAO)this.ctx.getBean("qnameDAO"));
        getChildrenCannedQueryFactory.setHiddenAspect((HiddenAspect)this.ctx.getBean("hiddenAspect"));
        getChildrenCannedQueryFactory.setMethodSecurity((MethodSecurityBean)this.ctx.getBean("FileFolderService_security_list"));
        getChildrenCannedQueryFactory.afterPropertiesSet();
        this.fiveStarRatingScheme = this.ratingService.getRatingScheme("fiveStarRatingScheme");
        GetChildrenCannedQueryTest.assertNotNull((Object)this.fiveStarRatingScheme);
        this.likesRatingScheme = this.ratingService.getRatingScheme("likesRatingScheme");
        GetChildrenCannedQueryTest.assertNotNull((Object)this.likesRatingScheme);
        if (!setupTestData) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            DictionaryBootstrap bootstrap = new DictionaryBootstrap();
            ArrayList<String> bootstrapModels = new ArrayList<String>();
            bootstrapModels.add("org/alfresco/repo/node/getchildren/testModel.xml");
            ArrayList labels = new ArrayList();
            bootstrap.setModels(bootstrapModels);
            bootstrap.setLabels(labels);
            bootstrap.setDictionaryDAO(this.dictionaryDAO);
            bootstrap.setTenantService(this.tenantService);
            bootstrap.bootstrap();
            this.createUser(TEST_USER, TEST_USER, TEST_USER);
            this.createUser(String.valueOf(TEST_USER_PREFIX) + "aaaa", String.valueOf(TEST_USER_PREFIX) + "bbbb", String.valueOf(TEST_USER_PREFIX) + "cccc");
            this.createUser(String.valueOf(TEST_USER_PREFIX) + "cccc", String.valueOf(TEST_USER_PREFIX) + "dddd", String.valueOf(TEST_USER_PREFIX) + "eeee");
            this.createUser(String.valueOf(TEST_USER_PREFIX) + "dddd", String.valueOf(TEST_USER_PREFIX) + "ffff", String.valueOf(TEST_USER_PREFIX) + "gggg");
            this.createUser(String.valueOf(TEST_USER_PREFIX) + "hhhh", String.valueOf(TEST_USER_PREFIX) + "cccc", String.valueOf(TEST_USER_PREFIX) + "jjjj");
            NodeRef testParentFolder = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
            this.createFolder(testParentFolder, FOLDER_3, TEST_FOLDER_SUBTYPE);
            this.createContent(testParentFolder, "textContent", TEST_CONTENT_SUBTYPE);
            this.createFolder(testParentFolder, FOLDER_5, ContentModel.TYPE_FOLDER);
            this.createFolder(testParentFolder, FOLDER_4, ContentModel.TYPE_FOLDER);
            boolean canRead = true;
            this.loadContent(testParentFolder, "quick.jpg", "", "", canRead, this.permHits);
            this.loadContent(testParentFolder, "quick.txt", "ZZ title " + TEST_RUN, "ZZ description 1", canRead, this.permHits);
            this.loadContent(testParentFolder, "quick.bmp", null, null, canRead, this.permHits);
            this.loadContent(testParentFolder, "quick.doc", "BB title " + TEST_RUN, "BB description", canRead, this.permHits);
            this.loadContent(testParentFolder, "quick.pdf", "ZZ title " + TEST_RUN, "ZZ description 2", canRead, this.permHits);
            canRead = false;
            this.loadContent(testParentFolder, "quick.ppt", "CC title " + TEST_RUN, "CC description", canRead, this.permMisses);
            this.loadContent(testParentFolder, "quick.xls", "AA title " + TEST_RUN, "AA description", canRead, this.permMisses);
            this.loadContent(testParentFolder, "quick.gif", "YY title " + TEST_RUN, "BB description", canRead, this.permMisses);
            this.loadContent(testParentFolder, "quick.xml", "ZZ title" + TEST_RUN, "BB description", canRead, this.permMisses);
            this.createFolder(testParentFolder, FOLDER_2, ContentModel.TYPE_FOLDER);
            this.createFolder(testParentFolder, FOLDER_1, ContentModel.TYPE_FOLDER);
            setupTestData = true;
            AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
            for (NodeRef nodeRef : this.permHits) {
                GetChildrenCannedQueryTest.assertTrue((this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            }
            for (NodeRef nodeRef : this.permMisses) {
                GetChildrenCannedQueryTest.assertFalse((this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            }
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            for (NodeRef nodeRef : this.permHits) {
                GetChildrenCannedQueryTest.assertTrue((this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            }
            for (NodeRef nodeRef : this.permMisses) {
                GetChildrenCannedQueryTest.assertTrue((this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            }
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef testFolder = this.createFolder(this.repositoryHelper.getCompanyHome(), "GetChildrenCannedQueryTest-testFolder-" + TEST_RUN_ID, QName.createQName((String)"http://www.alfresco.org/test/getchildrentest/1.0", (String)"folder"));
        this.createContent(testFolder, "textContent1", ContentModel.TYPE_CONTENT);
        this.createContent(testFolder, QName.createQName((String)"http://www.alfresco.org/test/getchildrentest/1.0", (String)"contains1"), "textContent2", ContentModel.TYPE_CONTENT);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
    }

    private NodeRef getOrCreateParentTestFolder(String name) throws Exception {
        NodeRef testFolder = this.nodeService.getChildByName(this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, name);
        if (testFolder == null) {
            testFolder = this.createFolder(this.repositoryHelper.getCompanyHome(), name, ContentModel.TYPE_FOLDER);
        }
        return testFolder;
    }

    public void testSetup() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0);
        GetChildrenCannedQueryTest.assertTrue((results.getPage().size() > 3 ? 1 : 0) != 0);
    }

    public void testMaxItems() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        int totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertTrue((totalCnt > 3 ? 1 : 0) != 0);
        int i = 1;
        while (i <= totalCnt) {
            results = this.list(parentNodeRef, 0, i, 0);
            GetChildrenCannedQueryTest.assertEquals((int)results.getPage().size(), (int)i);
            boolean hasMore = results.hasMoreItems();
            GetChildrenCannedQueryTest.assertTrue((hasMore == (i != totalCnt) ? 1 : 0) != 0);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("testSimpleMaxItems: [itemCnt=" + i + ",hasMore=" + hasMore + "]"));
            }
            ++i;
        }
    }

    public void testPaging() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        int totalCnt = results.getPage().size();
        int pageSize = 3;
        GetChildrenCannedQueryTest.assertTrue((totalCnt > pageSize ? 1 : 0) != 0);
        int pageCnt = totalCnt / pageSize;
        if (totalCnt % pageSize != 0) {
            ++pageCnt;
        }
        GetChildrenCannedQueryTest.assertTrue((pageCnt > 1 ? 1 : 0) != 0);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("testSimplePaging: [totalCount=" + totalCnt + ",pageSize=" + pageSize + ",pageCount=" + pageCnt + "]"));
        }
        int i = 1;
        while (i <= pageCnt) {
            int skipCount = (i - 1) * pageSize;
            int maxItems = pageSize;
            results = this.list(parentNodeRef, skipCount, maxItems, 0);
            boolean hasMore = results.hasMoreItems();
            int itemsCnt = results.getPage().size();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("testSimplePaging:     [pageNum=" + i + ",itemCnt=" + itemsCnt + ",hasMore=" + hasMore + "]"));
            }
            if (i != pageCnt) {
                GetChildrenCannedQueryTest.assertEquals((int)itemsCnt, (int)maxItems);
                GetChildrenCannedQueryTest.assertTrue((boolean)hasMore);
            } else {
                GetChildrenCannedQueryTest.assertTrue((itemsCnt <= maxItems ? 1 : 0) != 0);
                GetChildrenCannedQueryTest.assertFalse((boolean)hasMore);
            }
            ++i;
        }
    }

    public void testTypeFiltering() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        HashSet<QName> childTypeQNames = new HashSet<QName>(3);
        HashSet<QName> antiChildTypeQNames = new HashSet<QName>(3);
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_FOLDER);
        antiChildTypeQNames.clear();
        antiChildTypeQNames.add(TEST_FOLDER_SUBTYPE);
        this.filterByTypeAndCheck(parentNodeRef, childTypeQNames, antiChildTypeQNames);
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_CONTENT);
        antiChildTypeQNames.clear();
        antiChildTypeQNames.add(TEST_CONTENT_SUBTYPE);
        this.filterByTypeAndCheck(parentNodeRef, childTypeQNames, antiChildTypeQNames);
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_CONTENT);
        childTypeQNames.add(ContentModel.TYPE_FOLDER);
        antiChildTypeQNames.clear();
        antiChildTypeQNames.add(TEST_CONTENT_SUBTYPE);
        antiChildTypeQNames.add(TEST_FOLDER_SUBTYPE);
        this.filterByTypeAndCheck(parentNodeRef, childTypeQNames, antiChildTypeQNames);
        childTypeQNames.clear();
        childTypeQNames.add(TEST_CONTENT_SUBTYPE);
        childTypeQNames.add(TEST_FOLDER_SUBTYPE);
        antiChildTypeQNames.clear();
        antiChildTypeQNames.add(ContentModel.TYPE_CONTENT);
        antiChildTypeQNames.add(ContentModel.TYPE_FOLDER);
        this.filterByTypeAndCheck(parentNodeRef, childTypeQNames, antiChildTypeQNames);
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_LINK);
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0, childTypeQNames, null, null);
        GetChildrenCannedQueryTest.assertEquals((int)0, (int)results.getPage().size());
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_CMOBJECT);
        results = this.list(parentNodeRef, -1, -1, 0, childTypeQNames, null, null);
        GetChildrenCannedQueryTest.assertEquals((int)0, (int)results.getPage().size());
    }

    public void testPrimaryVsSecondary() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef userHomeRef = this.repositoryHelper.getCompanyHome();
        NodeRef parentNodeRef1 = this.createFolder(userHomeRef, "GetChildrenCannedQueryTest-PrimaryVsSecondary-" + TEST_RUN_ID, ContentModel.TYPE_FOLDER);
        PagingResults<NodeRef> results = this.list(parentNodeRef1, -1, -1, 0, null, null, null);
        GetChildrenCannedQueryTest.assertEquals((int)0, (int)results.getPage().size());
        ArrayList<FilterProp> filterPropsPrimary = new ArrayList<FilterProp>(1);
        filterPropsPrimary.add((FilterProp)new FilterPropBoolean(GetChildrenCannedQuery.FILTER_QNAME_NODE_IS_PRIMARY, Boolean.valueOf(true)));
        ArrayList<FilterProp> filterPropsSecondary = new ArrayList<FilterProp>(1);
        filterPropsSecondary.add((FilterProp)new FilterPropBoolean(GetChildrenCannedQuery.FILTER_QNAME_NODE_IS_PRIMARY, Boolean.valueOf(false)));
        results = this.list(parentNodeRef1, -1, -1, 0, null, filterPropsPrimary, null);
        GetChildrenCannedQueryTest.assertEquals((int)0, (int)results.getPage().size());
        results = this.list(parentNodeRef1, -1, -1, 0, null, filterPropsSecondary, null);
        GetChildrenCannedQueryTest.assertEquals((int)0, (int)results.getPage().size());
        NodeRef folder1Ref = this.createFolder(parentNodeRef1, FOLDER_1, ContentModel.TYPE_FOLDER);
        NodeRef folder2Ref = this.createFolder(parentNodeRef1, FOLDER_2, ContentModel.TYPE_FOLDER);
        results = this.list(parentNodeRef1, -1, -1, 0, null, null, null);
        GetChildrenCannedQueryTest.assertEquals((int)2, (int)results.getPage().size());
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder1Ref));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder2Ref));
        results = this.list(parentNodeRef1, -1, -1, 0, null, filterPropsPrimary, null);
        GetChildrenCannedQueryTest.assertEquals((int)2, (int)results.getPage().size());
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder1Ref));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder2Ref));
        results = this.list(parentNodeRef1, -1, -1, 0, null, filterPropsSecondary, null);
        GetChildrenCannedQueryTest.assertEquals((int)0, (int)results.getPage().size());
        NodeRef parentNodeRef2 = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-2-" + TEST_RUN_ID);
        NodeRef folder3Ref = this.createFolder(parentNodeRef2, FOLDER_3, ContentModel.TYPE_FOLDER);
        this.nodeService.addChild(parentNodeRef1, folder3Ref, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm:2nd"));
        results = this.list(parentNodeRef1, -1, -1, 0, null, null, null);
        GetChildrenCannedQueryTest.assertEquals((int)3, (int)results.getPage().size());
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder1Ref));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder2Ref));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder3Ref));
        results = this.list(parentNodeRef1, -1, -1, 0, null, filterPropsPrimary, null);
        GetChildrenCannedQueryTest.assertEquals((int)2, (int)results.getPage().size());
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder1Ref));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder2Ref));
        results = this.list(parentNodeRef1, -1, -1, 0, null, filterPropsSecondary, null);
        GetChildrenCannedQueryTest.assertEquals((int)1, (int)results.getPage().size());
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(folder3Ref));
    }

    public void testPropertyStringFiltering() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_NAME, "GC-CQ-File-" + TEST_RUN + "-", FilterPropString.FilterTypeString.STARTSWITH, 5);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_NAME, "gc-CQ-File-" + TEST_RUN + "-", FilterPropString.FilterTypeString.STARTSWITH, 0);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_NAME, "gC-CQ-File-" + TEST_RUN + "-", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE, 5);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_NAME, "CQ-CQ-File-" + TEST_RUN + "-", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE, 0);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_TITLE, "ZZ title " + TEST_RUN, FilterPropString.FilterTypeString.EQUALS, 2);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_TITLE, "zz title " + TEST_RUN, FilterPropString.FilterTypeString.EQUALS, 0);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_TITLE, "zZ tItLe " + TEST_RUN, FilterPropString.FilterTypeString.EQUALS_IGNORECASE, 2);
        this.filterByPropAndCheck(parentNodeRef, ContentModel.PROP_TITLE, "title " + TEST_RUN, FilterPropString.FilterTypeString.EQUALS, 0);
        ArrayList<FilterProp> filterProps = new ArrayList<FilterProp>(4);
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_USERNAME, String.valueOf(TEST_USER_PREFIX) + "dddd", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_FIRSTNAME, String.valueOf(TEST_USER_PREFIX) + "dddd", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        NodeRef peopleContainerRef = this.personService.getPeopleContainer();
        PagingResults<NodeRef> results = this.list(peopleContainerRef, -1, -1, 0, null, filterProps, null);
        GetChildrenCannedQueryTest.assertEquals((int)2, (int)results.getPage().size());
        filterProps.clear();
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_USERNAME, String.valueOf(TEST_USER_PREFIX) + "cccc", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_FIRSTNAME, String.valueOf(TEST_USER_PREFIX) + "cccc", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_LASTNAME, String.valueOf(TEST_USER_PREFIX) + "cccc", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        results = this.list(peopleContainerRef, -1, -1, 0, null, filterProps, null);
        GetChildrenCannedQueryTest.assertEquals((int)3, (int)results.getPage().size());
        filterProps.clear();
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_USERNAME, String.valueOf(TEST_USER_PREFIX) + "aaaa", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_FIRSTNAME, String.valueOf(TEST_USER_PREFIX) + "aaaa", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_LASTNAME, String.valueOf(TEST_USER_PREFIX) + "aaaa", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        results = this.list(peopleContainerRef, -1, -1, 0, null, filterProps, null);
        GetChildrenCannedQueryTest.assertEquals((int)1, (int)results.getPage().size());
        filterProps.clear();
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_USERNAME, String.valueOf(TEST_USER_PREFIX) + "ffff", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_FIRSTNAME, String.valueOf(TEST_USER_PREFIX) + "ffff", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_LASTNAME, String.valueOf(TEST_USER_PREFIX) + "ffff", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        results = this.list(peopleContainerRef, -1, -1, 0, null, filterProps, null);
        GetChildrenCannedQueryTest.assertEquals((int)1, (int)results.getPage().size());
        filterProps.clear();
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_USERNAME, String.valueOf(TEST_USER_PREFIX) + "jjjj", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_FIRSTNAME, String.valueOf(TEST_USER_PREFIX) + "jjjj", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_LASTNAME, String.valueOf(TEST_USER_PREFIX) + "jjjj", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        results = this.list(peopleContainerRef, -1, -1, 0, null, filterProps, null);
        GetChildrenCannedQueryTest.assertEquals((int)1, (int)results.getPage().size());
        filterProps.clear();
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_NAME, "a", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_TITLE, "a", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_DESCRIPTION, "a", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_CREATOR, "a", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        try {
            results = this.list(parentNodeRef, -1, -1, 0, null, filterProps, null);
            GetChildrenCannedQueryTest.fail((String)"Unexpected - cannot filter with more than three props");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    private float getFiveStarRating() {
        float rating = this.random.nextFloat() * (this.fiveStarRatingScheme.getMaxRating() - this.fiveStarRatingScheme.getMinRating()) + this.fiveStarRatingScheme.getMinRating();
        GetChildrenCannedQueryTest.assertTrue((String)("Five star rating is out of range: " + rating), (rating >= this.fiveStarRatingScheme.getMinRating() && rating <= this.fiveStarRatingScheme.getMaxRating() ? 1 : 0) != 0);
        return rating;
    }

    public void testPropertySorting() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        NodeRef nodeRef1 = null;
        NodeRef nodeRef2 = null;
        NodeRef nodeRef3 = null;
        NodeRef nodeRef4 = null;
        NodeRef nodeRef5 = null;
        NodeRef nodeRef6 = null;
        NodeRef nodeRef7 = null;
        NodeRef nodeRef8 = null;
        NodeRef nodeRef9 = null;
        NodeRef nodeRef10 = null;
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            nodeRef1 = this.createContent(parentNodeRef, "rating1", ContentModel.TYPE_CONTENT);
            nodeRef2 = this.createContent(parentNodeRef, "rating2", ContentModel.TYPE_CONTENT);
            nodeRef3 = this.createContent(parentNodeRef, "rating3", ContentModel.TYPE_CONTENT);
            nodeRef4 = this.createContent(parentNodeRef, "rating4", ContentModel.TYPE_CONTENT);
            nodeRef5 = this.createContent(parentNodeRef, "rating5", ContentModel.TYPE_CONTENT);
            nodeRef6 = this.createContent(parentNodeRef, "rating6", ContentModel.TYPE_CONTENT);
            nodeRef7 = this.createContent(parentNodeRef, "rating7", ContentModel.TYPE_CONTENT);
            nodeRef8 = this.createContent(parentNodeRef, "rating8", ContentModel.TYPE_CONTENT);
            nodeRef9 = this.createContent(parentNodeRef, "rating9", ContentModel.TYPE_CONTENT);
            nodeRef10 = this.createContent(parentNodeRef, "rating10", ContentModel.TYPE_CONTENT);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        this.ratingService.applyRating(nodeRef1, this.getFiveStarRating(), "fiveStarRatingScheme");
        this.ratingService.applyRating(nodeRef2, this.getFiveStarRating(), "fiveStarRatingScheme");
        this.ratingService.applyRating(nodeRef3, this.getFiveStarRating(), "fiveStarRatingScheme");
        this.ratingService.applyRating(nodeRef4, this.getFiveStarRating(), "fiveStarRatingScheme");
        this.ratingService.applyRating(nodeRef5, this.getFiveStarRating(), "fiveStarRatingScheme");
        this.ratingService.applyRating(nodeRef6, 1.0f, "likesRatingScheme");
        this.ratingService.applyRating(nodeRef7, 1.0f, "likesRatingScheme");
        this.ratingService.applyRating(nodeRef8, 1.0f, "likesRatingScheme");
        this.ratingService.applyRating(nodeRef9, 1.0f, "likesRatingScheme");
        this.ratingService.applyRating(nodeRef10, 1.0f, "likesRatingScheme");
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0);
        ArrayList<QName> sortQNames = new ArrayList<QName>(3);
        sortQNames.add(ContentModel.PROP_NAME);
        sortQNames.add(ContentModel.PROP_TITLE);
        sortQNames.add(ContentModel.PROP_DESCRIPTION);
        sortQNames.add(ContentModel.PROP_CREATED);
        sortQNames.add(ContentModel.PROP_CREATOR);
        sortQNames.add(ContentModel.PROP_MODIFIED);
        sortQNames.add(ContentModel.PROP_MODIFIER);
        sortQNames.add(GetChildrenCannedQuery.SORT_QNAME_CONTENT_SIZE);
        sortQNames.add(GetChildrenCannedQuery.SORT_QNAME_CONTENT_MIMETYPE);
        sortQNames.add(GetChildrenCannedQuery.SORT_QNAME_NODE_TYPE);
        sortQNames.add(GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER);
        sortQNames.add(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"fiveStarRatingSchemeCount"));
        sortQNames.add(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"likesRatingSchemeCount"));
        for (QName sortQName : sortQNames) {
            this.sortAndCheck(parentNodeRef, sortQName, false);
            this.sortAndCheck(parentNodeRef, sortQName, true);
        }
        ArrayList<Object> sortPairs = new ArrayList<Pair<QName, Boolean>>(3);
        sortPairs.add(new Pair((Object)ContentModel.PROP_TITLE, (Object)false));
        sortPairs.add(new Pair((Object)ContentModel.PROP_DESCRIPTION, (Object)false));
        results = this.list(parentNodeRef, -1, -1, 0, null, null, sortPairs);
        GetChildrenCannedQueryTest.assertEquals((Object)(String.valueOf(TEST_FILE_PREFIX) + "quick.pdf"), (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(0), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)(String.valueOf(TEST_FILE_PREFIX) + "quick.txt"), (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(1), ContentModel.PROP_NAME));
        sortPairs = new ArrayList(3);
        sortPairs.add((Pair<QName, Boolean>)new Pair((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER, (Object)false));
        sortPairs.add(new Pair((Object)ContentModel.PROP_NAME, (Object)true));
        results = this.list(parentNodeRef, -1, -1, 0, null, null, sortPairs);
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_1, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(0), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_2, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(1), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_3, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(2), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_4, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(3), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_5, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(4), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)(String.valueOf(TEST_FILE_PREFIX) + "quick.bmp"), (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(5), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)(String.valueOf(TEST_FILE_PREFIX) + "quick.doc"), (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(6), ContentModel.PROP_NAME));
        sortPairs = new ArrayList(3);
        sortPairs.add((Pair<QName, Boolean>)new Pair((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER, (Object)true));
        sortPairs.add(new Pair((Object)ContentModel.PROP_NAME, (Object)false));
        results = this.list(parentNodeRef, -1, -1, 0, null, null, sortPairs);
        int len = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((Object)"textContent", (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(0), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)"rating9", (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(1), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_5, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(len - 5), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_4, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(len - 4), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_3, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(len - 3), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_2, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(len - 2), ContentModel.PROP_NAME));
        GetChildrenCannedQueryTest.assertEquals((Object)FOLDER_1, (Object)this.nodeService.getProperty((NodeRef)results.getPage().get(len - 1), ContentModel.PROP_NAME));
        try {
            sortPairs = new ArrayList(3);
            sortPairs.add((Pair<QName, Boolean>)new Pair((Object)ContentModel.PROP_NAME, (Object)true));
            sortPairs.add(new Pair((Object)ContentModel.PROP_TITLE, (Object)true));
            sortPairs.add(new Pair((Object)ContentModel.PROP_DESCRIPTION, (Object)true));
            sortPairs.add(new Pair((Object)ContentModel.PROP_MODIFIED, (Object)true));
            results = this.list(parentNodeRef, -1, -1, 0, null, null, sortPairs);
            GetChildrenCannedQueryTest.fail((String)"Unexpected - cannot sort with more than three props");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    public void testPermissions() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-" + TEST_RUN_ID);
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        List nodeRefs = results.getPage();
        for (NodeRef nodeRef : this.permHits) {
            GetChildrenCannedQueryTest.assertTrue((boolean)nodeRefs.contains(nodeRef));
        }
        for (NodeRef nodeRef : this.permMisses) {
            GetChildrenCannedQueryTest.assertFalse((boolean)nodeRefs.contains(nodeRef));
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        results = this.list(parentNodeRef, -1, -1, 0);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        nodeRefs = results.getPage();
        for (NodeRef nodeRef : this.permHits) {
            GetChildrenCannedQueryTest.assertTrue((boolean)nodeRefs.contains(nodeRef));
        }
        for (NodeRef nodeRef : this.permMisses) {
            GetChildrenCannedQueryTest.assertTrue((boolean)nodeRefs.contains(nodeRef));
        }
    }

    public void testPatterns() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef parentNodeRef = this.nodeService.createNode(this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_FOLDER, null).getChildRef();
        NodeRef nodeRef1 = this.createContent(parentNodeRef, "page.component-1-2.user~admin~dashboard.xml", ContentModel.TYPE_CONTENT);
        NodeRef nodeRef2 = this.createContent(parentNodeRef, "page.component-1-4.user~admin~dashboard.xml", ContentModel.TYPE_CONTENT);
        NodeRef nodeRef3 = this.createContent(parentNodeRef, "page.xml", ContentModel.TYPE_CONTENT);
        NodeRef nodeRef4 = this.createContent(parentNodeRef, "page.component-1-4.user~admin~panel.xml", ContentModel.TYPE_CONTENT);
        NodeRef nodeRef5 = this.createContent(parentNodeRef, "page.component-1-4.user~admin~%dashboard.xml", ContentModel.TYPE_CONTENT);
        AuthenticationUtil.popAuthentication();
        String pattern = "page.*.user~admin~%dashboard.xml";
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        int totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertTrue((totalCnt == 1 ? 1 : 0) != 0);
        GetChildrenCannedQueryTest.assertEquals((Object)nodeRef5, results.getPage().get(0));
        pattern = "page.*.user~admin~dashboard.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertTrue((totalCnt == 2 ? 1 : 0) != 0);
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef1));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef2));
        pattern = "*";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertTrue((totalCnt == 5 ? 1 : 0) != 0);
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef1));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef2));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef3));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef4));
        GetChildrenCannedQueryTest.assertTrue((boolean)results.getPage().contains(nodeRef5));
        pattern = "foo*bar";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)0, (int)totalCnt);
        pattern = "page.*.admin~dashboard.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)0, (int)totalCnt);
        pattern = "page.*.user~admin~*.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)4, (int)totalCnt);
        pattern = "page.*.user~admin~%*.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)1, (int)totalCnt);
        pattern = "page.*.user~admin~%dashboard.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)1, (int)totalCnt);
        pattern = "page.component-1-4.user~admin~%dashboard.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)1, (int)totalCnt);
        pattern = "page.%.user~admin~%.xml";
        results = this.list(parentNodeRef, -1, -1, 0, pattern, null);
        GetChildrenCannedQueryTest.assertFalse((boolean)results.hasMoreItems());
        totalCnt = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((String)"", (int)0, (int)totalCnt);
    }

    public void testRestrictByAssocType() throws Exception {
        NodeRef parentNodeRef = this.getOrCreateParentTestFolder("GetChildrenCannedQueryTest-testFolder-" + TEST_RUN_ID);
        HashSet<QName> assocTypeQNames = new HashSet<QName>(3);
        HashSet<QName> childTypeQNames = new HashSet<QName>(3);
        assocTypeQNames.clear();
        assocTypeQNames.add(ContentModel.ASSOC_CONTAINS);
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_CONTENT);
        List<NodeRef> children = this.filterByAssocTypeAndCheck(parentNodeRef, assocTypeQNames, childTypeQNames);
        GetChildrenCannedQueryTest.assertEquals((int)1, (int)children.size());
        assocTypeQNames.clear();
        assocTypeQNames.add(QName.createQName((String)"http://www.alfresco.org/test/getchildrentest/1.0", (String)"contains1"));
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_CONTENT);
        children = this.filterByAssocTypeAndCheck(parentNodeRef, assocTypeQNames, childTypeQNames);
        GetChildrenCannedQueryTest.assertEquals((int)1, (int)children.size());
        assocTypeQNames.clear();
        assocTypeQNames.add(QName.createQName((String)"http://www.alfresco.org/test/getchildrentest/1.0", (String)"contains1"));
        assocTypeQNames.add(ContentModel.ASSOC_CONTAINS);
        childTypeQNames.clear();
        childTypeQNames.add(ContentModel.TYPE_CONTENT);
        children = this.filterByAssocTypeAndCheck(parentNodeRef, assocTypeQNames, childTypeQNames);
        GetChildrenCannedQueryTest.assertEquals((int)2, (int)children.size());
    }

    public void testAspectFiltering() throws Exception {
        NodeRef parentNodeRef = this.repositoryHelper.getCompanyHome();
        NodeRef nodeRef2 = null;
        NodeRef nodeRef4 = null;
        NodeRef nodeRef8 = null;
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            this.createContent(parentNodeRef, "node1", ContentModel.TYPE_CONTENT);
            nodeRef2 = this.createContent(parentNodeRef, "node2", ContentModel.TYPE_CONTENT);
            this.createContent(parentNodeRef, "node3", ContentModel.TYPE_CONTENT);
            nodeRef4 = this.createContent(parentNodeRef, "node4", ContentModel.TYPE_CONTENT);
            this.createContent(parentNodeRef, "node5", ContentModel.TYPE_CONTENT);
            this.createContent(parentNodeRef, "node6", ContentModel.TYPE_CONTENT);
            this.createContent(parentNodeRef, "node7", ContentModel.TYPE_CONTENT);
            nodeRef8 = this.createContent(parentNodeRef, "node8", ContentModel.TYPE_CONTENT);
            this.createContent(parentNodeRef, "node9", ContentModel.TYPE_CONTENT);
            this.createContent(parentNodeRef, "node10", ContentModel.TYPE_CONTENT);
            Map props = Collections.emptyMap();
            this.nodeService.addAspect(nodeRef2, ContentModel.ASPECT_CLASSIFIABLE, props);
            this.nodeService.addAspect(nodeRef4, ContentModel.ASPECT_CLASSIFIABLE, props);
            this.nodeService.addAspect(nodeRef4, RenditionModel.ASPECT_RENDITION, props);
            this.nodeService.addAspect(nodeRef8, ContentModel.ASPECT_CLASSIFIABLE, props);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0);
        List nodeRefs = results.getPage();
        for (NodeRef nodeRef : nodeRefs) {
            System.out.print(nodeRef);
            Set aspects = this.nodeService.getAspects(nodeRef);
            for (QName aspect : aspects) {
                System.out.print(" " + aspect);
            }
            System.out.println();
        }
        HashSet<QName> includedAspects = new HashSet<QName>(Arrays.asList(ContentModel.ASPECT_CLASSIFIABLE));
        results = this.list(parentNodeRef, includedAspects, null, -1, -1, 0);
        GetChildrenCannedQueryTest.assertEquals((int)3, (int)results.getPage().size());
        HashSet<QName> excludedAspects = new HashSet<QName>(Arrays.asList(RenditionModel.ASPECT_RENDITION));
        results = this.list(parentNodeRef, null, excludedAspects, -1, -1, 0);
        for (NodeRef result : results.getPage()) {
            GetChildrenCannedQueryTest.assertFalse((boolean)this.nodeService.getAspects(result).contains(RenditionModel.ASPECT_RENDITION));
        }
        results = this.list(parentNodeRef, includedAspects, excludedAspects, -1, -1, 0);
        GetChildrenCannedQueryTest.assertEquals((int)2, (int)results.getPage().size());
    }

    private PagingResults<NodeRef> list(NodeRef parentNodeRef, int skipCount, int maxItems, int requestTotalCountMax, String pattern, List<Pair<QName, Boolean>> sortProps) {
        PagingRequest pagingRequest = new PagingRequest(skipCount, maxItems, null);
        pagingRequest.setRequestTotalCountMax(requestTotalCountMax);
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)this.cannedQueryRegistry.getNamedObject(CQ_FACTORY_NAME);
        final GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(parentNodeRef, pattern, null, null, null, null, null, sortProps, pagingRequest);
        RetryingTransactionHelper.RetryingTransactionCallback<CannedQueryResults<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<CannedQueryResults<NodeRef>>(){

            public CannedQueryResults<NodeRef> execute() throws Throwable {
                return cq.execute();
            }
        };
        CannedQueryResults results = (CannedQueryResults)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        List nodeRefs = (List)results.getPages().get(0);
        Integer totalCount = null;
        if (requestTotalCountMax > 0) {
            totalCount = (Integer)results.getTotalResultCount().getFirst();
        }
        return new PagingNodeRefResultsImpl(nodeRefs, results.hasMoreItems(), totalCount, false);
    }

    private void filterByTypeAndCheck(NodeRef parentNodeRef, Set<QName> childTypeQNames, Set<QName> antiChildTypeQNames) {
        QName childNodeTypeQName;
        for (QName childTypeQName : childTypeQNames) {
            GetChildrenCannedQueryTest.assertFalse((boolean)antiChildTypeQNames.contains(childTypeQName));
        }
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0, childTypeQNames, null, null);
        GetChildrenCannedQueryTest.assertTrue((results.getPage().size() > 0 ? 1 : 0) != 0);
        PagingResults<NodeRef> antiResults = this.list(parentNodeRef, -1, -1, 0, antiChildTypeQNames, null, null);
        GetChildrenCannedQueryTest.assertTrue((antiResults.getPage().size() > 0 ? 1 : 0) != 0);
        List childNodeRefs = results.getPage();
        List antiChildNodeRefs = antiResults.getPage();
        for (NodeRef childNodeRef : childNodeRefs) {
            GetChildrenCannedQueryTest.assertFalse((boolean)antiChildNodeRefs.contains(childNodeRef));
        }
        for (NodeRef childNodeRef : childNodeRefs) {
            childNodeTypeQName = this.nodeService.getType(childNodeRef);
            GetChildrenCannedQueryTest.assertTrue((boolean)childTypeQNames.contains(childNodeTypeQName));
        }
        for (NodeRef childNodeRef : antiChildNodeRefs) {
            childNodeTypeQName = this.nodeService.getType(childNodeRef);
            GetChildrenCannedQueryTest.assertTrue((boolean)antiChildTypeQNames.contains(childNodeTypeQName));
        }
    }

    private List<NodeRef> filterByAssocTypeAndCheck(NodeRef parentNodeRef, Set<QName> assocTypeQNames, Set<QName> childTypeQNames) {
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0, assocTypeQNames, childTypeQNames, null, null, null, null);
        GetChildrenCannedQueryTest.assertTrue((results.getPage().size() > 0 ? 1 : 0) != 0);
        List childNodeRefs = results.getPage();
        return childNodeRefs;
    }

    private void filterByPropAndCheck(NodeRef parentNodeRef, QName filterPropQName, String filterVal, FilterPropString.FilterTypeString filterType, int expectedCount) {
        FilterPropString filter = new FilterPropString(filterPropQName, filterVal, filterType);
        ArrayList<FilterProp> filterProps = new ArrayList<FilterProp>(1);
        filterProps.add((FilterProp)filter);
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0, null, filterProps, null);
        int count = results.getPage().size();
        GetChildrenCannedQueryTest.assertEquals((int)expectedCount, (int)count);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("testFiltering: " + count + " items [" + filterPropQName + "," + filterVal + "," + filterType + "]"));
        }
        block6: for (NodeRef nodeRef : results.getPage()) {
            Serializable propVal = this.nodeService.getProperty(nodeRef, filterPropQName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("testFiltering:     [" + nodeRef + "," + propVal + "]"));
            }
            if (propVal instanceof String) {
                String val = (String)((Object)propVal);
                switch (filterType) {
                    case STARTSWITH: {
                        if (val.startsWith(filterVal)) continue block6;
                        GetChildrenCannedQueryTest.fail((String)("Unexpected val: " + val + " (does not 'startWith': " + filterVal + ")"));
                        break;
                    }
                    case STARTSWITH_IGNORECASE: {
                        if (val.toLowerCase().startsWith(filterVal.toLowerCase())) continue block6;
                        GetChildrenCannedQueryTest.fail((String)("Unexpected val: " + val + " (does not 'startWithIgnoreCase': " + filterVal + ")"));
                        break;
                    }
                    case EQUALS: {
                        if (val.equals(filterVal)) continue block6;
                        GetChildrenCannedQueryTest.fail((String)("Unexpected val: " + val + " (does not 'equal': " + filterVal + ")"));
                        break;
                    }
                    case EQUALS_IGNORECASE: {
                        if (val.equalsIgnoreCase(filterVal)) continue block6;
                        GetChildrenCannedQueryTest.fail((String)("Unexpected val: " + val + " (does not 'equalIgnoreCase': " + filterVal + ")"));
                    }
                }
                continue;
            }
            GetChildrenCannedQueryTest.fail((String)("Unsupported filter type: " + propVal.getClass().getName()));
        }
    }

    private void sortAndCheck(NodeRef parentNodeRef, QName sortPropQName, boolean sortAscending) {
        ArrayList<Pair<QName, Boolean>> sortPairs = new ArrayList<Pair<QName, Boolean>>(1);
        sortPairs.add(new Pair((Object)sortPropQName, (Object)sortAscending));
        PagingResults<NodeRef> results = this.list(parentNodeRef, -1, -1, 0, null, null, sortPairs);
        int count = results.getPage().size();
        GetChildrenCannedQueryTest.assertTrue((count > 3 ? 1 : 0) != 0);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("testSorting: " + count + " items [" + sortPropQName + "," + (sortAscending ? " ascending" : " descending") + "]"));
        }
        Collator collator = AlfrescoCollator.getInstance((Locale)I18NUtil.getContentLocale());
        Object prevVal = null;
        NodeRef prevNodeRef = null;
        int currentIteration = 0;
        boolean allValsNull = true;
        for (NodeRef nodeRef : results.getPage()) {
            ++currentIteration;
            Object val = null;
            if (sortPropQName.equals((Object)GetChildrenCannedQuery.SORT_QNAME_CONTENT_SIZE) || sortPropQName.equals((Object)GetChildrenCannedQuery.SORT_QNAME_CONTENT_MIMETYPE)) {
                ContentData cd = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
                if (cd != null) {
                    if (sortPropQName.equals((Object)GetChildrenCannedQuery.SORT_QNAME_CONTENT_SIZE)) {
                        val = cd.getSize();
                    } else if (sortPropQName.equals((Object)GetChildrenCannedQuery.SORT_QNAME_CONTENT_MIMETYPE)) {
                        val = cd.getMimetype();
                    }
                }
            } else {
                val = sortPropQName.equals((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_TYPE) ? this.nodeService.getType(nodeRef) : (sortPropQName.equals((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER) ? Boolean.valueOf(this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_FOLDER)) : this.nodeService.getProperty(nodeRef, sortPropQName));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("testSorting:     [" + nodeRef + ", " + val + "]"));
            }
            int result = 0;
            if (val != null) {
                allValsNull = false;
            }
            if (prevVal == null) {
                result = val == null ? 0 : 1;
            } else if (val == null) {
                result = -1;
            } else {
                if (val instanceof Date) {
                    result = ((Date)val).compareTo((Date)prevVal);
                } else if (val instanceof String) {
                    result = collator.compare((String)val, (String)prevVal);
                } else if (val instanceof Long) {
                    result = ((Long)val).compareTo((Long)prevVal);
                } else if (val instanceof Integer) {
                    result = ((Integer)val).compareTo((Integer)prevVal);
                } else if (val instanceof QName) {
                    result = val.compareTo((QName)prevVal);
                } else if (val instanceof Boolean) {
                    result = ((Boolean)val).compareTo((Boolean)prevVal);
                } else {
                    GetChildrenCannedQueryTest.fail((String)("Unsupported sort type (" + nodeRef + "): " + val.getClass().getName()));
                }
                String prevName = (String)((Object)this.nodeService.getProperty(prevNodeRef, ContentModel.PROP_NAME));
                String currName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                if (!sortAscending) {
                    GetChildrenCannedQueryTest.assertTrue((String)("Not descending: " + result + "\n" + "   Iteration: " + currentIteration + " out of " + count + "\n" + "   Previous:  " + prevNodeRef + " had " + prevVal + " (" + prevName + ")\n" + "   Current :  " + nodeRef + " had " + val + " (" + currName + ")"), (result <= 0 ? 1 : 0) != 0);
                } else {
                    GetChildrenCannedQueryTest.assertTrue((String)("Not ascending: " + result + "\n" + "   Iteration: " + currentIteration + " out of " + count + "\n" + "   Previous:  " + prevNodeRef + " had " + prevVal + " (" + prevName + ")\n" + "   Current :  " + nodeRef + " had " + val + " (" + currName + ")"), (result >= 0 ? 1 : 0) != 0);
                }
            }
            prevVal = val;
            prevNodeRef = nodeRef;
        }
        GetChildrenCannedQueryTest.assertFalse((String)"All values were null", (boolean)allValsNull);
    }

    private PagingResults<NodeRef> list(NodeRef parentNodeRef, Set<QName> inclusiveAspects, Set<QName> exclusiveAscpects, int skipCount, int maxItems, int requestTotalCountMax) {
        return this.list(parentNodeRef, skipCount, maxItems, requestTotalCountMax, null, null, null, null, inclusiveAspects, exclusiveAscpects);
    }

    private PagingResults<NodeRef> list(NodeRef parentNodeRef, int skipCount, int maxItems, int requestTotalCountMax) {
        return this.list(parentNodeRef, skipCount, maxItems, requestTotalCountMax, null, null, null, null, null, null);
    }

    private PagingResults<NodeRef> list(NodeRef parentNodeRef, int skipCount, int maxItems, int requestTotalCountMax, Set<QName> childTypeQNames, List<FilterProp> filterProps, List<Pair<QName, Boolean>> sortProps) {
        PagingRequest pagingRequest = new PagingRequest(skipCount, maxItems, null);
        pagingRequest.setRequestTotalCountMax(requestTotalCountMax);
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)this.cannedQueryRegistry.getNamedObject(CQ_FACTORY_NAME);
        final GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(parentNodeRef, null, null, childTypeQNames, null, null, filterProps, sortProps, pagingRequest);
        RetryingTransactionHelper.RetryingTransactionCallback<CannedQueryResults<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<CannedQueryResults<NodeRef>>(){

            public CannedQueryResults<NodeRef> execute() throws Throwable {
                return cq.execute();
            }
        };
        CannedQueryResults results = (CannedQueryResults)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        List nodeRefs = (List)results.getPages().get(0);
        Integer totalCount = null;
        if (requestTotalCountMax > 0) {
            totalCount = (Integer)results.getTotalResultCount().getFirst();
        }
        return new PagingNodeRefResultsImpl(nodeRefs, results.hasMoreItems(), totalCount, false);
    }

    private PagingResults<NodeRef> list(NodeRef parentNodeRef, int skipCount, int maxItems, int requestTotalCountMax, Set<QName> assocTypeQNames, Set<QName> childTypeQNames, List<FilterProp> filterProps, List<Pair<QName, Boolean>> sortProps, Set<QName> inclusiveAspects, Set<QName> exclusiveAspects) {
        PagingRequest pagingRequest = new PagingRequest(skipCount, maxItems, null);
        pagingRequest.setRequestTotalCountMax(requestTotalCountMax);
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)this.cannedQueryRegistry.getNamedObject(CQ_FACTORY_NAME);
        final GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(parentNodeRef, null, assocTypeQNames, childTypeQNames, inclusiveAspects, exclusiveAspects, filterProps, sortProps, pagingRequest);
        RetryingTransactionHelper.RetryingTransactionCallback<CannedQueryResults<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<CannedQueryResults<NodeRef>>(){

            public CannedQueryResults<NodeRef> execute() throws Throwable {
                return cq.execute();
            }
        };
        CannedQueryResults results = (CannedQueryResults)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        List nodeRefs = (List)results.getPages().get(0);
        Integer totalCount = null;
        if (requestTotalCountMax > 0) {
            totalCount = (Integer)results.getTotalResultCount().getFirst();
        }
        return new PagingNodeRefResultsImpl(nodeRefs, results.hasMoreItems(), totalCount, false);
    }

    private NodeRef createFolder(NodeRef parentNodeRef, String folderName, QName folderType) throws IOException {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, folderName);
        NodeRef nodeRef = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, folderName);
        if (nodeRef != null) {
            this.nodeService.deleteNode(nodeRef);
        }
        nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)folderName), folderType, properties).getChildRef();
        return nodeRef;
    }

    private NodeRef createContent(NodeRef parentNodeRef, String fileName, QName contentType) throws IOException {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, fileName);
        properties.put(ContentModel.PROP_TITLE, String.valueOf(fileName) + " my title");
        properties.put(ContentModel.PROP_DESCRIPTION, String.valueOf(fileName) + " my description");
        NodeRef nodeRef = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, fileName);
        if (nodeRef != null) {
            this.nodeService.deleteNode(nodeRef);
        }
        nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)fileName), contentType, properties).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(this.mimetypeService.guessMimetype(fileName));
        writer.putContent("my text content");
        return nodeRef;
    }

    private NodeRef createContent(NodeRef parentNodeRef, QName childAssocType, String fileName, QName contentType) throws IOException {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, fileName);
        properties.put(ContentModel.PROP_TITLE, String.valueOf(fileName) + " my title");
        properties.put(ContentModel.PROP_DESCRIPTION, String.valueOf(fileName) + " my description");
        NodeRef nodeRef = this.nodeService.getChildByName(parentNodeRef, childAssocType, fileName);
        if (nodeRef != null) {
            this.nodeService.deleteNode(nodeRef);
        }
        nodeRef = this.nodeService.createNode(parentNodeRef, childAssocType, QName.createQName((String)fileName), contentType, properties).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(this.mimetypeService.guessMimetype(fileName));
        writer.putContent("my text content");
        return nodeRef;
    }

    private void loadContent(NodeRef parentNodeRef, String inFileName, String title, String description, boolean readAllowed, Set<NodeRef> results) throws IOException {
        String newFileName = String.valueOf(TEST_FILE_PREFIX) + inFileName;
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, newFileName);
        properties.put(ContentModel.PROP_TITLE, title);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        NodeRef nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)newFileName), ContentModel.TYPE_CONTENT, properties).getChildRef();
        String classPath = "quick/" + inFileName;
        File file = null;
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(classPath);
        if (url != null && !(file = new File(url.getFile())).exists()) {
            file = null;
        }
        if (file == null) {
            GetChildrenCannedQueryTest.fail((String)("Unable to find test file: " + classPath));
        }
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(this.mimetypeService.guessMimetype(inFileName));
        writer.putContent(file);
        if (!readAllowed) {
            this.permissionService.setInheritParentPermissions(nodeRef, false);
        }
        results.add(nodeRef);
    }

    private void createUser(String userName, String firstName, String lastName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(5);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)firstName);
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)lastName);
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    public void testPagingGetChildrenCannedQueryWithoutProps() throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            int itemCount = 1500;
            int repeatListCount = 5;
            HashSet<QName> assocTypeQNames = new HashSet<QName>(1);
            assocTypeQNames.add(ContentModel.ASSOC_CONTAINS);
            HashSet<QName> childTypeQNames = new HashSet<QName>(1);
            childTypeQNames.add(ContentModel.TYPE_FOLDER);
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            NodeRef testFolder = this.repositoryHelper.getCompanyHome();
            NodeRef parentFolder = this.createFolder(testFolder, "testCreateList-" + GUID.generate(), ContentModel.TYPE_FOLDER);
            int i = 1;
            while (i <= itemCount) {
                String folderName = "folder_" + GUID.generate();
                this.createFolder(parentFolder, folderName, ContentModel.TYPE_FOLDER);
                ++i;
            }
            int j = 1;
            while (j <= repeatListCount) {
                boolean hasMore = true;
                int skipCount = 0;
                int maxItems = 100;
                int count = 0;
                HashSet<String> docIds = new HashSet<String>(itemCount);
                while (hasMore) {
                    PagingResults<NodeRef> results = this.list(parentFolder, skipCount, maxItems, skipCount + 10000, assocTypeQNames, childTypeQNames, null, null, null, null);
                    hasMore = results.hasMoreItems();
                    skipCount += maxItems;
                    for (NodeRef nodeRef : results.getPage()) {
                        docIds.add(nodeRef.getId());
                        ++count;
                    }
                }
                GetChildrenCannedQueryTest.assertEquals((int)itemCount, (int)count);
                GetChildrenCannedQueryTest.assertEquals((int)itemCount, (int)docIds.size());
                ++j;
            }
            System.out.println("Test time: " + (System.currentTimeMillis() - startTime) + " ms");
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    private class PagingNodeRefResultsImpl
    implements PagingResults<NodeRef> {
        private List<NodeRef> nodeRefs;
        private boolean hasMorePages;
        private Integer totalResultCount;
        private Boolean isTotalResultCountCutoff;

        public PagingNodeRefResultsImpl(List<NodeRef> nodeRefs, boolean hasMorePages, Integer totalResultCount, Boolean isTotalResultCountCutoff) {
            this.nodeRefs = nodeRefs;
            this.hasMorePages = hasMorePages;
            this.totalResultCount = totalResultCount;
            this.isTotalResultCountCutoff = isTotalResultCountCutoff;
        }

        public List<NodeRef> getPage() {
            return this.nodeRefs;
        }

        public boolean hasMoreItems() {
            return this.hasMorePages;
        }

        public Pair<Integer, Integer> getTotalResultCount() {
            return new Pair((Object)this.totalResultCount, (Object)(this.isTotalResultCountCutoff != false ? null : this.totalResultCount));
        }

        public String getQueryExecutionId() {
            return "";
        }
    }
}

