/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class RuleLinkTest
extends BaseSpringTest {
    protected static final String RULE_TYPE_NAME = "inbound";
    protected static final String ACTION_DEF_NAME = "add-features";
    protected static final String ACTION_PROP_NAME_1 = "aspect-name";
    protected static final QName ACTION_PROP_VALUE_1 = ContentModel.ASPECT_LOCKABLE;
    protected static final String CONDITION_DEF_NAME = "compare-property-value";
    protected static final String COND_PROP_NAME_1 = "value";
    protected static final String COND_PROP_VALUE_1 = ".doc";
    private NodeService nodeService;
    private RuleService ruleService;
    private ActionService actionService;
    private AuthenticationComponent authenticationComponent;
    private FileFolderService fileFolderService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef folderOne;
    private NodeRef folderTwo;
    private NodeRef folderThree;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_FOLDER).getChildRef();
        this.folderOne = this.fileFolderService.create(folder, "folderOne", ContentModel.TYPE_FOLDER).getNodeRef();
        this.folderTwo = this.fileFolderService.create(folder, "folderTwo", ContentModel.TYPE_FOLDER).getNodeRef();
        this.folderThree = this.fileFolderService.create(folder, "folderThree", ContentModel.TYPE_FOLDER).getNodeRef();
    }

    @Test
    public void testLinkRule() {
        Rule rule = this.createTestRule(false, "bobs rule");
        this.ruleService.saveRule(this.folderOne, rule);
        RuleLinkTest.assertTrue((boolean)this.ruleService.hasRules(this.folderOne));
        RuleLinkTest.assertEquals((int)1, (int)this.ruleService.getRules(this.folderOne, false).size());
        RuleLinkTest.assertFalse((boolean)this.ruleService.isLinkedToRuleNode(this.folderOne));
        RuleLinkTest.assertFalse((boolean)this.ruleService.hasRules(this.folderTwo));
        RuleLinkTest.assertEquals((int)0, (int)this.ruleService.getRules(this.folderTwo, false).size());
        RuleLinkTest.assertFalse((boolean)this.ruleService.isLinkedToRuleNode(this.folderTwo));
        Action linkAction = this.actionService.createAction("link-rules");
        linkAction.setParameterValue("link_from_node", (Serializable)this.folderOne);
        this.actionService.executeAction(linkAction, this.folderTwo);
        RuleLinkTest.assertTrue((boolean)this.ruleService.hasRules(this.folderOne));
        RuleLinkTest.assertEquals((int)1, (int)this.ruleService.getRules(this.folderOne, false).size());
        RuleLinkTest.assertFalse((boolean)this.ruleService.isLinkedToRuleNode(this.folderOne));
        RuleLinkTest.assertTrue((boolean)this.ruleService.hasRules(this.folderTwo));
        RuleLinkTest.assertEquals((int)1, (int)this.ruleService.getRules(this.folderTwo, false).size());
        boolean value = this.ruleService.isLinkedToRuleNode(this.folderTwo);
        RuleLinkTest.assertTrue((boolean)value);
        RuleLinkTest.assertEquals((Object)this.folderOne, (Object)this.ruleService.getLinkedToRuleNode(this.folderTwo));
        List linkedFrom = this.ruleService.getLinkedFromRuleNodes(this.folderTwo);
        RuleLinkTest.assertNotNull((Object)linkedFrom);
        RuleLinkTest.assertTrue((boolean)linkedFrom.isEmpty());
        linkedFrom = this.ruleService.getLinkedFromRuleNodes(this.folderOne);
        RuleLinkTest.assertNotNull((Object)linkedFrom);
        RuleLinkTest.assertEquals((int)1, (int)linkedFrom.size());
        RuleLinkTest.assertEquals((Object)this.folderTwo, linkedFrom.get(0));
        try {
            rule = this.createTestRule(false, "bobs rule 2");
            this.ruleService.saveRule(this.folderTwo, rule);
            RuleLinkTest.fail((String)"Shouldn't be able to add a new rule to a linked rule set");
        }
        catch (RuleServiceException ruleServiceException) {}
        rule = this.createTestRule(false, "bobs other rule");
        this.ruleService.saveRule(this.folderOne, rule);
        RuleLinkTest.assertTrue((boolean)this.ruleService.hasRules(this.folderOne));
        RuleLinkTest.assertEquals((int)2, (int)this.ruleService.getRules(this.folderOne, false).size());
        RuleLinkTest.assertFalse((boolean)this.ruleService.isLinkedToRuleNode(this.folderOne));
        RuleLinkTest.assertTrue((boolean)this.ruleService.hasRules(this.folderTwo));
        RuleLinkTest.assertEquals((int)2, (int)this.ruleService.getRules(this.folderTwo, false).size());
        value = this.ruleService.isLinkedToRuleNode(this.folderTwo);
        RuleLinkTest.assertTrue((boolean)value);
        RuleLinkTest.assertEquals((Object)this.folderOne, (Object)this.ruleService.getLinkedToRuleNode(this.folderTwo));
        linkedFrom = this.ruleService.getLinkedFromRuleNodes(this.folderTwo);
        RuleLinkTest.assertNotNull((Object)linkedFrom);
        RuleLinkTest.assertTrue((boolean)linkedFrom.isEmpty());
        linkedFrom = this.ruleService.getLinkedFromRuleNodes(this.folderOne);
        RuleLinkTest.assertNotNull((Object)linkedFrom);
        RuleLinkTest.assertEquals((int)1, (int)linkedFrom.size());
        RuleLinkTest.assertEquals((Object)this.folderTwo, linkedFrom.get(0));
        this.unlink(this.folderTwo);
        RuleLinkTest.assertTrue((boolean)this.ruleService.hasRules(this.folderOne));
        RuleLinkTest.assertEquals((int)2, (int)this.ruleService.getRules(this.folderOne, false).size());
        RuleLinkTest.assertFalse((boolean)this.ruleService.isLinkedToRuleNode(this.folderOne));
        RuleLinkTest.assertFalse((boolean)this.ruleService.hasRules(this.folderTwo));
        RuleLinkTest.assertEquals((int)0, (int)this.ruleService.getRules(this.folderTwo, false).size());
        RuleLinkTest.assertFalse((boolean)this.ruleService.isLinkedToRuleNode(this.folderTwo));
    }

    private void link(NodeRef folderFrom, NodeRef folderTo) {
        Action linkAction = this.actionService.createAction("link-rules");
        linkAction.setParameterValue("link_from_node", (Serializable)folderFrom);
        this.actionService.executeAction(linkAction, folderTo);
    }

    private void unlink(NodeRef folder) {
        Action unlinkAction = this.actionService.createAction("unlink-rules");
        this.actionService.executeAction(unlinkAction, folder);
    }

    @Test
    public void testRelink() {
        Rule rule = this.createTestRule(false, "luke");
        this.ruleService.saveRule(this.folderOne, rule);
        rule = this.createTestRule(false, "chewy");
        this.ruleService.saveRule(this.folderTwo, rule);
        rule = this.createTestRule(false, "han");
        this.ruleService.saveRule(this.folderTwo, rule);
        List rules = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertNotNull((Object)rules);
        RuleLinkTest.assertTrue((boolean)rules.isEmpty());
        this.link(this.folderOne, this.folderThree);
        rules = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertNotNull((Object)rules);
        RuleLinkTest.assertFalse((boolean)rules.isEmpty());
        RuleLinkTest.assertEquals((int)1, (int)rules.size());
        this.link(this.folderTwo, this.folderThree);
        rules = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertNotNull((Object)rules);
        RuleLinkTest.assertFalse((boolean)rules.isEmpty());
        RuleLinkTest.assertEquals((int)2, (int)rules.size());
        try {
            rules = this.ruleService.getRules(this.folderTwo);
            RuleLinkTest.assertNotNull((Object)rules);
            RuleLinkTest.assertFalse((boolean)rules.isEmpty());
            RuleLinkTest.assertEquals((int)2, (int)rules.size());
            this.link(this.folderTwo, this.folderOne);
            RuleLinkTest.fail((String)"Shouldn't be able to link a folder that already has rules that it owns.");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
        this.unlink(this.folderThree);
        rules = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertNotNull((Object)rules);
        RuleLinkTest.assertTrue((boolean)rules.isEmpty());
        this.link(this.folderTwo, this.folderThree);
        rules = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertNotNull((Object)rules);
        RuleLinkTest.assertFalse((boolean)rules.isEmpty());
        RuleLinkTest.assertEquals((int)2, (int)rules.size());
    }

    @Test
    public void testDeleteFolderWithPrimaryRules() {
        Rule rule = this.createTestRule(false, "luke");
        this.ruleService.saveRule(this.folderOne, rule);
        this.link(this.folderOne, this.folderTwo);
        this.link(this.folderOne, this.folderThree);
        List rules1 = this.ruleService.getRules(this.folderOne);
        RuleLinkTest.assertNotNull((Object)rules1);
        RuleLinkTest.assertFalse((boolean)rules1.isEmpty());
        RuleLinkTest.assertEquals((int)1, (int)rules1.size());
        List rules2 = this.ruleService.getRules(this.folderTwo);
        RuleLinkTest.assertEquals((Object)rules1, (Object)rules2);
        List rules3 = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertEquals((Object)rules1, (Object)rules3);
        this.nodeService.deleteNode(this.folderOne);
        rules2 = this.ruleService.getRules(this.folderTwo);
        rules3 = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertTrue((boolean)rules2.isEmpty());
        RuleLinkTest.assertFalse((boolean)this.nodeService.hasAspect(this.folderTwo, RuleModel.ASPECT_RULES));
        RuleLinkTest.assertTrue((boolean)rules3.isEmpty());
        RuleLinkTest.assertFalse((boolean)this.nodeService.hasAspect(this.folderThree, RuleModel.ASPECT_RULES));
    }

    @Test
    public void testDeleteFolderWithSecondaryRules() {
        Rule rule = this.createTestRule(false, "luke");
        this.ruleService.saveRule(this.folderOne, rule);
        this.link(this.folderOne, this.folderTwo);
        this.link(this.folderOne, this.folderThree);
        List rules1 = this.ruleService.getRules(this.folderOne);
        RuleLinkTest.assertNotNull((Object)rules1);
        RuleLinkTest.assertFalse((boolean)rules1.isEmpty());
        RuleLinkTest.assertEquals((int)1, (int)rules1.size());
        List rules2 = this.ruleService.getRules(this.folderTwo);
        RuleLinkTest.assertEquals((Object)rules1, (Object)rules2);
        List rules3 = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertEquals((Object)rules1, (Object)rules3);
        this.nodeService.deleteNode(this.folderTwo);
        rules1 = this.ruleService.getRules(this.folderOne);
        rules3 = this.ruleService.getRules(this.folderThree);
        RuleLinkTest.assertFalse((boolean)rules1.isEmpty());
        RuleLinkTest.assertTrue((boolean)this.nodeService.hasAspect(this.folderOne, RuleModel.ASPECT_RULES));
        RuleLinkTest.assertFalse((boolean)rules3.isEmpty());
        RuleLinkTest.assertTrue((boolean)this.nodeService.hasAspect(this.folderThree, RuleModel.ASPECT_RULES));
        RuleLinkTest.assertEquals((Object)rules1, (Object)rules3);
    }

    protected Rule createTestRule(boolean isAppliedToChildren, String title) {
        HashMap<String, String> conditionProps = new HashMap<String, String>();
        conditionProps.put(COND_PROP_NAME_1, COND_PROP_VALUE_1);
        HashMap<String, QName> actionProps = new HashMap<String, QName>();
        actionProps.put(ACTION_PROP_NAME_1, ACTION_PROP_VALUE_1);
        ArrayList<String> ruleTypes = new ArrayList<String>(1);
        ruleTypes.add(RULE_TYPE_NAME);
        Action action = this.actionService.createAction(CONDITION_DEF_NAME);
        action.setParameterValues(conditionProps);
        ActionCondition actionCondition = this.actionService.createActionCondition(CONDITION_DEF_NAME);
        actionCondition.setParameterValues(conditionProps);
        action.addActionCondition(actionCondition);
        Rule rule = new Rule();
        rule.setRuleTypes(ruleTypes);
        rule.setTitle(title);
        rule.setDescription("bob");
        rule.applyToChildren(isAppliedToChildren);
        rule.setAction(action);
        return rule;
    }
}

