/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.subscriptions;

import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.PrivateSubscriptionListException;
import org.alfresco.service.cmr.subscriptions.SubscriptionItemTypeEnum;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class SubscriptionServiceImplTest
extends TestCase {
    public static final String[] CONTEXTS = new String[]{"classpath:alfresco/application-context.xml", "classpath:test/alfresco/test-subscriptions-context.xml"};
    public static final String USER_BOB = "bob" + GUID.generate();
    public static final String USER_TOM = "tom" + GUID.generate();
    public static final String USER_LISA = "lisa" + GUID.generate();
    public static final String FOLLOWED_NODE_NAME = "Followed.txt";
    public static final QName ASPECT_ARCHIVE = QName.createQName((String)"http://www.alfresco.org/model/testsubscriptionsmodel/1.0", (String)"archive");
    private UserTransaction txn;
    protected ApplicationContext ctx;
    protected TransactionService transactionService;
    protected SubscriptionService subscriptionService;
    protected PersonService personService;
    protected NodeService nodeService;
    protected SearchService searchService;
    protected Repository repositoryHelper;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext((String[])CONTEXTS);
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.subscriptionService = (SubscriptionService)this.ctx.getBean("SubscriptionService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.searchService = (SearchService)this.ctx.getBean("SearchService");
        this.repositoryHelper = (Repository)this.ctx.getBean("repositoryHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.txn = this.transactionService.getNonPropagatingUserTransaction(false);
        this.txn.begin();
        this.createPerson(USER_BOB);
        this.createPerson(USER_TOM);
        this.createPerson(USER_LISA);
    }

    protected void tearDown() throws Exception {
        this.deletePerson(USER_BOB);
        this.deletePerson(USER_TOM);
        this.deletePerson(USER_LISA);
        if (this.txn != null) {
            if (this.txn.getStatus() == 1) {
                this.txn.rollback();
            } else {
                this.txn.commit();
            }
            this.txn = null;
        }
    }

    protected void deletePerson(String userId) {
        this.personService.deletePerson(userId);
    }

    protected NodeRef createPerson(String userId) {
        this.deletePerson(userId);
        PropertyMap properties = new PropertyMap(5);
        properties.put((Object)ContentModel.PROP_USERNAME, (Object)userId);
        properties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userId);
        properties.put((Object)ContentModel.PROP_LASTNAME, (Object)"Test");
        properties.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(userId) + "@test.demo.alfresco.com"));
        return this.personService.createPerson((Map)properties);
    }

    public void testFollow() throws Exception {
        String userId1 = USER_BOB;
        String userId2 = USER_TOM;
        String userId3 = USER_LISA;
        if (this.subscriptionService.follows(userId1, userId2)) {
            this.subscriptionService.unfollow(userId1, userId2);
        }
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.follows(userId1, userId2));
        int count = this.subscriptionService.getFollowingCount(userId1);
        SubscriptionServiceImplTest.assertTrue((count >= 0 ? 1 : 0) != 0);
        this.subscriptionService.follow(userId1, userId2);
        this.subscriptionService.follow(userId1, userId2);
        SubscriptionServiceImplTest.assertEquals((int)(count + 1), (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId2));
        this.subscriptionService.follow(userId1, userId3);
        SubscriptionServiceImplTest.assertEquals((int)(count + 2), (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId3));
        PagingFollowingResults following = this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null));
        SubscriptionServiceImplTest.assertNotNull((Object)following);
        SubscriptionServiceImplTest.assertNotNull((Object)following.getPage());
        SubscriptionServiceImplTest.assertTrue((boolean)following.getPage().contains(userId2));
        SubscriptionServiceImplTest.assertTrue((boolean)following.getPage().contains(userId3));
        int followerCount = this.subscriptionService.getFollowersCount(userId2);
        SubscriptionServiceImplTest.assertTrue((followerCount > 0 ? 1 : 0) != 0);
        PagingFollowingResults followers = this.subscriptionService.getFollowers(userId2, new PagingRequest(100000, null));
        SubscriptionServiceImplTest.assertNotNull((Object)followers);
        SubscriptionServiceImplTest.assertNotNull((Object)followers.getPage());
        SubscriptionServiceImplTest.assertTrue((boolean)followers.getPage().contains(userId1));
        this.subscriptionService.unfollow(userId1, userId2);
        SubscriptionServiceImplTest.assertEquals((int)(count + 1), (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.follows(userId1, userId2));
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId3));
        this.subscriptionService.unfollow(userId1, userId3);
        SubscriptionServiceImplTest.assertEquals((int)count, (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.follows(userId1, userId3));
    }

    public void testDeletePerson() throws Exception {
        String userId1 = USER_BOB;
        String userId2 = "subscription-temp-user";
        this.createPerson(userId2);
        this.subscriptionService.follow(userId1, userId2);
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId2));
        this.deletePerson(userId2);
        PagingFollowingResults following = this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null));
        SubscriptionServiceImplTest.assertNotNull((Object)following);
        SubscriptionServiceImplTest.assertNotNull((Object)following.getPage());
        SubscriptionServiceImplTest.assertFalse((boolean)following.getPage().contains(userId2));
    }

    public void testPrivateList() throws Exception {
        final String userId1 = USER_BOB;
        String userId2 = USER_TOM;
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.isSubscriptionListPrivate(userId1));
        this.subscriptionService.setSubscriptionListPrivate(userId1, false);
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.isSubscriptionListPrivate(userId1));
        this.subscriptionService.setSubscriptionListPrivate(userId1, true);
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.isSubscriptionListPrivate(userId1));
        this.subscriptionService.setSubscriptionListPrivate(userId1, false);
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.isSubscriptionListPrivate(userId1));
        this.subscriptionService.setSubscriptionListPrivate(userId1, true);
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.isSubscriptionListPrivate(userId1));
        this.subscriptionService.follow(userId1, userId2);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceImplTest.assertNotNull((Object)SubscriptionServiceImplTest.this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null)));
                return null;
            }
        }, (String)userId1);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceImplTest.assertNotNull((Object)SubscriptionServiceImplTest.this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null)));
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    SubscriptionServiceImplTest.this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null));
                    SubscriptionServiceImplTest.fail((String)"Expected PrivateSubscriptionListException!");
                }
                catch (PrivateSubscriptionListException privateSubscriptionListException) {}
                return null;
            }
        }, (String)userId2);
    }

    public void testSubscriptionsRemovalOnArchivingNodesForAlf12358() throws Exception {
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        ChildAssociationRef followed = null;
        int initialCount = this.subscriptionService.getSubscriptionCount(USER_TOM, SubscriptionItemTypeEnum.USER);
        try {
            followed = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)FOLLOWED_NODE_NAME)), ContentModel.TYPE_USER);
            this.nodeService.addAspect(followed.getChildRef(), ASPECT_ARCHIVE, null);
            SubscriptionServiceImplTest.assertTrue((String)"Fake User node MUST BE archival!", (boolean)this.nodeService.hasAspect(followed.getChildRef(), ASPECT_ARCHIVE));
            this.subscriptionService.subscribe(USER_TOM, followed.getChildRef());
            SubscriptionServiceImplTest.assertEquals((String)"Initial subscriptions count MUST BE lesser by 1 after adding new subscription!", (int)1, (int)(this.subscriptionService.getSubscriptionCount(USER_TOM, SubscriptionItemTypeEnum.USER) - initialCount));
            this.nodeService.deleteNode(followed.getChildRef());
            SubscriptionServiceImplTest.assertEquals((String)"Archiving of node MUST cause removal all the subscriptions created against it!", (int)initialCount, (int)this.subscriptionService.getSubscriptionCount(USER_TOM, SubscriptionItemTypeEnum.USER));
        }
        catch (Throwable throwable) {
            if (followed != null && this.nodeService.exists(followed.getChildRef())) {
                try {
                    this.nodeService.deleteNode(followed.getChildRef());
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (followed != null && this.nodeService.exists(followed.getChildRef())) {
            try {
                this.nodeService.deleteNode(followed.getChildRef());
            }
            catch (Exception exception) {}
        }
    }
}

