/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.rendition.MockedTestServiceRegistry;
import org.alfresco.repo.rendition.RenditionServiceImpl;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.thumbnail.ThumbnailRenditionConvertor;
import org.alfresco.repo.thumbnail.ThumbnailServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.PagedSourceOptions;
import org.alfresco.service.cmr.repository.TemporalSourceOptions;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Deprecated
public class ThumbnailServiceImplParameterTest {
    private ActionService mockActionService = (ActionService)Mockito.mock(ActionService.class);
    private RenditionService2Impl mockRenditionService2 = (RenditionService2Impl)Mockito.mock(RenditionService2Impl.class);
    private RenditionServiceImpl renditionService;
    private ThumbnailService thumbnailService;
    private final NodeRef dummyNodeRef1 = new NodeRef("workspace", "dummy", "dummyID_1");
    private final NodeRef dummyNodeRef2 = new NodeRef("workspace", "dummy", "dummyID_2");
    private final NodeRef dummyNodeRef3 = new NodeRef("workspace", "dummy", "dummyID_3");

    @Before
    public void initMockObjects() {
        this.renditionService = new RenditionServiceImpl(){

            public RenditionDefinition loadRenditionDefinition(QName renditionDefinitionName) {
                return null;
            }
        };
        this.renditionService.setActionService(this.mockActionService);
        this.renditionService.setServiceRegistry((ServiceRegistry)new MockedTestServiceRegistry());
        this.renditionService.setRenditionService2(this.mockRenditionService2);
        Mockito.when((Object)this.mockRenditionService2.isCreatedByRenditionService2((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)false);
        ThumbnailServiceImpl thumbs = new ThumbnailServiceImpl(){

            public NodeRef getThumbnailByName(NodeRef node, QName contentProperty, String thumbnailName) {
                return null;
            }

            public NodeRef getThumbnailNode(ChildAssociationRef thumbnailRef) {
                return null;
            }
        };
        thumbs.setRenditionService((RenditionService)this.renditionService);
        thumbs.setThumbnailRegistry(new ThumbnailRegistry(){

            public ThumbnailRenditionConvertor getThumbnailRenditionConvertor() {
                return new ThumbnailRenditionConvertor();
            }
        });
        thumbs.setNodeService((NodeService)Mockito.mock(NodeService.class));
        TransactionServiceImpl transactionServiceImpl = new TransactionServiceImpl(){

            public boolean getAllowWrite() {
                return true;
            }

            public boolean isReadOnly() {
                return false;
            }

            public RetryingTransactionHelper getRetryingTransactionHelper() {
                RetryingTransactionHelper rth = new RetryingTransactionHelper(){

                    public <R> R doInTransaction(RetryingTransactionHelper.RetryingTransactionCallback<R> cb, boolean readOnly, boolean requiresNew) {
                        try {
                            return (R)cb.execute();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                };
                return rth;
            }
        };
        thumbs.setTransactionService((TransactionService)transactionServiceImpl);
        this.thumbnailService = thumbs;
    }

    @Test
    public void createThumbnailPassesParametersToActionService() {
        HashMap<String, Object> parametersUnderTest = new HashMap<String, Object>();
        parametersUnderTest.put("xsize", new Integer(42));
        parametersUnderTest.put("ysize", new Integer(93));
        parametersUnderTest.put("commandOptions", "foo");
        parametersUnderTest.put("maintainAspectRatio", Boolean.TRUE);
        parametersUnderTest.put("resizeToThumbnail", Boolean.FALSE);
        parametersUnderTest.put("allowEnlargement", Boolean.TRUE);
        parametersUnderTest.put("targetContentProperty", ContentModel.PROP_CONTENT);
        parametersUnderTest.put("rendition-destination-node", this.dummyNodeRef2);
        parametersUnderTest.put("source_start_page", new Integer(2));
        parametersUnderTest.put("source_end_page", new Integer(2));
        parametersUnderTest.put("source_time_offset", "00:00:00.5");
        ImageTransformationOptions imageTransOpts = new ImageTransformationOptions();
        imageTransOpts.setTargetNodeRef(this.dummyNodeRef2);
        imageTransOpts.setTargetContentProperty((QName)parametersUnderTest.get("targetContentProperty"));
        imageTransOpts.setCommandOptions((String)parametersUnderTest.get("commandOptions"));
        ImageResizeOptions resizeOptions = new ImageResizeOptions();
        resizeOptions.setHeight(((Integer)parametersUnderTest.get("ysize")).intValue());
        resizeOptions.setWidth(((Integer)parametersUnderTest.get("xsize")).intValue());
        resizeOptions.setMaintainAspectRatio(((Boolean)parametersUnderTest.get("maintainAspectRatio")).booleanValue());
        resizeOptions.setResizeToThumbnail(((Boolean)parametersUnderTest.get("resizeToThumbnail")).booleanValue());
        resizeOptions.setAllowEnlargement(((Boolean)parametersUnderTest.get("allowEnlargement")).booleanValue());
        imageTransOpts.setResizeOptions(resizeOptions);
        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
        pagedSourceOptions.setStartPageNumber((Integer)parametersUnderTest.get("source_start_page"));
        pagedSourceOptions.setEndPageNumber((Integer)parametersUnderTest.get("source_end_page"));
        imageTransOpts.addSourceOptions((TransformationSourceOptions)pagedSourceOptions);
        TemporalSourceOptions temporalSourceOptions = new TemporalSourceOptions();
        temporalSourceOptions.setOffset((String)parametersUnderTest.get("source_time_offset"));
        imageTransOpts.addSourceOptions((TransformationSourceOptions)temporalSourceOptions);
        ThumbnailParentAssociationDetails assocDetails = new ThumbnailParentAssociationDetails(this.dummyNodeRef3, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"homerSimpson"));
        this.thumbnailService.createThumbnail(this.dummyNodeRef1, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransOpts, "bartSimpson", assocDetails);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Action.class);
        ((ActionService)Mockito.verify((Object)this.mockActionService)).executeAction((Action)argument.capture(), (NodeRef)ArgumentMatchers.any(NodeRef.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        Action action = (Action)argument.getValue();
        RenditionDefinition renditionDefn = (RenditionDefinition)action;
        Map parameters = renditionDefn.getParameterValues();
        for (String s : parametersUnderTest.keySet()) {
            if (!parameters.keySet().contains(s) || parameters.get(s) == null || ((Serializable)parameters.get(s)).toString().length() == 0) {
                Assert.fail((String)("Missing parameter " + s));
            }
            Assert.assertEquals((String)("Parameter " + s + " had wrong value."), parametersUnderTest.get(s), parameters.get(s));
        }
    }
}

