/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.util.schemacomp.DbObjectXMLTransformer;
import org.alfresco.util.schemacomp.SchemaCompTestingUtils;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.validator.NameValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class DbObjectXMLTransformerTest {
    private DbObjectXMLTransformer transformer;
    private TransformerHandler xmlOut;
    private Writer writer;
    private boolean outputDumpEnabled = true;

    @Before
    public void setUp() {
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            this.xmlOut = stf.newTransformerHandler();
        }
        catch (TransformerConfigurationException error) {
            throw new RuntimeException("Unable to create TransformerHandler.", error);
        }
        Transformer t = this.xmlOut.getTransformer();
        try {
            t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("standalone", "no");
        this.writer = new StringWriter();
        this.xmlOut.setResult(new StreamResult(this.writer));
        this.transformer = new DbObjectXMLTransformer((ContentHandler)this.xmlOut);
    }

    @Test
    public void transformColumn() throws IOException {
        Column column = new Column(null, "last_name", "VARCHAR2(100)", true);
        column.setAutoIncrement(true);
        column.setOrder(2);
        this.transformer.output((DbObject)column);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<column name=\"last_name\" order=\"2\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <type>VARCHAR2(100)</type>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <nullable>true</nullable>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <autoincrement>true</autoincrement>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</column>", (Object)reader.readLine());
    }

    @Test
    public void transformForeignKey() throws IOException {
        ForeignKey fk = new ForeignKey(null, "fk_for_some_table", "local_column", "target_table", "target_column");
        this.transformer.output((DbObject)fk);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<foreignkey name=\"fk_for_some_table\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <localcolumn>local_column</localcolumn>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <targettable>target_table</targettable>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <targetcolumn>target_column</targetcolumn>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</foreignkey>", (Object)reader.readLine());
    }

    @Test
    public void transformIndex() throws IOException {
        Index index = new Index(null, "index_name", Arrays.asList("first", "second"));
        this.transformer.output((DbObject)index);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<index name=\"index_name\" unique=\"false\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <columnnames>", (Object)reader.readLine());
        Assert.assertEquals((Object)"    <columnname>first</columnname>", (Object)reader.readLine());
        Assert.assertEquals((Object)"    <columnname>second</columnname>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  </columnnames>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</index>", (Object)reader.readLine());
    }

    @Test
    public void transformPrimaryKey() throws IOException {
        PrimaryKey pk = new PrimaryKey(null, "pk_name", Arrays.asList("a_column", "b_column"), Arrays.asList(2, 1));
        this.transformer.output((DbObject)pk);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<primarykey name=\"pk_name\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <columnnames>", (Object)reader.readLine());
        Assert.assertEquals((Object)"    <columnname order=\"2\">a_column</columnname>", (Object)reader.readLine());
        Assert.assertEquals((Object)"    <columnname order=\"1\">b_column</columnname>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  </columnnames>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</primarykey>", (Object)reader.readLine());
    }

    @Test
    public void transformSchemaNoColumnOrderCheck() throws IOException {
        Collection<Column> columns = SchemaCompTestingUtils.columns("one VARCHAR2(100)", "two NUMBER(10)");
        PrimaryKey pk = new PrimaryKey(null, "pk_for_my_table", Arrays.asList("id"), Arrays.asList(1));
        List<ForeignKey> fks = SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_one", "lc", "tt", "tc"), SchemaCompTestingUtils.fk("fk_two", "lc", "tt", "tc"));
        Collection<Index> indexes = SchemaCompTestingUtils.indexes("index_one col1 col2", "index_two col3 col4");
        Table tableOne = new Table(null, "table_one", columns, pk, fks, indexes);
        Table tableTwo = new Table(null, "table_two", columns, pk, fks, indexes);
        Schema schema = new Schema("my_schema", "alf_", 132, false);
        schema.add((DbObject)tableOne);
        schema.add((DbObject)tableTwo);
        schema.add((DbObject)new Sequence(null, "sequence_one"));
        schema.add((DbObject)new Sequence(null, "sequence_two"));
        schema.add((DbObject)new Sequence(null, "sequence_three"));
        schema.setValidators(new ArrayList());
        this.transformer.output((DbObject)schema);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<schema xmlns=\"http://www.alfresco.org/repo/db-schema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.alfresco.org/repo/db-schema db-schema.xsd\" name=\"my_schema\" dbprefix=\"alf_\" version=\"132\" tablecolumnorder=\"false\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <objects>", (Object)reader.readLine());
        this.skipUntilEnd("       {table}", reader);
        this.skipUntilEnd("       {table}", reader);
        this.skipUntilEnd("       {sequence}", reader, true);
        this.skipUntilEnd("       {sequence}", reader, true);
        this.skipUntilEnd("       {sequence}", reader, true);
        Assert.assertEquals((Object)"  </objects>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</schema>", (Object)reader.readLine());
    }

    @Test
    public void transformSchemaWithColumnOrderCheck() throws IOException {
        Collection<Column> columns = SchemaCompTestingUtils.columns("one VARCHAR2(100)", "two NUMBER(10)");
        PrimaryKey pk = new PrimaryKey(null, "pk_for_my_table", Arrays.asList("id"), Arrays.asList(1));
        List<ForeignKey> fks = SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_one", "lc", "tt", "tc"), SchemaCompTestingUtils.fk("fk_two", "lc", "tt", "tc"));
        Collection<Index> indexes = SchemaCompTestingUtils.indexes("index_one col1 col2", "index_two col3 col4");
        Table tableOne = new Table(null, "table_one", columns, pk, fks, indexes);
        Table tableTwo = new Table(null, "table_two", columns, pk, fks, indexes);
        Schema schema = new Schema("my_schema", "alf_", 132, true);
        schema.add((DbObject)tableOne);
        schema.add((DbObject)tableTwo);
        schema.add((DbObject)new Sequence(null, "sequence_one"));
        schema.add((DbObject)new Sequence(null, "sequence_two"));
        schema.add((DbObject)new Sequence(null, "sequence_three"));
        schema.setValidators(new ArrayList());
        this.transformer.output((DbObject)schema);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<schema xmlns=\"http://www.alfresco.org/repo/db-schema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.alfresco.org/repo/db-schema db-schema.xsd\" name=\"my_schema\" dbprefix=\"alf_\" version=\"132\" tablecolumnorder=\"true\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <objects>", (Object)reader.readLine());
        this.skipUntilEnd("       {table}", reader);
        this.skipUntilEnd("       {table}", reader);
        this.skipUntilEnd("       {sequence}", reader, true);
        this.skipUntilEnd("       {sequence}", reader, true);
        this.skipUntilEnd("       {sequence}", reader, true);
        Assert.assertEquals((Object)"  </objects>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</schema>", (Object)reader.readLine());
    }

    @Test
    public void transformSequence() throws IOException {
        Sequence sequence = new Sequence(null, "my_sequence");
        this.transformer.output((DbObject)sequence);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<sequence name=\"my_sequence\"/>", (Object)reader.readLine());
    }

    @Test
    public void transformTable() throws IOException {
        Collection<Column> columns = SchemaCompTestingUtils.columns("one VARCHAR2(100)", "two NUMBER(10)");
        PrimaryKey pk = new PrimaryKey(null, "pk_for_my_table", Arrays.asList("id"), Arrays.asList(1));
        List<ForeignKey> fks = SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_one", "lc", "tt", "tc"), SchemaCompTestingUtils.fk("fk_two", "lc", "tt", "tc"));
        Collection<Index> indexes = SchemaCompTestingUtils.indexes("index_one col1 col2", "index_two col3 col4");
        Table table = new Table(null, "my_table", columns, pk, fks, indexes);
        this.transformer.output((DbObject)table);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<table name=\"my_table\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <columns>", (Object)reader.readLine());
        this.skipUntilEnd("       {column}", reader);
        this.skipUntilEnd("       {column}", reader);
        Assert.assertEquals((Object)"  </columns>", (Object)reader.readLine());
        this.skipUntilEnd("  {primarykey}", reader);
        Assert.assertEquals((Object)"  <foreignkeys>", (Object)reader.readLine());
        this.skipUntilEnd("       {foreignkey}", reader);
        this.skipUntilEnd("       {foreignkey}", reader);
        Assert.assertEquals((Object)"  </foreignkeys>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <indexes>", (Object)reader.readLine());
        this.skipUntilEnd("       {index}", reader);
        this.skipUntilEnd("       {index}", reader);
        Assert.assertEquals((Object)"  </indexes>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</table>", (Object)reader.readLine());
    }

    @Test
    public void transformTableWithoutPrimaryKey() throws IOException {
        Table table = new Table("my_table");
        Assert.assertFalse((boolean)table.hasPrimaryKey());
        this.transformer.output((DbObject)table);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        this.skipUntilEnd("  {columns}", reader, true);
        this.skipUntilEnd("  {foreignkeys}", reader, true);
        this.skipUntilEnd("  {indexes}", reader, true);
        Assert.assertEquals((Object)"</table>", (Object)reader.readLine());
    }

    @Test
    public void transformObjectWithValidators() throws IOException {
        Collection<Column> columns = SchemaCompTestingUtils.columns("one VARCHAR2(100)", "two NUMBER(10)");
        PrimaryKey pk = new PrimaryKey(null, "pk_for_my_table", Arrays.asList("id"), Arrays.asList(1));
        List<ForeignKey> fks = SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_one", "lc", "tt", "tc"), SchemaCompTestingUtils.fk("fk_two", "lc", "tt", "tc"));
        Collection<Index> indexes = SchemaCompTestingUtils.indexes("index_one col1 col2", "index_two col3 col4");
        Table table = new Table(null, "my_table", columns, pk, fks, indexes);
        NameValidator nameValidator = new NameValidator();
        nameValidator.setPattern(Pattern.compile("match_me_if_you_can"));
        ArrayList<NameValidator> validators = new ArrayList<NameValidator>();
        validators.add(nameValidator);
        table.setValidators(validators);
        this.transformer.output((DbObject)table);
        BufferedReader reader = new BufferedReader(new StringReader(this.writer.toString()));
        this.dumpOutput();
        this.assertHasPreamble(reader);
        Assert.assertEquals((Object)"<table name=\"my_table\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <validators>", (Object)reader.readLine());
        Assert.assertEquals((Object)"    <validator class=\"org.alfresco.util.schemacomp.validator.NameValidator\">", (Object)reader.readLine());
        Assert.assertEquals((Object)"      <properties>", (Object)reader.readLine());
        Assert.assertEquals((Object)"        <property name=\"pattern\">match_me_if_you_can</property>", (Object)reader.readLine());
        Assert.assertEquals((Object)"      </properties>", (Object)reader.readLine());
        Assert.assertEquals((Object)"    </validator>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  </validators>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <columns>", (Object)reader.readLine());
        this.skipUntilEnd("       {column}", reader);
        this.skipUntilEnd("       {column}", reader);
        Assert.assertEquals((Object)"  </columns>", (Object)reader.readLine());
        this.skipUntilEnd("  {primarykey}", reader);
        Assert.assertEquals((Object)"  <foreignkeys>", (Object)reader.readLine());
        this.skipUntilEnd("       {foreignkey}", reader);
        this.skipUntilEnd("       {foreignkey}", reader);
        Assert.assertEquals((Object)"  </foreignkeys>", (Object)reader.readLine());
        Assert.assertEquals((Object)"  <indexes>", (Object)reader.readLine());
        this.skipUntilEnd("       {index}", reader);
        this.skipUntilEnd("       {index}", reader);
        Assert.assertEquals((Object)"  </indexes>", (Object)reader.readLine());
        Assert.assertEquals((Object)"</table>", (Object)reader.readLine());
    }

    private void skipUntilEnd(String textToFind, BufferedReader reader, boolean emptyTag) {
        textToFind = emptyTag ? textToFind.trim().replace("{", "<").replace("}", ".*/>") : textToFind.trim().replace("{", "</").replace("}", ">");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.trim().matches(textToFind)) continue;
                return;
            }
            Assert.fail((String)("Unable to find text: " + textToFind));
        }
        catch (IOException error) {
            throw new RuntimeException("Unable to skip text whilst looking for: " + textToFind, error);
        }
    }

    private void skipUntilEnd(String textToFind, BufferedReader reader) {
        this.skipUntilEnd(textToFind, reader, false);
    }

    private void assertHasPreamble(BufferedReader reader) throws IOException {
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", (Object)reader.readLine());
    }

    private void dumpOutput() {
        if (this.outputDumpEnabled) {
            System.out.println(this.writer.toString());
        }
    }
}

