/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.NodeBulkLoader;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public interface NodeDAO
extends NodeBulkLoader {
    public Long getCurrentTransactionCommitTime();

    public Long getCurrentTransactionId(boolean var1);

    public Pair<Long, StoreRef> getStore(StoreRef var1);

    public List<Pair<Long, StoreRef>> getStores();

    public boolean exists(StoreRef var1);

    public Pair<Long, NodeRef> newStore(StoreRef var1);

    public void moveStore(StoreRef var1, StoreRef var2);

    public Pair<Long, NodeRef> getRootNode(StoreRef var1);

    public Set<NodeRef> getAllRootNodes(StoreRef var1);

    public boolean exists(NodeRef var1);

    public List<NodeRef> exists(List<NodeRef> var1);

    public boolean exists(Long var1);

    public boolean isInCurrentTxn(Long var1);

    public NodeRef.Status getNodeRefStatus(NodeRef var1);

    public NodeRef.Status getNodeIdStatus(Long var1);

    public Pair<Long, NodeRef> getNodePair(NodeRef var1);

    public List<Pair<Long, NodeRef>> getNodePairs(StoreRef var1, List<NodeRef> var2);

    public Pair<Long, NodeRef> getNodePair(Long var1);

    public List<Pair<Long, NodeRef>> getNodePairs(List<Long> var1);

    public QName getNodeType(Long var1);

    public Long getNodeAclId(Long var1);

    public ChildAssocEntity newNode(Long var1, QName var2, QName var3, StoreRef var4, String var5, QName var6, Locale var7, String var8, Map<QName, Serializable> var9) throws InvalidTypeException;

    public Pair<Pair<Long, ChildAssociationRef>, Pair<Long, NodeRef>> moveNode(Long var1, Long var2, QName var3, QName var4);

    public int touchNodes(Long var1, List<Long> var2);

    public boolean updateNode(Long var1, QName var2, Locale var3);

    public void setNodeAclId(Long var1, Long var2);

    public void setPrimaryChildrenSharedAclId(Long var1, Long var2, Long var3);

    public void deleteNode(Long var1);

    public int purgeNodes(long var1, long var3);

    public Serializable getNodeProperty(Long var1, QName var2);

    public Map<QName, Serializable> getNodeProperties(Long var1);

    public Map<Long, Map<QName, Serializable>> getNodeProperties(List<Long> var1);

    public boolean setNodeProperties(Long var1, Map<QName, Serializable> var2);

    public boolean addNodeProperty(Long var1, QName var2, Serializable var3);

    public boolean addNodeProperties(Long var1, Map<QName, Serializable> var2);

    public boolean removeNodeProperties(Long var1, Set<QName> var2);

    public boolean setModifiedDate(Long var1, Date var2);

    public boolean setModifiedProperties(Long var1, Date var2, String var3);

    public Set<QName> getNodeAspects(Long var1);

    public Map<Long, Set<QName>> getNodeAspects(List<Long> var1);

    public boolean hasNodeAspect(Long var1, QName var2);

    public boolean addNodeAspects(Long var1, Set<QName> var2);

    public boolean removeNodeAspects(Long var1);

    public boolean removeNodeAspects(Long var1, Set<QName> var2);

    public void getNodesWithAspects(Set<QName> var1, Long var2, Long var3, NodeRefQueryCallback var4);

    public void getNodesWithAspects(Set<QName> var1, Long var2, Long var3, boolean var4, NodeRefQueryCallback var5);

    public void getNodesWithAspects(Set<QName> var1, Long var2, Long var3, boolean var4, int var5, NodeRefQueryCallback var6);

    public Long newNodeAssoc(Long var1, Long var2, QName var3, int var4);

    public void setNodeAssocIndex(Long var1, int var2);

    public int removeNodeAssoc(Long var1, Long var2, QName var3);

    public int removeNodeAssocs(List<Long> var1);

    public Collection<Pair<Long, AssociationRef>> getNodeAssocsToAndFrom(Long var1);

    public Collection<Pair<Long, AssociationRef>> getSourceNodeAssocs(Long var1, QName var2);

    public Collection<Pair<Long, AssociationRef>> getTargetNodeAssocs(Long var1, QName var2);

    public Collection<Pair<Long, AssociationRef>> getTargetAssocsByPropertyValue(Long var1, QName var2, QName var3, Serializable var4);

    public Pair<Long, AssociationRef> getNodeAssocOrNull(Long var1);

    public Pair<Long, AssociationRef> getNodeAssoc(Long var1);

    public Pair<Long, ChildAssociationRef> newChildAssoc(Long var1, Long var2, QName var3, QName var4, String var5);

    public void deleteChildAssoc(Long var1);

    public int setChildAssocIndex(Long var1, Long var2, QName var3, QName var4, int var5);

    public void setChildAssocsUniqueName(Long var1, String var2);

    public Pair<Long, ChildAssociationRef> getChildAssoc(Long var1);

    public Pair<Long, ChildAssociationRef> getChildAssoc(Long var1, Long var2, QName var3, QName var4);

    public void getChildAssocs(Long var1, Long var2, QName var3, QName var4, Boolean var5, Boolean var6, ChildAssocRefQueryCallback var7);

    public void getChildAssocs(Long var1, QName var2, QName var3, int var4, ChildAssocRefQueryCallback var5);

    public void getChildAssocs(Long var1, Set<QName> var2, ChildAssocRefQueryCallback var3);

    public Pair<Long, ChildAssociationRef> getChildAssoc(Long var1, QName var2, String var3);

    public void getChildAssocs(Long var1, QName var2, Collection<String> var3, ChildAssocRefQueryCallback var4);

    public void getChildAssocsByChildTypes(Long var1, Set<QName> var2, ChildAssocRefQueryCallback var3);

    public void getChildAssocsWithoutParentAssocsOfType(Long var1, QName var2, ChildAssocRefQueryCallback var3);

    public List<Node> selectChildAssocsWithoutNodeAssocsOfTypes(Long var1, Long var2, Long var3, Set<QName> var4);

    public Pair<Long, ChildAssociationRef> getPrimaryParentAssoc(Long var1);

    public void getParentAssocs(Long var1, QName var2, QName var3, Boolean var4, ChildAssocRefQueryCallback var5);

    public List<NodeIdAndAclId> getPrimaryChildrenAcls(Long var1);

    public List<Path> getPaths(Pair<Long, NodeRef> var1, boolean var2) throws InvalidNodeRefException;

    public void cycleCheck(Long var1);

    public Long getMaxTxnIdByCommitTime(long var1);

    public Transaction getTxnById(Long var1);

    public int getTransactionCount();

    public List<NodeRef.Status> getTxnChangesForStore(StoreRef var1, Long var2);

    public List<NodeRef.Status> getTxnChanges(Long var1);

    public List<Long> getTxnsUnused(Long var1, long var2, int var4);

    public int deleteTxnsUnused(long var1, long var3);

    public void purgeTxn(Long var1);

    public Long getMinTxnCommitTime();

    public Long getMaxTxnCommitTime();

    public Long getMinTxnCommitTimeForDeletedNodes();

    public Long getMinTxnId();

    public Long getMinUnusedTxnCommitTime();

    public Long getMaxTxnId();

    public Long getMinNodeId();

    public Long getMaxNodeId();

    public Pair<Long, Long> getNodeIdsIntervalForType(QName var1, Long var2, Long var3);

    public void getChildAssocsByPropertyValue(Long var1, QName var2, Serializable var3, ChildAssocRefQueryCallback var4);

    public List<String> selectAssocsNotLinkedByTwoOtherAssocs(Long var1);

    public List<NodePropertyEntity> selectNodePropertiesByTypes(Set<QName> var1);

    public List<NodePropertyEntity> selectNodePropertiesByDataType(QName var1, long var2, long var4);

    public int countChildAssocsByParent(Long var1, boolean var2);

    public Long getMinTxInNodeIdRange(Long var1, Long var2);

    public Long getMaxTxInNodeIdRange(Long var1, Long var2);

    public Long getNextTxCommitTime(Long var1);

    default public Iterator<Long> selectDeletedNodesByCommitTime(long maxCommitTime) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    default public List<String> purgeDeletedNodes(long minAge, int deleteBatchSize) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    default public Iterator<Long> selectUnusedTransactionsByCommitTime(long maxCommitTime) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    default public List<String> purgeEmptyTransactions(long minAge, int deleteBatchSize) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public static interface ChildAssocRefQueryCallback {
        public boolean handle(Pair<Long, ChildAssociationRef> var1, Pair<Long, NodeRef> var2, Pair<Long, NodeRef> var3);

        public boolean preLoadNodes();

        public boolean orderResults();

        public void done();
    }

    public static interface NodeRefQueryCallback {
        public boolean handle(Pair<Long, NodeRef> var1);
    }

    public static class NodeView {
        private static final String RESOURCE_KEY = "NodeViewMap";
        private Set<Long> primaryParentAssocIds = new HashSet<Long>(7);
        private Set<Long> secondaryParentAssocIds = new HashSet<Long>(7);
        private Set<Long> primaryChildAssocIds = new HashSet<Long>(167);
        private Set<Long> secondaryChildAssocIds = new HashSet<Long>(11);
        private Set<Long> targetAssocIds = new HashSet<Long>(11);
        private Set<Long> sourceAssocIds = new HashSet<Long>(11);

        public static NodeView getView(Long nodeId) {
            Map<Long, NodeView> nodeViewsById = TransactionalResourceHelper.getMap(RESOURCE_KEY);
            NodeView nodeView = (NodeView)nodeViewsById.get(nodeId);
            if (nodeView == null) {
                nodeView = new NodeView();
                nodeViewsById.put(nodeId, nodeView);
            }
            return nodeView;
        }

        public Set<Long> getPrimaryParentAssocIds() {
            return this.primaryParentAssocIds;
        }

        public Set<Long> getSecondaryParentAssocIds() {
            return this.secondaryParentAssocIds;
        }

        public Set<Long> getPrimaryChildAssocIds() {
            return this.primaryChildAssocIds;
        }

        public Set<Long> getSecondaryChildAssocIds() {
            return this.secondaryChildAssocIds;
        }

        public Set<Long> getTargetAssocIds() {
            return this.targetAssocIds;
        }

        public Set<Long> getSourceAssocIds() {
            return this.sourceAssocIds;
        }
    }
}

