/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;

public class ADMAccessControlListDAO
implements AccessControlListDAO {
    private static final Log log = LogFactory.getLog(ADMAccessControlListDAO.class);
    private NodeDAO nodeDAO;
    private AclDAO aclDaoComponent;
    private BehaviourFilter behaviourFilter;
    private boolean preserveAuditableData = true;
    private long fixedAclMaxTransactionTime = 10000L;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setAclDAO(AclDAO aclDaoComponent) {
        this.aclDaoComponent = aclDaoComponent;
    }

    public void setFixedAclMaxTransactionTime(long fixedAclMaxTransactionTime) {
        this.fixedAclMaxTransactionTime = fixedAclMaxTransactionTime;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPreserveAuditableData(boolean preserveAuditableData) {
        this.preserveAuditableData = preserveAuditableData;
    }

    public boolean isPreserveAuditableData() {
        return this.preserveAuditableData;
    }

    @Override
    public void forceCopy(NodeRef nodeRef) {
    }

    private Long getNodeIdNotNull(NodeRef nodeRef) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeRef);
        if (nodePair == null) {
            throw new InvalidNodeRefException(nodeRef);
        }
        return (Long)nodePair.getFirst();
    }

    @Override
    public Acl getAccessControlList(NodeRef nodeRef) {
        Long nodeId = this.getNodeIdNotNull(nodeRef);
        Long aclId = this.nodeDAO.getNodeAclId(nodeId);
        return this.aclDaoComponent.getAcl(aclId);
    }

    @Override
    public Acl getAccessControlList(StoreRef storeRef) {
        return null;
    }

    @Override
    public Long getIndirectAcl(NodeRef nodeRef) {
        return this.getAccessControlList(nodeRef).getId();
    }

    @Override
    public Long getInheritedAcl(NodeRef nodeRef) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeRef);
        if (nodePair == null) {
            return null;
        }
        Pair<Long, ChildAssociationRef> parentAssocRefPair = this.nodeDAO.getPrimaryParentAssoc((Long)nodePair.getFirst());
        if (parentAssocRefPair == null || ((ChildAssociationRef)parentAssocRefPair.getSecond()).getParentRef() == null) {
            return null;
        }
        Acl acl = this.getAccessControlList(((ChildAssociationRef)parentAssocRefPair.getSecond()).getParentRef());
        if (acl != null) {
            return acl.getId();
        }
        return null;
    }

    @Override
    public Map<ACLType, Integer> patchAcls() {
        CounterSet result = new CounterSet();
        List<Pair<Long, StoreRef>> stores = this.nodeDAO.getStores();
        for (Pair<Long, StoreRef> pair : stores) {
            Long rootNodeId = (Long)this.nodeDAO.getRootNode((StoreRef)pair.getSecond()).getFirst();
            CounterSet update = this.fixOldDmAcls(rootNodeId, this.nodeDAO.getNodeAclId(rootNodeId), null, true);
            result.add(update);
        }
        HashMap<ACLType, Integer> toReturn = new HashMap<ACLType, Integer>();
        toReturn.put(ACLType.DEFINING, ((Counter)result.get((Object)ACLType.DEFINING)).getCounter());
        toReturn.put(ACLType.FIXED, ((Counter)result.get((Object)ACLType.FIXED)).getCounter());
        toReturn.put(ACLType.GLOBAL, ((Counter)result.get((Object)ACLType.GLOBAL)).getCounter());
        toReturn.put(ACLType.LAYERED, ((Counter)result.get((Object)ACLType.LAYERED)).getCounter());
        toReturn.put(ACLType.OLD, ((Counter)result.get((Object)ACLType.OLD)).getCounter());
        toReturn.put(ACLType.SHARED, ((Counter)result.get((Object)ACLType.SHARED)).getCounter());
        return toReturn;
    }

    private CounterSet fixOldDmAcls(Long nodeId, Long existingNodeAclId, Long inheritedAclId, boolean isRoot) {
        CounterSet result = new CounterSet();
        Long newDefiningAcl = null;
        if (existingNodeAclId == null || !existingNodeAclId.equals(inheritedAclId)) {
            AccessControlListProperties properties;
            AccessControlList existing = null;
            if (existingNodeAclId != null) {
                existing = this.aclDaoComponent.getAccessControlList(existingNodeAclId);
            }
            if (existing != null) {
                if (existing.getProperties().getAclType() == ACLType.OLD) {
                    result.increment(ACLType.DEFINING);
                    properties = new SimpleAccessControlListProperties(this.aclDaoComponent.getDefaultProperties());
                    ((SimpleAccessControlListProperties)properties).setInherits(existing.getProperties().getInherits());
                    Long actuallyInherited = null;
                    if (existing.getProperties().getInherits().booleanValue() && inheritedAclId != null) {
                        actuallyInherited = inheritedAclId;
                    }
                    Acl newAcl = this.aclDaoComponent.createAccessControlList(properties, existing.getEntries(), actuallyInherited);
                    newDefiningAcl = newAcl.getId();
                    this.nodeDAO.setNodeAclId(nodeId, newDefiningAcl);
                } else if (existing.getProperties().getAclType() != ACLType.SHARED) {
                    return result;
                }
            } else if (isRoot) {
                result.increment(ACLType.DEFINING);
                properties = this.aclDaoComponent.getDefaultProperties();
                Acl newAcl = this.aclDaoComponent.createAccessControlList(properties);
                newDefiningAcl = newAcl.getId();
                this.nodeDAO.setNodeAclId(nodeId, newDefiningAcl);
            } else {
                this.nodeDAO.setNodeAclId(nodeId, inheritedAclId);
            }
        }
        Long toInherit = null;
        List<NodeIdAndAclId> children = this.nodeDAO.getPrimaryChildrenAcls(nodeId);
        if (children.size() > 0) {
            toInherit = newDefiningAcl == null ? inheritedAclId : this.aclDaoComponent.getInheritedAccessControlList(newDefiningAcl);
        }
        if (children.size() > 0) {
            this.nodeDAO.setPrimaryChildrenSharedAclId(nodeId, null, toInherit);
        }
        for (NodeIdAndAclId child : children) {
            CounterSet update = this.fixOldDmAcls(child.getId(), child.getAclId(), toInherit, false);
            result.add(update);
        }
        return result;
    }

    @Override
    public void setAccessControlList(NodeRef nodeRef, Long aclId) {
        boolean auditableBehaviorWasDisabled;
        boolean bl = auditableBehaviorWasDisabled = this.preserveAuditableData && this.behaviourFilter.isEnabled(ContentModel.ASPECT_AUDITABLE);
        if (auditableBehaviorWasDisabled) {
            this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        }
        try {
            Long nodeId = this.getNodeIdNotNull(nodeRef);
            this.nodeDAO.setNodeAclId(nodeId, aclId);
        }
        finally {
            if (auditableBehaviorWasDisabled) {
                this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    @Override
    public void setAccessControlList(NodeRef nodeRef, Acl acl) {
        Long aclId = null;
        if (acl != null) {
            aclId = acl.getId();
        }
        this.setAccessControlList(nodeRef, aclId);
    }

    @Override
    public void setAccessControlList(StoreRef storeRef, Acl acl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AclChange> setInheritanceForChildren(NodeRef parent, Long inheritFrom, Long sharedAclToReplace) {
        boolean asyncCall = AlfrescoTransactionSupport.getResource((Object)"FIXED_ACL_ASYNC_CALL") != null;
        return this.setInheritanceForChildren(parent, inheritFrom, sharedAclToReplace, asyncCall);
    }

    @Override
    public List<AclChange> setInheritanceForChildren(NodeRef parent, Long inheritFrom, Long sharedAclToReplace, boolean asyncCall) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        this.setFixedAcls(this.getNodeIdNotNull(parent), inheritFrom, null, sharedAclToReplace, changes, false, asyncCall, true);
        return changes;
    }

    @Override
    public List<AclChange> setInheritanceForChildren(NodeRef parent, Long inheritFrom, Long sharedAclToReplace, boolean asyncCall, boolean forceSharedACL) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        this.setFixedAcls(this.getNodeIdNotNull(parent), inheritFrom, null, sharedAclToReplace, changes, false, asyncCall, true, forceSharedACL);
        return changes;
    }

    @Override
    public void updateChangedAcls(NodeRef startingPoint, List<AclChange> changes) {
    }

    @Override
    public void setFixedAcls(Long nodeId, Long inheritFrom, Long mergeFrom, Long sharedAclToReplace, List<AclChange> changes, boolean set) {
        this.setFixedAcls(nodeId, inheritFrom, mergeFrom, sharedAclToReplace, changes, set, false, true);
    }

    public void setFixedAcls(Long nodeId, Long inheritFrom, Long mergeFrom, Long sharedAclToReplace, List<AclChange> changes, boolean set, boolean asyncCall, boolean propagateOnChildren) {
        this.setFixedAcls(nodeId, inheritFrom, mergeFrom, sharedAclToReplace, changes, set, false, true, false);
    }

    public void setFixedAcls(Long nodeId, Long inheritFrom, Long mergeFrom, Long sharedAclToReplace, List<AclChange> changes, boolean set, boolean asyncCall, boolean propagateOnChildren, boolean forceSharedACL) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Set fixed acl for nodeId=" + nodeId + " inheritFrom=" + inheritFrom + " sharedAclToReplace=" + sharedAclToReplace + " mergefrom= " + mergeFrom));
        }
        if (nodeId == null) {
            return;
        }
        Long currentAcl = this.nodeDAO.getNodeAclId(nodeId);
        if (this.nodeDAO.hasNodeAspect(nodeId, ContentModel.ASPECT_PENDING_FIX_ACL)) {
            sharedAclToReplace = (Long)this.nodeDAO.getNodeProperty(nodeId, ContentModel.PROP_SHARED_ACL_TO_REPLACE);
        }
        if (mergeFrom == null) {
            mergeFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritFrom);
        }
        if (set) {
            this.nodeDAO.setNodeAclId(nodeId, mergeFrom);
        }
        List<NodeIdAndAclId> children = this.nodeDAO.getPrimaryChildrenAcls(nodeId);
        if (!propagateOnChildren) {
            return;
        }
        for (NodeIdAndAclId child : children) {
            Long acl = this.nodeDAO.getNodeAclId(child.getId());
            if (acl == null) {
                propagateOnChildren = this.setFixAclPending(child.getId(), inheritFrom, mergeFrom, sharedAclToReplace, changes, false, asyncCall, propagateOnChildren, forceSharedACL);
                continue;
            }
            if (acl.equals(sharedAclToReplace) || acl.equals(mergeFrom) || acl.equals(currentAcl)) {
                propagateOnChildren = this.setFixAclPending(child.getId(), inheritFrom, mergeFrom, sharedAclToReplace, changes, false, asyncCall, propagateOnChildren, forceSharedACL);
                continue;
            }
            Acl dbAcl = this.aclDaoComponent.getAcl(acl);
            if (dbAcl.getAclType() == ACLType.LAYERED) {
                throw new UnsupportedOperationException();
            }
            if (dbAcl.getAclType() == ACLType.DEFINING) {
                if (!dbAcl.getInherits().booleanValue()) continue;
                this.aclDaoComponent.mergeInheritedAccessControlList(mergeFrom, acl);
                continue;
            }
            if (dbAcl.getAclType() != ACLType.SHARED) continue;
            if (forceSharedACL) {
                log.warn((Object)("Forcing shared ACL on node: " + child.getId() + " ( " + this.nodeDAO.getNodePair(child.getId()).getSecond() + ") - " + dbAcl));
                sharedAclToReplace = acl;
                propagateOnChildren = this.setFixAclPending(child.getId(), inheritFrom, mergeFrom, sharedAclToReplace, changes, false, asyncCall, propagateOnChildren, forceSharedACL);
                continue;
            }
            throw new ConcurrencyFailureException("setFixedAcls: unexpected shared acl: " + dbAcl + " on node " + child.getId() + " ( " + this.nodeDAO.getNodePair(child.getId()).getSecond() + ")");
        }
        if (children.size() > 0) {
            this.nodeDAO.setPrimaryChildrenSharedAclId(nodeId, sharedAclToReplace, mergeFrom);
        }
        if (this.nodeDAO.hasNodeAspect(nodeId, ContentModel.ASPECT_PENDING_FIX_ACL)) {
            this.removePendingAclAspect(nodeId);
        }
    }

    private boolean setFixAclPending(Long nodeId, Long inheritFrom, Long mergeFrom, Long sharedAclToReplace, List<AclChange> changes, boolean set, boolean asyncCall, boolean propagateOnChildren, boolean forceSharedACL) {
        long transactionStartTime = AlfrescoTransactionSupport.getTransactionStartTime();
        long transactionTime = System.currentTimeMillis() - transactionStartTime;
        if (transactionTime < this.fixedAclMaxTransactionTime) {
            this.setFixedAcls(nodeId, inheritFrom, mergeFrom, sharedAclToReplace, changes, set, asyncCall, propagateOnChildren, forceSharedACL);
            return true;
        }
        if (log.isWarnEnabled() && (AlfrescoTransactionSupport.getResource((Object)"FIXED_ACL_ASYNC_REQUIRED") == null || !((Boolean)AlfrescoTransactionSupport.getResource((Object)"FIXED_ACL_ASYNC_REQUIRED")).booleanValue())) {
            log.warn((Object)("The ACL processing time in transaction " + AlfrescoTransactionSupport.getTransactionId() + " exceeded the configured limit of " + this.fixedAclMaxTransactionTime + " ms. The rest of the ACL processing will be done asynchronously."));
        }
        this.addFixedAclPendingAspect(nodeId, sharedAclToReplace, inheritFrom, mergeFrom);
        AlfrescoTransactionSupport.bindResource((Object)"FIXED_ACL_ASYNC_REQUIRED", (Object)true);
        return false;
    }

    private void addFixedAclPendingAspect(Long nodeId, Long sharedAclToReplace, Long inheritFrom, Long mergeFrom) {
        if (this.nodeDAO.hasNodeAspect(nodeId, ContentModel.ASPECT_PENDING_FIX_ACL)) {
            HashMap<QName, Serializable> pendingAclProperties = new HashMap<QName, Serializable>();
            pendingAclProperties.put(ContentModel.PROP_INHERIT_FROM_ACL, inheritFrom);
            this.nodeDAO.addNodeProperties(nodeId, pendingAclProperties);
            return;
        }
        HashSet<QName> aspect = new HashSet<QName>();
        aspect.add(ContentModel.ASPECT_PENDING_FIX_ACL);
        this.nodeDAO.addNodeAspects(nodeId, aspect);
        HashMap<QName, Serializable> pendingAclProperties = new HashMap<QName, Serializable>();
        pendingAclProperties.put(ContentModel.PROP_SHARED_ACL_TO_REPLACE, sharedAclToReplace);
        pendingAclProperties.put(ContentModel.PROP_INHERIT_FROM_ACL, inheritFrom);
        this.nodeDAO.addNodeProperties(nodeId, pendingAclProperties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set Fixed Acl Pending : " + nodeId + " " + this.nodeDAO.getNodePair(nodeId).getSecond()));
        }
    }

    @Override
    public void removePendingAclAspect(Long nodeId) {
        HashSet<QName> aspects = new HashSet<QName>(1);
        aspects.add(ContentModel.ASPECT_PENDING_FIX_ACL);
        HashSet<QName> pendingFixAclProperties = new HashSet<QName>();
        pendingFixAclProperties.add(ContentModel.PROP_SHARED_ACL_TO_REPLACE);
        pendingFixAclProperties.add(ContentModel.PROP_INHERIT_FROM_ACL);
        this.nodeDAO.removeNodeAspects(nodeId, aspects);
        this.nodeDAO.removeNodeProperties(nodeId, pendingFixAclProperties);
    }

    @Override
    public void updateInheritance(Long childNodeId, Long oldParentAclId, Long newParentAclId) {
        Acl acl;
        if (oldParentAclId == null) {
            return;
        }
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        Long childAclId = this.nodeDAO.getNodeAclId(childNodeId);
        if (childAclId == null && newParentAclId != null) {
            Long newParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(newParentAclId);
            this.setFixedAcls(childNodeId, newParentSharedAclId, null, null, changes, true);
        }
        if ((acl = this.aclDaoComponent.getAcl(childAclId)) != null && acl.getInherits().booleanValue()) {
            Long oldParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(oldParentAclId);
            Long sharedAclchildInheritsFrom = acl.getInheritsFrom();
            if (childAclId.equals(oldParentSharedAclId)) {
                if (newParentAclId != null) {
                    Long newParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(newParentAclId);
                    this.setFixedAcls(childNodeId, newParentSharedAclId, null, childAclId, changes, true);
                }
            } else if (sharedAclchildInheritsFrom != null && sharedAclchildInheritsFrom.equals(oldParentSharedAclId)) {
                if (acl.getAclType() == ACLType.LAYERED) {
                    throw new UnsupportedOperationException();
                }
                if (acl.getAclType() == ACLType.DEFINING) {
                    Long newParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(newParentAclId);
                    this.aclDaoComponent.mergeInheritedAccessControlList(newParentSharedAclId, childAclId);
                } else if (acl.getAclType() == ACLType.SHARED) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class Counter {
        int counter;

        void increment() {
            ++this.counter;
        }

        int getCounter() {
            return this.counter;
        }

        void add(int i) {
            this.counter += i;
        }
    }

    public static class CounterSet
    extends HashMap<ACLType, Counter> {
        private static final long serialVersionUID = -3682278258679211481L;

        CounterSet() {
            this.put(ACLType.DEFINING, new Counter());
            this.put(ACLType.FIXED, new Counter());
            this.put(ACLType.GLOBAL, new Counter());
            this.put(ACLType.LAYERED, new Counter());
            this.put(ACLType.OLD, new Counter());
            this.put(ACLType.SHARED, new Counter());
        }

        void add(ACLType type, Counter c) {
            Counter counter = (Counter)this.get((Object)type);
            counter.add(c.getCounter());
        }

        void increment(ACLType type) {
            Counter counter = (Counter)this.get((Object)type);
            counter.increment();
        }

        void add(CounterSet other) {
            this.add(ACLType.DEFINING, (Counter)other.get((Object)ACLType.DEFINING));
            this.add(ACLType.FIXED, (Counter)other.get((Object)ACLType.FIXED));
            this.add(ACLType.GLOBAL, (Counter)other.get((Object)ACLType.GLOBAL));
            this.add(ACLType.LAYERED, (Counter)other.get((Object)ACLType.LAYERED));
            this.add(ACLType.OLD, (Counter)other.get((Object)ACLType.OLD));
            this.add(ACLType.SHARED, (Counter)other.get((Object)ACLType.SHARED));
        }
    }
}

