/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.AlfrescoCmisServiceCall;
import org.alfresco.repo.events.ClientUtil;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.sync.events.EventRegistry;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.events.types.TransactionCommittedEvent;
import org.alfresco.sync.events.types.TransactionRolledBackEvent;
import org.alfresco.sync.repo.Client;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionSupportUtil;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gytheio.messaging.MessageProducer;
import org.gytheio.messaging.MessagingException;

public abstract class AbstractEventsService
extends TransactionListenerAdapter {
    private static Log logger = LogFactory.getLog(AbstractEventsService.class);
    private static final String EVENTS_KEY = "camel.events";
    protected static final String TRANSACTION_HAS_EVENTS = "transaction.has.events";
    private MessageProducer messageProducer;
    protected CheckOutCheckInService cociService;
    protected SiteService siteService;
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected PermissionService permissionService;
    protected HiddenAspect hiddenAspect;
    protected EventRegistry eventRegistry;
    protected FileFolderService fileFolderService;
    protected TransactionService transactionService;
    protected Set<String> includeEventTypes;
    protected Set<QName> matchingTypes = new HashSet<QName>();
    protected boolean sendEventsBeforeCommit = true;

    public void setCociService(CheckOutCheckInService cociService) {
        this.cociService = cociService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setSendEventsBeforeCommit(boolean sendEventsBeforeCommit) {
        this.sendEventsBeforeCommit = sendEventsBeforeCommit;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setIncludeEventTypes(String includeEventTypesStr) {
        this.includeEventTypes = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)includeEventTypesStr));
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setMessageProducer(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void init() {
    }

    protected long nextSequenceNumber() {
        TxnEvents events = this.getTxnEvents();
        long seqNumber = events.nextSeqNumber();
        return seqNumber;
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        TxnEvents transactionEvents;
        if (this.sendEventsBeforeCommit && (transactionEvents = (TxnEvents)AlfrescoTransactionSupport.getResource((Object)EVENTS_KEY)) != null) {
            List<Event> filteredEvents = this.filterEventsBeforeSend(transactionEvents.getEvents());
            this.updateTransactionEvents(transactionEvents, filteredEvents);
            transactionEvents.sendEvents();
        }
    }

    protected Client getAlfrescoClient(Client knownClientType) {
        HttpServletRequest request;
        Object noAlfrescoClientIdHint = AlfrescoTransactionSupport.getResource((Object)"RuleServiceImpl.ExecutedRules");
        if (noAlfrescoClientIdHint != null) {
            return null;
        }
        CallContext context = AlfrescoCmisServiceCall.get();
        if (context != null && (request = (HttpServletRequest)context.get("httpServletRequest")) != null) {
            String alfrescoClientId = request.getHeader("alfrescoClientId");
            return new Client(Client.ClientType.cmis, alfrescoClientId);
        }
        return knownClientType;
    }

    @Override
    public void afterCommit() {
        if (this.sendEventsBeforeCommit) {
            if (!this.shouldSendCommitEvent()) {
                return;
            }
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            long timestamp = System.currentTimeMillis();
            String networkId = TenantUtil.getCurrentDomain();
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            Client alfrescoClient = this.getAlfrescoClient(null);
            TransactionCommittedEvent event = new TransactionCommittedEvent(this.nextSequenceNumber(), txnId, networkId, timestamp, username, alfrescoClient);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sendEvent " + event));
            }
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>((Event)event){
                private final /* synthetic */ Event val$event;
                {
                    this.val$event = event;
                }

                @Override
                public Void execute() throws Throwable {
                    AbstractEventsService.this.messageProducer.send((Object)this.val$event);
                    return null;
                }
            }, true, false);
        } else {
            TxnEvents transactionEvents = (TxnEvents)AlfrescoTransactionSupport.getResource((Object)EVENTS_KEY);
            if (transactionEvents != null) {
                List<Event> filteredEvents = this.filterEventsBeforeSend(transactionEvents.getEvents());
                this.updateTransactionEvents(transactionEvents, filteredEvents);
                transactionEvents.sendEvents();
            }
        }
    }

    protected boolean shouldSendCommitEvent() {
        return true;
    }

    protected List<Event> filterEventsBeforeSend(List<Event> events) {
        return events;
    }

    private void updateTransactionEvents(TxnEvents transactionEvents, List<Event> filteredEvents) {
        if (filteredEvents.size() < transactionEvents.getEvents().size()) {
            transactionEvents.clear();
            transactionEvents.addEvents(filteredEvents);
        }
    }

    @Override
    public void afterRollback() {
        String txnId = AlfrescoTransactionSupport.getTransactionId();
        long timestamp = System.currentTimeMillis();
        String networkId = TenantUtil.getCurrentDomain();
        String username = AuthenticationUtil.getFullyAuthenticatedUser();
        Client alfrescoClient = this.getAlfrescoClient(null);
        TransactionRolledBackEvent event = new TransactionRolledBackEvent(this.nextSequenceNumber(), txnId, networkId, timestamp, username, alfrescoClient);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sendEvent " + event));
        }
        try {
            try {
                this.messageProducer.send((Object)event);
            }
            catch (MessagingException e) {
                logger.error((Object)("Failed to send event " + event), (Throwable)e);
                TxnEvents events = (TxnEvents)AlfrescoTransactionSupport.getResource((Object)EVENTS_KEY);
                if (events != null) {
                    events.clear();
                }
            }
        }
        finally {
            TxnEvents events = (TxnEvents)AlfrescoTransactionSupport.getResource((Object)EVENTS_KEY);
            if (events != null) {
                events.clear();
            }
        }
    }

    protected boolean includeEventType(String eventType) {
        return this.includeEventTypes.contains(eventType);
    }

    private boolean parentMatches(QName type) {
        boolean matches = false;
        QName t = type;
        while (t != null) {
            TypeDefinition typeDef = this.dictionaryService.getType(t);
            if ((t = typeDef.getParentName()) == null || !this.matchingTypes.contains(t)) continue;
            matches = true;
            this.matchingTypes.add(type);
            break;
        }
        return matches;
    }

    protected void retrieveAdditionalProps(Map<String, Serializable> properties, NodeRef nodeRef) {
    }

    private boolean typeMatches(QName type) {
        boolean matches = false;
        if (type != null) {
            matches = this.matchingTypes == null || this.matchingTypes.size() == 0 ? true : (this.matchingTypes.contains(type) ? true : this.parentMatches(type));
        }
        return matches;
    }

    protected List<String> getPaths(List<Path> nodePaths, List<String> toAppend) {
        ArrayList<String> stringPaths = new ArrayList<String>(nodePaths.size());
        for (final Path path : nodePaths) {
            String displayPath = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    String displayPath = path.toDisplayPath(AbstractEventsService.this.nodeService, AbstractEventsService.this.permissionService);
                    return displayPath;
                }
            });
            StringBuilder pathStr = new StringBuilder(displayPath);
            if (toAppend != null && toAppend.size() > 0) {
                for (String elem : toAppend) {
                    pathStr.append("/");
                    pathStr.append(elem);
                }
            }
            stringPaths.add(pathStr.toString());
        }
        return stringPaths;
    }

    protected List<List<String>> getNodeIdsFromParent(List<Path> nodePaths) {
        ArrayList<List<String>> pathNodeIds = new ArrayList<List<String>>(nodePaths.size());
        for (Path path : nodePaths) {
            ArrayList<String> nodeIds = new ArrayList<String>(path.size());
            int i = path.size() - 2;
            while (i >= 0) {
                Path.Element element = path.get(i);
                if (element instanceof Path.ChildAssocElement) {
                    Path.ChildAssocElement childAssocElem = (Path.ChildAssocElement)element;
                    NodeRef childNodeRef = childAssocElem.getRef().getChildRef();
                    nodeIds.add(childNodeRef.getId());
                }
                --i;
            }
            pathNodeIds.add(nodeIds);
        }
        return pathNodeIds;
    }

    protected List<List<String>> getNodeIds(List<Path> nodePaths) {
        ArrayList<List<String>> pathNodeIds = new ArrayList<List<String>>(nodePaths.size());
        for (Path path : nodePaths) {
            ArrayList<String> nodeIds = new ArrayList<String>(path.size());
            int i = path.size() - 1;
            while (i >= 0) {
                Path.Element element = path.get(i);
                if (element instanceof Path.ChildAssocElement) {
                    Path.ChildAssocElement childAssocElem = (Path.ChildAssocElement)element;
                    NodeRef childNodeRef = childAssocElem.getRef().getChildRef();
                    nodeIds.add(childNodeRef.getId());
                }
                --i;
            }
            pathNodeIds.add(nodeIds);
        }
        return pathNodeIds;
    }

    protected TxnEvents getTxnEvents() {
        TxnEvents events = (TxnEvents)AlfrescoTransactionSupport.getResource((Object)EVENTS_KEY);
        if (events == null) {
            events = new TxnEvents();
            AlfrescoTransactionSupport.bindResource((Object)EVENTS_KEY, (Object)events);
            TransactionSupportUtil.bindListener((TransactionListener)this, (int)1);
        }
        return events;
    }

    public void sendEvent(Event event) {
        String eventType = event.getType();
        if (!this.eventRegistry.isEventTypeRegistered(eventType)) {
            this.eventRegistry.addEventType(eventType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sendEvent " + event));
        }
        TxnEvents events = this.getTxnEvents();
        events.addEvent(event);
    }

    protected NodeInfo getNodeInfo(final NodeRef nodeRef, final String eventType) {
        NodeInfo nodeInfo = (NodeInfo)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeInfo>(){

            public NodeInfo doWork() throws Exception {
                NodeInfo nodeInfo = null;
                String txnId = AlfrescoTransactionSupport.getTransactionId();
                if (!AbstractEventsService.this.includeEventType(eventType)) {
                    nodeInfo = new NodeInfo(eventType, null, null, nodeRef, null, null, null, null, null, null, null, null, false, null, null);
                } else if (nodeRef == null || !AbstractEventsService.this.nodeService.exists(nodeRef)) {
                    nodeInfo = new NodeInfo(eventType, txnId, null, nodeRef, null, null, null, null, null, null, null, false, true, false, null);
                } else {
                    FileFilterMode.Client filterclient = FileFilterMode.getClient();
                    HiddenAspect.Visibility visibility = AbstractEventsService.this.hiddenAspect.getVisibility(filterclient, nodeRef);
                    QName type = AbstractEventsService.this.nodeService.getType(nodeRef);
                    if (!AbstractEventsService.this.typeMatches(type)) {
                        nodeInfo = new NodeInfo(eventType, txnId, null, nodeRef, null, null, null, null, null, null, null, true, true, false, false);
                    } else if (!visibility.equals((Object)HiddenAspect.Visibility.Visible)) {
                        nodeInfo = new NodeInfo(eventType, txnId, null, nodeRef, null, null, null, null, null, null, null, true, true, true, true);
                    } else {
                        SiteInfo siteInfo = AbstractEventsService.this.siteService.getSite(nodeRef);
                        String siteId = siteInfo != null ? siteInfo.getShortName() : null;
                        Set aspects = AbstractEventsService.this.nodeService.getAspects(nodeRef);
                        String name = (String)((Object)AbstractEventsService.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                        List<Path> nodePaths = Collections.singletonList(AbstractEventsService.this.nodeService.getPath(nodeRef));
                        Date modifiedTime = (Date)AbstractEventsService.this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
                        Long modificationTimestamp = modifiedTime != null ? Long.valueOf(modifiedTime.getTime()) : null;
                        NodeRef.Status status = AbstractEventsService.this.nodeService.getNodeStatus(nodeRef);
                        Client client = ClientUtil.from(filterclient);
                        nodeInfo = new NodeInfo(eventType, txnId, name, nodeRef, status, nodePaths, modificationTimestamp, type, aspects, siteId, client, true, true, true, true);
                    }
                }
                return nodeInfo;
            }
        });
        return nodeInfo;
    }

    protected class NodeInfo {
        private String txnId;
        private String name;
        private NodeRef nodeRef;
        private List<Path> nodePaths;
        private Long modificationTimestamp;
        private QName type;
        private String siteId;
        private NodeRef.Status status;
        private Client client;
        private Boolean nodeExists;
        private boolean include;
        private Boolean isVisible;
        private Boolean typeMatches;
        private String eventType;
        private List<String> stringPaths;
        private List<List<String>> parentNodeIds;
        private Set<QName> aspects;

        public NodeInfo(String eventType, String txnId, String name, NodeRef nodeRef, NodeRef.Status status, List<Path> nodePaths, Long modificationTimestamp, QName type, Set<QName> aspects, String siteId, Client client, Boolean nodeExists, boolean include, Boolean isVisible, Boolean typeMatches) {
            this.eventType = eventType;
            this.txnId = txnId;
            this.name = name;
            this.nodeRef = nodeRef;
            this.status = status;
            this.nodePaths = nodePaths;
            this.modificationTimestamp = modificationTimestamp;
            this.type = type;
            this.aspects = aspects;
            this.siteId = siteId;
            this.client = client;
            this.nodeExists = nodeExists;
            this.include = include;
            this.isVisible = isVisible;
            this.typeMatches = typeMatches;
        }

        public Map<String, Serializable> getProperties() {
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            String workingCopyOwner = (String)((Object)AbstractEventsService.this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_WORKING_COPY_OWNER));
            if (workingCopyOwner != null) {
                properties.put(ContentModel.PROP_WORKING_COPY_OWNER.toPrefixString((NamespacePrefixResolver)AbstractEventsService.this.namespaceService), (Serializable)((Object)workingCopyOwner));
            }
            AbstractEventsService.this.retrieveAdditionalProps(properties, this.nodeRef);
            return properties;
        }

        public boolean checkNodeInfo() {
            boolean ret = true;
            if (!this.nodeExists.booleanValue()) {
                logger.warn((Object)("Unable to send event of type " + this.eventType + ", node not found: " + this.toString()));
                ret = false;
            } else if (!this.include) {
                logger.warn((Object)("Unable to send event of type " + this.eventType + ", node not included: " + this.toString()));
                ret = false;
            } else if (!this.typeMatches.booleanValue()) {
                logger.warn((Object)("Unable to send event of type " + this.eventType + ", node type filtered: " + this.toString()));
                ret = false;
            } else if (!this.isVisible.booleanValue()) {
                logger.warn((Object)("Unable to send event of type " + this.eventType + ", node is not visible: " + this.toString()));
                ret = false;
            }
            return ret;
        }

        public Set<QName> getAspects() {
            return this.aspects;
        }

        public Set<String> getAspectsAsStrings() {
            HashSet<String> strAspects = new HashSet<String>();
            for (QName aspect : this.aspects) {
                strAspects.add(aspect.toPrefixString((NamespacePrefixResolver)AbstractEventsService.this.namespaceService));
            }
            return strAspects;
        }

        public Boolean getTypeMatches() {
            return this.typeMatches;
        }

        public String getEventType() {
            return this.eventType;
        }

        public boolean isInclude() {
            return this.include;
        }

        public Boolean getIsVisible() {
            return this.isVisible;
        }

        public Boolean isNodeExists() {
            return this.nodeExists;
        }

        public String getTxnId() {
            return this.txnId;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeId() {
            String nodeId = this.nodeRef.getId();
            return nodeId;
        }

        public NodeRef.Status getStatus() {
            return this.status;
        }

        List<String> getToAppend() {
            List<String> ret = null;
            ret = this.name != null ? Arrays.asList(this.name) : Collections.emptyList();
            return ret;
        }

        public List<String> getPaths() {
            if (this.stringPaths == null && this.nodePaths != null) {
                this.stringPaths = AbstractEventsService.this.getPaths(this.nodePaths, this.getToAppend());
            }
            return this.stringPaths;
        }

        public List<List<String>> getParentNodeIds() {
            if (this.parentNodeIds == null && this.nodePaths != null) {
                this.parentNodeIds = AbstractEventsService.this.getNodeIdsFromParent(this.nodePaths);
            }
            return this.parentNodeIds;
        }

        public Long getModificationTimestamp() {
            return this.modificationTimestamp;
        }

        public QName getType() {
            return this.type;
        }

        public String getSiteId() {
            return this.siteId;
        }

        public Client getClient() {
            return this.client;
        }

        void updateName(String name) {
            this.name = name;
            this.stringPaths = null;
        }

        public String toString() {
            return "NodeInfo [txnId=" + this.txnId + ", name=" + this.name + ", nodeRef=" + this.nodeRef + ", nodePaths=" + this.nodePaths + ", modificationTimestamp=" + this.modificationTimestamp + ", type=" + this.type + ", siteId=" + this.siteId + ", status=" + this.status + ", client=" + this.client + ", nodeExists=" + this.nodeExists + ", include=" + this.include + ", isVisible=" + this.isVisible + ", typeMatches=" + this.typeMatches + ", eventType=" + this.eventType + ", stringPaths=" + this.stringPaths + ", parentNodeIds=" + this.parentNodeIds + "]";
        }
    }

    class TxnEvents {
        private long seqNumber = 0L;
        private List<Event> events = new LinkedList<Event>();

        TxnEvents() {
        }

        void addEvent(Event event) {
            this.events.add(event);
        }

        void addEvents(List<Event> events) {
            events.addAll(events);
        }

        void clear() {
            this.events.clear();
            this.seqNumber = 0L;
        }

        long nextSeqNumber() {
            return this.seqNumber++;
        }

        List<Event> getEvents() {
            return this.events;
        }

        void sendEvents() {
            if (this.events != null && this.events.size() > 0) {
                try {
                    for (Event event : this.events) {
                        AbstractEventsService.this.messageProducer.send((Object)event);
                    }
                }
                finally {
                    AlfrescoTransactionSupport.bindResource((Object)AbstractEventsService.TRANSACTION_HAS_EVENTS, (Object)true);
                    this.events.clear();
                }
            }
        }
    }
}

