/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.LocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.transform.client.model.config.CoreFunction;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class LocalTransformClient
implements TransformClient,
InitializingBean {
    private static final String TRANSFORM = "Local transform ";
    private static Log logger = LogFactory.getLog(LocalTransformClient.class);
    private LocalTransformServiceRegistry localTransformServiceRegistry;
    private TransactionService transactionService;
    private ContentService contentService;
    private RenditionService2Impl renditionService2;
    private boolean directAccessUrlEnabled;
    private ExecutorService executorService;
    private ThreadLocal<LocalTransform> transform = new ThreadLocal();

    public void setLocalTransformServiceRegistry(LocalTransformServiceRegistry localTransformServiceRegistry) {
        this.localTransformServiceRegistry = localTransformServiceRegistry;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setRenditionService2(RenditionService2Impl renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void setDirectAccessUrlEnabled(boolean directAccessUrlEnabled) {
        this.directAccessUrlEnabled = directAccessUrlEnabled;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"localTransformServiceRegistry", (Object)((Object)this.localTransformServiceRegistry));
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"renditionService2", (Object)this.renditionService2);
        PropertyCheck.mandatory((Object)this, (String)"directAccessUrlEnabled", (Object)this.directAccessUrlEnabled);
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
    }

    @Override
    public void checkSupported(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String sourceMimetype, long sourceSizeInBytes, String contentUrl) {
        String targetMimetype = renditionDefinition.getTargetMimetype();
        String renditionName = renditionDefinition.getRenditionName();
        Map<String, String> actualOptions = renditionDefinition.getTransformOptions();
        LocalTransform localTransform = this.localTransformServiceRegistry.getLocalTransform(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        this.transform.set(localTransform);
        String message = TRANSFORM + renditionName + " from " + sourceMimetype + (localTransform == null ? " is unsupported" : " is supported");
        logger.debug((Object)message);
        if (localTransform == null) {
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    public void transform(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String user, int sourceContentHashCode) {
        String renditionName = renditionDefinition.getRenditionName();
        String targetMimetype = renditionDefinition.getTargetMimetype();
        Map<String, String> renditionOptions = renditionDefinition.getTransformOptions();
        LocalTransform localTransform = this.transform.get();
        Map<String, String> actualOptions = this.addDirectAccessUrlToOptionsIfPossible(renditionOptions, sourceNodeRef, localTransform);
        this.executorService.submit(() -> AuthenticationUtil.runAs(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            try {
                if (localTransform == null) {
                    throw new IllegalStateException("isSupported was not called prior to an asynchronous transform.");
                }
                ContentReader reader = this.contentService.getReader(sourceNodeRef, ContentModel.PROP_CONTENT);
                if (reader == null || !reader.exists()) {
                    throw new IllegalArgumentException("sourceNodeRef " + sourceNodeRef + " has no content.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Local transform requested " + renditionName));
                }
                ContentWriter writer = this.contentService.getTempWriter();
                writer.setMimetype(targetMimetype);
                localTransform.transform(reader, writer, actualOptions, renditionName, sourceNodeRef);
                InputStream inputStream = writer.getReader().getContentInputStream();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Local transform to be consumed " + renditionName));
                }
                this.renditionService2.consume(sourceNodeRef, inputStream, renditionDefinition, sourceContentHashCode);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Local transform consumed " + renditionName));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Local transform failed " + renditionName), (Throwable)e);
                }
                if (renditionDefinition instanceof TransformDefinition) {
                    ((TransformDefinition)renditionDefinition).setErrorMessage(e.getMessage());
                }
                this.renditionService2.failure(sourceNodeRef, renditionDefinition, sourceContentHashCode);
                throw e;
            }
            return null;
        }), (String)user));
    }

    private Map<String, String> addDirectAccessUrlToOptionsIfPossible(Map<String, String> actualOptions, NodeRef sourceNodeRef, LocalTransform transform) {
        if (this.directAccessUrlEnabled && this.localTransformServiceRegistry.isSupported(CoreFunction.DIRECT_ACCESS_URL, transform) && this.contentService.isContentDirectUrlEnabled(sourceNodeRef, ContentModel.PROP_CONTENT)) {
            DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(sourceNodeRef, ContentModel.PROP_CONTENT, true);
            actualOptions = new HashMap<String, String>(actualOptions);
            actualOptions.put("directAccessUrl", directAccessUrl.getContentUrl());
        }
        return actualOptions;
    }
}

