/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.TemplateVirtualizationMethod;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeVirtualizationMethod
extends TemplateVirtualizationMethod {
    private static Log logger = LogFactory.getLog(TypeVirtualizationMethod.class);
    private NamespacePrefixResolver namespacePrefixResolver;
    private NodeRefExpression templatesPath;
    private String filters;
    private ThreadLocal<Boolean> solvingTemplate = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public void init() {
    }

    private QNamePattern[] createFilters() {
        QNamePattern[] qnamePatternFilters = new QNamePattern[]{};
        if (this.namespacePrefixResolver != null && this.filters != null) {
            qnamePatternFilters = this.asRegExpQNamePatternFilters(this.filters);
        } else {
            logger.debug((Object)("Could not reset qName filters with NameSpacePrefixResolver=" + this.namespacePrefixResolver + " and filters=" + this.filters));
        }
        return qnamePatternFilters;
    }

    private QNamePattern[] asRegExpQNamePatternFilters(String filtersString) {
        String[] filters = filtersString.split(",");
        ArrayList<Object> patterns = new ArrayList<Object>(3);
        int i = 0;
        while (i < filters.length) {
            block12: {
                String trimmedFilters = filters[i].trim();
                if (!trimmedFilters.isEmpty()) {
                    if ("*".equals(trimmedFilters)) {
                        patterns.clear();
                        patterns.add(RegexQNamePattern.MATCH_ALL);
                        break;
                    }
                    if ("none".equals(trimmedFilters)) {
                        patterns.clear();
                        break;
                    }
                    String[] components = filters[i].split(":");
                    if (components == null || components.length != 2 || components[0].trim().isEmpty() || components[1].trim().isEmpty()) {
                        throw new IllegalArgumentException("Illegal filters string " + filtersString + ". Expected <prefix>:<name> | <prefix>:'*' instead of " + filters[i]);
                    }
                    try {
                        String uri = this.namespacePrefixResolver.getNamespaceURI(components[0]);
                        if (uri == null) {
                            throw new NamespaceException("Unregistrered prefix " + components[0]);
                        }
                        String localName = components[1];
                        if ("*".equals(localName.trim())) {
                            localName = ".*";
                        }
                        Pattern.compile(uri);
                        Pattern.compile(localName);
                        RegexQNamePattern qNamePattern = new RegexQNamePattern(uri, localName);
                        if (!qNamePattern.isMatch(QName.createQName((String)uri, (String)components[1]))) {
                            throw new IllegalArgumentException("Illegal filters string " + filtersString + " due to invalid regexp translatrion in  " + filters[i] + " as " + qNamePattern);
                        }
                        patterns.add(qNamePattern);
                    }
                    catch (NamespaceException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Illegal filters string " + filtersString + " due to unregistered name space in  " + filters[i]), (Throwable)e);
                        }
                    }
                    catch (PatternSyntaxException e) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug((Object)("Illegal filters string " + filtersString + " due to invalid regexp translation in  " + filters[i]), (Throwable)e);
                    }
                }
            }
            ++i;
        }
        return patterns.toArray(new QNamePattern[0]);
    }

    public void setQnameFilters(String filters) {
        ParameterCheck.mandatoryString((String)"filters", (String)filters);
        this.filters = filters;
    }

    public void setTemplatesPath(NodeRefExpression templatesPath) {
        this.templatesPath = templatesPath;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver resolver) {
        this.namespacePrefixResolver = resolver;
    }

    @Override
    public boolean canVirtualize(ActualEnvironment env, NodeRef nodeRef) throws ActualEnvironmentException {
        if (this.solvingTemplate.get().booleanValue()) {
            return false;
        }
        this.solvingTemplate.set(true);
        try {
            boolean bl = this.templateNodeFor(env, nodeRef) != null;
            return bl;
        }
        finally {
            this.solvingTemplate.set(false);
        }
    }

    private String templateNodeNameForType(QName type) {
        String extension = ".json";
        String typePrefixString = type.toPrefixString(this.namespacePrefixResolver);
        String typeTemplateContentName = typePrefixString.replaceAll(":", "_");
        return String.valueOf(typeTemplateContentName) + extension;
    }

    private boolean isAnyFilterMatch(QName qname) {
        QNamePattern[] syncFilters = this.createFilters();
        int i = 0;
        while (i < syncFilters.length) {
            if (syncFilters[i].isMatch(qname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private NodeRef templateNodeFor(ActualEnvironment env, NodeRef nodeRef) {
        NodeRef templatesContainerNode;
        block7: {
            templatesContainerNode = this.templatesPath.resolve();
            if (templatesContainerNode != null) break block7;
            return null;
        }
        try {
            NodeRef templateNode = null;
            QName nodeType = env.getType(nodeRef);
            if (this.isAnyFilterMatch(nodeType)) {
                String typeTemplateNodeName = this.templateNodeNameForType(nodeType);
                templateNode = env.getChildByName(templatesContainerNode, ContentModel.ASSOC_CONTAINS, typeTemplateNodeName);
            }
            if (templateNode == null) {
                Set<QName> aspects = env.getAspects(nodeRef);
                for (QName aspect : aspects) {
                    String aspectTemplateNodeName;
                    if (this.isAnyFilterMatch(aspect) && (templateNode = env.getChildByName(templatesContainerNode, ContentModel.ASSOC_CONTAINS, aspectTemplateNodeName = this.templateNodeNameForType(aspect))) != null) break;
                }
            }
            return templateNode;
        }
        catch (PatternSyntaxException e) {
            logger.error((Object)"Invalid type method type and aspect in qName filter ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"Type virtualization template search failed.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Reference virtualize(ActualEnvironment env, NodeRef nodeRef) throws VirtualizationException {
        if (this.solvingTemplate.get().booleanValue()) {
            throw new VirtualizationException("Concurrent virtualization!");
        }
        try {
            this.solvingTemplate.set(true);
            NodeRef templateNode = this.templateNodeFor(env, nodeRef);
            Reference reference = this.newVirtualReference(Protocols.VANILLA.protocol, templateNode, nodeRef);
            return reference;
        }
        catch (VirtualizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirtualizationException(e);
        }
        finally {
            this.solvingTemplate.set(false);
        }
    }
}

