/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.camel;

import org.alfresco.util.testing.category.NeverRunsTests;
import org.apache.camel.CamelContext;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@Category(value={NeverRunsTests.class})
@ContextConfiguration(locations={"/test-messaging-context.xml"})
public class CamelComponentsTest {
    @Autowired
    protected CamelContext camelContext;
    @Produce(value="activemq:queue:alfresco.test")
    protected ProducerTemplate activemqTemplate;
    @Produce(value="amqp:queue:alfresco.test")
    protected ProducerTemplate amqpTemplate;
    @Produce(value="jms:queue:alfresco.test")
    protected ProducerTemplate jmsTemplate;

    @Test
    public void testActivemqComponent() {
        this.activemqTemplate.sendBody((Object)"ping <activemq>");
        Object reply = this.camelContext.createConsumerTemplate().receiveBody("activemq:queue:alfresco.test", 2000L);
        Assert.assertEquals((Object)"ping <activemq>", (Object)reply);
    }

    @Test
    public void testAmqpComponent() {
        this.amqpTemplate.sendBody((Object)"ping <amqp>");
        Object reply = this.camelContext.createConsumerTemplate().receiveBody("amqp:queue:alfresco.test", 2000L);
        Assert.assertEquals((Object)"ping <amqp>", (Object)reply);
    }

    @Test
    public void testJmsComponent() {
        this.jmsTemplate.sendBody((Object)"ping <jms>");
        Object reply = this.camelContext.createConsumerTemplate().receiveBody("jms:queue:alfresco.test", 2000L);
        Assert.assertEquals((Object)"ping <jms>", (Object)reply);
    }
}

