/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.audit;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLClusterNDBDialect;
import org.alfresco.repo.domain.propval.PropValGenerator;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.DBTests;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.experimental.categories.Category;
import org.springframework.context.ConfigurableApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class AuditDAOTest
extends TestCase {
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private AuditDAO auditDAO;
    private PropertyValueDAO propertyValueDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.auditDAO = (AuditDAO)this.ctx.getBean("auditDAO");
        this.propertyValueDAO = (PropertyValueDAO)this.ctx.getBean(PropertyValueDAO.class);
    }

    public void testAuditModel() throws Exception {
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        final URL url = new URL("file:" + file.getAbsolutePath());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>>(){

            public Pair<Long, ContentData> execute() throws Throwable {
                Pair auditModelPair = AuditDAOTest.this.auditDAO.getOrCreateAuditModel(url);
                return auditModelPair;
            }
        };
        Pair configPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        AuditDAOTest.assertNotNull((Object)configPair);
        Pair configPairCheck = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        AuditDAOTest.assertNotNull((Object)configPairCheck);
        AuditDAOTest.assertEquals((Object)configPair, (Object)configPairCheck);
    }

    public void testAuditApplication() throws Exception {
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        final URL url = new URL("file:" + file.getAbsolutePath());
        RetryingTransactionHelper.RetryingTransactionCallback<Long> createModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return (Long)AuditDAOTest.this.auditDAO.getOrCreateAuditModel(url).getFirst();
            }
        };
        final Long modelId = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createModelCallback);
        final String appName = String.valueOf(this.getName()) + "." + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createAppCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                int i = 0;
                while (i < 1000) {
                    AuditDAO.AuditApplicationInfo appInfo = AuditDAOTest.this.auditDAO.getAuditApplication(appName);
                    if (appInfo == null) {
                        AuditDAO.AuditApplicationInfo auditApplicationInfo = AuditDAOTest.this.auditDAO.createAuditApplication(appName, modelId);
                    }
                    ++i;
                }
                return null;
            }
        };
        long before = System.nanoTime();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createAppCallback);
        long after = System.nanoTime();
        System.out.println("Time for 1000 application creations was " + (double)(after - before) / 1.0E7 + "ms");
    }

    public void testAuditEntry() throws Exception {
        this.doAuditEntryImpl(1000);
    }

    private String doAuditEntryImpl(final int count) throws Exception {
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        final URL url = new URL("file:" + file.getAbsolutePath());
        final String appName = String.valueOf(this.getName()) + "." + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Long> createAppCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                AuditDAO.AuditApplicationInfo appInfo = AuditDAOTest.this.auditDAO.getAuditApplication(appName);
                if (appInfo == null) {
                    Long modelId = (Long)AuditDAOTest.this.auditDAO.getOrCreateAuditModel(url).getFirst();
                    appInfo = AuditDAOTest.this.auditDAO.createAuditApplication(appName, modelId);
                }
                return appInfo.getId();
            }
        };
        final Long sessionId = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createAppCallback);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createEntryCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                int i = 0;
                while (i < count) {
                    Map<String, Integer> values = Collections.singletonMap("/a/b/c", new Integer(i));
                    long now = System.currentTimeMillis();
                    AuditDAOTest.this.auditDAO.createAuditEntry(sessionId, now, "alexi", values);
                    ++i;
                }
                return null;
            }
        };
        long before = System.nanoTime();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createEntryCallback);
        long after = System.nanoTime();
        System.out.println("Time for " + count + " entry creations was " + (double)(after - before) / 1.0E7 + "ms");
        return appName;
    }

    public synchronized void testAuditQuery() throws Exception {
        this.doAuditEntryImpl(1);
        final MutableInt count = new MutableInt(0);
        final LinkedList timestamps = new LinkedList();
        final AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return false;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                count.setValue(count.intValue() + 1);
                timestamps.add(time);
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        final AuditQueryParameters params = new AuditQueryParameters();
        params.addSearchKey("/a/b/c", null);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        count.setValue(0);
        timestamps.clear();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((String)"Expected at least one result", (count.intValue() > 0 ? 1 : 0) != 0);
        ((Object)((Object)this)).wait(1000L);
        this.doAuditEntryImpl(1);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> findReverseCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                params.setForward(false);
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                params.setForward(true);
                return null;
            }
        };
        timestamps.clear();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findReverseCallback);
    }

    public synchronized void testAuditQueryCombos() throws Exception {
        this.doAuditEntryImpl(10);
        final MutableInt count = new MutableInt(0);
        final LinkedList timestamps = new LinkedList();
        final LinkedList entryIds = new LinkedList();
        final AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return false;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                count.setValue(count.intValue() + 1);
                timestamps.add(time);
                entryIds.add(entryId);
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        final AuditQueryParameters params = new AuditQueryParameters();
        params.addSearchKey("/a/b/c", null);
        Object findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 10);
                return null;
            }
        };
        count.setValue(0);
        timestamps.clear();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertEquals((int)10, (int)count.intValue());
        ArrayList allEntryIds = new ArrayList(entryIds);
        ArrayList allTimestamps = new ArrayList(timestamps);
        entryIds.clear();
        timestamps.clear();
        params.setFromId((Long)allEntryIds.get(2));
        findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((boolean)allEntryIds.subList(2, 4).equals(entryIds));
        entryIds.clear();
        timestamps.clear();
        params.setFromId(null);
        params.setFromTime(null);
        params.setToTime(null);
        params.setToId((Long)allEntryIds.get(2));
        findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((boolean)allEntryIds.subList(0, 2).equals(entryIds));
        entryIds.clear();
        timestamps.clear();
        params.setFromId((Long)allEntryIds.get(2));
        params.setToId((Long)allEntryIds.get(5));
        params.setFromTime(null);
        params.setToTime(null);
        findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 1);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((boolean)allEntryIds.subList(2, 3).equals(entryIds));
        entryIds.clear();
        timestamps.clear();
        params.setFromTime((Long)allTimestamps.get(2));
        params.setFromId(null);
        params.setToTime(null);
        params.setToId(null);
        findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((boolean)allTimestamps.subList(2, 4).equals(timestamps));
        entryIds.clear();
        timestamps.clear();
        params.setFromTime(null);
        params.setFromId(null);
        params.setToTime((Long)allTimestamps.get(4));
        params.setToId(null);
        findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((boolean)allTimestamps.subList(0, 2).equals(timestamps));
        entryIds.clear();
        timestamps.clear();
        params.setFromTime((Long)allTimestamps.get(2));
        params.setFromId(null);
        params.setToTime((Long)allTimestamps.get(5));
        params.setToId(null);
        findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)findCallback);
        AuditDAOTest.assertTrue((boolean)allTimestamps.subList(2, 4).equals(timestamps));
    }

    public void testAuditDeleteEntries() throws Exception {
        final AuditService.AuditQueryCallback noResultsCallback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return false;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                AuditDAOTest.fail((String)"Expected no results.  All entries should have been removed.");
                return false;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        final String appName = this.doAuditEntryImpl(1);
        final AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(appName);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deletedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Long appId = AuditDAOTest.this.auditDAO.getAuditApplication(appName).getId();
                AuditDAOTest.this.auditDAO.deleteAuditEntries(appId, null, null);
                AuditDAOTest.this.auditDAO.findAuditEntries(noResultsCallback, params, Integer.MAX_VALUE);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deletedCallback);
    }

    public void testAuditDeleteEntriesForApplication() throws Exception {
        final String app1 = this.doAuditEntryImpl(6);
        final String app2 = this.doAuditEntryImpl(18);
        final AuditQueryCallbackImpl resultsCallback = new AuditQueryCallbackImpl();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deletedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Long app1Id = AuditDAOTest.this.auditDAO.getAuditApplication(app1).getId();
                AuditDAOTest.this.auditDAO.deleteAuditEntries(app1Id, null, null);
                AuditDAOTest.this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)resultsCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                AuditDAOTest.assertEquals((String)"All entries should have been deleted from app1", (int)0, (int)resultsCallback.numEntries(app1));
                AuditDAOTest.assertEquals((String)"No entries should have been deleted from app2", (int)18, (int)resultsCallback.numEntries(app2));
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deletedCallback);
    }

    public void testAuditDeleteEntriesForApplicationBetweenTimes() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deletedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            AuditQueryCallbackImpl preDeleteCallback;
            AuditQueryCallbackImpl resultsCallback;
            {
                this.preDeleteCallback = new AuditQueryCallbackImpl();
                this.resultsCallback = new AuditQueryCallbackImpl();
            }

            public Void execute() throws Throwable {
                AuditDAO.AuditApplicationInfo info1 = AuditDAOTest.this.createAuditApp();
                String app1 = info1.getName();
                Long app1Id = info1.getId();
                AuditDAO.AuditApplicationInfo info2 = AuditDAOTest.this.createAuditApp();
                String app2 = info2.getName();
                AuditDAOTest.this.createItem(info1, 10);
                AuditDAOTest.this.createItem(info1, 11);
                Thread.sleep(10L);
                Thread.sleep(10L);
                long t1 = System.currentTimeMillis();
                Thread.sleep(10L);
                Thread.sleep(10L);
                AuditDAOTest.this.createItem(info2, 21);
                AuditDAOTest.this.createItem(info1, 12);
                AuditDAOTest.this.createItem(info1, 13);
                Thread.sleep(10L);
                Thread.sleep(10L);
                long t2 = System.currentTimeMillis();
                Thread.sleep(10L);
                Thread.sleep(10L);
                AuditDAOTest.this.createItem(info2, 22);
                AuditDAOTest.this.createItem(info1, 14);
                AuditDAOTest.this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)this.preDeleteCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                AuditDAOTest.assertEquals((int)5, (int)this.preDeleteCallback.numEntries(app1));
                AuditDAOTest.assertEquals((int)2, (int)this.preDeleteCallback.numEntries(app2));
                AuditDAOTest.this.auditDAO.deleteAuditEntries(app1Id, Long.valueOf(t1), Long.valueOf(t2));
                AuditDAOTest.this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)this.resultsCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                AuditDAOTest.assertEquals((String)"Two entries should have been deleted from app1", (int)3, (int)this.resultsCallback.numEntries(app1));
                AuditDAOTest.assertEquals((String)"No entries should have been deleted from app2", (int)2, (int)this.resultsCallback.numEntries(app2));
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deletedCallback);
    }

    public void testAuditDeleteEntriesBetweenTimes() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deletedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            AuditQueryCallbackImpl preDeleteCallback;
            AuditQueryCallbackImpl resultsCallback;
            {
                this.preDeleteCallback = new AuditQueryCallbackImpl();
                this.resultsCallback = new AuditQueryCallbackImpl();
            }

            public Void execute() throws Throwable {
                AuditDAO.AuditApplicationInfo info1 = AuditDAOTest.this.createAuditApp();
                String app1 = info1.getName();
                AuditDAO.AuditApplicationInfo info2 = AuditDAOTest.this.createAuditApp();
                String app2 = info2.getName();
                AuditDAOTest.this.createItem(info1, 10);
                AuditDAOTest.this.createItem(info1, 11);
                Thread.sleep(10L);
                Thread.sleep(10L);
                long t1 = System.currentTimeMillis();
                Thread.sleep(10L);
                Thread.sleep(10L);
                AuditDAOTest.this.createItem(info2, 21);
                AuditDAOTest.this.createItem(info1, 12);
                AuditDAOTest.this.createItem(info1, 13);
                Thread.sleep(10L);
                Thread.sleep(10L);
                long t2 = System.currentTimeMillis();
                Thread.sleep(10L);
                Thread.sleep(10L);
                AuditDAOTest.this.createItem(info2, 22);
                AuditDAOTest.this.createItem(info1, 14);
                AuditDAOTest.this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)this.preDeleteCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                AuditDAOTest.assertEquals((int)5, (int)this.preDeleteCallback.numEntries(app1));
                AuditDAOTest.assertEquals((int)2, (int)this.preDeleteCallback.numEntries(app2));
                AuditDAOTest.this.auditDAO.deleteAuditEntries(null, Long.valueOf(t1), Long.valueOf(t2));
                AuditDAOTest.this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)this.resultsCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                AuditDAOTest.assertEquals((String)"Two entries should have been deleted from app1", (int)3, (int)this.resultsCallback.numEntries(app1));
                AuditDAOTest.assertEquals((String)"One entry should have been deleted from app2", (int)1, (int)this.resultsCallback.numEntries(app2));
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deletedCallback);
    }

    private void createItem(AuditDAO.AuditApplicationInfo appInfo, int value) {
        String username = "alexi";
        Map<String, Integer> values = Collections.singletonMap("/a/b/c", value);
        long now = System.currentTimeMillis();
        this.auditDAO.createAuditEntry(appInfo.getId(), now, username, values);
    }

    private AuditDAO.AuditApplicationInfo createAuditApp() throws IOException {
        String appName = String.valueOf(this.getName()) + "." + GUID.generate();
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        URL url = new URL("file:" + file.getAbsolutePath());
        AuditDAO.AuditApplicationInfo appInfo = this.auditDAO.getAuditApplication(appName);
        if (appInfo == null) {
            Long modelId = (Long)this.auditDAO.getOrCreateAuditModel(url).getFirst();
            appInfo = this.auditDAO.createAuditApplication(appName, modelId);
        }
        return appInfo;
    }

    public void testScriptCanDeleteOrphanedProps() throws Exception {
        Dialect dialect = (Dialect)this.ctx.getBean("dialect");
        if (dialect instanceof MySQLClusterNDBDialect) {
            throw new Exception("TODO review this test case with NDB - note: throw exeception here else causes later tests to fail (when running via AllDBTestTestSuite)");
        }
        this.scriptCanDeleteOrphanedPropsWork(false);
    }

    public void testMaxResults() throws Exception {
        try {
            AuditQueryCallbackImpl callback = new AuditQueryCallbackImpl();
            this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)callback, new AuditQueryParameters(), -1);
            AuditDAOTest.fail((String)"maxResults == -1 should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void scriptCanDeleteOrphanedPropsWork(boolean performance) throws Exception {
        int maxIterations;
        int iterationStep;
        if (performance) {
            iterationStep = 1000;
            maxIterations = 1000;
        } else {
            iterationStep = 1;
            maxIterations = 1;
        }
        int i = iterationStep;
        while (i <= maxIterations * iterationStep) {
            LinkedList<String> stringValues = new LinkedList<String>();
            LinkedList<Double> doubleValues = new LinkedList<Double>();
            LinkedList<Date> dateValues = new LinkedList<Date>();
            UserTransaction txn = this.transactionService.getUserTransaction();
            long startCreate = System.currentTimeMillis();
            txn.begin();
            int j = 0;
            while (j < i) {
                PropValGenerator valueGen = new PropValGenerator(this.propertyValueDAO);
                String stringValue = valueGen.createUniqueString();
                stringValues.add(stringValue);
                Double doubleValue = valueGen.createUniqueDouble();
                doubleValues.add(doubleValue);
                Date dateValue = valueGen.createUniqueDate();
                dateValues.add(dateValue);
                AuditQueryCallbackImpl preDeleteCallback = new AuditQueryCallbackImpl();
                AuditQueryCallbackImpl resultsCallback = new AuditQueryCallbackImpl();
                AuditDAO.AuditApplicationInfo info1 = this.createAuditApp();
                String app1 = info1.getName();
                String username = "alexi";
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("/a/b/string-" + j, stringValue);
                values.put("/a/b/double-" + j, doubleValue);
                values.put("/a/b/date-" + j, dateValue);
                long now = System.currentTimeMillis();
                this.auditDAO.createAuditEntry(info1.getId(), now, username, values);
                this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)preDeleteCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                AuditDAOTest.assertEquals((int)1, (int)preDeleteCallback.numEntries(app1));
                this.auditDAO.deleteAuditEntries(info1.getId(), null, null);
                if (!performance) {
                    this.auditDAO.findAuditEntries((AuditService.AuditQueryCallback)resultsCallback, new AuditQueryParameters(), Integer.MAX_VALUE);
                    AuditDAOTest.assertEquals((String)"All entries should have been deleted from app1", (int)0, (int)resultsCallback.numEntries(app1));
                }
                ++j;
            }
            txn.commit();
            System.out.println("Created values for " + i + " entries in " + (System.currentTimeMillis() - startCreate) + " ms.");
            if (!performance) {
                for (String stringValue : stringValues) {
                    AuditDAOTest.assertEquals((Object)stringValue, (Object)this.propertyValueDAO.getPropertyValue((Serializable)((Object)stringValue)).getSecond());
                }
                for (Double doubleValue : doubleValues) {
                    AuditDAOTest.assertEquals((Object)doubleValue, (Object)this.propertyValueDAO.getPropertyValue((Serializable)doubleValue).getSecond());
                }
                for (Date dateValue : dateValues) {
                    AuditDAOTest.assertEquals((Object)dateValue, (Object)this.propertyValueDAO.getPropertyValue((Serializable)dateValue).getSecond());
                }
            }
            long startDelete = System.currentTimeMillis();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    AuditDAOTest.this.propertyValueDAO.cleanupUnusedValues();
                    return null;
                }
            };
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
            System.out.println("Cleaned values for " + i + " entries in " + (System.currentTimeMillis() - startDelete) + " ms.");
            if (!performance) {
                txn = this.transactionService.getUserTransaction();
                txn.begin();
                for (String stringValue : stringValues) {
                    this.assertPropDeleted(this.propertyValueDAO.getPropertyValue((Serializable)((Object)stringValue)));
                }
                for (Double doubleValue : doubleValues) {
                    this.assertPropDeleted(this.propertyValueDAO.getPropertyValue((Serializable)doubleValue));
                }
                for (Date dateValue : dateValues) {
                    this.assertPropDeleted(this.propertyValueDAO.getPropertyValue((Serializable)dateValue));
                }
                txn.commit();
            }
            i += iterationStep;
        }
    }

    private void assertPropDeleted(Pair<Long, ?> value) {
        if (value != null) {
            String msg = String.format("Property value [%s=%s] should have been deleted by cleanup script.", value.getSecond().getClass().getSimpleName(), value.getSecond());
            AuditDAOTest.fail((String)msg);
        }
    }

    public void scriptCanDeleteOrphanedPropsPerformance() throws Exception {
        this.scriptCanDeleteOrphanedPropsWork(true);
    }

    public static void main(String[] args) {
        try {
            try {
                AuditDAOTest test = new AuditDAOTest();
                test.setUp();
                System.out.println("Press any key to run performance test.");
                System.in.read();
                test.scriptCanDeleteOrphanedPropsPerformance();
                System.out.println("Press any key to shutdown.");
                System.in.read();
                test.tearDown();
            }
            catch (Throwable e) {
                e.printStackTrace();
                ApplicationContextHelper.closeApplicationContext();
            }
        }
        finally {
            ApplicationContextHelper.closeApplicationContext();
        }
    }

    public class AuditQueryCallbackImpl
    implements AuditService.AuditQueryCallback {
        private Map<String, Integer> countsByApp = new HashMap<String, Integer>();

        public boolean valuesRequired() {
            return false;
        }

        public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
            Integer count = this.countsByApp.get(applicationName);
            if (count == null) {
                this.countsByApp.put(applicationName, 1);
            } else {
                count = count + 1;
                this.countsByApp.put(applicationName, count);
            }
            return true;
        }

        public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
            throw new AlfrescoRuntimeException(errorMsg, error);
        }

        public int numEntries(String appName) {
            if (this.countsByApp.containsKey(appName)) {
                return this.countsByApp.get(appName);
            }
            return 0;
        }
    }
}

