/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.FixedAclUpdater;
import org.alfresco.repo.domain.permissions.FixedAclUpdaterListener;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.security.permissions.PermissionServicePolicies;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.alfresco.util.PolicyIgnoreUtil;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class FixedAclUpdaterUnitTest {
    private static final NodeRef NODE_REF = new NodeRef("test://node/ref");
    private static final long NODE_ID = 123L;
    private static final NodeRef ARCHIVED_NODE = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, "archived");
    @InjectMocks
    private FixedAclUpdater fixedAclUpdater = new FixedAclUpdater();
    private FixedAclUpdater.AclWorker aclWorker = this.fixedAclUpdater.createAclWorker();
    @Mock
    private NodeDAO nodeDAO;
    @Mock
    private AccessControlListDAO accessControlListDAO;
    @Mock
    private PolicyIgnoreUtil policyIgnoreUtil;
    @Mock
    private ClassPolicyDelegate<PermissionServicePolicies.OnInheritPermissionsDisabled> onInheritPermissionsDisabledDelegate;
    @Mock
    private PermissionServicePolicies.OnInheritPermissionsDisabled onInheritPermissionsDisabled;
    @Mock
    private FixedAclUpdaterListener listenerA;
    @Mock
    private FixedAclUpdaterListener listenerB;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        FixedAclUpdater.registerListener((FixedAclUpdaterListener)this.listenerA);
        FixedAclUpdater.registerListener((FixedAclUpdaterListener)this.listenerB);
    }

    @Test
    public void testListenersNotifiedAboutUpdate() throws Throwable {
        Mockito.when((Object)this.nodeDAO.getNodePair(NODE_REF)).thenReturn((Object)new Pair((Object)123L, (Object)NODE_REF));
        Mockito.when((Object)((PermissionServicePolicies.OnInheritPermissionsDisabled)this.onInheritPermissionsDisabledDelegate.get(ContentModel.TYPE_BASE))).thenReturn((Object)this.onInheritPermissionsDisabled);
        this.aclWorker.process(NODE_REF);
        ((FixedAclUpdaterListener)Mockito.verify((Object)this.listenerA)).permissionsUpdatedAsynchronously(NODE_REF);
        ((FixedAclUpdaterListener)Mockito.verify((Object)this.listenerB)).permissionsUpdatedAsynchronously(NODE_REF);
    }

    @Test
    public void testListenersNotNotifiedAboutArchivedNode() throws Throwable {
        Mockito.when((Object)this.nodeDAO.getNodePair(ARCHIVED_NODE)).thenReturn((Object)new Pair((Object)123L, (Object)ARCHIVED_NODE));
        Mockito.when((Object)((PermissionServicePolicies.OnInheritPermissionsDisabled)this.onInheritPermissionsDisabledDelegate.get(ContentModel.TYPE_BASE))).thenReturn((Object)this.onInheritPermissionsDisabled);
        this.aclWorker.process(ARCHIVED_NODE);
        ((AccessControlListDAO)Mockito.verify((Object)this.accessControlListDAO)).removePendingAclAspect(Long.valueOf(123L));
        ((FixedAclUpdaterListener)Mockito.verify((Object)this.listenerA, (VerificationMode)Mockito.never())).permissionsUpdatedAsynchronously((NodeRef)ArgumentMatchers.any(NodeRef.class));
        ((FixedAclUpdaterListener)Mockito.verify((Object)this.listenerB, (VerificationMode)Mockito.never())).permissionsUpdatedAsynchronously((NodeRef)ArgumentMatchers.any(NodeRef.class));
    }
}

