/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jms.ConnectionFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.event.v1.model.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.PeerAssociationResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event2.EventGenerator;
import org.alfresco.repo.event2.EventGeneratorQueue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractContextAwareRepoEvent
extends BaseSpringTest {
    protected static final boolean DEBUG = false;
    protected static final String TEST_NAMESPACE = "http://www.alfresco.org/test/ContextAwareRepoEvent";
    protected static final RepoEventContainer EVENT_CONTAINER = new RepoEventContainer();
    private static final String BROKER_URL = "tcp://localhost:61616";
    private static final String TOPIC_NAME = "alfresco.repo.event2";
    private static final String CAMEL_ROUTE = "jms:topic:alfresco.repo.event2";
    private static final CamelContext CAMEL_CONTEXT = new DefaultCamelContext();
    private static boolean isCamelConfigured;
    private static DataFormat dataFormat;
    @Autowired
    protected RetryingTransactionHelper retryingTransactionHelper;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected CustomModelService customModelService;
    @Qualifier(value="descriptorComponent")
    @Autowired
    protected DescriptorService descriptorService;
    @Autowired
    protected ObjectMapper event2ObjectMapper;
    @Autowired
    @Qualifier(value="eventGeneratorV2")
    protected EventGenerator eventGenerator;
    @Autowired
    @Qualifier(value="eventGeneratorQueue")
    protected EventGeneratorQueue eventQueue;
    @Autowired
    private NamespaceDAO namespaceDAO;
    protected NodeRef rootNodeRef;

    @BeforeClass
    public static void beforeAll() {
        isCamelConfigured = false;
    }

    @AfterClass
    public static void afterAll() throws Exception {
        CAMEL_CONTEXT.stop();
    }

    @Before
    public void setUp() throws Exception {
        if (!isCamelConfigured) {
            dataFormat = new JacksonDataFormat(this.event2ObjectMapper, RepoEvent.class);
            this.configRoute();
            isCamelConfigured = true;
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.rootNodeRef = (NodeRef)this.retryingTransactionHelper.doInTransaction(() -> {
            StoreRef storeRef = new StoreRef("workspace", ((Object)((Object)this)).getClass().getName());
            if (!this.nodeService.exists(storeRef)) {
                storeRef = this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
            }
            return this.nodeService.getRootNode(storeRef);
        });
        this.initTestNamespacePrefixMapping();
        this.flushSpuriousEvents();
    }

    protected void initTestNamespacePrefixMapping() {
        if (this.namespaceDAO.getNamespaceURI("ce") == null) {
            this.namespaceDAO.addURI(TEST_NAMESPACE);
            this.namespaceDAO.addPrefix("ce", TEST_NAMESPACE);
        }
    }

    protected void flushSpuriousEvents() throws InterruptedException {
        int maxloops;
        int count = maxloops = 5;
        do {
            Thread.sleep(165L);
            if (EVENT_CONTAINER.isEmpty()) {
                --count;
                continue;
            }
            EVENT_CONTAINER.reset();
            count = maxloops;
        } while (count > 0);
    }

    @After
    public void tearDown() {
        EVENT_CONTAINER.reset();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected NodeRef createNode(QName contentType) {
        return (NodeRef)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()), contentType).getChildRef());
    }

    protected NodeRef createNode(QName contentType, NodeRef parentRef) {
        return (NodeRef)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()), contentType).getChildRef());
    }

    protected NodeRef createNode(QName contentType, PropertyMap propertyMap) {
        return this.createNode(contentType, GUID.generate(), propertyMap);
    }

    protected NodeRef createNode(QName contentType, String localName, PropertyMap propertyMap) {
        return (NodeRef)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)localName), contentType, (Map)propertyMap).getChildRef());
    }

    protected NodeRef updateNodeName(NodeRef nodeRef, String newName) {
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.put((Object)ContentModel.PROP_NAME, (Object)newName);
        return (NodeRef)this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.addProperties(nodeRef, (Map)propertyMap);
            return null;
        });
    }

    protected void deleteNode(NodeRef nodeRef) {
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.deleteNode(nodeRef);
            return null;
        });
    }

    protected RepoEventContainer getRepoEventsContainer() {
        return EVENT_CONTAINER;
    }

    protected <D extends DataAttributes<? extends Resource>> RepoEvent<D> getRepoEvent(int eventSequenceNumber) {
        this.waitUntilNumOfEvents(eventSequenceNumber);
        RepoEventContainer eventContainer = this.getRepoEventsContainer();
        RepoEvent<?> event = eventContainer.getEvent(eventSequenceNumber);
        AbstractContextAwareRepoEvent.assertNotNull(event);
        return event;
    }

    protected <D extends DataAttributes<? extends Resource>> RepoEvent<D> getRepoEventWithoutWait(int eventSequenceNumber) {
        RepoEventContainer eventContainer = this.getRepoEventsContainer();
        RepoEvent<?> event = eventContainer.getEvent(eventSequenceNumber);
        AbstractContextAwareRepoEvent.assertNotNull(event);
        return event;
    }

    protected <D extends DataAttributes<? extends Resource>> D getEventData(int eventSequenceNumber) {
        RepoEvent<D> event = this.getRepoEvent(eventSequenceNumber);
        DataAttributes eventData = event.getData();
        AbstractContextAwareRepoEvent.assertNotNull((Object)eventData);
        return (D)eventData;
    }

    protected <D extends DataAttributes<? extends Resource>> D getEventDataWithoutWait(int eventSequenceNumber) {
        RepoEvent<D> event = this.getRepoEventWithoutWait(eventSequenceNumber);
        DataAttributes eventData = event.getData();
        AbstractContextAwareRepoEvent.assertNotNull((Object)eventData);
        return (D)eventData;
    }

    protected <D extends DataAttributes<? extends Resource>> D getEventData(RepoEvent<D> repoEvent) {
        AbstractContextAwareRepoEvent.assertNotNull(repoEvent);
        DataAttributes eventData = repoEvent.getData();
        AbstractContextAwareRepoEvent.assertNotNull((Object)eventData);
        return (D)eventData;
    }

    protected NodeResource getNodeResource(int eventSequenceNumber) {
        Object eventData = this.getEventData(eventSequenceNumber);
        NodeResource resource = (NodeResource)eventData.getResource();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource);
        return resource;
    }

    protected NodeResource getNodeResourceWithoutWait(int eventSequenceNumber) {
        Object eventData = this.getEventDataWithoutWait(eventSequenceNumber);
        NodeResource resource = (NodeResource)eventData.getResource();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource);
        return resource;
    }

    protected <D extends DataAttributes<NodeResource>> NodeResource getNodeResource(RepoEvent<D> repoEvent) {
        AbstractContextAwareRepoEvent.assertNotNull(repoEvent);
        D eventData = this.getEventData(repoEvent);
        AbstractContextAwareRepoEvent.assertNotNull(eventData);
        NodeResource resource = (NodeResource)eventData.getResource();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource);
        return resource;
    }

    protected <D extends DataAttributes<ChildAssociationResource>> ChildAssociationResource getChildAssocResource(RepoEvent<D> repoEvent) {
        AbstractContextAwareRepoEvent.assertNotNull(repoEvent);
        DataAttributes eventData = repoEvent.getData();
        AbstractContextAwareRepoEvent.assertNotNull((Object)eventData);
        ChildAssociationResource resource = (ChildAssociationResource)eventData.getResource();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource);
        return resource;
    }

    protected <D extends DataAttributes<PeerAssociationResource>> PeerAssociationResource getPeerAssocResource(RepoEvent<D> repoEvent) {
        AbstractContextAwareRepoEvent.assertNotNull(repoEvent);
        DataAttributes eventData = repoEvent.getData();
        AbstractContextAwareRepoEvent.assertNotNull((Object)eventData);
        PeerAssociationResource resource = (PeerAssociationResource)eventData.getResource();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource);
        return resource;
    }

    protected NodeResource getNodeResourceBefore(int eventSequenceNumber) {
        Object eventData = this.getEventData(eventSequenceNumber);
        NodeResource resourceBefore = (NodeResource)eventData.getResourceBefore();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resourceBefore);
        return resourceBefore;
    }

    protected <D extends DataAttributes<NodeResource>> NodeResource getNodeResourceBefore(RepoEvent<D> repoEvent) {
        AbstractContextAwareRepoEvent.assertNotNull(repoEvent);
        DataAttributes eventData = repoEvent.getData();
        AbstractContextAwareRepoEvent.assertNotNull((Object)eventData);
        NodeResource resourceBefore = (NodeResource)eventData.getResourceBefore();
        AbstractContextAwareRepoEvent.assertNotNull((Object)resourceBefore);
        return resourceBefore;
    }

    protected <T> T getProperty(NodeResource resource, String propertyName) {
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource);
        AbstractContextAwareRepoEvent.assertNotNull((Object)resource.getProperties());
        return (T)resource.getProperties().get(propertyName);
    }

    protected void waitUntilNumOfEvents(int eventSequenceNumber) {
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> EVENT_CONTAINER.getEvents().size() >= eventSequenceNumber);
        }
        catch (Exception exception) {
            AbstractContextAwareRepoEvent.fail((String)("Requested event #" + eventSequenceNumber + " but, after waiting 10s, total events in the container are: " + EVENT_CONTAINER.getEvents().size()));
        }
    }

    protected void checkNumOfEvents(int expected) {
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> EVENT_CONTAINER.getEvents().size() == expected);
        }
        catch (Exception exception) {
            AbstractContextAwareRepoEvent.assertEquals((String)"Wrong number of events ", (int)expected, (int)EVENT_CONTAINER.getEvents().size());
        }
    }

    private void configRoute() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(BROKER_URL);
        CAMEL_CONTEXT.addComponent("jms", (Component)JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory));
        CAMEL_CONTEXT.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(AbstractContextAwareRepoEvent.CAMEL_ROUTE).id("RepoEvent2Test")).unmarshal(dataFormat)).process((Processor)EVENT_CONTAINER);
            }
        });
        CAMEL_CONTEXT.start();
    }

    public <D extends DataAttributes<? extends Resource>> List<RepoEvent<D>> getFilteredEvents(EventType eventType) {
        ArrayList<RepoEvent<D>> assocChildCreatedEvents = new ArrayList<RepoEvent<D>>();
        for (RepoEvent<?> event : EVENT_CONTAINER.getEvents()) {
            if (!event.getType().equals(eventType.getType())) continue;
            assocChildCreatedEvents.add(event);
        }
        return assocChildCreatedEvents;
    }

    public <D extends DataAttributes<? extends Resource>> RepoEvent<D> getFilteredEvent(EventType eventType, int index) {
        ArrayList events = new ArrayList();
        for (RepoEvent<?> event : EVENT_CONTAINER.getEvents()) {
            if (!event.getType().equals(eventType.getType())) continue;
            events.add(event);
        }
        AbstractContextAwareRepoEvent.assertTrue((events.size() > index ? 1 : 0) != 0);
        return (RepoEvent)events.get(index);
    }

    public static class RepoEventContainer
    implements Processor {
        private final List<RepoEvent<?>> events = Collections.synchronizedList(new ArrayList());

        public void process(Exchange exchange) {
            Object object = exchange.getIn().getBody();
            this.events.add((RepoEvent)object);
        }

        public List<RepoEvent<?>> getEvents() {
            return this.events;
        }

        public RepoEvent<?> getEvent(int eventSequenceNumber) {
            int index = eventSequenceNumber - 1;
            if (index < this.events.size()) {
                return this.events.get(index);
            }
            return null;
        }

        public void reset() {
            this.events.clear();
        }

        public boolean isEmpty() {
            return this.events.isEmpty();
        }
    }
}

