/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.LockServiceImpl;
import org.alfresco.repo.lock.LockServicePolicies;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.SearcherComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TestWithUserUtils;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class LockServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private LockService lockService;
    private MutableAuthenticationService authenticationService;
    private CheckOutCheckInService cociService;
    private PermissionService permissionService;
    private LockService securedLockService;
    private NodeRef parentNode;
    private NodeRef childNode1;
    private NodeRef childNode2;
    private NodeRef noAspectNode;
    private NodeRef checkedOutNode;
    private static final String GOOD_USER_NAME = "goodUser";
    private static final String BAD_USER_NAME = "badUser";
    private static final String PWD = "password";
    NodeRef rootNodeRef;
    private StoreRef storeRef;
    private PolicyComponent policyComponent;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.securedLockService = (LockService)this.applicationContext.getBean("LockService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        AuthenticationComponent authComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authComponent.setSystemUserAsCurrentUser();
        HashMap<QName, String> nodeProperties = new HashMap<QName, String>();
        nodeProperties.put(QName.createQName((String)"{test}property1"), "value1");
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.parentNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}ParentNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.parentNode, ContentModel.ASPECT_LOCKABLE, new HashMap());
        HashMap<QName, String> audProps = new HashMap<QName, String>();
        audProps.put(ContentModel.PROP_CREATOR, "Monkey");
        this.nodeService.addAspect(this.parentNode, ContentModel.ASPECT_AUDITABLE, audProps);
        LockServiceImplTest.assertNotNull((Object)this.parentNode);
        this.childNode1 = this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}ChildNode1"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.childNode1, ContentModel.ASPECT_LOCKABLE, new HashMap());
        LockServiceImplTest.assertNotNull((Object)this.childNode1);
        this.childNode2 = this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}ChildNode2"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.childNode2, ContentModel.ASPECT_LOCKABLE, new HashMap());
        LockServiceImplTest.assertNotNull((Object)this.childNode2);
        this.noAspectNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}noAspectNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        LockServiceImplTest.assertNotNull((Object)this.noAspectNode);
        this.checkedOutNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}checkedOutNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        LockServiceImplTest.assertNotNull((Object)this.checkedOutNode);
        NodeRef fileWorkingCopyNodeRef = this.cociService.checkout(this.checkedOutNode);
        LockServiceImplTest.assertNotNull((Object)fileWorkingCopyNodeRef);
        LockServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.checkedOutNode, ContentModel.ASPECT_CHECKED_OUT));
        LockServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.checkedOutNode, ContentModel.ASPECT_LOCKABLE));
        TestWithUserUtils.createUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.createUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        this.permissionService.setPermission(this.rootNodeRef, GOOD_USER_NAME, "All", true);
        this.permissionService.setPermission(this.rootNodeRef, BAD_USER_NAME, "CheckOut", true);
        this.permissionService.setPermission(this.rootNodeRef, BAD_USER_NAME, "Write", true);
        this.permissionService.setPermission(this.rootNodeRef, BAD_USER_NAME, "Read", true);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
    }

    @Test
    public void testLockServicePolicies() {
        LockServicePoliciesImpl mockedLockServicePoliciesImpl = (LockServicePoliciesImpl)Mockito.mock(LockServicePoliciesImpl.class);
        BehaviourDefinition lockDef = this.policyComponent.bindClassBehaviour(LockServicePolicies.BeforeLock.QNAME, ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour((Object)mockedLockServicePoliciesImpl, "beforeLock"));
        BehaviourDefinition unlockDef = this.policyComponent.bindClassBehaviour(LockServicePolicies.BeforeUnlock.QNAME, ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour((Object)mockedLockServicePoliciesImpl, "beforeUnlock"));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        ((LockServicePoliciesImpl)Mockito.verify((Object)mockedLockServicePoliciesImpl, (VerificationMode)Mockito.times((int)1))).beforeLock(this.parentNode, LockType.WRITE_LOCK);
        this.lockService.unlock(this.parentNode);
        ((LockServicePoliciesImpl)Mockito.verify((Object)mockedLockServicePoliciesImpl, (VerificationMode)Mockito.times((int)1))).beforeUnlock(this.parentNode);
        this.policyComponent.removeClassDefinition(lockDef);
        this.policyComponent.removeClassDefinition(unlockDef);
    }

    public void testLock() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockState lockState = this.lockService.getLockState(this.parentNode);
        LockServiceImplTest.assertEquals((Object)this.parentNode, (Object)lockState.getNodeRef());
        LockServiceImplTest.assertEquals((Object)LockType.WRITE_LOCK, (Object)lockState.getLockType());
        LockServiceImplTest.assertEquals((String)GOOD_USER_NAME, (String)lockState.getOwner());
        LockServiceImplTest.assertEquals((Object)Lifetime.PERSISTENT, (Object)lockState.getLifetime());
        LockServiceImplTest.assertEquals(null, (Object)lockState.getExpires());
        LockServiceImplTest.assertEquals(null, (String)lockState.getAdditionalInfo());
        Map props = this.nodeService.getProperties(this.parentNode);
        LockServiceImplTest.assertEquals((Object)GOOD_USER_NAME, props.get(ContentModel.PROP_LOCK_OWNER));
        LockServiceImplTest.assertEquals((Object)LockType.WRITE_LOCK.toString(), props.get(ContentModel.PROP_LOCK_TYPE));
        LockServiceImplTest.assertEquals((Object)Lifetime.PERSISTENT.toString(), props.get(ContentModel.PROP_LOCK_LIFETIME));
        LockServiceImplTest.assertEquals(null, props.get(ContentModel.PROP_EXPIRY_DATE));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        try {
            this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
            LockServiceImplTest.fail((String)"The user should not be able to lock the node since it is already locked by another user.");
        }
        catch (UnableToAquireLockException exception) {
            System.out.println(exception.getMessage());
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        }
        catch (Exception exception) {
            LockServiceImplTest.fail((String)"No error should be thrown when a node is re-locked by the current lock owner.");
        }
        this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
    }

    public void testPersistentLockMayStoreAdditionalInfo() {
        this.lockService.lock(this.noAspectNode, LockType.NODE_LOCK, 0, Lifetime.PERSISTENT, "additional info");
        LockState lockState = this.lockService.getLockState(this.noAspectNode);
        LockServiceImplTest.assertEquals((String)"additional info", (String)lockState.getAdditionalInfo());
    }

    public void testEphemeralLock() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.noAspectNode, ContentModel.ASPECT_LOCKABLE));
        this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 86400, Lifetime.EPHEMERAL, "some extra data");
        LockServiceImplTest.assertEquals((String)"some extra data", (String)this.lockService.getAdditionalInfo(this.noAspectNode));
        LockState lockState = this.lockService.getLockState(this.noAspectNode);
        LockServiceImplTest.assertEquals((Object)this.noAspectNode, (Object)lockState.getNodeRef());
        LockServiceImplTest.assertEquals((Object)LockType.WRITE_LOCK, (Object)lockState.getLockType());
        LockServiceImplTest.assertEquals((String)GOOD_USER_NAME, (String)lockState.getOwner());
        LockServiceImplTest.assertEquals((Object)Lifetime.EPHEMERAL, (Object)lockState.getLifetime());
        LockServiceImplTest.assertNotNull((Object)lockState.getExpires());
        LockServiceImplTest.assertEquals((String)"some extra data", (String)lockState.getAdditionalInfo());
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.noAspectNode, ContentModel.ASPECT_LOCKABLE));
        NodeService fullNodeService = (NodeService)this.applicationContext.getBean("nodeService");
        LockServiceImplTest.assertEquals((boolean)true, (boolean)fullNodeService.hasAspect(this.noAspectNode, ContentModel.ASPECT_LOCKABLE));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
        try {
            this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK);
            LockServiceImplTest.fail((String)"The user should not be able to lock the node since it is already locked by another user.");
        }
        catch (UnableToAquireLockException exception) {
            System.out.println(exception.getMessage());
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
        try {
            this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 0, Lifetime.EPHEMERAL);
        }
        catch (Exception exception) {
            LockServiceImplTest.fail((String)"No error should be thrown when a node is re-locked by the current lock owner.");
        }
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
        LockStore lockStore = (LockStore)this.applicationContext.getBean("lockStore");
        lockStore.clear();
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
        try {
            this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 0, Lifetime.EPHEMERAL);
        }
        catch (Exception exception) {
            LockServiceImplTest.fail((String)"No error should be thrown when a node is re-locked by the current lock owner.");
        }
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
        this.lockService.unlock(this.noAspectNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
    }

    @Test
    @Category(value={RedundantTests.class})
    public void testEphemeralLockIndexing() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        IndexerAndSearcher indexerAndSearcher = (IndexerAndSearcher)this.applicationContext.getBean("indexerAndSearcherFactory");
        SearcherComponent searcher = new SearcherComponent();
        searcher.setIndexerAndSearcherFactory(indexerAndSearcher);
        this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 86400, Lifetime.EPHEMERAL);
        String query = String.format("+@cm\\:lockOwner:\"%s\" +@cm\\:lockType:\"WRITE_LOCK\"", GOOD_USER_NAME);
        ResultSet rs = searcher.query(this.storeRef, "lucene", query);
        LockServiceImplTest.assertTrue((boolean)rs.getNodeRefs().contains(this.noAspectNode));
        this.lockService.unlock(this.noAspectNode);
        rs = searcher.query(this.storeRef, "lucene", query);
        LockServiceImplTest.assertFalse((boolean)rs.getNodeRefs().contains(this.noAspectNode));
    }

    @Test
    public void testEphemeralLockModifyNode() {
        HashMap<QName, String> props;
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.noAspectNode, ContentModel.ASPECT_LOCKABLE));
        this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 86400, Lifetime.EPHEMERAL, "some extra data");
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.noAspectNode));
        NodeService fullNodeService = (NodeService)this.applicationContext.getBean("nodeService");
        try {
            props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_DESCRIPTION, "descr" + System.currentTimeMillis());
            props.put(ContentModel.PROP_TITLE, "title" + System.currentTimeMillis());
            fullNodeService.addProperties(this.noAspectNode, props);
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        try {
            fullNodeService.setProperty(this.noAspectNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)("descr" + System.currentTimeMillis())));
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        try {
            props = new HashMap();
            props.put(ContentModel.PROP_DESCRIPTION, "descr" + System.currentTimeMillis());
            props.put(ContentModel.PROP_TITLE, "title" + System.currentTimeMillis());
            fullNodeService.setProperties(this.noAspectNode, props);
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        try {
            fullNodeService.removeProperty(this.noAspectNode, ContentModel.PROP_DESCRIPTION);
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        try {
            fullNodeService.addAspect(this.noAspectNode, ContentModel.ASPECT_AUTHOR, null);
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        try {
            fullNodeService.removeAspect(this.noAspectNode, ContentModel.ASPECT_AUTHOR);
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        try {
            fullNodeService.setType(this.noAspectNode, ContentModel.TYPE_CMOBJECT);
            LockServiceImplTest.fail();
        }
        catch (NodeLockedException nodeLockedException) {}
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.unlock(this.noAspectNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
    }

    public void testExpiredEphemeralLockAndPersitentLock() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.securedLockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.securedLockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.noAspectNode, ContentModel.ASPECT_LOCKABLE));
        this.securedLockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 1, Lifetime.EPHEMERAL);
        LockState lockState = this.securedLockService.getLockState(this.noAspectNode);
        LockServiceImplTest.assertEquals((Object)this.noAspectNode, (Object)lockState.getNodeRef());
        LockServiceImplTest.assertEquals((Object)LockType.WRITE_LOCK, (Object)lockState.getLockType());
        LockServiceImplTest.assertEquals((String)GOOD_USER_NAME, (String)lockState.getOwner());
        LockServiceImplTest.assertEquals((Object)Lifetime.EPHEMERAL, (Object)lockState.getLifetime());
        LockServiceImplTest.assertNotNull((Object)lockState.getExpires());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        LockServiceImplTest.assertFalse((boolean)this.securedLockService.isLocked(this.noAspectNode));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.securedLockService.lock(this.noAspectNode, LockType.READ_ONLY_LOCK, 1000, Lifetime.PERSISTENT);
        LockServiceImplTest.assertTrue((boolean)this.securedLockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.noAspectNode, ContentModel.ASPECT_LOCKABLE));
        LockServiceImplTest.assertEquals((Object)LockType.READ_ONLY_LOCK, (Object)this.securedLockService.getLockType(this.noAspectNode));
        lockState = this.securedLockService.getLockState(this.noAspectNode);
        LockServiceImplTest.assertEquals((Object)this.noAspectNode, (Object)lockState.getNodeRef());
        LockServiceImplTest.assertEquals((Object)LockType.READ_ONLY_LOCK, (Object)lockState.getLockType());
        LockServiceImplTest.assertEquals((String)BAD_USER_NAME, (String)lockState.getOwner());
        LockServiceImplTest.assertEquals((Object)Lifetime.PERSISTENT, (Object)lockState.getLifetime());
        this.securedLockService.unlock(this.noAspectNode);
        LockServiceImplTest.assertFalse((boolean)this.securedLockService.isLocked(this.noAspectNode));
    }

    public void testLockRevertedOnRollback() throws NotSupportedException, SystemException {
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.rootNodeRef));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.rootNodeRef));
        this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK, 0, Lifetime.EPHEMERAL);
        this.lockService.lock(this.rootNodeRef, LockType.NODE_LOCK, 0, Lifetime.EPHEMERAL);
        this.lockService.lock(this.rootNodeRef, LockType.NODE_LOCK, 3600, Lifetime.EPHEMERAL);
        TestTransaction.end();
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.noAspectNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.rootNodeRef));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.rootNodeRef));
    }

    public void testLockChildren() {
    }

    public void testLockMany() {
    }

    public void testUnlock() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.testLock();
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.unlock(this.parentNode);
        }
        catch (UnableToReleaseLockException exception) {
            System.out.println(exception.getMessage());
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.unlock(this.parentNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.unlock(this.parentNode);
        }
        catch (Exception exception) {
            LockServiceImplTest.fail((String)"Unlocking an unlocked node should not result in an exception being raised.");
        }
        this.lockService.unlock(this.noAspectNode);
    }

    public void testUnlockChildren() {
    }

    public void testUnlockMany() {
    }

    public void testGetLockStatus() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockStatus lockStatus1 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)lockStatus1);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockStatus lockStatus2 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCKED, (Object)lockStatus2);
        LockStore lockStore = (LockStore)this.applicationContext.getBean("lockStore");
        lockStore.clear();
        LockState lockState = lockStore.get(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockState);
        this.lockService.getLockStatus(this.parentNode);
        lockState = lockStore.get(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockState);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockStatus lockStatus3 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)lockStatus3);
        this.lockService.getLockStatus(this.noAspectNode);
        LockStatus lockStatus4 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)lockStatus4);
    }

    @Category(value={RedundantTests.class})
    public void testGetLocks() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImpl lockService = (LockServiceImpl)this.lockService;
        List locked1 = lockService.getLocks(this.storeRef);
        LockServiceImplTest.assertNotNull((Object)locked1);
        LockServiceImplTest.assertEquals((int)0, (int)locked1.size());
        LockServiceImplTest.assertFalse((boolean)lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        LockServiceImplTest.assertTrue((boolean)lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)lockService.isLockedAndReadOnly(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)lockService.isLocked(this.childNode1));
        LockServiceImplTest.assertFalse((boolean)lockService.isLockedAndReadOnly(this.childNode1));
        this.lockService.lock(this.childNode1, LockType.WRITE_LOCK);
        LockServiceImplTest.assertTrue((boolean)lockService.isLocked(this.childNode1));
        LockServiceImplTest.assertFalse((boolean)lockService.isLockedAndReadOnly(this.childNode1));
        LockServiceImplTest.assertFalse((boolean)lockService.isLocked(this.childNode2));
        LockServiceImplTest.assertFalse((boolean)lockService.isLockedAndReadOnly(this.childNode2));
        this.lockService.lock(this.childNode2, LockType.READ_ONLY_LOCK);
        LockServiceImplTest.assertTrue((boolean)lockService.isLocked(this.childNode2));
        LockServiceImplTest.assertTrue((boolean)lockService.isLockedAndReadOnly(this.childNode2));
        List locked2 = lockService.getLocks(this.storeRef);
        LockServiceImplTest.assertNotNull((Object)locked2);
        LockServiceImplTest.assertEquals((int)3, (int)locked2.size());
        List locked3 = lockService.getLocks(this.storeRef, LockType.WRITE_LOCK);
        LockServiceImplTest.assertNotNull((Object)locked3);
        LockServiceImplTest.assertEquals((int)2, (int)locked3.size());
        List locked4 = lockService.getLocks(this.storeRef, LockType.READ_ONLY_LOCK);
        LockServiceImplTest.assertNotNull((Object)locked4);
        LockServiceImplTest.assertEquals((int)1, (int)locked4.size());
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        List locked5 = lockService.getLocks(this.storeRef);
        LockServiceImplTest.assertNotNull((Object)locked5);
        LockServiceImplTest.assertEquals((int)0, (int)locked5.size());
    }

    public void testGetLockType() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockType lockType1 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockType1);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        LockType lockType2 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)lockType2);
        LockServiceImplTest.assertEquals((Object)LockType.WRITE_LOCK, (Object)lockType2);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.unlock(this.parentNode);
        LockType lockType3 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockType3);
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.READ_ONLY_LOCK);
        LockType lockType4 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)lockType4);
        LockServiceImplTest.assertEquals((Object)LockType.READ_ONLY_LOCK, (Object)lockType4);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.NODE_LOCK);
        LockType lockType5 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)lockType5);
        LockServiceImplTest.assertEquals((Object)LockType.NODE_LOCK, (Object)lockType5);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.unlock(this.parentNode);
        LockType lockType6 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockType6);
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        LockType lockType7 = this.lockService.getLockType(this.noAspectNode);
        LockServiceImplTest.assertTrue((String)"lock type is not null", (lockType7 == null ? 1 : 0) != 0);
    }

    public void testGetLockTypeEphemeral() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockType lockType1 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockType1);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 0, Lifetime.EPHEMERAL);
        LockType lockType2 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)lockType2);
        LockServiceImplTest.assertEquals((Object)LockType.WRITE_LOCK, (Object)lockType2);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.unlock(this.parentNode);
        LockType lockType3 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockType3);
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.READ_ONLY_LOCK, 0, Lifetime.EPHEMERAL);
        LockType lockType4 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)lockType4);
        LockServiceImplTest.assertEquals((Object)LockType.READ_ONLY_LOCK, (Object)lockType4);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.NODE_LOCK, 0, Lifetime.EPHEMERAL);
        LockType lockType5 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)lockType5);
        LockServiceImplTest.assertEquals((Object)LockType.NODE_LOCK, (Object)lockType5);
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        this.lockService.unlock(this.parentNode);
        LockType lockType6 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)lockType6);
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.parentNode));
        LockType lockType7 = this.lockService.getLockType(this.noAspectNode);
        LockServiceImplTest.assertTrue((String)"lock type is not null", (lockType7 == null ? 1 : 0) != 0);
    }

    public void testTimeToExpire() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 1);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_EXPIRED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_EXPIRED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 0);
        try {
            TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
            this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 1);
            LockServiceImplTest.fail((String)"Can not update lock info if not lock owner");
        }
        catch (UnableToAquireLockException unableToAquireLockException) {}
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 1);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.parentNode));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_EXPIRED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        LockServiceImplTest.assertEquals((Object)LockStatus.LOCK_EXPIRED, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
    }

    public void testEphemeralExpiryThreshold() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        int origThresh = ((LockServiceImpl)this.lockService).getEphemeralExpiryThreshold();
        LockServiceImplTest.assertEquals((int)172800, (int)origThresh);
        try {
            this.lockService.setEphemeralExpiryThreshold(300);
            this.checkLifetimeForExpiry(Lifetime.EPHEMERAL, 0, Lifetime.EPHEMERAL);
            this.checkLifetimeForExpiry(Lifetime.EPHEMERAL, 150, Lifetime.EPHEMERAL);
            this.checkLifetimeForExpiry(Lifetime.EPHEMERAL, 300, Lifetime.EPHEMERAL);
            this.checkLifetimeForExpiry(Lifetime.PERSISTENT, 301, Lifetime.EPHEMERAL);
            this.lockService.setEphemeralExpiryThreshold(-1);
            this.checkLifetimeForExpiry(Lifetime.PERSISTENT, 0, Lifetime.EPHEMERAL);
            this.checkLifetimeForExpiry(Lifetime.PERSISTENT, 150, Lifetime.EPHEMERAL);
            this.checkLifetimeForExpiry(Lifetime.PERSISTENT, 300, Lifetime.EPHEMERAL);
            this.checkLifetimeForExpiry(Lifetime.PERSISTENT, 301, Lifetime.EPHEMERAL);
        }
        finally {
            this.lockService.setEphemeralExpiryThreshold(origThresh);
        }
    }

    private void checkLifetimeForExpiry(Lifetime expectedLifetime, int expirySecs, Lifetime requestedLifetime) {
        this.lockService.unlock(this.parentNode);
        Assert.assertNotEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, expirySecs, requestedLifetime);
        LockState lock = this.lockService.getLockState(this.parentNode);
        LockServiceImplTest.assertEquals((Object)expectedLifetime, (Object)lock.getLifetime());
        this.lockService.unlock(this.parentNode);
        Assert.assertNotEquals((Object)LockStatus.LOCKED, (Object)this.lockService.getLockStatus(this.parentNode));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, expirySecs, Lifetime.PERSISTENT);
        lock = this.lockService.getLockState(this.parentNode);
        LockServiceImplTest.assertEquals((Object)Lifetime.PERSISTENT, (Object)lock.getLifetime());
    }

    public void testCreateChildrenOfLockedNodes() throws Exception {
        LockServiceImplTest.assertEquals((Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(this.parentNode));
        LockServiceImplTest.assertFalse((boolean)this.lockService.isLocked(this.parentNode));
        this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildA"), ContentModel.TYPE_FOLDER);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildB"), ContentModel.TYPE_FOLDER);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildB"), ContentModel.TYPE_FOLDER);
            LockServiceImplTest.fail((String)"could create a child with a read only lock");
        }
        catch (NodeLockedException e) {
            this.logger.debug((Object)"exception while trying to create a child of a read only lock", (Throwable)e);
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.NODE_LOCK);
        this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildD"), ContentModel.TYPE_FOLDER);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildC"), ContentModel.TYPE_FOLDER);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.READ_ONLY_LOCK);
        try {
            this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildD"), ContentModel.TYPE_FOLDER);
            LockServiceImplTest.fail((String)"could create a child with a read only lock");
        }
        catch (NodeLockedException e) {
            this.logger.debug((Object)"exception while trying to create a child of a read only lock", (Throwable)e);
        }
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"ChildE"), ContentModel.TYPE_FOLDER);
            LockServiceImplTest.fail((String)"could create a child with a read only lock");
        }
        catch (NodeLockedException e) {
            this.logger.debug((Object)"exception while trying to create a child of a read only lock", (Throwable)e);
        }
    }

    public void testUnlockCheckedOut() throws Exception {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.unlock(this.checkedOutNode);
            LockServiceImplTest.fail((String)"could unlock a checked out node");
        }
        catch (UnableToReleaseLockException e) {
            this.logger.debug((Object)"exception while trying to unlock a checked out node", (Throwable)e);
        }
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLocked(this.checkedOutNode));
        LockServiceImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.checkedOutNode));
    }

    public void testUnlockNodeWithAdminUserAndAllPermissionsUser() {
        Lifetime[] lifetimeArray = new Lifetime[]{Lifetime.EPHEMERAL, Lifetime.PERSISTENT};
        int n = lifetimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lifetime lt = lifetimeArray[n2];
            TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
            NodeRef testNode = this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{}testNode"), ContentModel.TYPE_CONTAINER).getChildRef();
            this.securedLockService.lock(testNode, LockType.WRITE_LOCK, 172800, lt, null);
            LockServiceImplTest.assertNotNull((Object)this.securedLockService.getLockState(testNode));
            LockServiceImplTest.assertNotNull((Object)this.securedLockService.getLockStatus(testNode));
            LockServiceImplTest.assertTrue((boolean)this.securedLockService.isLocked(testNode));
            LockServiceImplTest.assertFalse((boolean)this.securedLockService.isLockedAndReadOnly(testNode));
            TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
            LockServiceImplTest.assertNotNull((Object)this.securedLockService.getLockState(testNode));
            LockServiceImplTest.assertNotNull((Object)this.securedLockService.getLockStatus(testNode));
            LockServiceImplTest.assertTrue((boolean)this.securedLockService.isLocked(testNode));
            LockServiceImplTest.assertTrue((boolean)this.securedLockService.isLockedAndReadOnly(testNode));
            try {
                this.securedLockService.unlock(testNode);
                LockServiceImplTest.fail((String)("BAD user shouldn't be able to unlock " + lt + " lock"));
            }
            catch (AccessDeniedException accessDeniedException) {}
            TestWithUserUtils.authenticateUser(AuthenticationUtil.getAdminUserName(), "admin", this.rootNodeRef, (AuthenticationService)this.authenticationService);
            LockServiceImplTest.assertNotNull((Object)this.securedLockService.getLockState(testNode));
            LockServiceImplTest.assertNotNull((Object)this.securedLockService.getLockStatus(testNode));
            LockServiceImplTest.assertTrue((boolean)this.securedLockService.isLocked(testNode));
            LockServiceImplTest.assertTrue((boolean)this.securedLockService.isLockedAndReadOnly(testNode));
            this.securedLockService.unlock(testNode);
            TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
            this.securedLockService.lock(testNode, LockType.WRITE_LOCK, 172800, lt, null);
            this.securedLockService.unlock(testNode);
            this.securedLockService.lock(testNode, LockType.WRITE_LOCK, 172800, lt, null);
            TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
            this.securedLockService.unlock(testNode);
            this.nodeService.deleteNode(testNode);
            ++n2;
        }
    }

    private class LockServicePoliciesImpl
    implements LockServicePolicies.BeforeLock,
    LockServicePolicies.BeforeUnlock {
        private LockServicePoliciesImpl() {
        }

        public void beforeLock(NodeRef nodeRef, LockType lockType) {
            if (LockServiceImplTest.this.logger.isDebugEnabled()) {
                LockServiceImplTest.this.logger.debug((Object)("Invoked beforeLock() for nodeRef: " + nodeRef + lockType != null ? " and lockType: " + lockType : ""));
            }
        }

        public void beforeUnlock(NodeRef nodeRef) {
            if (LockServiceImplTest.this.logger.isDebugEnabled()) {
                LockServiceImplTest.this.logger.debug((Object)("Invoked beforeUnlock() for nodeRef: " + nodeRef));
            }
        }
    }
}

