/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.alfresco.repo.module.ModuleVersionNumber;

public class ModuleVersionNumberTest
extends TestCase {
    public void testCreate() {
        ModuleVersionNumber version0 = ModuleVersionNumber.VERSION_ZERO;
        ModuleVersionNumberTest.assertNotNull((Object)version0);
        ModuleVersionNumber versionBig = ModuleVersionNumber.VERSION_BIG;
        ModuleVersionNumberTest.assertNotNull((Object)versionBig);
        ModuleVersionNumber version1 = new ModuleVersionNumber("1");
        ModuleVersionNumberTest.assertNotNull((Object)version1);
        ModuleVersionNumber version2 = new ModuleVersionNumber("1.2");
        ModuleVersionNumberTest.assertNotNull((Object)version2);
        ModuleVersionNumber version3 = new ModuleVersionNumber("1.2.3");
        ModuleVersionNumberTest.assertNotNull((Object)version3);
        ModuleVersionNumber versiona = new ModuleVersionNumber("1.2.3a");
        ModuleVersionNumberTest.assertNotNull((Object)versiona);
        ModuleVersionNumber versionSnap = new ModuleVersionNumber("1.2.3-SNAPSHOT");
        ModuleVersionNumberTest.assertNotNull((Object)versionSnap);
        ModuleVersionNumber versionFinal = new ModuleVersionNumber("1.2.3-final");
        ModuleVersionNumberTest.assertNotNull((Object)versionFinal);
        ModuleVersionNumber versionMixed = new ModuleVersionNumber("0.1-incubating-unreleased");
        ModuleVersionNumberTest.assertNotNull((Object)versionMixed);
        versionMixed = new ModuleVersionNumber("3.2.6-alfresco-patched");
        ModuleVersionNumberTest.assertNotNull((Object)versionMixed);
        versionMixed = new ModuleVersionNumber("0.2-20120518");
        ModuleVersionNumberTest.assertNotNull((Object)versionMixed);
        ModuleVersionNumber version1s = new ModuleVersionNumber("4.2.0-SNAPSHOT");
        ModuleVersionNumberTest.assertNotNull((Object)version1s);
        ModuleVersionNumber version4c = new ModuleVersionNumber("4.2.0-C");
        ModuleVersionNumberTest.assertNotNull((Object)version4c);
        ModuleVersionNumber version16 = new ModuleVersionNumber("4.0.1.16");
        ModuleVersionNumberTest.assertNotNull((Object)version16);
        ModuleVersionNumber versionn1 = new ModuleVersionNumber("4.0.16.1.7");
        ModuleVersionNumberTest.assertNotNull((Object)versionn1);
        ModuleVersionNumber versionn2 = new ModuleVersionNumber("4.0.1.2.8.9");
        ModuleVersionNumberTest.assertNotNull((Object)versionn2);
        ModuleVersionNumber versionc = new ModuleVersionNumber("4.2.c");
        ModuleVersionNumberTest.assertNotNull((Object)versionc);
        ModuleVersionNumber versionb = new ModuleVersionNumber("1.0.b");
        ModuleVersionNumberTest.assertNotNull((Object)versionb);
        ModuleVersionNumber versionsnap = new ModuleVersionNumber("1.0-SNAPSHOT");
        ModuleVersionNumberTest.assertNotNull((Object)versionsnap);
    }

    public void testEquals() {
        ModuleVersionNumber version0 = new ModuleVersionNumber("1");
        ModuleVersionNumber version1 = new ModuleVersionNumber("1.2");
        ModuleVersionNumber version2 = new ModuleVersionNumber("1.2");
        ModuleVersionNumber version3 = new ModuleVersionNumber("1.2.3");
        ModuleVersionNumber version4 = new ModuleVersionNumber("1.2.3");
        ModuleVersionNumber version5 = new ModuleVersionNumber("1.3.3");
        ModuleVersionNumber version6 = new ModuleVersionNumber("1.0");
        ModuleVersionNumber versiona = new ModuleVersionNumber("1.0.a");
        ModuleVersionNumber versionb = new ModuleVersionNumber("1.0.b");
        ModuleVersionNumber versionsnap = new ModuleVersionNumber("1.0-SNAPSHOT");
        ModuleVersionNumberTest.assertFalse((boolean)version0.equals((Object)version1));
        ModuleVersionNumberTest.assertTrue((boolean)version1.equals((Object)version2));
        ModuleVersionNumberTest.assertFalse((boolean)version2.equals((Object)version3));
        ModuleVersionNumberTest.assertTrue((boolean)version3.equals((Object)version4));
        ModuleVersionNumberTest.assertFalse((boolean)version4.equals((Object)version5));
        ModuleVersionNumberTest.assertTrue((boolean)version0.equals((Object)version6));
        ModuleVersionNumberTest.assertFalse((boolean)versiona.equals((Object)version0));
        ModuleVersionNumberTest.assertFalse((boolean)versiona.equals((Object)versionb));
        ModuleVersionNumberTest.assertFalse((boolean)versionsnap.equals((Object)version6));
        ModuleVersionNumberTest.assertFalse((boolean)versionsnap.equals((Object)versiona));
        ModuleVersionNumberTest.assertFalse((boolean)versionsnap.equals((Object)versionb));
    }

    public void testCompare() {
        ModuleVersionNumber version0 = new ModuleVersionNumber("1");
        ModuleVersionNumber version1 = new ModuleVersionNumber("1.2");
        ModuleVersionNumber version2 = new ModuleVersionNumber("1.2");
        ModuleVersionNumber version3 = new ModuleVersionNumber("1.2.3");
        ModuleVersionNumber version4 = new ModuleVersionNumber("1.11");
        ModuleVersionNumber version5 = new ModuleVersionNumber("1.3.3");
        ModuleVersionNumber version6 = new ModuleVersionNumber("2.0");
        ModuleVersionNumber version7 = new ModuleVersionNumber("2.0.1");
        ModuleVersionNumber version8 = new ModuleVersionNumber("10.0");
        ModuleVersionNumber version9 = new ModuleVersionNumber("10.3");
        ModuleVersionNumber version10 = new ModuleVersionNumber("11.1");
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version0.compareTo(version1));
        ModuleVersionNumberTest.assertEquals((int)1, (int)version1.compareTo(version0));
        ModuleVersionNumberTest.assertEquals((int)0, (int)version1.compareTo(version2));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version2.compareTo(version3));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version2.compareTo(version4));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version3.compareTo(version5));
        ModuleVersionNumberTest.assertEquals((int)1, (int)version6.compareTo(version5));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version6.compareTo(version7));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version1.compareTo(version8));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version8.compareTo(version9));
        ModuleVersionNumberTest.assertEquals((int)-1, (int)version9.compareTo(version10));
        ModuleVersionNumber version1point4 = new ModuleVersionNumber("1.4");
        ModuleVersionNumber version1point4a = new ModuleVersionNumber("1.4.a");
        ModuleVersionNumber version1point4b = new ModuleVersionNumber("1.4.b");
        ModuleVersionNumber version1point4c = new ModuleVersionNumber("1.4.c");
        ModuleVersionNumber version1point4d = new ModuleVersionNumber("1.4.d");
        ModuleVersionNumber version1point4snapshot = new ModuleVersionNumber("1.4-SNAPSHOT");
        ModuleVersionNumber version1point40 = new ModuleVersionNumber("1.4.0");
        ModuleVersionNumberTest.assertEquals((int)1, (int)ModuleVersionNumber.VERSION_BIG.compareTo(version1));
        ModuleVersionNumberTest.assertEquals((int)1, (int)ModuleVersionNumber.VERSION_BIG.compareTo(version0));
        ModuleVersionNumberTest.assertEquals((int)1, (int)ModuleVersionNumber.VERSION_BIG.compareTo(version8));
        ModuleVersionNumberTest.assertEquals((int)1, (int)ModuleVersionNumber.VERSION_BIG.compareTo(version1point4b));
        ModuleVersionNumberTest.assertEquals((int)1, (int)ModuleVersionNumber.VERSION_BIG.compareTo(version1point4snapshot));
        ModuleVersionNumberTest.assertEquals((int)0, (int)version1point4.compareTo(new ModuleVersionNumber("1.4")));
        ModuleVersionNumberTest.assertTrue((version1point4.compareTo(version1point4a) < 1 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4.compareTo(version1point4snapshot) > 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4b.compareTo(version1point4a) > 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4b.compareTo(version1point4snapshot) < 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4c.compareTo(version1point4b) > 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4c.compareTo(version1point4d) < 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4c.compareTo(version1point4snapshot) < 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4d.compareTo(version1point4c) > 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point40.compareTo(version1point4) == 0 ? 1 : 0) != 0);
        ModuleVersionNumberTest.assertTrue((version1point4d.compareTo(version1point4snapshot) < 0 ? 1 : 0) != 0);
        ModuleVersionNumber versionBase = new ModuleVersionNumber("0.1");
        ModuleVersionNumber versionMixed = new ModuleVersionNumber("0.1-incubating-unreleased");
        ModuleVersionNumberTest.assertTrue((versionMixed.compareTo(versionBase) > 0 ? 1 : 0) != 0);
        versionBase = new ModuleVersionNumber("3.2.6");
        versionMixed = new ModuleVersionNumber("3.2.6-alfresco-patched");
        ModuleVersionNumberTest.assertTrue((versionMixed.compareTo(versionBase) > 0 ? 1 : 0) != 0);
        versionBase = new ModuleVersionNumber("0.2");
        versionMixed = new ModuleVersionNumber("0.2-20120518");
        ModuleVersionNumberTest.assertTrue((versionMixed.compareTo(versionBase) > 0 ? 1 : 0) != 0);
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        ModuleVersionNumber version0Before = new ModuleVersionNumber("1");
        ModuleVersionNumber version6Before = new ModuleVersionNumber("1.0");
        ModuleVersionNumber versionaBefore = new ModuleVersionNumber("1.0.a");
        ModuleVersionNumber versionbBefore = new ModuleVersionNumber("1.0.b");
        ModuleVersionNumber versionsnapBefore = new ModuleVersionNumber("1.0-SNAPSHOT");
        ModuleVersionNumber version0 = this.writeAndRead(version0Before);
        ModuleVersionNumber version6 = this.writeAndRead(version6Before);
        ModuleVersionNumber versiona = this.writeAndRead(versionaBefore);
        ModuleVersionNumber versionb = this.writeAndRead(versionbBefore);
        ModuleVersionNumber versionsnap = this.writeAndRead(versionsnapBefore);
        ModuleVersionNumberTest.assertTrue((boolean)version0.equals((Object)version0Before));
        ModuleVersionNumberTest.assertTrue((boolean)version6.equals((Object)version6Before));
        ModuleVersionNumberTest.assertTrue((boolean)versiona.equals((Object)versionaBefore));
        ModuleVersionNumberTest.assertTrue((boolean)versionb.equals((Object)versionbBefore));
        ModuleVersionNumberTest.assertTrue((boolean)versionsnap.equals((Object)versionsnapBefore));
        ModuleVersionNumberTest.assertTrue((boolean)version0.equals((Object)version6));
        ModuleVersionNumberTest.assertFalse((boolean)versiona.equals((Object)version0));
        ModuleVersionNumberTest.assertFalse((boolean)versiona.equals((Object)versionb));
        ModuleVersionNumberTest.assertFalse((boolean)versionsnap.equals((Object)version6));
        ModuleVersionNumberTest.assertFalse((boolean)versionsnap.equals((Object)versiona));
        ModuleVersionNumberTest.assertFalse((boolean)versionsnap.equals((Object)versionb));
    }

    private ModuleVersionNumber writeAndRead(ModuleVersionNumber versionNumber) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(versionNumber);
        oos.flush();
        oos.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        return (ModuleVersionNumber)objectInputStream.readObject();
    }

    public void testGetVersionWithoutSuffix() {
        String[][] stringArrayArray = new String[16][];
        String[] stringArray = new String[2];
        stringArray[1] = "1.2";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"1.2.3", "1.2.3"};
        stringArrayArray[2] = new String[]{"1.2.3.4", "1.2.3.4"};
        String[] stringArray2 = new String[2];
        stringArray2[1] = "1.2.3.4.5";
        stringArrayArray[3] = stringArray2;
        stringArrayArray[4] = new String[]{"1.2.3", "1.2.3-M4"};
        stringArrayArray[5] = new String[]{"1.2.3.4", "1.2.3.4-A56"};
        stringArrayArray[6] = new String[]{"1.2.3", "1.2.3-RC456"};
        stringArrayArray[7] = new String[]{"11.22.33.44", "11.22.33.44-A5"};
        String[] stringArray3 = new String[2];
        stringArray3[1] = "1.2.3-456";
        stringArrayArray[8] = stringArray3;
        String[] stringArray4 = new String[2];
        stringArray4[1] = "1.2.3-X12";
        stringArrayArray[9] = stringArray4;
        String[] stringArray5 = new String[2];
        stringArray5[1] = "1.2.5-A6-A6";
        stringArrayArray[10] = stringArray5;
        String[] stringArray6 = new String[2];
        stringArray6[1] = "1.2.3.4.5-A6";
        stringArrayArray[11] = stringArray6;
        String[] stringArray7 = new String[2];
        stringArray7[1] = "1.2-M3";
        stringArrayArray[12] = stringArray7;
        String[] stringArray8 = new String[2];
        stringArray8[1] = "1.2.3-RCA-45";
        stringArrayArray[13] = stringArray8;
        String[] stringArray9 = new String[2];
        stringArray9[1] = "1.2.3-AM4";
        stringArrayArray[14] = stringArray9;
        String[] stringArray10 = new String[2];
        stringArray10[1] = "1.2.3-A56A";
        stringArrayArray[15] = stringArray10;
        String[][] stringArrayArray2 = stringArrayArray;
        int n = stringArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArrayArray2[n2];
            String expected = pair[0];
            String value = pair[1];
            ModuleVersionNumber version = new ModuleVersionNumber(value);
            String actual = version.getVersionWithoutSuffix();
            ModuleVersionNumberTest.assertEquals((String)expected, (String)actual);
            ++n2;
        }
    }

    public void testInternalVersionsAreUpgrades() {
        String[][] stringArrayArray = new String[][]{{"upgrade", "7.0.0-A10", "7.0.0"}, {"upgrade", "7.0.0", "7.0.0-A11"}, {"upgrade", "7.0.0-A10", "7.0.0-A12"}, {"upgrade", "7.0.0-A13", "7.0.0-M1"}, {"upgrade", "7.0.0-A13", "7.0.0-RC1"}, {"same", "7.0.0", "7.0.0"}, {"same", "7.0.0-A14", "7.0.0-A14"}, {"downgrade", "7.0.0", "6.2.3"}, {"upgrade", "6.2.3", "7.0.0"}, {"upgrade", "7.0.0-A15", "7.0.0-1234"}, {"downgrade", "7.0.0-1234", "7.0.0-M2"}, {"downgrade", "7.0.0-Rubbish1", "7.0.0-M3"}, {"upgrade", "7.0.0-A16", "7.0.0-Rubbish2"}};
        int n = stringArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArrayArray[n2];
            String expected = pair[0];
            String value1 = pair[1];
            String value2 = pair[2];
            ModuleVersionNumber thisVersion = new ModuleVersionNumber(value1);
            ModuleVersionNumber thatVersion = new ModuleVersionNumber(value2);
            int actual = thisVersion.compareTo(thatVersion);
            if ("downgrade".equals(expected)) {
                ModuleVersionNumberTest.assertTrue((String)("Expected " + thisVersion + " to be a downgrade " + thatVersion + " (" + actual + ")"), (actual > 0 ? 1 : 0) != 0);
            } else if ("same".equals(expected)) {
                ModuleVersionNumberTest.assertTrue((String)("Expected " + thisVersion + " to be the same base version as " + thatVersion + " (" + actual + ")"), (actual == 0 ? 1 : 0) != 0);
            } else if ("upgrade".equals(expected)) {
                ModuleVersionNumberTest.assertTrue((String)("Expected " + thisVersion + " to be an upgrade from " + thatVersion + " (" + actual + ")"), (actual < 0 ? 1 : 0) != 0);
            }
            ++n2;
        }
    }
}

