/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.ByteArrayInputStream;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.AbstractSolrQueryHTTPClient;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AbstractSolrQueryHTTPClientTest {
    private static final String URL = "http://this/is/a/url";
    private AbstractSolrQueryHTTPClient abstractSolrQueryHTTPClient = (AbstractSolrQueryHTTPClient)Mockito.spy(AbstractSolrQueryHTTPClient.class);
    @Mock
    private HttpClient httpClient;
    @Mock
    private JSONObject body;
    @Mock
    private PostMethod postMethod;
    @Mock
    private Header header;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        ((AbstractSolrQueryHTTPClient)Mockito.doReturn((Object)this.postMethod).when((Object)this.abstractSolrQueryHTTPClient)).createNewPostMethod(URL);
        Mockito.when((Object)this.postMethod.getResponseCharSet()).thenReturn((Object)"UTF-8");
    }

    @Test
    public void testPostQuery_success() throws Exception {
        Mockito.when((Object)this.body.toString()).thenReturn((Object)"Example body");
        Mockito.when((Object)this.postMethod.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.postMethod.getResponseBodyAsStream()).thenReturn((Object)this.convertStringToInputStream("{}"));
        JSONObject response = this.abstractSolrQueryHTTPClient.postQuery(this.httpClient, URL, this.body);
        Assert.assertEquals((String)"Unexpected JSON response received.", (Object)"{}", (Object)response.toString());
    }

    @Test
    public void testPostQuery_failure() throws Exception {
        String failureMessage = "{\"error\": {\"trace\": \"ExceptionClass: Stacktrace\"}}";
        Mockito.when((Object)this.body.toString()).thenReturn((Object)"Example body");
        Mockito.when((Object)this.postMethod.getStatusCode()).thenReturn((Object)404);
        Mockito.when((Object)this.postMethod.getResponseBodyAsStream()).thenReturn((Object)this.convertStringToInputStream(failureMessage));
        Mockito.when((Object)this.postMethod.getResponseBodyAsString()).thenReturn((Object)failureMessage);
        try {
            this.abstractSolrQueryHTTPClient.postQuery(this.httpClient, URL, this.body);
            Assert.fail((String)"Expected a QueryParserException to be thrown.");
        }
        catch (QueryParserException e) {
            Assert.assertEquals((String)"Unexpected status code in exception.", (long)e.getHttpStatusCode(), (long)404L);
            ((PostMethod)Mockito.verify((Object)this.postMethod)).releaseConnection();
        }
    }

    @Test
    public void testPostQuery_unsupportedOperation() throws Exception {
        String failureMessage = "{\"error\": {\"trace\": \"java.lang.UnsupportedOperationException: Stacktrace\"}}";
        Mockito.when((Object)this.body.toString()).thenReturn((Object)"Example body");
        Mockito.when((Object)this.postMethod.getStatusCode()).thenReturn((Object)500);
        Mockito.when((Object)this.postMethod.getResponseBodyAsStream()).thenReturn((Object)this.convertStringToInputStream(failureMessage));
        Mockito.when((Object)this.postMethod.getResponseBodyAsString()).thenReturn((Object)failureMessage);
        try {
            this.abstractSolrQueryHTTPClient.postQuery(this.httpClient, URL, this.body);
            Assert.fail((String)"Expected a QueryParserException to be thrown.");
        }
        catch (QueryParserException e) {
            Assert.assertEquals((String)"Unexpected status code in exception.", (long)e.getHttpStatusCode(), (long)501L);
        }
    }

    @Test
    public void testPostQuery_moved() throws Exception {
        Mockito.when((Object)this.body.toString()).thenReturn((Object)"Example body");
        Mockito.when((Object)this.postMethod.getStatusCode()).thenReturn((Object)301).thenReturn((Object)200);
        Mockito.when((Object)this.postMethod.getResponseBodyAsStream()).thenReturn((Object)this.convertStringToInputStream("{}"));
        Mockito.when((Object)this.postMethod.getResponseHeader("location")).thenReturn((Object)this.header);
        Mockito.when((Object)this.header.getValue()).thenReturn((Object)"http://new/URL");
        JSONObject response = this.abstractSolrQueryHTTPClient.postQuery(this.httpClient, URL, this.body);
        ((PostMethod)Mockito.verify((Object)this.postMethod)).setURI(new URI("http://new/URL", true));
        Assert.assertEquals((String)"Unexpected JSON response received.", (Object)"{}", (Object)response.toString());
    }

    private ByteArrayInputStream convertStringToInputStream(String message) {
        return new ByteArrayInputStream(message.getBytes());
    }
}

