/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.transaction.UserTransaction;
import junit.framework.AssertionFailedError;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.Version2ServiceImpl;
import org.alfresco.repo.version.VersionRevertCallback;
import org.alfresco.repo.version.VersionRevertDetails;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.repo.version.VersionableAspect;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.Commit;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Category(value={OwnJVMTestsCategory.class})
public class VersionServiceImplTest
extends BaseVersionStoreTest {
    private static Log logger = LogFactory.getLog(VersionServiceImplTest.class);
    private static final String UPDATED_NAME_1 = "a.txt";
    private static final String UPDATED_NAME_2 = "b.txt";
    private static final String UPDATED_NAME_3 = "c.txt";
    private static final String UPDATED_TITLE_1 = "a";
    private static final String UPDATED_TITLE_2 = "b";
    private static final String UPDATED_TITLE_3 = "c";
    private static final String UPDATED_VALUE_1 = "updatedValue1";
    private static final String UPDATED_VALUE_2 = "updatedValue2";
    private static final String UPDATED_VALUE_3 = "updatedValue3";
    private static final String UPDATED_CONTENT_1 = "updatedContent1";
    private static final String UPDATED_CONTENT_2 = "updatedContent2";
    private static final String UPDATED_CONTENT_3 = "updatedContent3";
    private static final String PWD_A = "passA";
    private static final String USER_NAME_A = "userA";
    private PersonService personService;
    private VersionableAspect versionableAspect;
    private List<String> excludedOnUpdateProps;
    private Properties globalProperties;
    private TestVersionPolicy versionBehavior;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.versionableAspect = (VersionableAspect)this.applicationContext.getBean("versionableAspect");
        this.excludedOnUpdateProps = this.versionableAspect.getExcludedOnUpdateProps();
        this.globalProperties = (Properties)this.applicationContext.getBean("global-properties");
        this.globalProperties.setProperty("version.store.enableAutoVersionOnUpdateProps", "true");
        this.createAndEnableBehaviours();
    }

    @After
    public void after() throws Exception {
        this.versionableAspect.setExcludedOnUpdateProps(this.excludedOnUpdateProps);
        this.versionableAspect.afterDictionaryInit();
        this.globalProperties.setProperty("version.store.enableAutoVersionOnUpdateProps", "false");
    }

    private void createAndEnableBehaviours() {
        this.versionBehavior = new TestVersionPolicy();
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME, BaseVersionStoreTest.TEST_TYPE_QNAME, (Behaviour)new JavaBehaviour((Object)this.versionBehavior, "beforeCreateVersion"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.AfterCreateVersionPolicy.QNAME, BaseVersionStoreTest.TEST_TYPE_QNAME, (Behaviour)new JavaBehaviour((Object)this.versionBehavior, "afterCreateVersion"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnCreateVersionPolicy.QNAME, BaseVersionStoreTest.TEST_TYPE_QNAME, (Behaviour)new JavaBehaviour((Object)this.versionBehavior, "onCreateVersion"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.AfterVersionRevertPolicy.QNAME, BaseVersionStoreTest.TEST_TYPE_QNAME, (Behaviour)new JavaBehaviour((Object)this.versionBehavior, "afterVersionRevert"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnRevertVersionPolicy.QNAME, BaseVersionStoreTest.TEST_TYPE_QNAME, (Behaviour)new JavaBehaviour((Object)this.versionBehavior, "getRevertVersionCallback"));
    }

    @Test
    public void testSetup() {
    }

    @Test
    public void testDiscussableAspect() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version v1 = this.createVersion(versionableNode);
        this.addComment(versionableNode, "<p>Comment for version 1</p>", false);
        this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)vh.getAllVersions().size());
        this.addComment(versionableNode, "<p>Comment for version 2</p>", false);
        Set aspects = this.nodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertTrue((boolean)aspects.contains(ForumModel.ASPECT_DISCUSSABLE));
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "<p>Comment for version 2</p>"));
        this.createVersion(versionableNode);
        vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)3, (int)vh.getAllVersions().size());
        this.addComment(versionableNode, "Comment for third version", false);
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "Comment for third version"));
        this.versionService.revert(versionableNode, v1);
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "Comment for third version"));
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "<p>Comment for version 2</p>"));
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "<p>Comment for version 1</p>"));
        versionableNode = this.createNewVersionableNode();
        v1 = this.createVersion(versionableNode);
        vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)1, (int)vh.getAllVersions().size());
        this.createVersion(versionableNode);
        vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)vh.getAllVersions().size());
        this.addComment(versionableNode, "<p>Comment for version 2</p>", false);
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "<p>Comment for version 2</p>"));
        this.createVersion(versionableNode);
        vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)3, (int)vh.getAllVersions().size());
        this.addComment(versionableNode, "Comment for third version", false);
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "Comment for third version"));
        this.versionService.revert(versionableNode, v1);
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "Comment for third version"));
        VersionServiceImplTest.assertTrue((boolean)this.isCommentExist(versionableNode, "<p>Comment for version 2</p>"));
        VersionServiceImplTest.assertFalse((boolean)this.isCommentExist(versionableNode, "<p>Comment for version 1</p>"));
    }

    private NodeRef addComment(NodeRef nr, String comment, boolean suppressRollups) {
        if (!this.nodeService.hasAspect(nr, ForumModel.ASPECT_DISCUSSABLE)) {
            this.nodeService.addAspect(nr, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        if (!this.nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP) && !suppressRollups) {
            this.nodeService.addAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
        }
        NodeRef forumNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(nr, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = this.nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"));
        NodeRef topicNode = null;
        topicNode = existingTopics.isEmpty() ? this.nodeService.createNode(forumNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"), ForumModel.TYPE_TOPIC).getChildRef() : ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        NodeRef postNode = this.nodeService.createNode(topicNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)("comment" + System.currentTimeMillis())), ForumModel.TYPE_POST).getChildRef();
        this.nodeService.setProperty(postNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        ContentWriter writer = this.contentService.getWriter(postNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(comment);
        return postNode;
    }

    private boolean isCommentExist(NodeRef nr, String commentForCheck) {
        if (!this.nodeService.hasAspect(nr, ForumModel.ASPECT_DISCUSSABLE)) {
            return false;
        }
        NodeRef forumNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(nr, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = this.nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"));
        if (existingTopics.isEmpty()) {
            return false;
        }
        NodeRef topicNode = ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        Collection comments = this.nodeService.getChildAssocsWithoutParentAssocsOfType(topicNode, ContentModel.ASSOC_CONTAINS);
        for (ChildAssociationRef comment : comments) {
            String contentString;
            NodeRef commentRef = comment.getChildRef();
            ContentReader reader = this.contentService.getReader(commentRef, ContentModel.PROP_CONTENT);
            if (reader == null || !commentForCheck.equals(contentString = reader.getContentString())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testCommentsCountProperty() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.addComment(versionableNode, "<p>Comment</p>", false);
        Version v1 = this.createVersion(versionableNode);
        this.addComment(versionableNode, "<p>Comment</p>", false);
        this.createVersion(versionableNode);
        this.versionService.revert(versionableNode, v1);
        VersionServiceImplTest.assertEquals((String)"Incorrect comments count:", (Object)2, (Object)this.nodeService.getProperty(versionableNode, ForumModel.PROP_COMMENT_COUNT));
    }

    @Test
    public void testCreateIntialVersion() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
    }

    @Test
    public void testCreateManyVersionsSameWorkspace() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)vh);
        VersionServiceImplTest.assertEquals((int)3, (int)vh.getAllVersions().size());
    }

    @Test
    public void testCreateManyVersionsWithNullVersionProperties() {
        this.versionProperties = null;
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)vh);
        VersionServiceImplTest.assertEquals((int)3, (int)vh.getAllVersions().size());
    }

    @Test
    public void testCreateInitialVersionWhenNotVersionable() {
        NodeRef node = this.createNewNode();
        this.createVersion(node);
    }

    @Test
    public void testGetCurrentVersion() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        Version version = vh.getRootVersion();
        NodeRef node = version.getVersionedNodeRef();
        Version currentVersion = this.versionService.getCurrentVersion(node);
        VersionServiceImplTest.assertNotNull((String)"Failed to retrieve the current version from the head", (Object)currentVersion);
        try {
            node = version.getFrozenStateNodeRef();
            currentVersion = this.versionService.getCurrentVersion(node);
            VersionServiceImplTest.fail((String)"Getting the current version is only allowed on live nodes, not on version nodes.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testVersioningChildren() {
        NodeRef versionableNode = this.createNewVersionableNode();
        String expectedVersionLabel = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Collection versions = this.versionService.createVersion(versionableNode, this.versionProperties, true);
        this.CheckVersionCollection(expectedVersionLabel, beforeVersionTime, versions);
    }

    @Test
    public void testVersioningManyNodes() {
        NodeRef versionableNode = this.createNewVersionableNode();
        String expectedVersionLabel = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Collection versions = this.versionService.createVersion(this.versionableNodes.values(), this.versionProperties);
        this.CheckVersionCollection(expectedVersionLabel, beforeVersionTime, versions);
    }

    private void CheckVersionCollection(String expectedVersionLabel, long beforeVersionTime, Collection<Version> versions) {
        for (Version version : versions) {
            String frozenNodeId = null;
            if (this.versionService.getVersionStoreReference().getIdentifier().equals("version2Store")) {
                frozenNodeId = ((NodeRef)version.getVersionProperty("frozenNodeRef")).getId();
            } else if (this.versionService.getVersionStoreReference().getIdentifier().equals("lightWeightVersionStore")) {
                frozenNodeId = (String)((Object)version.getVersionProperty("frozenNodeId"));
            }
            VersionServiceImplTest.assertNotNull((String)"Unable to retrieve the frozen node id from the created version.", (Object)frozenNodeId);
            NodeRef originalNodeRef = (NodeRef)this.versionableNodes.get(frozenNodeId);
            VersionServiceImplTest.assertNotNull((String)"The versionable node ref that relates to the frozen node id can not be found.", (Object)originalNodeRef);
            this.checkNewVersion(beforeVersionTime, expectedVersionLabel, version, originalNodeRef);
        }
    }

    private void CheckVersionHistory(VersionHistory vh, List<Version> expectedVersions) {
        if (vh == null) {
            VersionServiceImplTest.assertNull(expectedVersions);
        } else {
            Iterator<Version> itr = expectedVersions.iterator();
            for (Version version : vh.getAllVersions()) {
                Version expectedVersion = itr.next();
                VersionServiceImplTest.assertEquals((String)version.getVersionLabel(), (String)expectedVersion.getVersionLabel());
                VersionServiceImplTest.assertEquals((Object)version.getFrozenStateNodeRef(), (Object)expectedVersion.getFrozenStateNodeRef());
            }
            VersionServiceImplTest.assertFalse((boolean)itr.hasNext());
        }
    }

    @Test
    public void testNoVersionHistory() {
        NodeRef nodeRef = this.createNewVersionableNode();
        VersionHistory vh = this.versionService.getVersionHistory(nodeRef);
        VersionServiceImplTest.assertNull((Object)vh);
    }

    @Test
    public void testGetVersionHistorySameWorkspace() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version1 = this.addToVersionHistory(versionableNode, null);
        Version version2 = this.addToVersionHistory(versionableNode, version1);
        Version version3 = this.addToVersionHistory(versionableNode, version2);
        Version version4 = this.addToVersionHistory(versionableNode, version3);
        this.addToVersionHistory(versionableNode, version4);
    }

    @Test
    public void testIdsOutOfOrder() {
        if (this.versionService instanceof Version2ServiceImpl) {
            this.setOutOfOrderIdsVersionService("org.alfresco.repo.version.common.VersionLabelComparator");
            this.testGetVersionHistorySameWorkspace();
        }
    }

    @Test
    public void testIdsOutOfOrderFails() {
        if (this.versionService instanceof Version2ServiceImpl) {
            try {
                this.setOutOfOrderIdsVersionService("");
                this.testGetVersionHistorySameWorkspace();
                VersionServiceImplTest.fail((String)"Expected this to fail");
            }
            catch (AssertionFailedError e) {
                System.out.print("A test failed as EXPECTED: " + e.getMessage());
            }
        }
    }

    @Test
    public void testVersionIndex() {
        this.setUseVersionAssocIndex(true);
        NodeRef versionableNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNodeTestIndex"), ContentModel.TYPE_CONTENT, null).getChildRef();
        this.nodeService.addAspect(versionableNode, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        Version version1 = this.createVersion(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        Version version3 = this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)"Version History does not contain 3 versions", (int)3, (int)vh.getAllVersions().size());
        NodeRef root = this.nodeService.getPrimaryParent(vh.getRootVersion().getFrozenStateNodeRef()).getParentRef();
        NodeRef versionHistoryNode = this.dbNodeService.getChildByName(root, Version2Model.CHILD_QNAME_VERSION_HISTORIES, versionableNode.getId());
        List vhChildAssocs = this.nodeService.getChildAssocs(versionHistoryNode);
        int index = 0;
        for (ChildAssociationRef vhChildAssoc : vhChildAssocs) {
            VersionServiceImplTest.assertFalse((String)"Index is not set", (vhChildAssoc.getNthSibling() < 0 ? 1 : 0) != 0);
            VersionServiceImplTest.assertTrue((String)"Index is not increasing as expected", (vhChildAssoc.getNthSibling() > index ? 1 : 0) != 0);
            index = vhChildAssoc.getNthSibling();
        }
        VersionServiceImplTest.assertEquals((String)"1st version is not 1st assoc", (String)version1.getFrozenStateNodeRef().getId(), (String)((ChildAssociationRef)vhChildAssocs.get(0)).getChildRef().getId());
        VersionServiceImplTest.assertEquals((String)"2nd version is not 2nd assoc", (String)version2.getFrozenStateNodeRef().getId(), (String)((ChildAssociationRef)vhChildAssocs.get(1)).getChildRef().getId());
        VersionServiceImplTest.assertEquals((String)"3rd version is not 3rd assoc", (String)version3.getFrozenStateNodeRef().getId(), (String)((ChildAssociationRef)vhChildAssocs.get(2)).getChildRef().getId());
    }

    @Test
    public void testVersionIndexDisabled() {
        this.setUseVersionAssocIndex(false);
        NodeRef versionableNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNodeTestWithoutIndex"), ContentModel.TYPE_CONTENT, null).getChildRef();
        this.nodeService.addAspect(versionableNode, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        Version version1 = this.createVersion(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        Version version3 = this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)"Version History does not contain 3 versions", (int)3, (int)vh.getAllVersions().size());
        NodeRef root = this.nodeService.getPrimaryParent(vh.getRootVersion().getFrozenStateNodeRef()).getParentRef();
        NodeRef versionHistoryNode = this.dbNodeService.getChildByName(root, Version2Model.CHILD_QNAME_VERSION_HISTORIES, versionableNode.getId());
        List vhChildAssocs = this.nodeService.getChildAssocs(versionHistoryNode);
        for (ChildAssociationRef vhChildAssoc : vhChildAssocs) {
            VersionServiceImplTest.assertTrue((String)"Index is not set", (vhChildAssoc.getNthSibling() < 0 ? 1 : 0) != 0);
        }
        VersionServiceImplTest.assertEquals((String)"1st version is not 1st assoc", (String)version1.getFrozenStateNodeRef().getId(), (String)((ChildAssociationRef)vhChildAssocs.get(0)).getChildRef().getId());
        VersionServiceImplTest.assertEquals((String)"2nd version is not 2nd assoc", (String)version2.getFrozenStateNodeRef().getId(), (String)((ChildAssociationRef)vhChildAssocs.get(1)).getChildRef().getId());
        VersionServiceImplTest.assertEquals((String)"3rd version is not 3rd assoc", (String)version3.getFrozenStateNodeRef().getId(), (String)((ChildAssociationRef)vhChildAssocs.get(2)).getChildRef().getId());
    }

    private void setOutOfOrderIdsVersionService(String versionComparatorClass) {
        Version2ServiceImpl versionService = new Version2ServiceImpl(){

            protected List<Version> getAllVersions(NodeRef versionHistoryRef) {
                List versions = super.getAllVersions(versionHistoryRef);
                if (versions.size() > 1) {
                    ArrayList copy = new ArrayList(versions);
                    do {
                        Collections.shuffle(versions);
                    } while (versions.equals(copy));
                }
                return versions;
            }
        };
        versionService.setNodeService(this.nodeService);
        versionService.setDbNodeService(this.dbNodeService);
        versionService.setSearcher(this.versionSearchService);
        versionService.setDictionaryService(this.dictionaryService);
        versionService.setPolicyComponent(this.policyComponent);
        versionService.setPolicyBehaviourFilter(this.policyBehaviourFilter);
        versionService.setPermissionService(this.permissionService);
        versionService.setVersionComparatorClass(versionComparatorClass);
        versionService.initialise();
        this.setVersionService((VersionService)versionService);
    }

    private void setUseVersionAssocIndex(boolean useVersionAssocIndex) {
        Version2ServiceImpl versionService = new Version2ServiceImpl();
        versionService.setNodeService(this.nodeService);
        versionService.setDbNodeService(this.dbNodeService);
        versionService.setSearcher(this.versionSearchService);
        versionService.setDictionaryService(this.dictionaryService);
        versionService.setPolicyComponent(this.policyComponent);
        versionService.setPolicyBehaviourFilter(this.policyBehaviourFilter);
        versionService.setPermissionService(this.permissionService);
        versionService.setUseVersionAssocIndex(useVersionAssocIndex);
        versionService.initialise();
        this.setVersionService((VersionService)versionService);
    }

    private Version addToVersionHistory(NodeRef versionableNode, Version parentVersion) {
        Version createdVersion = this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((String)"The version history should not be null since we know we have versioned this node.", (Object)vh);
        if (parentVersion == null) {
            Version root = vh.getRootVersion();
            VersionServiceImplTest.assertNotNull((String)"The root version should never be null, since every version history ust have a root version.", (Object)root);
            VersionServiceImplTest.assertEquals((String)createdVersion.getVersionLabel(), (String)root.getVersionLabel());
        }
        Version version = vh.getVersion(createdVersion.getVersionLabel());
        VersionServiceImplTest.assertNotNull((Object)version);
        VersionServiceImplTest.assertEquals((String)createdVersion.getVersionLabel(), (String)version.getVersionLabel());
        Collection suc = vh.getSuccessors(version);
        VersionServiceImplTest.assertNotNull((Object)suc);
        VersionServiceImplTest.assertEquals((int)0, (int)suc.size());
        Version pre = vh.getPredecessor(version);
        if (parentVersion == null) {
            VersionServiceImplTest.assertNull((Object)pre);
        } else {
            VersionServiceImplTest.assertNotNull((Object)pre);
            VersionServiceImplTest.assertEquals((String)parentVersion.getVersionLabel(), (String)pre.getVersionLabel());
        }
        if (parentVersion != null) {
            Collection parentSuc = vh.getSuccessors(parentVersion);
            VersionServiceImplTest.assertNotNull((Object)parentSuc);
            VersionServiceImplTest.assertEquals((int)1, (int)parentSuc.size());
            Version tempVersion = (Version)parentSuc.toArray()[0];
            VersionServiceImplTest.assertEquals((String)version.getVersionLabel(), (String)tempVersion.getVersionLabel());
        }
        return createdVersion;
    }

    @Test
    public void testRevert() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.addAspect(versionableNode, BaseVersionStoreTest.TEST_MARKER_ASPECT_QNAME, null);
        Set origAspects = this.dbNodeService.getAspects(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        VersionHistory history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)version1.getVersionLabel(), (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)version1.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        VersionServiceImplTest.assertEquals((int)1, (int)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[1]);
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)"0.1", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)UPDATED_VALUE_1));
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_2, null);
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_1);
        this.dbNodeService.addAspect(versionableNode, ApplicationModel.ASPECT_SIMPLE_WORKFLOW, null);
        Set origAspects2 = this.dbNodeService.getAspects(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)version2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[2]);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[1].getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)"0.2", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)UPDATED_VALUE_2));
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_2, (Serializable)((Object)UPDATED_VALUE_3));
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_3, null);
        ContentWriter contentWriter2 = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter2);
        contentWriter2.putContent(UPDATED_CONTENT_2);
        String versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.versionService.revert(versionableNode);
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)UPDATED_VALUE_1, (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
        VersionServiceImplTest.assertNull((Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_3));
        ContentReader contentReader1 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader1);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_1, (String)contentReader1.getContentString());
        Set aspects1 = this.dbNodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertEquals((int)aspects1.size(), (int)origAspects2.size());
        VersionServiceImplTest.assertTrue((boolean)aspects1.contains(BaseVersionStoreTest.TEST_MARKER_ASPECT_QNAME));
        history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)version2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[2]);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[1].getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)"0.2", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((String)"0.2", (String)history.getHeadVersion().getVersionLabel());
        this.versionService.revert(versionableNode, version1);
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_3));
        ContentReader contentReader2 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader2);
        VersionServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader2.getContentString());
        Set aspects2 = this.dbNodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertEquals((int)aspects2.size(), (int)origAspects.size());
        VersionServiceImplTest.assertTrue((boolean)aspects2.contains(BaseVersionStoreTest.TEST_MARKER_ASPECT_QNAME));
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)version2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[2]);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[1].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.2", (String)history.getHeadVersion().getVersionLabel());
    }

    @Test
    public void testRevertWithComments() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"I am before version"));
        Version version1 = this.createVersion(versionableNode);
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"I am after version 1"));
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)vh);
        VersionServiceImplTest.assertEquals((int)1, (int)vh.getAllVersions().size());
        this.createVersion(versionableNode);
        this.versionService.revert(versionableNode, version1);
        VersionServiceImplTest.assertEquals((Object)"I am before version", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
        this.createComment(versionableNode, "my comment", "Do great work", false);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(versionableNode, ForumModel.ASPECT_DISCUSSABLE));
        VersionServiceImplTest.assertTrue((String)"fm:discussion association must exist", (this.nodeService.getChildAssocs(versionableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL).size() > 0 ? 1 : 0) != 0);
        VersionServiceImplTest.assertEquals((Object)1, (Object)this.dbNodeService.getProperty(versionableNode, ForumModel.PROP_COMMENT_COUNT));
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"I am version 3"));
        Version version3 = this.createVersion(versionableNode);
        this.dbNodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"I am after version 3"));
        this.createComment(versionableNode, "v3", "Great version", false);
        VersionServiceImplTest.assertEquals((Object)2, (Object)this.dbNodeService.getProperty(versionableNode, ForumModel.PROP_COMMENT_COUNT));
        this.versionService.revert(versionableNode, version3);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(versionableNode, ForumModel.ASPECT_DISCUSSABLE));
        VersionServiceImplTest.assertTrue((String)"fm:discussion association must exist", (this.nodeService.getChildAssocs(versionableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL).size() > 0 ? 1 : 0) != 0);
        VersionServiceImplTest.assertEquals((Object)"I am version 3", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
        this.versionService.revert(versionableNode, version1);
        VersionServiceImplTest.assertEquals((Object)"I am before version", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(versionableNode, ForumModel.ASPECT_DISCUSSABLE));
        this.versionService.revert(versionableNode, version3);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(versionableNode, ForumModel.ASPECT_DISCUSSABLE));
        VersionServiceImplTest.assertTrue((String)"fm:discussion association must exist", (this.nodeService.getChildAssocs(versionableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL).size() > 0 ? 1 : 0) != 0);
        VersionServiceImplTest.assertEquals((Object)"I am version 3", (Object)this.dbNodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
        NodeRef clearNode = this.createNewVersionableNode();
        Version clearVersion1 = this.createVersion(clearNode);
        this.createComment(clearNode, "my comment", "Do great work", false);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(clearNode, ForumModel.ASPECT_DISCUSSABLE));
        Version clearVersion2 = this.createVersion(clearNode);
        this.versionService.revert(clearNode, clearVersion1);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(clearNode, ForumModel.ASPECT_DISCUSSABLE));
        this.createComment(clearNode, "my comment", "Do great work", false);
        this.createVersion(clearNode);
        this.versionService.revert(clearNode, clearVersion2);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(versionableNode, ForumModel.ASPECT_DISCUSSABLE));
        VersionServiceImplTest.assertTrue((String)"fm:discussion association must exist", (this.nodeService.getChildAssocs(clearNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAssociationIsPresentAfterRevert() {
        NodeRef orderNodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableOrder"), BaseVersionStoreTest.TEST_ATS_PARENT_TYPE_QNAME, (Map)this.nodeProperties).getChildRef();
        this.dbNodeService.addAspect(orderNodeRef, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        VersionServiceImplTest.assertNotNull((Object)orderNodeRef);
        this.dbNodeService.setProperty(orderNodeRef, BaseVersionStoreTest.PROP_ATS_PARENT_ID, (Serializable)Integer.valueOf(1));
        NodeRef productNodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyProduct1"), BaseVersionStoreTest.TEST_ATS_CHILD_TYPE_QNAME, (Map)this.nodeProperties).getChildRef();
        this.dbNodeService.setProperty(orderNodeRef, BaseVersionStoreTest.PROP_ATS_CHILD_ID, (Serializable)Integer.valueOf(1));
        ChildAssociationRef childAssoc = this.dbNodeService.addChild(orderNodeRef, productNodeRef, BaseVersionStoreTest.TEST_ATS_RELATED_CHILDREN_QNAME, BaseVersionStoreTest.TEST_ATS_RELATED_CHILDREN_QNAME);
        VersionServiceImplTest.assertFalse((String)"Order-product child association should not be primary", (boolean)childAssoc.isPrimary());
        Version version1 = this.createVersion(orderNodeRef);
        this.dbNodeService.setProperty(orderNodeRef, BaseVersionStoreTest.PROP_ATS_PARENT_ID, (Serializable)Integer.valueOf(2));
        VersionServiceImplTest.assertEquals((String)"New property should be set", (Object)2, (Object)this.dbNodeService.getProperty(orderNodeRef, BaseVersionStoreTest.PROP_ATS_PARENT_ID));
        List childAssocs = this.nodeService.getChildAssocs(orderNodeRef, (QNamePattern)BaseVersionStoreTest.TEST_ATS_RELATED_CHILDREN_QNAME, RegexQNamePattern.MATCH_ALL);
        VersionServiceImplTest.assertTrue((String)"Order-Product association must exist", (childAssocs.size() > 0 ? 1 : 0) != 0);
        VersionServiceImplTest.assertTrue((String)"Order should have Order-Product association", (boolean)childAssocs.contains(childAssoc));
        VersionHistory vh = this.versionService.getVersionHistory(orderNodeRef);
        VersionServiceImplTest.assertNotNull((Object)vh);
        VersionServiceImplTest.assertEquals((int)1, (int)vh.getAllVersions().size());
        this.versionService.revert(orderNodeRef, version1);
        VersionServiceImplTest.assertEquals((String)"Old property should restore after revert", (Object)1, (Object)this.dbNodeService.getProperty(orderNodeRef, BaseVersionStoreTest.PROP_ATS_PARENT_ID));
        childAssocs = this.nodeService.getChildAssocs(orderNodeRef, (QNamePattern)BaseVersionStoreTest.TEST_ATS_RELATED_CHILDREN_QNAME, RegexQNamePattern.MATCH_ALL);
        VersionServiceImplTest.assertTrue((String)"Order-Product association must exist after revert", (childAssocs.size() > 0 ? 1 : 0) != 0);
        VersionServiceImplTest.assertTrue((String)"Order-Product association should remain the same", (boolean)childAssocs.contains(childAssoc));
    }

    private NodeRef createComment(NodeRef discussableNode, String title, String comment, boolean suppressRollups) {
        if (comment == null) {
            throw new IllegalArgumentException("Must provide a non-null comment");
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE)) {
            this.nodeService.addAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP) && !suppressRollups) {
            this.nodeService.addAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
        }
        NodeRef forumNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(discussableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = this.nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"));
        NodeRef topicNode = null;
        if (existingTopics.isEmpty()) {
            HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
            props.put(ContentModel.PROP_NAME, "Comments");
            topicNode = this.nodeService.createNode(forumNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"), ForumModel.TYPE_TOPIC, props).getChildRef();
        } else {
            topicNode = ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        }
        NodeRef postNode = this.nodeService.createNode(topicNode, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ForumModel.TYPE_POST).getChildRef();
        this.nodeService.setProperty(postNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        this.nodeService.setProperty(postNode, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        ContentWriter writer = this.contentService.getWriter(postNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(comment);
        return postNode;
    }

    @Commit
    @Test
    public void testScriptNodeRevert() {
        CheckOutCheckInService checkOutCheckIn = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        NodeRef versionableNode = this.createNewVersionableNode();
        NodeRef checkedOut = checkOutCheckIn.checkout(versionableNode);
        this.createVersion(checkedOut);
        ContentWriter contentWriter = this.contentService.getWriter(checkedOut, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_1);
        this.nodeService.setProperty(checkedOut, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value1"));
        checkOutCheckIn.checkin(checkedOut, null, contentWriter.getContentUrl(), false);
        Version version1 = this.createVersion(versionableNode);
        checkedOut = checkOutCheckIn.checkout(versionableNode);
        contentWriter = this.contentService.getWriter(checkedOut, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_2);
        this.nodeService.setProperty(checkedOut, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value2"));
        checkOutCheckIn.checkin(checkedOut, null, contentWriter.getContentUrl(), false);
        Version version2 = this.createVersion(versionableNode);
        checkedOut = checkOutCheckIn.checkout(versionableNode);
        VersionHistory history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)version2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[2]);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[1].getVersionLabel());
        contentWriter = this.contentService.getWriter(checkedOut, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_3);
        this.nodeService.setProperty(checkedOut, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value3"));
        checkOutCheckIn.checkin(checkedOut, null, contentWriter.getContentUrl(), false);
        Version version3 = this.createVersion(versionableNode);
        history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)version3.getVersionLabel(), (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)version3.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        VersionServiceImplTest.assertEquals((int)3, (int)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[3]);
        VersionServiceImplTest.assertEquals((String)"0.3", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versions[1].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[2].getVersionLabel());
        ServiceRegistry services = (ServiceRegistry)this.applicationContext.getBean(ServiceRegistry.class);
        ScriptNode scriptNode = new ScriptNode(versionableNode, services);
        VersionServiceImplTest.assertEquals((Object)"0.3", (Object)this.nodeService.getProperty(scriptNode.getNodeRef(), ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.nodeService.getProperty(scriptNode.getNodeRef(), BaseVersionStoreTest.PROP_1));
        ScriptNode newNode = scriptNode.revert("History", false, version2.getVersionLabel());
        ContentReader contentReader = this.contentService.getReader(newNode.getNodeRef(), ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_2, (String)contentReader.getContentString());
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.nodeService.getProperty(newNode.getNodeRef(), BaseVersionStoreTest.PROP_1));
        VersionServiceImplTest.assertEquals((Object)"0.4", (Object)this.nodeService.getProperty(newNode.getNodeRef(), ContentModel.PROP_VERSION_LABEL));
        newNode = scriptNode.revert("History", false, version1.getVersionLabel());
        contentReader = this.contentService.getReader(newNode.getNodeRef(), ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_1, (String)contentReader.getContentString());
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.nodeService.getProperty(newNode.getNodeRef(), BaseVersionStoreTest.PROP_1));
        VersionServiceImplTest.assertEquals((Object)"0.5", (Object)this.nodeService.getProperty(newNode.getNodeRef(), ContentModel.PROP_VERSION_LABEL));
    }

    @Commit
    @Test
    public void testScriptNodeRevertWithChangeType() {
        CheckOutCheckInService checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version1 = this.createVersion(versionableNode);
        this.nodeService.setType(versionableNode, BaseVersionStoreTest.TEST_TYPE_WITH_MANDATORY_ASPECT_QNAME);
        NodeRef checkedOut = checkOutCheckInService.checkout(versionableNode);
        ContentWriter contentWriter = this.contentService.getWriter(checkedOut, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_1);
        this.nodeService.setProperty(checkedOut, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value1"));
        checkOutCheckInService.checkin(checkedOut, null, contentWriter.getContentUrl(), false);
        this.createVersion(versionableNode);
        ServiceRegistry services = (ServiceRegistry)this.applicationContext.getBean(ServiceRegistry.class);
        ScriptNode scriptNode = new ScriptNode(versionableNode, services);
        VersionServiceImplTest.assertEquals((Object)"0.2", (Object)this.nodeService.getProperty(scriptNode.getNodeRef(), ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)BaseVersionStoreTest.TEST_TYPE_WITH_MANDATORY_ASPECT_QNAME, (Object)this.nodeService.getType(scriptNode.getNodeRef()));
        ScriptNode newNode = scriptNode.revert("History", false, version1.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)"0.3", (Object)this.nodeService.getProperty(newNode.getNodeRef(), ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)BaseVersionStoreTest.TEST_TYPE_QNAME, (Object)this.nodeService.getType(newNode.getNodeRef()));
    }

    @Test
    public void testRestore() {
        try {
            this.versionService.restore(new NodeRef(this.testStoreRef, "123"), this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"));
            VersionServiceImplTest.fail((String)"An exception should have been raised since this node has no version history.");
        }
        catch (VersionServiceException versionServiceException) {}
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createComment(versionableNode, "my comment", "Do great work", false);
        VersionServiceImplTest.assertEquals(null, (Object)this.versionService.getVersionHistory(versionableNode));
        Set origAspects = this.dbNodeService.getAspects(versionableNode);
        try {
            this.versionService.restore(versionableNode, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"));
            VersionServiceImplTest.fail((String)"An exception should have been raised since this node exists and you can't restore a node that exists.");
        }
        catch (VersionServiceException versionServiceException) {}
        this.versionService.createVersion(versionableNode, null);
        this.versionService.createVersion(versionableNode, null);
        VersionHistory history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((Object)"0.2", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((String)"0.2", (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        this.dbNodeService.deleteNode(versionableNode);
        VersionServiceImplTest.assertFalse((boolean)this.dbNodeService.exists(versionableNode));
        history = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        NodeRef restoredNode = this.versionService.restore(versionableNode, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"));
        VersionServiceImplTest.assertNotNull((Object)restoredNode);
        VersionServiceImplTest.assertTrue((boolean)this.dbNodeService.exists(restoredNode));
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.dbNodeService.getProperty(restoredNode, BaseVersionStoreTest.PROP_1));
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.dbNodeService.getProperty(restoredNode, BaseVersionStoreTest.PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(restoredNode, BaseVersionStoreTest.PROP_3));
        ContentReader contentReader2 = this.contentService.getReader(restoredNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader2);
        VersionServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader2.getContentString());
        String versionLabel = (String)((Object)this.dbNodeService.getProperty(restoredNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versionLabel);
        Set aspects2 = this.dbNodeService.getAspects(restoredNode);
        VersionServiceImplTest.assertEquals((int)aspects2.size(), (int)origAspects.size());
        history = this.versionService.getVersionHistory(restoredNode);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)history.getHeadVersion().getVersionLabel());
        VersionServiceImplTest.assertEquals((int)2, (int)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[2]);
        VersionServiceImplTest.assertEquals((String)"0.2", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"0.1", (String)versions[1].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"versionStore", (String)versions[0].getFrozenStateNodeRef().getStoreRef().getProtocol());
        VersionServiceImplTest.assertEquals((String)"versionStore", (String)versions[1].getFrozenStateNodeRef().getStoreRef().getProtocol());
    }

    @Test
    public void testDeleteVersionHistory() {
        NodeRef versionableNode = this.createNewVersionableNode();
        VersionHistory versionHistory1 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNull((Object)versionHistory1);
        this.createVersion(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        String versionLabel1 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel1);
        VersionServiceImplTest.assertEquals((String)version1.getVersionLabel(), (String)versionLabel1);
        VersionHistory versionHistory2 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)versionHistory2);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory2.getAllVersions().size());
        this.versionService.deleteVersionHistory(versionableNode);
        VersionHistory versionHistory3 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNull((Object)versionHistory3);
        String versionLabel2 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel2);
        this.createVersion(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        VersionHistory versionHistory4 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)versionHistory4);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory4.getAllVersions().size());
        String versionLabel3 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel3);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)versionLabel3);
    }

    @Test
    public void testDeleteLastVersion() {
        this.versionProperties.put("versionType", VersionType.MAJOR);
        NodeRef versionableNode = this.createNewVersionableNode();
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_NAME, (Serializable)((Object)UPDATED_NAME_1));
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_TITLE, (Serializable)((Object)UPDATED_TITLE_1));
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_1);
        this.createVersion(versionableNode);
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_NAME, (Serializable)((Object)UPDATED_NAME_2));
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_TITLE, (Serializable)((Object)UPDATED_TITLE_2));
        contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(UPDATED_CONTENT_2);
        Version version2 = this.createVersion(versionableNode);
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_NAME, (Serializable)((Object)UPDATED_NAME_3));
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_TITLE, (Serializable)((Object)UPDATED_TITLE_3));
        contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(UPDATED_CONTENT_3);
        String name3 = (String)((Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_NAME));
        VersionServiceImplTest.assertEquals((String)UPDATED_NAME_3, (String)name3);
        String title3 = (String)((Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_TITLE));
        VersionServiceImplTest.assertEquals((String)UPDATED_TITLE_3, (String)title3);
        Version version3 = this.createVersion(versionableNode);
        Version currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)version3.getVersionLabel(), (String)currentVersion.getVersionLabel());
        ContentReader contentReader1 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_3, (String)contentReader1.getContentString());
        this.versionService.deleteVersion(versionableNode, version3);
        String name2 = (String)((Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_NAME));
        VersionServiceImplTest.assertEquals((String)UPDATED_NAME_2, (String)name2);
        String title2 = (String)((Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_TITLE));
        VersionServiceImplTest.assertEquals((String)UPDATED_TITLE_2, (String)title2);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)currentVersion.getVersionLabel());
        contentReader1 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_2, (String)contentReader1.getContentString());
        VersionHistory vHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)vHistory.getAllVersions().size());
        Version headVersion = vHistory.getHeadVersion();
        VersionServiceImplTest.assertEquals((String)"2.0", (String)headVersion.getVersionLabel());
    }

    @Test
    public void testDeleteVersion() {
        this.versionProperties.put("versionType", VersionType.MAJOR);
        NodeRef versionableNode = this.createNewVersionableNode();
        VersionHistory versionHistory = this.versionService.getVersionHistory(versionableNode);
        this.CheckVersionHistory(versionHistory, null);
        String versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel);
        Version version = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertNull((Object)version);
        Version version1 = this.createVersion(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        String versionLabel1 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((String)"first version label", (String)"2.0", (String)versionLabel1);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)versionLabel1);
        ArrayList<Object> expectedVersions = new ArrayList<Version>(2);
        expectedVersions.add(version2);
        expectedVersions.add(version1);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        Version[] versions = versionHistory.getAllVersions().toArray(new Version[2]);
        VersionServiceImplTest.assertEquals((String)"2.0", (String)versions[0].getVersionLabel());
        VersionServiceImplTest.assertEquals((String)"1.0", (String)versions[1].getVersionLabel());
        Version currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version2.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version2.getFrozenStateNodeRef());
        Version version3 = this.createVersion(versionableNode);
        Version version4 = this.createVersion(versionableNode);
        String versionLabel4 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((String)"4.0", (String)versionLabel4);
        VersionServiceImplTest.assertEquals((String)version4.getVersionLabel(), (String)versionLabel4);
        expectedVersions = new ArrayList(4);
        expectedVersions.add(version4);
        expectedVersions.add(version3);
        expectedVersions.add(version2);
        expectedVersions.add(version1);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)4, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version4.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version4.getFrozenStateNodeRef());
        VersionServiceImplTest.assertEquals((String)"4.0", (String)currentVersion.getVersionLabel());
        this.versionService.deleteVersion(versionableNode, version3);
        this.versionService.deleteVersion(versionableNode, version1);
        expectedVersions = new ArrayList(2);
        expectedVersions.add(version4);
        expectedVersions.add(version2);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version4.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version4.getFrozenStateNodeRef());
        this.versionService.deleteVersion(versionableNode, version4);
        expectedVersions = new ArrayList(1);
        expectedVersions.add(version2);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version2.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version2.getFrozenStateNodeRef());
        Version version3n = this.createVersion(versionableNode);
        expectedVersions = new ArrayList(2);
        expectedVersions.add(version3n);
        expectedVersions.add(version2);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version3n.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version3n.getFrozenStateNodeRef());
        VersionServiceImplTest.assertEquals((String)"3.0", (String)currentVersion.getVersionLabel());
        this.versionProperties.put("versionType", VersionType.MINOR);
        Version version31 = this.createVersion(versionableNode);
        Version version32 = this.createVersion(versionableNode);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)4, (int)versionHistory.getAllVersions().size());
        expectedVersions = new ArrayList(2);
        expectedVersions.add(version32);
        expectedVersions.add(version31);
        expectedVersions.add(version3n);
        expectedVersions.add(version2);
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version32.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version32.getFrozenStateNodeRef());
        VersionServiceImplTest.assertEquals((String)"3.2", (String)currentVersion.getVersionLabel());
        this.versionService.deleteVersion(versionableNode, version31);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)3, (int)versionHistory.getAllVersions().size());
        expectedVersions.remove(version31);
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version32.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version32.getFrozenStateNodeRef());
        this.versionService.deleteVersion(versionableNode, version32);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        expectedVersions.remove(version32);
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version3n.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version3n.getFrozenStateNodeRef());
        VersionServiceImplTest.assertEquals((String)"3.0", (String)currentVersion.getVersionLabel());
        this.versionService.deleteVersion(versionableNode, version2);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version3n.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version3n.getFrozenStateNodeRef());
        this.versionService.deleteVersion(versionableNode, version3n);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        this.CheckVersionHistory(versionHistory, null);
        versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel);
        version = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertNull((Object)version);
    }

    @Test
    public void testAutoVersionOnInitialVersionOn() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                ContentWriter contentWriter = VersionServiceImplTest.this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
                VersionServiceImplTest.assertNotNull((Object)contentWriter);
                contentWriter.putContent(VersionServiceImplTest.UPDATED_CONTENT_1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    @Test
    public void testAutoVersionOff() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION, (Serializable)Boolean.valueOf(false));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                ContentWriter contentWriter = VersionServiceImplTest.this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
                VersionServiceImplTest.assertNotNull((Object)contentWriter);
                contentWriter.putContent(VersionServiceImplTest.UPDATED_CONTENT_1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    @Test
    public void testInitialVersionOff() {
        HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
        props.put(ContentModel.PROP_INITIAL_VERSION, false);
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "test.txt");
        final NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode2"), BaseVersionStoreTest.TEST_TYPE_QNAME, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNull((Object)versionHistory);
                return null;
            }
        });
    }

    @Test
    public void testAddVersionableAspectWithNoVersionType() {
        NodeRef nodeRef = this.createNodeWithVersionType(null);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.assertCorrectVersionLabel(nodeRef, "1.0");
    }

    @Test
    public void testAddVersionableAspectWithMinorVersionType() {
        NodeRef nodeRef = this.createNodeWithVersionType(VersionType.MINOR);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.assertCorrectVersionLabel(nodeRef, "0.1");
    }

    @Test
    public void testAddVersionableAspectWithMajorVersionType() {
        NodeRef nodeRef = this.createNodeWithVersionType(VersionType.MAJOR);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.assertCorrectVersionLabel(nodeRef, "1.0");
    }

    private void assertCorrectVersionLabel(final NodeRef nodeRef, final String versionLabel) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                Version version = VersionServiceImplTest.this.versionService.getCurrentVersion(nodeRef);
                VersionServiceImplTest.assertEquals((String)"Wrong version label", (String)versionLabel, (String)version.getVersionLabel());
                return null;
            }
        });
    }

    private NodeRef createNodeWithVersionType(VersionType versionType) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, "test.txt");
        NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"), BaseVersionStoreTest.TEST_TYPE_QNAME, props).getChildRef();
        HashMap<QName, VersionType> aspectProps = new HashMap<QName, VersionType>();
        if (versionType != null) {
            aspectProps.put(ContentModel.PROP_VERSION_TYPE, versionType);
        }
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, aspectProps);
        return nodeRef;
    }

    @Test
    public void testAddRemoveVersionableAspect() {
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "test.txt");
        final NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode2"), BaseVersionStoreTest.TEST_TYPE_QNAME, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.dbNodeService.removeAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNull((Object)versionHistory);
                VersionServiceImplTest.this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    @Test
    public void testAutoRemovalOfVersionHistory() {
        StoreRef spacesStoreRef = new StoreRef("workspace", "SpacesStore");
        NodeRef root = this.dbNodeService.getRootNode(spacesStoreRef);
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "test-" + GUID.generate() + ".txt");
        final NodeRef nodeRef = this.dbNodeService.createNode(root, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode2"), ContentModel.TYPE_CONTENT, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.dbNodeService.deleteNode(nodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                NodeRef archivedNodeRef = VersionServiceImplTest.this.nodeArchiveService.getArchivedNode(nodeRef);
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(archivedNodeRef);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.dbNodeService.deleteNode(archivedNodeRef);
                return null;
            }
        });
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                NodeRef archivedNodeRef = VersionServiceImplTest.this.nodeArchiveService.getArchivedNode(nodeRef);
                VersionHistory versionHistory12 = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                VersionServiceImplTest.assertNull((Object)versionHistory12);
                VersionHistory versionHistory23 = VersionServiceImplTest.this.versionService.getVersionHistory(archivedNodeRef);
                VersionServiceImplTest.assertNull((Object)versionHistory23);
                return null;
            }
        });
    }

    @Test
    public void testAutoVersionOnUpdatePropsOnly() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 1"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"test description"));
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionType vType = (VersionType)versionHistory.getHeadVersion().getVersionProperty("versionType");
                VersionServiceImplTest.assertNotNull((String)"Is not setted the version type", (Object)vType);
                VersionServiceImplTest.assertEquals((Object)vType, (Object)VersionType.MINOR);
                return null;
            }
        });
        TestTransaction.start();
        final NodeRef versionableNode2 = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode2, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(false));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode2);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode2, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode2);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    @Test
    public void testAutoVersionOnUpdatePropsOnlyWithExcludes() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 1"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 1"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[2]);
                VersionServiceImplTest.assertEquals((String)"1.1", (String)versions[0].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"1.0", (String)versions[1].getVersionLabel());
                return null;
            }
        });
        ArrayList<String> excludedOnUpdateProps = new ArrayList<String>(1);
        NamespaceService namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        excludedOnUpdateProps.add(ContentModel.PROP_AUTHOR.toPrefixString((NamespacePrefixResolver)namespaceService));
        this.versionableAspect.setExcludedOnUpdateProps(excludedOnUpdateProps);
        this.versionableAspect.afterDictionaryInit();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 2"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionType vType = (VersionType)versionHistory.getHeadVersion().getVersionProperty("versionType");
                VersionServiceImplTest.assertNotNull((String)"Is not setted the version type", (Object)vType);
                VersionServiceImplTest.assertEquals((Object)vType, (Object)VersionType.MINOR);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 3"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)3, (int)versionHistory.getAllVersions().size());
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[3]);
                VersionServiceImplTest.assertEquals((String)"1.2", (String)versions[0].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"1.1", (String)versions[1].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"1.0", (String)versions[2].getVersionLabel());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[3]);
                Version version = versions[1];
                VersionServiceImplTest.assertEquals((String)"1.1", (String)version.getVersionLabel());
                VersionServiceImplTest.this.versionService.deleteVersion(versionableNode, version);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[2]);
                VersionServiceImplTest.assertEquals((String)"1.2", (String)versions[0].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"1.0", (String)versions[1].getVersionLabel());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                Version version = VersionServiceImplTest.this.versionService.getCurrentVersion(versionableNode);
                VersionServiceImplTest.assertEquals((String)"1.2", (String)version.getVersionLabel());
                VersionServiceImplTest.this.versionService.deleteVersion(versionableNode, version);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[1]);
                VersionServiceImplTest.assertEquals((String)"1.0", (String)versions[0].getVersionLabel());
                return null;
            }
        });
    }

    @Test
    public void testAutoVersionWithPropsOnRevert() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 0"));
        this.nodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value1"));
        HashMap<String, VersionType> vprops = new HashMap<String, VersionType>();
        vprops.put("versionType", VersionType.MAJOR);
        this.versionService.createVersion(versionableNode, vprops);
        this.versionService.createVersion(versionableNode, vprops);
        VersionServiceImplTest.assertEquals((Object)"2.0", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.versionService.deleteVersion(versionableNode, this.versionService.getVersionHistory(versionableNode).getVersion("1.0"));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.assertEquals((String)"2.0", (String)versionHistory.getHeadVersion().getVersionLabel());
                VersionServiceImplTest.assertEquals((Object)"2.0", (Object)VersionServiceImplTest.this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 2"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 2"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 3"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 3"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, BaseVersionStoreTest.PROP_1, (Serializable)((Object)"value3"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)3, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.assertEquals((String)"2.2", (String)versionHistory.getHeadVersion().getVersionLabel());
                VersionServiceImplTest.assertEquals((Object)"2.2", (Object)VersionServiceImplTest.this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[3]);
                VersionServiceImplTest.assertEquals((String)"2.2", (String)versions[0].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"2.1", (String)versions[1].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"2.0", (String)versions[2].getVersionLabel());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Version v21 = versionHistory.getVersion("2.1");
                VersionServiceImplTest.this.versionService.deleteVersion(versionableNode, v21);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.assertEquals((String)"2.2", (String)versionHistory.getHeadVersion().getVersionLabel());
                VersionServiceImplTest.assertEquals((Object)"2.2", (Object)VersionServiceImplTest.this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[2]);
                VersionServiceImplTest.assertEquals((String)"2.2", (String)versions[0].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"2.0", (String)versions[1].getVersionLabel());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Version v20 = versionHistory.getVersion("2.0");
                VersionServiceImplTest.this.versionService.revert(versionableNode, v20);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                Version[] versions = versionHistory.getAllVersions().toArray(new Version[2]);
                VersionServiceImplTest.assertEquals((String)"2.2", (String)versions[0].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"2.0", (String)versions[1].getVersionLabel());
                VersionServiceImplTest.assertEquals((String)"2.2", (String)versionHistory.getHeadVersion().getVersionLabel());
                VersionServiceImplTest.assertEquals((Object)"2.2", (Object)VersionServiceImplTest.this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
                VersionServiceImplTest.assertEquals((Object)"value1", (Object)VersionServiceImplTest.this.nodeService.getProperty(versionableNode, BaseVersionStoreTest.PROP_1));
                VersionServiceImplTest.assertEquals((Object)"description 0", (Object)VersionServiceImplTest.this.nodeService.getProperty(versionableNode, ContentModel.PROP_DESCRIPTION));
                return null;
            }
        });
    }

    @Test
    public void testALF5618() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        String cfr_ignored_0 = "opaquelocktoken:" + versionableNode.getId() + ":admin";
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertNotNull((Object)versionHistory);
                VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    @Test
    public void testAR807() {
        QName prop = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"intProp");
        ChildAssociationRef childAssociation = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"integerTest"), BaseVersionStoreTest.TEST_TYPE_QNAME);
        NodeRef newNode = childAssociation.getChildRef();
        this.nodeService.setProperty(newNode, prop, (Serializable)Integer.valueOf(1));
        Serializable editionCode = this.nodeService.getProperty(newNode, prop);
        VersionServiceImplTest.assertEquals(editionCode.getClass(), Integer.class);
        HashMap<String, VersionType> versionProps = new HashMap<String, VersionType>(1);
        versionProps.put("versionType", VersionType.MAJOR);
        Version version = this.versionService.createVersion(newNode, versionProps);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        VersionServiceImplTest.assertNotNull((Object)versionNodeRef);
        Serializable editionCodeArchive = this.nodeService.getProperty(versionNodeRef, prop);
        VersionServiceImplTest.assertEquals(editionCodeArchive.getClass(), Integer.class);
    }

    @Test
    public void testVersionTypeIsSet() {
        ChildAssociationRef childAssociation = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/versiontypeissettest/1.0", (String)"versionTypeIsSetTest"), BaseVersionStoreTest.TEST_TYPE_QNAME);
        NodeRef newNode = childAssociation.getChildRef();
        VersionServiceImplTest.assertNull((Object)this.nodeService.getProperty(newNode, ContentModel.PROP_VERSION_TYPE));
        HashMap<String, VersionType> versionProps = new HashMap<String, VersionType>(1);
        versionProps.put("versionType", VersionType.MINOR);
        this.versionService.createVersion(newNode, versionProps);
        Serializable versionTypeProperty = this.nodeService.getProperty(newNode, ContentModel.PROP_VERSION_TYPE);
        VersionServiceImplTest.assertNotNull((Object)versionTypeProperty);
        VersionServiceImplTest.assertTrue((boolean)versionTypeProperty.toString().equals(VersionType.MINOR.toString()));
    }

    @Test
    public void testHasPermission() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (!this.authenticationDAO.userExists(USER_NAME_A)) {
            this.authenticationService.createAuthentication(USER_NAME_A, PWD_A.toCharArray());
        }
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "Read", true);
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, true);
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.permissionService.setInheritParentPermissions(versionableNode, false);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
    }

    @Test
    public void testHasPermissionSwappedProtocol() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (!this.authenticationDAO.userExists(USER_NAME_A)) {
            this.authenticationService.createAuthentication(USER_NAME_A, PWD_A.toCharArray());
        }
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "Read", true);
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, true);
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        NodeRef versionNodeRefSwapped = new NodeRef("workspace", versionNodeRef.getStoreRef().getIdentifier(), versionNodeRef.getId());
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRefSwapped, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRefSwapped, "Read"));
        this.permissionService.setInheritParentPermissions(versionableNode, false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(versionNodeRefSwapped, "Read"));
    }

    @Test
    public void testALF_3962() {
        NodeRef versionableNode = this.createNode(true, QName.createQName((String)"http://www.alfresco.org/model/action/1.0", (String)"action"));
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        Version ver = this.createVersion(versionableNode);
        Date frozenModifiedDate = ver.getFrozenModifiedDate();
        ver = this.createVersion(versionableNode);
        NodeRef versionNodeRef = VersionUtil.convertNodeRef((NodeRef)ver.getFrozenStateNodeRef());
        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIED, (Serializable)frozenModifiedDate);
        ver = this.createVersion(versionableNode);
        versionNodeRef = VersionUtil.convertNodeRef((NodeRef)ver.getFrozenStateNodeRef());
        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIED, (Serializable)frozenModifiedDate);
        Collection versions = this.versionService.getVersionHistory(versionableNode).getAllVersions();
        ArrayList<Version> oldVersions = new ArrayList<Version>(versions.size());
        for (Version version : versions) {
            versionNodeRef = VersionUtil.convertNodeRef((NodeRef)version.getFrozenStateNodeRef());
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)"0"));
            oldVersions.add(version);
        }
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)"0"));
        this.versionService.createVersion(versionableNode, this.versionProperties);
        versions = this.versionService.getVersionHistory(versionableNode).getAllVersions();
        ArrayList<Version> newVersions = new ArrayList<Version>(versions.size());
        for (Version version : versions) {
            VersionServiceImplTest.assertFalse((boolean)version.getVersionLabel().equals("0"));
            newVersions.add(version);
        }
        VersionServiceImplTest.assertFalse((boolean)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL).toString().equals("0"));
        int i = 0;
        while (i < oldVersions.size()) {
            Version oldVersion = (Version)oldVersions.get(i);
            Version newVersion = (Version)newVersions.get(i + 1);
            VersionServiceImplTest.assertEquals((Object)oldVersion.getFrozenModifiedDate(), (Object)newVersion.getFrozenModifiedDate());
            VersionServiceImplTest.assertEquals((String)oldVersion.getVersionLabel(), (String)newVersion.getVersionLabel());
            String nodeDbidKey = ContentModel.PROP_NODE_DBID.getLocalName();
            VersionServiceImplTest.assertEquals((Object)oldVersion.getVersionProperty(nodeDbidKey), (Object)newVersion.getVersionProperty(nodeDbidKey));
            String nodeUuidKey = ContentModel.PROP_NODE_UUID.getLocalName();
            VersionServiceImplTest.assertEquals((Object)oldVersion.getVersionProperty(nodeUuidKey), (Object)newVersion.getVersionProperty(nodeUuidKey));
            ++i;
        }
    }

    @Test
    public void testVersioningAndAuditable() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (!this.authenticationDAO.userExists(USER_NAME_A)) {
            this.authenticationService.createAuthentication(USER_NAME_A, PWD_A.toCharArray());
        }
        NodeRef nodeA = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return (NodeRef)VersionServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    public NodeRef execute() throws Exception {
                        AuthenticationUtil.setFullyAuthenticatedUser((String)VersionServiceImplTest.USER_NAME_A);
                        NodeRef a = (this).VersionServiceImplTest.this.nodeService.createNode((this).VersionServiceImplTest.this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}NodeForA"), ContentModel.TYPE_CONTENT).getChildRef();
                        (this).VersionServiceImplTest.this.nodeService.addAspect(a, ContentModel.ASPECT_AUDITABLE, null);
                        return a;
                    }
                });
            }
        }, (String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_MODIFIER));
        VersionServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(nodeA, ContentModel.ASPECT_VERSIONABLE));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.versionService.createVersion(nodeA, null);
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_MODIFIER));
        VersionServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(nodeA, ContentModel.ASPECT_VERSIONABLE));
    }

    @Test
    public void testEnsureVersioningEnabled() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (!this.authenticationDAO.userExists(USER_NAME_A)) {
            this.authenticationService.createAuthentication(USER_NAME_A, PWD_A.toCharArray());
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        NodeRef none = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}None"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(none, ContentModel.ASPECT_AUDITABLE, null);
        NodeRef aspect = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}None"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(aspect, ContentModel.ASPECT_AUDITABLE, null);
        this.nodeService.addAspect(aspect, ContentModel.ASPECT_VERSIONABLE, null);
        this.nodeService.setProperty(aspect, ContentModel.PROP_AUTO_VERSION, (Serializable)Boolean.FALSE);
        this.nodeService.setProperty(aspect, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.TRUE);
        NodeRef versioned = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}None"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(versioned, ContentModel.ASPECT_AUDITABLE, null);
        this.nodeService.addAspect(versioned, ContentModel.ASPECT_VERSIONABLE, null);
        this.nodeService.setProperty(versioned, ContentModel.PROP_AUTO_VERSION, (Serializable)Boolean.TRUE);
        this.nodeService.setProperty(versioned, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.FALSE);
        this.versionService.createVersion(versioned, null);
        VersionServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(none, ContentModel.ASPECT_VERSIONABLE));
        VersionServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(aspect, ContentModel.ASPECT_VERSIONABLE));
        VersionServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(versioned, ContentModel.ASPECT_VERSIONABLE));
        VersionServiceImplTest.assertNull((Object)this.versionService.getVersionHistory(none));
        VersionServiceImplTest.assertNull((Object)this.versionService.getVersionHistory(aspect));
        VersionServiceImplTest.assertNotNull((Object)this.versionService.getVersionHistory(versioned));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(none, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(none, ContentModel.PROP_MODIFIER));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_MODIFIER));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_MODIFIER));
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_TITLE, "This shouldn't be set by the method");
        props.put(ContentModel.PROP_AUTO_VERSION, Boolean.TRUE);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.versionService.ensureVersioningEnabled(none, props);
        this.versionService.ensureVersioningEnabled(aspect, props);
        this.versionService.ensureVersioningEnabled(versioned, props);
        VersionServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(none, ContentModel.ASPECT_VERSIONABLE));
        VersionServiceImplTest.assertEquals((Object)Boolean.TRUE, (Object)this.nodeService.getProperty(none, ContentModel.PROP_AUTO_VERSION));
        VersionServiceImplTest.assertEquals((Object)Boolean.TRUE, (Object)this.nodeService.getProperty(none, ContentModel.PROP_AUTO_VERSION_PROPS));
        VersionServiceImplTest.assertEquals(null, (Object)this.nodeService.getProperty(none, ContentModel.PROP_TITLE));
        VersionServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(aspect, ContentModel.ASPECT_VERSIONABLE));
        VersionServiceImplTest.assertEquals((Object)Boolean.FALSE, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_AUTO_VERSION));
        VersionServiceImplTest.assertEquals((Object)Boolean.TRUE, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_AUTO_VERSION_PROPS));
        VersionServiceImplTest.assertEquals(null, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_TITLE));
        VersionServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(versioned, ContentModel.ASPECT_VERSIONABLE));
        VersionServiceImplTest.assertEquals((Object)Boolean.TRUE, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_AUTO_VERSION));
        VersionServiceImplTest.assertEquals((Object)Boolean.FALSE, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_AUTO_VERSION_PROPS));
        VersionServiceImplTest.assertEquals(null, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_TITLE));
        VersionServiceImplTest.assertNotNull((Object)this.versionService.getVersionHistory(none));
        VersionServiceImplTest.assertNotNull((Object)this.versionService.getVersionHistory(aspect));
        VersionServiceImplTest.assertNotNull((Object)this.versionService.getVersionHistory(versioned));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(none, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(none, ContentModel.PROP_MODIFIER));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(aspect, ContentModel.PROP_MODIFIER));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_CREATOR));
        VersionServiceImplTest.assertEquals((Object)USER_NAME_A, (Object)this.nodeService.getProperty(versioned, ContentModel.PROP_MODIFIER));
    }

    @Test
    public void testVersionLockedNode() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                NodeRef versionableNode = VersionServiceImplTest.this.createNewVersionableNode();
                VersionServiceImplTest.assertEquals((boolean)true, (boolean)VersionServiceImplTest.this.nodeService.hasAspect(versionableNode, ContentModel.ASPECT_VERSIONABLE));
                VersionServiceImplTest.this.dbNodeService.addAspect(versionableNode, ContentModel.ASPECT_LOCKABLE, new HashMap());
                VersionServiceImplTest.assertEquals((boolean)true, (boolean)VersionServiceImplTest.this.nodeService.hasAspect(versionableNode, ContentModel.ASPECT_LOCKABLE));
                VersionServiceImplTest.this.checkOutCheckInService.checkout(versionableNode);
                VersionServiceImplTest.this.createVersion(versionableNode);
                VersionHistory vh = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                VersionServiceImplTest.assertEquals((int)1, (int)vh.getAllVersions().size());
                return null;
            }
        });
    }

    public static void main(String ... args) {
        try {
            VersionServiceImplTest.doMain(args);
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error((Object)e);
            System.exit(1);
        }
    }

    private static void doMain(String ... args) {
        long start;
        if (args.length != 1) {
            System.out.println("Usage: VersionServiceImplTest fileCount");
            System.exit(1);
        }
        int fileCount = Integer.parseInt(args[0]);
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
        NodeService nodeService = serviceRegistry.getNodeService();
        VersionService versionService = serviceRegistry.getVersionService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        System.out.println("Using: " + versionService.getVersionStoreReference());
        StoreRef storeRef = new StoreRef("test", "VersionServiceImplTest-main-" + System.currentTimeMillis());
        if (!nodeService.exists(storeRef)) {
            nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        NodeRef folderNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test", (String)"versionMain"), ContentModel.TYPE_FOLDER).getChildRef();
        int count = 0;
        long lastReport = start = System.currentTimeMillis();
        int i = 0;
        while (i < fileCount) {
            fileFolderService.create(folderNodeRef, "file-" + i, ContentModel.TYPE_CONTENT);
            ++count;
            long now = System.currentTimeMillis();
            if (now - lastReport > 10000L) {
                long delta = now - start;
                double average = (double)delta / (double)count;
                System.out.println("File Creation: \n   Count:        " + count + " of " + fileCount + "\n" + "   Average (ms): " + average);
                lastReport = now;
            }
            ++i;
        }
        List files = fileFolderService.listFiles(folderNodeRef);
        count = 0;
        lastReport = start = System.currentTimeMillis();
        for (FileInfo fileInfo : files) {
            NodeRef nodeRef = fileInfo.getNodeRef();
            versionService.createVersion(nodeRef, null);
            ++count;
            long now = System.currentTimeMillis();
            if (now - lastReport <= 10000L) continue;
            long delta = now - start;
            double average = (double)delta / (double)count;
            System.out.println("Version: \n   Count:        " + count + " of " + fileCount + "\n" + "   Average (ms): " + average);
            lastReport = now;
        }
        System.out.println("Finished: " + fileCount);
    }

    @Test
    public void test_MNT10404() {
        String test_run = String.valueOf(System.currentTimeMillis());
        String test_user = "userUsageTestUser-" + test_run;
        String document_name = "test_MNT10404" + test_run + ".txt";
        NodeRef document = null;
        try {
            if (this.personService.personExists(test_user)) {
                this.personService.deletePerson(test_user);
            }
            HashMap<QName, String> properties = new HashMap<QName, String>();
            properties.put(ContentModel.PROP_USERNAME, test_user);
            NodeRef personNodeRef = this.personService.createPerson(properties);
            VersionServiceImplTest.assertNotNull((Object)personNodeRef);
            properties.clear();
            properties.put(ContentModel.PROP_NAME, document_name);
            document = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)document_name), ContentModel.TYPE_CONTENT, properties).getChildRef();
            this.contentService.getWriter(document, ContentModel.PROP_CONTENT, true).putContent("This is simple content.");
            this.permissionService.setPermission(document, test_user, "WriteContent", true);
            final NodeRef doc = document;
            AuthenticationUtil.RunAsWork<Void> getWork = new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    HashMap<QName, Object> versionProperties = new HashMap<QName, Object>();
                    versionProperties.put(ContentModel.PROP_VERSION_LABEL, "0.1");
                    versionProperties.put(ContentModel.PROP_INITIAL_VERSION, true);
                    versionProperties.put(ContentModel.PROP_VERSION_TYPE, VersionType.MINOR);
                    VersionServiceImplTest.this.nodeService.addAspect(doc, ContentModel.ASPECT_VERSIONABLE, versionProperties);
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getWork, (String)AuthenticationUtil.getSystemUserName());
            VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(document, ContentModel.ASPECT_VERSIONABLE));
            AuthenticationUtil.RunAsWork<Void> getWorkSetContent = new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    VersionServiceImplTest.this.contentService.getWriter(doc, ContentModel.PROP_CONTENT, true).putContent("Update content.");
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getWorkSetContent, (String)test_user);
            VersionServiceImplTest.assertTrue((boolean)"Update content.".equals(this.contentService.getReader(document, ContentModel.PROP_CONTENT).getContentString()));
        }
        catch (Throwable throwable) {
            if (this.personService.personExists(test_user)) {
                this.personService.deletePerson(test_user);
            }
            if (document != null && this.nodeService.exists(document)) {
                this.nodeService.deleteNode(document);
            }
            throw throwable;
        }
        if (this.personService.personExists(test_user)) {
            this.personService.deletePerson(test_user);
        }
        if (document != null && this.nodeService.exists(document)) {
            this.nodeService.deleteNode(document);
        }
    }

    @Test
    public void test_MNT14143() {
        NodeRef node = this.createNewNode();
        HashMap<QName, Boolean> verProperties = new HashMap<QName, Boolean>(1);
        verProperties.put(ContentModel.PROP_AUTO_VERSION_PROPS, false);
        this.versionService.ensureVersioningEnabled(node, verProperties);
        this.nodeService.addAspect(node, ContentModel.ASPECT_DUBLINCORE, null);
        this.nodeService.setProperty(node, ContentModel.PROP_SUBJECT, (Serializable)((Object)"Test subject"));
        Version version10 = this.versionService.getCurrentVersion(node);
        VersionServiceImplTest.assertEquals((String)"1.0", (String)version10.getVersionLabel());
        this.createVersion(node);
        Version version11 = this.versionService.getCurrentVersion(node);
        VersionServiceImplTest.assertEquals((String)"1.1", (String)version11.getVersionLabel());
        this.versionService.revert(node, version10);
        VersionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_DUBLINCORE));
        this.versionService.revert(node, version11);
        VersionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_DUBLINCORE));
    }

    @Test
    public void testbehaviourCreateVersion() throws Exception {
        this.behaviourVersionTestWork(false, false, false);
        this.assertBehaviourCreateVersionWithoutRevert();
    }

    @Test
    public void testbehaviourRevertVersion() throws Exception {
        this.behaviourVersionTestWork(true, false, false);
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.AfterCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.AfterCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.OnCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.OnCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.AfterVersionRevertPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.AfterVersionRevertPolicy.QNAME));
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.OnRevertVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)3, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.OnRevertVersionPolicy.QNAME));
    }

    @Test
    public void testbehaviourCreateVersionDisableNode() throws Exception {
        this.behaviourVersionTestWork(false, true, true);
        this.assertBehaviourCreateVersionDisable();
    }

    @Test
    public void testbehaviourCreateVersionDisable() throws Exception {
        this.behaviourVersionTestWork(false, true, false);
        this.assertBehaviourCreateVersionDisable();
    }

    private void assertBehaviourCreateVersionDisable() {
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.AfterCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.AfterCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.OnCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.OnCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.AfterVersionRevertPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.AfterVersionRevertPolicy.QNAME));
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.OnRevertVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.OnRevertVersionPolicy.QNAME));
    }

    @Test
    public void testbehaviourRevertVersionDisableNode() throws Exception {
        this.behaviourVersionTestWork(true, true, true);
        this.assertBehaviourCreateVersionWithoutRevert();
    }

    @Test
    public void testbehaviourRevertVersionDisable() throws Exception {
        this.behaviourVersionTestWork(true, true, false);
        this.assertBehaviourCreateVersionWithoutRevert();
    }

    private void assertBehaviourCreateVersionWithoutRevert() {
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.AfterCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.AfterCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertTrue((String)"Behavior should be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.OnCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)1, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.OnCreateVersionPolicy.QNAME));
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.AfterVersionRevertPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.AfterVersionRevertPolicy.QNAME));
        VersionServiceImplTest.assertFalse((String)"Behavior should not be executed", (boolean)this.versionBehavior.isExecuted(VersionServicePolicies.OnRevertVersionPolicy.QNAME));
        VersionServiceImplTest.assertEquals((int)0, (int)this.versionBehavior.getExecutionCount(VersionServicePolicies.OnRevertVersionPolicy.QNAME));
    }

    private void behaviourVersionTestWork(boolean revert, boolean disableBehaviour, boolean disableBehaviourNode) throws Exception {
        UserTransaction transaction = this.transactionService.getUserTransaction();
        try {
            transaction.begin();
            NodeRef nodeRef = this.createNode(false, BaseVersionStoreTest.TEST_TYPE_QNAME);
            if (revert) {
                this.createVersion(nodeRef);
            }
            if (disableBehaviour) {
                if (disableBehaviourNode) {
                    this.policyBehaviourFilter.disableBehaviour(nodeRef, BaseVersionStoreTest.TEST_TYPE_QNAME);
                } else {
                    this.policyBehaviourFilter.disableBehaviour(BaseVersionStoreTest.TEST_TYPE_QNAME);
                }
            }
            try {
                if (revert) {
                    this.versionService.revert(nodeRef);
                } else {
                    this.createVersion(nodeRef);
                }
            }
            finally {
                if (disableBehaviour) {
                    if (disableBehaviourNode) {
                        this.policyBehaviourFilter.enableBehaviour(nodeRef, BaseVersionStoreTest.TEST_TYPE_QNAME);
                    } else {
                        this.policyBehaviourFilter.enableBehaviour(BaseVersionStoreTest.TEST_TYPE_QNAME);
                    }
                }
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public class TestVersionPolicy
    implements VersionServicePolicies.BeforeCreateVersionPolicy,
    VersionServicePolicies.AfterCreateVersionPolicy,
    VersionServicePolicies.OnCreateVersionPolicy,
    VersionServicePolicies.AfterVersionRevertPolicy,
    VersionServicePolicies.OnRevertVersionPolicy {
        private Map<QName, Boolean> executed;
        private Map<QName, Integer> executionCount;

        protected void execute(QName className) {
            this.executed = Optional.ofNullable(this.executed).orElseGet(HashMap::new);
            this.executed.put(className, true);
            this.executionCount = Optional.ofNullable(this.executionCount).orElseGet(HashMap::new);
            this.executionCount.merge(className, 1, Integer::sum);
        }

        public boolean isExecuted(QName className) {
            this.executed = Optional.ofNullable(this.executed).orElseGet(HashMap::new);
            return this.executed.getOrDefault(className, false);
        }

        public int getExecutionCount(QName className) {
            this.executionCount = Optional.ofNullable(this.executionCount).orElseGet(HashMap::new);
            return this.executionCount.getOrDefault(className, 0);
        }

        public void beforeCreateVersion(NodeRef versionableNode) {
            this.execute(VersionServicePolicies.BeforeCreateVersionPolicy.QNAME);
        }

        public void afterCreateVersion(NodeRef versionableNode, Version version) {
            this.execute(VersionServicePolicies.AfterCreateVersionPolicy.QNAME);
        }

        public void onCreateVersion(QName classRef, NodeRef versionableNode, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
            this.execute(VersionServicePolicies.OnCreateVersionPolicy.QNAME);
        }

        public void afterVersionRevert(NodeRef nodeRef, Version version) {
            this.execute(VersionServicePolicies.AfterVersionRevertPolicy.QNAME);
        }

        public VersionRevertCallback getRevertVersionCallback(QName classRef, VersionRevertDetails copyDetails) {
            this.execute(VersionServicePolicies.OnRevertVersionPolicy.QNAME);
            return null;
        }
    }
}

