/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.function.Supplier;
import org.junit.Assert;

public class TestHelper {
    public static void assertThrows(Runnable action, Class<?> expectedException, String failMessage) {
        try {
            action.run();
        }
        catch (Throwable ex) {
            Assert.assertTrue((String)("The caught exception [" + ex.getClass().getSimpleName() + "] is not the expected exception:" + expectedException.getSimpleName()), (boolean)expectedException.isInstance(ex));
            return;
        }
        Assert.fail((String)(String.valueOf(failMessage) + " So failed to throw expected exception: " + expectedException.getSimpleName()));
    }

    public static <T> T waitBeforeRetry(Supplier<T> supplier, T requiredResult, int maxRetry, long waitTimeInMillis) throws InterruptedException {
        T t;
        int retryCount = 0;
        do {
            Thread.sleep(waitTimeInMillis);
            t = supplier.get();
            if (!requiredResult.equals(t)) continue;
            return t;
        } while (++retryCount < maxRetry);
        return t;
    }
}

