/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.email.server.AliasableAspectCopyBehaviourCallback;
import org.alfresco.email.server.EmailServerModel;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.attributes.DuplicateAttributeException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AliasableAspect
implements NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.BeforeRemoveAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
CopyServicePolicies.OnCopyNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private AttributeService attributeService;
    private static Log logger = LogFactory.getLog(AliasableAspect.class);
    public static final String ALIASABLE_ATTRIBUTE_KEY_1 = "AliasableAspect";
    public static final String ALIASABLE_ATTRIBUTE_KEY_2 = "Alias";
    private static final String ERROR_MSG_DUPLICATE_ALIAS = "email.server.err.duplicate_alias";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"attributeService", (Object)this.attributeService);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.FIRST_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeRemoveAspectPolicy.QNAME, EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "beforeRemoveAspect", Behaviour.NotificationFrequency.FIRST_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
    }

    public static String normaliseAlias(String value) {
        if (value != null) {
            return value.toLowerCase();
        }
        return value;
    }

    public void addAlias(NodeRef nodeRef, String alias) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("add email alias nodeRef:" + nodeRef + ", alias:" + alias));
        }
        try {
            this.attributeService.createAttribute((Serializable)nodeRef, new Serializable[]{ALIASABLE_ATTRIBUTE_KEY_1, ALIASABLE_ATTRIBUTE_KEY_2, AliasableAspect.normaliseAlias(alias)});
        }
        catch (DuplicateAttributeException duplicateAttributeException) {
            throw AlfrescoRuntimeException.create((String)ERROR_MSG_DUPLICATE_ALIAS, (Object[])new Object[]{AliasableAspect.normaliseAlias(alias)});
        }
    }

    public void removeAlias(String alias) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove email alias alias:" + alias));
        }
        this.attributeService.removeAttribute(new Serializable[]{ALIASABLE_ATTRIBUTE_KEY_1, ALIASABLE_ATTRIBUTE_KEY_2, AliasableAspect.normaliseAlias(alias)});
    }

    public NodeRef getByAlias(String alias) {
        Serializable value = this.attributeService.getAttribute(new Serializable[]{ALIASABLE_ATTRIBUTE_KEY_1, ALIASABLE_ATTRIBUTE_KEY_2, AliasableAspect.normaliseAlias(alias)});
        if (value instanceof NodeRef) {
            return (NodeRef)value;
        }
        return null;
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        Serializable alias = this.nodeService.getProperty(nodeRef, EmailServerModel.PROP_ALIAS);
        if (alias != null) {
            this.addAlias(nodeRef, alias.toString());
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String oldAlias = (String)((Object)before.get(EmailServerModel.PROP_ALIAS));
        String newAlias = (String)((Object)after.get(EmailServerModel.PROP_ALIAS));
        if (oldAlias != null && newAlias != null && AliasableAspect.normaliseAlias(oldAlias).equals(AliasableAspect.normaliseAlias(newAlias))) {
            return;
        }
        if (newAlias != null) {
            this.addAlias(nodeRef, newAlias);
        }
        if (oldAlias != null) {
            this.removeAlias(oldAlias);
        }
    }

    @Override
    public void beforeRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        String alias = (String)((Object)this.nodeService.getProperty(nodeRef, EmailServerModel.PROP_ALIAS));
        if (alias != null) {
            this.removeAlias(alias);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String alias = (String)((Object)this.nodeService.getProperty(nodeRef, EmailServerModel.PROP_ALIAS));
        if (alias != null) {
            this.removeAlias(alias);
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return AliasableAspectCopyBehaviourCallback.INSTANCE;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public AttributeService getAttributeService() {
        return this.attributeService;
    }
}

