/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;

public class PropertyParameterConstraint
extends BaseParameterConstraint {
    public static final String NAME = "ac-properties";
    private DictionaryService dictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        Collection properties = this.dictionaryService.getAllProperties(null);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(properties.size());
        for (QName property : properties) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(property);
            if (propertyDef == null || propertyDef.getTitle((MessageLookup)this.dictionaryService) == null) continue;
            result.put(property.toPrefixString(), propertyDef.getTitle((MessageLookup)this.dictionaryService));
        }
        return result;
    }
}

