/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentMetadataExtracter
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(ContentMetadataExtracter.class);
    public static final String EXECUTOR_NAME = "extract-metadata";
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private TaggingService taggingService;
    private MetadataExtracterRegistry metadataExtracterRegistry;
    private boolean carryAspectProperties = true;
    private boolean enableStringTagging = false;
    public static final List<String> DEFAULT_STRING_TAGGING_SEPARATORS = Arrays.asList(",", ";", "\\|");
    protected List<String> stringTaggingSeparators = DEFAULT_STRING_TAGGING_SEPARATORS;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictService) {
        this.dictionaryService = dictService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setMetadataExtracterRegistry(MetadataExtracterRegistry metadataExtracterRegistry) {
        this.metadataExtracterRegistry = metadataExtracterRegistry;
    }

    public void setCarryAspectProperties(boolean carryAspectProperties) {
        this.carryAspectProperties = carryAspectProperties;
    }

    public void setEnableStringTagging(boolean enableStringTagging) {
        this.enableStringTagging = enableStringTagging;
    }

    public void setStringTaggingSeparators(List<String> stringTaggingSeparators) {
        this.stringTaggingSeparators = stringTaggingSeparators;
    }

    protected void addTags(NodeRef actionedUponNodeRef, PropertyDefinition propertyDef, Serializable rawValue) {
        ContentMetadataExtracter.addTags(actionedUponNodeRef, propertyDef, rawValue, this.nodeService, this.stringTaggingSeparators, this.taggingService);
    }

    private static void addTags(NodeRef actionedUponNodeRef, PropertyDefinition propertyDef, Serializable rawValue, NodeService nodeService, List<String> stringTaggingSeparators, TaggingService taggingService) {
        block17: {
            if (rawValue == null) {
                return;
            }
            ArrayList<String> tags = new ArrayList<String>();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("converting " + rawValue + " of type " + rawValue.getClass().getCanonicalName() + " to tags"));
            }
            if (rawValue instanceof Collection) {
                for (Object singleValue : (Collection)((Object)rawValue)) {
                    if (singleValue instanceof String) {
                        if (NodeRef.isNodeRef((String)((String)singleValue))) {
                            Serializable convertedPropertyValue = (Serializable)DefaultTypeConverter.INSTANCE.convert(propertyDef.getDataType(), (Object)((String)singleValue));
                            try {
                                NodeRef nodeRef = (NodeRef)convertedPropertyValue;
                                String tagName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("adding string tag name'" + tagName + "' (from tag nodeRef " + nodeRef + ") to " + actionedUponNodeRef));
                                }
                                tags.addAll(ContentMetadataExtracter.splitTag(tagName, stringTaggingSeparators));
                            }
                            catch (InvalidNodeRefException e) {
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn((Object)("tag nodeRef Invalid: " + e.getMessage()));
                            }
                            continue;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("adding string tag name'" + singleValue + "' to " + actionedUponNodeRef));
                        }
                        tags.addAll(ContentMetadataExtracter.splitTag((String)singleValue, stringTaggingSeparators));
                        continue;
                    }
                    if (!(singleValue instanceof NodeRef)) continue;
                    NodeRef nodeRef = (NodeRef)singleValue;
                    String tagName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("adding string tag name'" + tagName + "' (for nodeRef " + nodeRef + ") to " + actionedUponNodeRef));
                    }
                    tags.addAll(ContentMetadataExtracter.splitTag(tagName, stringTaggingSeparators));
                }
            } else if (rawValue instanceof String) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("adding string tag name'" + (String)((Object)rawValue) + "' to " + actionedUponNodeRef));
                }
                tags.addAll(ContentMetadataExtracter.splitTag((String)((Object)rawValue), stringTaggingSeparators));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("adding tags '" + tags + "' to " + actionedUponNodeRef));
            }
            try {
                taggingService.addTags(actionedUponNodeRef, tags);
            }
            catch (IllegalArgumentException iae) {
                if (!logger.isWarnEnabled()) break block17;
                logger.warn((Object)("Cannot add tags '" + tags + "' - " + iae.getMessage()));
            }
        }
    }

    protected List<String> splitTag(String str) {
        return ContentMetadataExtracter.splitTag(str, this.stringTaggingSeparators);
    }

    private static List<String> splitTag(String str, List<String> stringTaggingSeparators) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null && !str.equals("")) {
            result.add(str.trim());
            if (stringTaggingSeparators != null) {
                for (String sep : stringTaggingSeparators) {
                    ArrayList<String> splitTags = new ArrayList<String>(result.size());
                    for (String tag : result) {
                        String[] parts;
                        String[] stringArray = parts = tag.split(sep);
                        int n = parts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String part = stringArray[n2];
                            splitTags.add(part.trim());
                            ++n2;
                        }
                    }
                    result = splitTags;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isExecuteAsynchronously(NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return false;
        }
        ContentReader reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
        if (reader == null || reader.getMimetype() == null) {
            return false;
        }
        String mimetype = reader.getMimetype();
        long sourceSizeInBytes = reader.getSize();
        MetadataExtracter extracter = this.metadataExtracterRegistry.getExtractor(mimetype, sourceSizeInBytes);
        return extracter instanceof AsynchronousExtractor;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        long sourceSizeInBytes;
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return;
        }
        ContentReader reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
        if (reader == null || reader.getMimetype() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no content or mimetype - do nothing");
            }
            return;
        }
        String mimetype = reader.getMimetype();
        MetadataExtracter extracter = this.metadataExtracterRegistry.getExtractor(mimetype, sourceSizeInBytes = reader.getSize());
        if (extracter == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("no extracter for mimetype:" + mimetype));
            }
            return;
        }
        if (this.enableStringTagging && extracter instanceof AbstractMappingMetadataExtracter) {
            ((AbstractMappingMetadataExtracter)extracter).setEnableStringTagging(this.enableStringTagging);
        }
        Map nodeProperties = this.nodeService.getProperties(actionedUponNodeRef);
        Map<QName, Serializable> modifiedProperties = null;
        try {
            modifiedProperties = extracter.extract(actionedUponNodeRef, reader, (Map<QName, Serializable>)nodeProperties);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Raw metadata extraction failed: \n   Extracter: " + this + "\n" + "   Node:      " + actionedUponNodeRef + "\n" + "   Content:   " + reader), e);
            } else {
                logger.warn((Object)("Raw metadata extraction failed (turn on DEBUG for full error): \n   Extracter: " + this + "\n" + "   Node:      " + actionedUponNodeRef + "\n" + "   Content:   " + reader + "\n" + "   Failure:   " + e.getMessage()));
            }
            modifiedProperties = new HashMap<QName, Serializable>(0);
        }
        if (modifiedProperties.size() == 0) {
            return;
        }
        ContentMetadataExtracter.addExtractedMetadataToNode(actionedUponNodeRef, nodeProperties, modifiedProperties, this.nodeService, this.dictionaryService, this.taggingService, this.enableStringTagging, this.carryAspectProperties, this.stringTaggingSeparators);
    }

    public static void addExtractedMetadataToNode(NodeRef actionedUponNodeRef, Map<QName, Serializable> nodeProperties, Map<QName, Serializable> modifiedProperties, NodeService nodeService, DictionaryService dictionaryService, TaggingService taggingService, boolean enableStringTagging, boolean carryAspectProperties, List<String> stringTaggingSeparators) {
        HashSet<QName> requiredAspectQNames = new HashSet<QName>(3);
        HashSet aspectPropertyQNames = new HashSet(17);
        for (QName propertyQName : modifiedProperties.keySet()) {
            ClassDefinition propertyContainerDef;
            PropertyDefinition propertyDef = dictionaryService.getProperty(propertyQName);
            if (propertyDef == null || !(propertyContainerDef = propertyDef.getContainerClass()).isAspect()) continue;
            if (enableStringTagging && propertyContainerDef.getName().equals((Object)ContentModel.ASPECT_TAGGABLE)) {
                Serializable oldValue = nodeProperties.get(propertyQName);
                ContentMetadataExtracter.addTags(actionedUponNodeRef, propertyDef, oldValue, nodeService, stringTaggingSeparators, taggingService);
                nodeProperties.put(ContentModel.PROP_TAGS, nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_TAGS));
                continue;
            }
            QName aspectQName = propertyContainerDef.getName();
            requiredAspectQNames.add(aspectQName);
            Set aspectProperties = propertyContainerDef.getProperties().keySet();
            aspectPropertyQNames.addAll(aspectProperties);
        }
        if (!carryAspectProperties) {
            for (QName aspectPropertyQName : aspectPropertyQNames) {
                if (!modifiedProperties.containsKey(aspectPropertyQName)) {
                    nodeProperties.remove(aspectPropertyQName);
                    continue;
                }
                if (modifiedProperties.get(aspectPropertyQName) != null) continue;
                nodeProperties.remove(aspectPropertyQName);
            }
        }
        nodeService.setProperties(actionedUponNodeRef, nodeProperties);
        for (QName requiredAspectQName : requiredAspectQNames) {
            if (nodeService.hasAspect(actionedUponNodeRef, requiredAspectQName)) continue;
            nodeService.addAspect(actionedUponNodeRef, requiredAspectQName, null);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> arg0) {
    }
}

