/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure1;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure11;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure13;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure15;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure17;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure19;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure3;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure5;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure7;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl$AjcClosure9;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.coci.traitextender.CheckOutCheckInServiceExtension;
import org.alfresco.repo.coci.traitextender.CheckOutCheckInServiceTrait;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.extensions.surf.util.I18NUtil;

public class CheckOutCheckInServiceImpl
implements CheckOutCheckInService,
Extensible {
    private static final String MSG_ERR_BAD_COPY = "coci_service.err_bad_copy";
    private static final String MSG_WORKING_COPY_LABEL = "coci_service.working_copy_label";
    private static final String MSG_ERR_NOT_OWNER = "coci_service.err_not_owner";
    private static final String MSG_ERR_ALREADY_WORKING_COPY = "coci_service.err_workingcopy_checkout";
    private static final String MSG_ERR_NOT_AUTHENTICATED = "coci_service.err_not_authenticated";
    private static final String MSG_ERR_WORKINGCOPY_HAS_NO_CONTENT = "coci_service.err_workingcopy_has_no_content";
    private static final String MSG_ALREADY_CHECKEDOUT = "coci_service.err_already_checkedout";
    private static final String MSG_ERR_CANNOT_RENAME = "coci_service.err_cannot_rename";
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCheckOut> beforeCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCheckOut> onCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCheckIn> beforeCheckIn;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCheckIn> onCheckIn;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCancelCheckOut> beforeCancelCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCancelCheckOut> onCancelCheckOut;
    private static final String EXTENSION_CHARACTER = ".";
    private static Log logger;
    private NodeService nodeService;
    private VersionService versionService;
    private LockService lockService;
    private CopyService copyService;
    private FileFolderService fileFolderService;
    private OwnableService ownableService;
    private PolicyComponent policyComponent;
    private AuthenticationService authenticationService;
    private RuleService ruleService;
    private BehaviourFilter behaviourFilter;
    private final ExtendedTrait<CheckOutCheckInServiceTrait> checkOutCheckInServiceTrait = new ExtendedTrait<CheckOutCheckInServiceTrait>(AJProxyTrait.create(this, CheckOutCheckInServiceTrait.class));
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;

    static {
        CheckOutCheckInServiceImpl.ajc$preClinit();
        logger = LogFactory.getLog(CheckOutCheckInServiceImpl.class);
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.beforeCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckOut.class);
        this.onCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCheckOut.class);
        this.beforeCheckIn = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckIn.class);
        this.onCheckIn = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCheckIn.class);
        this.beforeCancelCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCancelCheckOut.class);
        this.onCancelCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCancelCheckOut.class);
    }

    private List<QName> getInvokeClasses(NodeRef nodeRef) {
        ArrayList<QName> result = new ArrayList<QName>(10);
        result.add(this.nodeService.getType(nodeRef));
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            result.add(aspect);
        }
        return result;
    }

    private void invokeBeforeCheckOut(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCheckOut> policies = this.beforeCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCheckOut policy : policies) {
                policy.beforeCheckOut(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
            }
        }
    }

    private void invokeOnCheckOut(NodeRef workingCopy) {
        List<QName> classes = this.getInvokeClasses(workingCopy);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCheckOut> policies = this.onCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCheckOut policy : policies) {
                policy.onCheckOut(workingCopy);
            }
        }
    }

    private void invokeBeforeCheckIn(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        List<QName> classes = this.getInvokeClasses(workingCopyNodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCheckIn> policies = this.beforeCheckIn.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCheckIn policy : policies) {
                policy.beforeCheckIn(workingCopyNodeRef, versionProperties, contentUrl, keepCheckedOut);
            }
        }
    }

    private void invokeOnCheckIn(NodeRef nodeRef) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCheckIn> policies = this.onCheckIn.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCheckIn policy : policies) {
                policy.onCheckIn(nodeRef);
            }
        }
    }

    private void invokeBeforeCancelCheckOut(NodeRef workingCopy) {
        List<QName> classes = this.getInvokeClasses(workingCopy);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCancelCheckOut> policies = this.beforeCancelCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCancelCheckOut policy : policies) {
                policy.beforeCancelCheckOut(workingCopy);
            }
        }
    }

    private void invokeOnCancelCheckOut(NodeRef nodeRef) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCancelCheckOut> policies = this.onCancelCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCancelCheckOut policy : policies) {
                policy.onCancelCheckOut(nodeRef);
            }
        }
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef checkout(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("checkout", NodeRef.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef checkout(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        NodeRef nodeRef2 = nodeRef;
        NodeRef nodeRef3 = destinationParentNodeRef;
        QName qName = destinationAssocTypeQName;
        QName qName2 = destinationAssocQName;
        Object[] objectArray = new Object[]{nodeRef2, nodeRef3, qName, qName2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, nodeRef3, qName, qName2, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("checkout", NodeRef.class, NodeRef.class, QName.class, QName.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private NodeRef doCheckout(final NodeRef nodeRef, final NodeRef destinationParentNodeRef, final QName destinationAssocTypeQName, QName destinationAssocQName) {
        this.invokeBeforeCheckOut(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
        final String userName = this.getUserName();
        NodeRef workingCopy = null;
        this.ruleService.disableRuleType("update");
        try {
            String copyName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            String workingCopyLabel = CheckOutCheckInServiceImpl.getWorkingCopyLabel();
            copyName = CheckOutCheckInServiceImpl.createWorkingCopyName(copyName, workingCopyLabel);
            final QName copyQName = QName.createQName((String)destinationAssocQName.getNamespaceURI(), (String)QName.createValidLocalName((String)copyName));
            ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
            workingCopy = destinationParentNodeRef.equals((Object)childAssocRef.getParentRef()) ? (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef copy = CheckOutCheckInServiceImpl.this.copyService.copy(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, copyQName);
                    CheckOutCheckInServiceImpl.this.ownableService.setOwner(copy, userName);
                    return copy;
                }
            }, (String)AuthenticationUtil.getSystemUserName()) : this.copyService.copy(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, copyQName);
            this.nodeService.setProperty(workingCopy, ContentModel.PROP_NAME, (Serializable)((Object)copyName));
            HashMap<QName, String> workingCopyProperties = new HashMap<QName, String>(1);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_OWNER, userName);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_LABEL, workingCopyLabel);
            this.nodeService.addAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY, workingCopyProperties);
            this.nodeService.addAspect(workingCopy, ContentModel.ASPECT_LOCKABLE, null);
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT, null);
            this.nodeService.createAssociation(nodeRef, workingCopy, ContentModel.ASSOC_WORKING_COPY_LINK);
            this.nodeService.removeAspect(workingCopy, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT);
        }
        finally {
            this.ruleService.enableRuleType("update");
        }
        this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        this.invokeOnCheckOut(workingCopy);
        return workingCopy;
    }

    private String getUserName() {
        String un = this.authenticationService.getCurrentUserName();
        if (un != null) {
            return un;
        }
        throw new CheckOutCheckInServiceException(MSG_ERR_NOT_AUTHENTICATED);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties) {
        NodeRef nodeRef = workingCopyNodeRef;
        Map<String, Serializable> map = versionProperties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nodeRef, map);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, map, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("checkin", NodeRef.class, Map.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl) {
        NodeRef nodeRef = workingCopyNodeRef;
        Map<String, Serializable> map = versionProperties;
        String string = contentUrl;
        Object[] objectArray = new Object[]{nodeRef, map, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, map, string, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("checkin", NodeRef.class, Map.class, String.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        NodeRef nodeRef = workingCopyNodeRef;
        Map<String, Serializable> map = versionProperties;
        String string = contentUrl;
        boolean bl = keepCheckedOut;
        Object[] objectArray = new Object[]{nodeRef, map, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, map, string, Conversions.booleanObject((boolean)bl), joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("checkin", NodeRef.class, Map.class, String.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef cancelCheckout(NodeRef workingCopyNodeRef) {
        NodeRef nodeRef = workingCopyNodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nodeRef);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("cancelCheckout", NodeRef.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef getWorkingCopy(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("getWorkingCopy", NodeRef.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public NodeRef getCheckedOut(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("getCheckedOut", NodeRef.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public boolean isWorkingCopy(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("isWorkingCopy", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=CheckOutCheckInServiceTrait.class, extensionAPI=CheckOutCheckInServiceExtension.class)
    public boolean isCheckedOut(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CheckOutCheckInServiceImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = CheckOutCheckInServiceImpl.class.getDeclaredMethod("isCheckedOut", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    public static String createWorkingCopyName(String name, String workingCopyLabel) {
        if (workingCopyLabel != null && workingCopyLabel.length() != 0) {
            int index;
            name = name != null && name.length() != 0 ? ((index = name.lastIndexOf(EXTENSION_CHARACTER)) > 0 ? String.valueOf(name.substring(0, index)) + " " + workingCopyLabel + name.substring(index) : String.valueOf(name) + " " + workingCopyLabel) : workingCopyLabel;
        } else {
            throw new IllegalArgumentException("workingCopyLabel is null or empty");
        }
        return name;
    }

    private String getNameFromWorkingCopyName(String workingCopyName, String workingCopyLabel) {
        String workingCopyLabelRegEx = workingCopyLabel.replaceAll("\\(", "\\\\(");
        workingCopyLabelRegEx = workingCopyLabelRegEx.replaceAll("\\)", "\\\\)");
        if (workingCopyName.contains(" " + workingCopyLabel)) {
            workingCopyName = workingCopyName.replaceFirst(" " + workingCopyLabelRegEx, "");
        } else if (workingCopyName.contains(workingCopyLabel)) {
            workingCopyName = workingCopyName.replaceFirst(workingCopyLabelRegEx, "");
        }
        return workingCopyName;
    }

    private boolean hasWorkingCopyNameChanged(String workingCopyName, String origName, String wcLabel) {
        String origWorkingCopyName = CheckOutCheckInServiceImpl.createWorkingCopyName(origName, wcLabel);
        return !workingCopyName.equals(origWorkingCopyName);
    }

    public static String getWorkingCopyLabel() {
        return I18NUtil.getMessage((String)MSG_WORKING_COPY_LABEL);
    }

    @Override
    public <T extends Trait> ExtendedTrait<T> getTrait(Class<? extends T> traitAPI) {
        return this.checkOutCheckInServiceTrait;
    }

    static final /* synthetic */ NodeRef checkout_aroundBody0(CheckOutCheckInServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        ChildAssociationRef childAssocRef = ajc$this.nodeService.getPrimaryParent(nodeRef);
        return ajc$this.checkout(nodeRef, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
    }

    static final /* synthetic */ NodeRef checkout_aroundBody2(CheckOutCheckInServiceImpl ajc$this, NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName, JoinPoint joinPoint) {
        if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
            throw new CheckOutCheckInServiceException(MSG_ALREADY_CHECKEDOUT);
        }
        if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new CheckOutCheckInServiceException(MSG_ERR_ALREADY_WORKING_COPY);
        }
        LockStatus lockStatus = ajc$this.lockService.getLockStatus(nodeRef);
        if (lockStatus != LockStatus.NO_LOCK && lockStatus != LockStatus.LOCK_EXPIRED) {
            throw new NodeLockedException(nodeRef);
        }
        ajc$this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        ajc$this.behaviourFilter.disableBehaviour(destinationParentNodeRef, ContentModel.ASPECT_AUDITABLE);
        try {
            NodeRef nodeRef2 = ajc$this.doCheckout(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
            return nodeRef2;
        }
        finally {
            ajc$this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            ajc$this.behaviourFilter.enableBehaviour(destinationParentNodeRef, ContentModel.ASPECT_AUDITABLE);
        }
    }

    static final /* synthetic */ NodeRef checkin_aroundBody4(CheckOutCheckInServiceImpl ajc$this, NodeRef workingCopyNodeRef, Map versionProperties, JoinPoint joinPoint) {
        return ajc$this.checkin(workingCopyNodeRef, versionProperties, null, false);
    }

    static final /* synthetic */ NodeRef checkin_aroundBody6(CheckOutCheckInServiceImpl ajc$this, NodeRef workingCopyNodeRef, Map versionProperties, String contentUrl, JoinPoint joinPoint) {
        return ajc$this.checkin(workingCopyNodeRef, versionProperties, contentUrl, false);
    }

    static final /* synthetic */ NodeRef checkin_aroundBody8(CheckOutCheckInServiceImpl ajc$this, NodeRef workingCopyNodeRef, Map versionProperties, String contentUrl, boolean keepCheckedOut, JoinPoint joinPoint) {
        if (!ajc$this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        NodeRef nodeRef = ajc$this.getCheckedOut(workingCopyNodeRef);
        if (nodeRef == null) {
            throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
        }
        ajc$this.invokeBeforeCheckIn(workingCopyNodeRef, versionProperties, contentUrl, keepCheckedOut);
        try {
            if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                ajc$this.lockService.unlock(nodeRef, false, true);
            }
        }
        catch (UnableToReleaseLockException exception) {
            throw new CheckOutCheckInServiceException(MSG_ERR_NOT_OWNER, exception);
        }
        if (contentUrl != null) {
            ContentData contentData = (ContentData)ajc$this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_CONTENT);
            if (contentData == null) {
                throw new AlfrescoRuntimeException(MSG_ERR_WORKINGCOPY_HAS_NO_CONTENT, new Object[]{workingCopyNodeRef});
            }
            contentData = new ContentData(contentUrl, contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
            ajc$this.nodeService.setProperty(workingCopyNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
        }
        ajc$this.copyService.copy(workingCopyNodeRef, nodeRef);
        if (ajc$this.fileFolderService.getFileInfo(workingCopyNodeRef) != null) {
            String origName = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            String name = (String)((Object)ajc$this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_NAME));
            String wcLabel = (String)((Object)ajc$this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_WORKING_COPY_LABEL));
            if (wcLabel == null) {
                wcLabel = CheckOutCheckInServiceImpl.getWorkingCopyLabel();
            }
            if (ajc$this.hasWorkingCopyNameChanged(name, origName, wcLabel)) {
                if (!name.contains(" " + wcLabel)) {
                    try {
                        ajc$this.fileFolderService.rename(workingCopyNodeRef, CheckOutCheckInServiceImpl.createWorkingCopyName(name, wcLabel));
                    }
                    catch (FileExistsException e) {
                        throw new CheckOutCheckInServiceException((Throwable)((Object)e), MSG_ERR_CANNOT_RENAME, name, wcLabel);
                    }
                    catch (FileNotFoundException e) {
                        throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, wcLabel);
                    }
                }
                String newName = ajc$this.getNameFromWorkingCopyName(name, wcLabel);
                try {
                    ajc$this.fileFolderService.rename(nodeRef, newName);
                }
                catch (FileExistsException e) {
                    throw new CheckOutCheckInServiceException((Throwable)((Object)e), MSG_ERR_CANNOT_RENAME, origName, newName);
                }
                catch (FileNotFoundException e) {
                    throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, newName);
                }
            }
        }
        if (versionProperties != null && ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && !ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT)) {
            ajc$this.versionService.createVersion(nodeRef, (Map<String, Serializable>)versionProperties);
        }
        ajc$this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT);
        if (!keepCheckedOut) {
            ajc$this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            ajc$this.behaviourFilter.disableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
            try {
                ajc$this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT);
                ajc$this.nodeService.deleteNode(workingCopyNodeRef);
            }
            finally {
                ajc$this.behaviourFilter.enableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
                ajc$this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        } else {
            ajc$this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        }
        ajc$this.invokeOnCheckIn(nodeRef);
        return nodeRef;
    }

    static final /* synthetic */ NodeRef cancelCheckout_aroundBody10(CheckOutCheckInServiceImpl ajc$this, NodeRef workingCopyNodeRef, JoinPoint joinPoint) {
        if (!ajc$this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        NodeRef nodeRef = ajc$this.getCheckedOut(workingCopyNodeRef);
        if (nodeRef == null) {
            throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
        }
        ajc$this.invokeBeforeCancelCheckOut(workingCopyNodeRef);
        ajc$this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        ajc$this.behaviourFilter.disableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
        ajc$this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT);
        try {
            try {
                if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                    ajc$this.lockService.unlock(nodeRef, false, true);
                }
                ajc$this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT);
                ajc$this.nodeService.deleteNode(workingCopyNodeRef);
                ajc$this.invokeOnCancelCheckOut(nodeRef);
                if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT)) {
                    ajc$this.nodeService.deleteNode(nodeRef);
                }
            }
            catch (UnableToReleaseLockException exception) {
                throw new CheckOutCheckInServiceException(MSG_ERR_NOT_OWNER, exception);
            }
        }
        finally {
            ajc$this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            ajc$this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT);
        }
        return nodeRef;
    }

    static final /* synthetic */ NodeRef getWorkingCopy_aroundBody12(CheckOutCheckInServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        NodeRef workingCopy = null;
        if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
            List assocs = ajc$this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
            if (assocs.size() == 0) {
                logger.warn((Object)("Found node with cm:checkedOut aspect but no association.  Current node state: " + ajc$this.nodeService.getNodeStatus(nodeRef)));
            } else if (assocs.size() > 1) {
                logger.warn((Object)("Found multiple " + ContentModel.ASSOC_WORKING_COPY_LINK + " association from node: " + nodeRef));
            } else {
                workingCopy = ((AssociationRef)assocs.get(0)).getTargetRef();
            }
        }
        return workingCopy;
    }

    static final /* synthetic */ NodeRef getCheckedOut_aroundBody14(CheckOutCheckInServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        NodeRef original = null;
        if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            List assocs = ajc$this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
            if (assocs.size() == 0) {
                logger.warn((Object)("Found node with cm:workingcopy aspect but no association.  Current node state: " + ajc$this.nodeService.getNodeStatus(nodeRef)));
            } else if (assocs.size() > 1) {
                logger.warn((Object)("Found multiple " + ContentModel.ASSOC_WORKING_COPY_LINK + " association to node: " + nodeRef));
            } else {
                original = ((AssociationRef)assocs.get(0)).getSourceRef();
            }
        }
        return original;
    }

    static final /* synthetic */ boolean isWorkingCopy_aroundBody16(CheckOutCheckInServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        return ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
    }

    static final /* synthetic */ boolean isCheckedOut_aroundBody18(CheckOutCheckInServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        return ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CheckOutCheckInServiceImpl.java", CheckOutCheckInServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkout", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.repository.NodeRef"), 374);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkout", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.namespace.QName:org.alfresco.service.namespace.QName", "nodeRef:destinationParentNodeRef:destinationAssocTypeQName:destinationAssocQName", "", "org.alfresco.service.cmr.repository.NodeRef"), 385);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkin", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.util.Map", "workingCopyNodeRef:versionProperties", "", "org.alfresco.service.cmr.repository.NodeRef"), 533);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkin", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.util.Map:java.lang.String", "workingCopyNodeRef:versionProperties:contentUrl", "", "org.alfresco.service.cmr.repository.NodeRef"), 542);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkin", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.util.Map:java.lang.String:boolean", "workingCopyNodeRef:versionProperties:contentUrl:keepCheckedOut", "", "org.alfresco.service.cmr.repository.NodeRef"), 552);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelCheckout", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "workingCopyNodeRef", "", "org.alfresco.service.cmr.repository.NodeRef"), 707);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingCopy", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.repository.NodeRef"), 765);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCheckedOut", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.repository.NodeRef"), 791);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkingCopy", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 817);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCheckedOut", "org.alfresco.repo.coci.CheckOutCheckInServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 824);
    }
}

