/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class HttpAlfrescoContentReader
extends AbstractContentReader {
    private static final String ERR_NO_CONNECTION = "content.http_reader.err.no_connection";
    private static final String ERR_NO_AUTHENTICATION = "content.http_reader.err.no_authentication";
    private static final String ERR_CHECK_CLUSTER = "content.http_reader.err.check_cluster";
    private static final String ERR_UNRECOGNIZED = "content.http_reader.err.unrecognized";
    private static final String DEFAULT_URL = "{0}/dr?contentUrl={1}&ticket={2}";
    private static final String INFO_ONLY = "&infoOnly=true";
    private static Log logger = LogFactory.getLog(HttpAlfrescoContentReader.class);
    private TransactionService transactionService;
    private AuthenticationService authenticationService;
    private String baseHttpUrl;
    private HttpClient httpClient;
    private PropagateTicketCallback ticketCallback;
    private boolean isInfoCached;
    private boolean cachedExists;
    private long cachedLastModified;
    private long cachedSize;

    public HttpAlfrescoContentReader(TransactionService transactionService, AuthenticationService authenticationService, String baseHttpUrl, String contentUrl) {
        super(contentUrl);
        this.transactionService = transactionService;
        this.authenticationService = authenticationService;
        this.baseHttpUrl = baseHttpUrl;
        this.httpClient = new HttpClient();
        this.ticketCallback = new PropagateTicketCallback();
        this.cachedExists = false;
        this.cachedSize = 0L;
        this.cachedLastModified = 0L;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("HttpAlfrescoContentReader").append("[ contentUrl=").append(this.getContentUrl()).append("]");
        return sb.toString();
    }

    private void getInfo() {
        AuthenticationUtil.RunAsWork<Object> getInfoRunAs = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                HttpAlfrescoContentReader.this.getInfoImpl();
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getInfoRunAs, (String)"System");
    }

    private void getInfoImpl() {
        block21: {
            String contentUrl = this.getContentUrl();
            this.isInfoCached = true;
            GetMethod method = null;
            try {
                String ticket = this.transactionService.getRetryingTransactionHelper().doInTransaction(this.ticketCallback, false, true);
                String url = HttpAlfrescoContentReader.generateURL(this.baseHttpUrl, contentUrl, ticket, true);
                method = new GetMethod(url);
                int statusCode = this.httpClient.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    String responseSize = method.getResponseHeader("alfresco.dr.size").getValue();
                    String responseLastModified = method.getResponseHeader("alfresco.dr.lastModified").getValue();
                    String responseMimetype = method.getResponseHeader("alfresco.dr.mimetype").getValue();
                    String responseEncoding = method.getResponseHeader("alfresco.dr.encoding").getValue();
                    String responseLocale = method.getResponseHeader("alfresco.dr.locale").getValue();
                    this.cachedSize = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)responseSize);
                    this.cachedLastModified = ((Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)responseLastModified)).getTime();
                    this.setMimetype((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)responseMimetype));
                    this.setEncoding((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)responseEncoding));
                    this.setLocale((Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)responseLocale));
                    this.cachedExists = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\nHttpReader content found: \n   Reader: " + this + "\n" + "   Server: " + this.baseHttpUrl));
                    }
                } else {
                    if (statusCode != 204) {
                        if (statusCode == 403) {
                            logger.error((Object)I18NUtil.getMessage((String)ERR_NO_AUTHENTICATION, (Object[])new Object[]{this.baseHttpUrl}));
                            logger.error((Object)I18NUtil.getMessage((String)ERR_CHECK_CLUSTER));
                        } else {
                            logger.error((Object)I18NUtil.getMessage((String)ERR_UNRECOGNIZED, (Object[])new Object[]{this.baseHttpUrl, contentUrl, statusCode}));
                            logger.error((Object)I18NUtil.getMessage((String)ERR_CHECK_CLUSTER));
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\nHttpReader content not found: \n   Reader: " + this + "\n" + "   Server: " + this.baseHttpUrl));
                    }
                }
            }
            catch (ConnectException connectException) {
                logger.error((Object)I18NUtil.getMessage((String)ERR_NO_CONNECTION, (Object[])new Object[]{this.baseHttpUrl}));
                if (method != null) {
                    try {
                        method.releaseConnection();
                    }
                    catch (Throwable throwable) {}
                }
                break block21;
            }
            catch (Throwable e) {
                try {
                    throw new AlfrescoRuntimeException("Reader exists check failed: " + this, e);
                }
                catch (Throwable throwable) {
                    if (method != null) {
                        try {
                            method.releaseConnection();
                        }
                        catch (Throwable throwable2) {}
                    }
                    throw throwable;
                }
            }
            if (method == null) break block21;
            try {
                method.releaseConnection();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized boolean exists() {
        if (!this.isInfoCached) {
            this.getInfo();
        }
        return this.cachedExists;
    }

    public synchronized long getLastModified() {
        if (!this.isInfoCached) {
            this.getInfo();
        }
        return this.cachedLastModified;
    }

    public synchronized long getSize() {
        if (!this.isInfoCached) {
            this.getInfo();
        }
        return this.cachedSize;
    }

    @Override
    protected ContentReader createReader() throws ContentIOException {
        return new HttpAlfrescoContentReader(this.transactionService, this.authenticationService, this.baseHttpUrl, this.getContentUrl());
    }

    @Override
    protected ReadableByteChannel getDirectReadableChannel() throws ContentIOException {
        AuthenticationUtil.RunAsWork<ReadableByteChannel> getChannelRunAs = new AuthenticationUtil.RunAsWork<ReadableByteChannel>(){

            public ReadableByteChannel doWork() throws Exception {
                return HttpAlfrescoContentReader.this.getDirectReadableChannelImpl();
            }
        };
        return (ReadableByteChannel)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getChannelRunAs, (String)"System");
    }

    private ReadableByteChannel getDirectReadableChannelImpl() throws ContentIOException {
        String contentUrl = this.getContentUrl();
        try {
            if (!this.exists()) {
                throw new IOException("Content doesn't exist");
            }
            String ticket = this.transactionService.getRetryingTransactionHelper().doInTransaction(this.ticketCallback, false, true);
            String url = HttpAlfrescoContentReader.generateURL(this.baseHttpUrl, contentUrl, ticket, false);
            GetMethod method = new GetMethod(url);
            int statusCode = this.httpClient.executeMethod((HttpMethod)method);
            if (statusCode == 200) {
                InputStream contentStream = method.getResponseBodyAsStream();
                this.addListener(new StreamCloseListener(method));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\nHttpReader retrieve intput stream: \n   Reader: " + this + "\n" + "   Server: " + this.baseHttpUrl));
                }
                return Channels.newChannel(contentStream);
            }
            throw new IOException("Failed to get content remote content that supposedly exists.");
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to open stream: \n   Reader:        " + this + "\n" + "   Remote server: " + this.baseHttpUrl, e);
        }
    }

    public static final String generateURL(String baseHttpUrl, String contentUrl, String ticket, boolean infoOnly) {
        String url = MessageFormat.format(DEFAULT_URL, baseHttpUrl, contentUrl, ticket);
        if (infoOnly) {
            url = String.valueOf(url) + INFO_ONLY;
        }
        return url;
    }

    private class PropagateTicketCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private PropagateTicketCallback() {
        }

        @Override
        public String execute() throws Throwable {
            return HttpAlfrescoContentReader.this.authenticationService.getCurrentTicket();
        }
    }

    private static class StreamCloseListener
    implements ContentStreamListener {
        private GetMethod getMethod;

        private StreamCloseListener(GetMethod getMethod) {
            this.getMethod = getMethod;
        }

        public void contentStreamClosed() throws ContentIOException {
            try {
                this.getMethod.releaseConnection();
            }
            catch (Throwable throwable) {}
        }
    }
}

