/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterLimits;
import org.alfresco.repo.content.metadata.MetadataExtractorPropertyMappingOverride;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2Impl;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.transform.client.registry.TransformServiceRegistry;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.springframework.dao.ConcurrencyFailureException;

public class AsynchronousExtractor
extends AbstractMappingMetadataExtracter {
    private static final String EXTRACT = "extract";
    private static final String EMBED = "embed";
    private static final String MIMETYPE_METADATA_EXTRACT = "alfresco-metadata-extract";
    private static final String MIMETYPE_METADATA_EMBED = "alfresco-metadata-embed";
    private static final String EXTRACT_MAPPING = "extractMapping";
    private static final String METADATA = "metadata";
    private static final Map<String, Serializable> EMPTY_METADATA = Collections.emptyMap();
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private TransformerDebug transformerDebug;
    private RenditionService2 renditionService2;
    private RenditionDefinitionRegistry2Impl renditionDefinitionRegistry2;
    private ContentService contentService;
    private TransactionService transactionService;
    private TransformServiceRegistry transformServiceRegistry;
    private TaggingService taggingService;
    private List<MetadataExtractorPropertyMappingOverride> metadataExtractorPropertyMappingOverrides = Collections.emptyList();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setRenditionService2(RenditionService2 renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void setRenditionDefinitionRegistry2(RenditionDefinitionRegistry2Impl renditionDefinitionRegistry2) {
        this.renditionDefinitionRegistry2 = renditionDefinitionRegistry2;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTransformServiceRegistry(TransformServiceRegistry transformServiceRegistry) {
        this.transformServiceRegistry = transformServiceRegistry;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setMetadataExtractorPropertyMappingOverrides(List<MetadataExtractorPropertyMappingOverride> metadataExtractorPropertyMappingOverrides) {
        this.metadataExtractorPropertyMappingOverrides = metadataExtractorPropertyMappingOverrides;
    }

    @Override
    protected Map<String, Set<QName>> getDefaultMapping() {
        return Collections.emptyMap();
    }

    public boolean isSupported(String sourceMimetype, long sourceSizeInBytes) {
        return this.isEnabled(sourceMimetype) && this.isSupported(sourceMimetype, sourceSizeInBytes, MIMETYPE_METADATA_EXTRACT);
    }

    public boolean isEmbedderSupported(String sourceMimetype, long sourceSizeInBytes) {
        return this.isSupported(sourceMimetype, sourceSizeInBytes, MIMETYPE_METADATA_EMBED);
    }

    private boolean isSupported(String sourceMimetype, long sourceSizeInBytes, String targetMimetype) {
        return this.transformServiceRegistry.isSupported(sourceMimetype, sourceSizeInBytes, targetMimetype, Collections.emptyMap(), targetMimetype);
    }

    public static boolean isMetadataExtractMimetype(String targetMimetype) {
        return MIMETYPE_METADATA_EXTRACT.equals(targetMimetype);
    }

    public static boolean isMetadataEmbedMimetype(String targetMimetype) {
        return MIMETYPE_METADATA_EMBED.equals(targetMimetype);
    }

    public static String getTargetMimetypeFromTransformName(String transformName) {
        return transformName == null ? null : (transformName.startsWith(MIMETYPE_METADATA_EXTRACT) ? MIMETYPE_METADATA_EXTRACT : (transformName.startsWith(MIMETYPE_METADATA_EMBED) ? MIMETYPE_METADATA_EMBED : null));
    }

    public static String getSourceMimetypeFromTransformName(String transformName) {
        return transformName == null ? null : (transformName.startsWith(MIMETYPE_METADATA_EXTRACT) ? transformName.substring(MIMETYPE_METADATA_EXTRACT.length() + 1) : (transformName.startsWith(MIMETYPE_METADATA_EMBED) ? transformName.substring(MIMETYPE_METADATA_EMBED.length() + 1) : null));
    }

    public static String getExtension(String targetMimetype, String sourceExtension, String targetExtension) {
        return AsynchronousExtractor.isMetadataExtractMimetype(targetMimetype) ? "json" : (AsynchronousExtractor.isMetadataEmbedMimetype(targetMimetype) ? sourceExtension : targetExtension);
    }

    public static String getRenditionName(String renditionName) {
        String transformName = TransformDefinition.getTransformName(renditionName);
        return transformName != null && transformName.startsWith(MIMETYPE_METADATA_EXTRACT) ? "metadataExtract" : (transformName != null && transformName.startsWith(MIMETYPE_METADATA_EMBED) ? "metadataEmbed" : renditionName);
    }

    @Override
    protected void checkIsSupported(ContentReader reader) {
    }

    @Override
    protected void checkIsEmbedSupported(ContentWriter writer) {
    }

    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) {
        return null;
    }

    @Override
    protected Map<String, Serializable> extractRawInThread(NodeRef nodeRef, ContentReader reader, MetadataExtracterLimits limits) throws Throwable {
        Map<String, String> options = this.getExtractOptions(nodeRef, reader, limits);
        this.transformInBackground(nodeRef, reader, MIMETYPE_METADATA_EXTRACT, EXTRACT, options);
        return EMPTY_METADATA;
    }

    private Map<String, String> getExtractOptions(NodeRef nodeRef, ContentReader reader, MetadataExtracterLimits limits) {
        long timeoutMs = limits.getTimeoutMs();
        String sourceMimetype = reader.getMimetype();
        for (MetadataExtractorPropertyMappingOverride override : this.metadataExtractorPropertyMappingOverrides) {
            if (!override.match(sourceMimetype)) continue;
            Map<String, Set<String>> extractMapping = override.getExtractMapping(nodeRef);
            String extractMappingAsString = this.extractMappingToString(extractMapping);
            HashMap<String, String> options = new HashMap<String, String>(2);
            options.put("timeout", Long.toString(timeoutMs));
            options.put(EXTRACT_MAPPING, extractMappingAsString);
            return options;
        }
        return Collections.singletonMap("timeout", Long.toString(timeoutMs));
    }

    private String extractMappingToString(Map<String, Set<String>> map) {
        try {
            return this.jsonObjectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            AbstractMappingMetadataExtracter.logger.error((Object)"Failed to save extractMapping as Json", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Map<String, Serializable> mapSystemToRaw(Map<QName, Serializable> systemMetadata) {
        HashMap<String, Serializable> metadataProperties = new HashMap<String, Serializable>(systemMetadata.size());
        for (Map.Entry<QName, Serializable> entry : systemMetadata.entrySet()) {
            Serializable serializableValue = entry.getValue();
            if (serializableValue == null) continue;
            QName modelProperty = entry.getKey();
            String key = modelProperty.toString();
            if (serializableValue instanceof Collection) {
                Collection serializableCollection = (Collection)((Object)serializableValue);
                ArrayList<String> collection = new ArrayList<String>(serializableCollection.size());
                for (Object singleValue : serializableCollection) {
                    try {
                        String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, singleValue);
                        collection.add(value);
                    }
                    catch (TypeConversionException e) {
                        AbstractMappingMetadataExtracter.logger.info((Object)("Could not convert " + key + ": " + e.getMessage()));
                    }
                }
                if (collection.isEmpty()) continue;
                metadataProperties.put(key, collection);
                continue;
            }
            try {
                String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)serializableValue);
                metadataProperties.put(key, (Serializable)((Object)value));
            }
            catch (TypeConversionException e) {
                AbstractMappingMetadataExtracter.logger.info((Object)("Could not convert " + key + ": " + e.getMessage()));
            }
        }
        return metadataProperties;
    }

    @Override
    protected void embedInternal(NodeRef nodeRef, Map<String, Serializable> metadata, ContentReader reader, ContentWriter writer) {
        String metadataAsJson = this.metadataToString(metadata);
        Map<String, String> options = Collections.singletonMap(METADATA, metadataAsJson);
        this.transformInBackground(nodeRef, reader, MIMETYPE_METADATA_EMBED, EMBED, options);
    }

    private void transformInBackground(NodeRef nodeRef, ContentReader reader, String targetMimetype, String embedOrExtract, Map<String, String> options) {
        String domain = TenantUtil.getCurrentDomain();
        String runAsUser = AuthenticationUtil.getRunAsUser();
        ExecutorService executorService = this.getExecutorService();
        executorService.execute(() -> TenantUtil.runAsUserTenant(() -> {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                try {
                    this.transform(nodeRef, reader, targetMimetype, embedOrExtract, options);
                }
                finally {
                    this.extractRawThreadFinished();
                }
                return null;
            }, false);
            return null;
        }, (String)runAsUser, (String)domain));
    }

    private void transform(NodeRef nodeRef, ContentReader reader, String targetMimetype, String embedOrExtract, Map<String, String> options) {
        block4: {
            String sourceMimetype = reader.getMimetype();
            String transformName = String.valueOf(targetMimetype) + '/' + sourceMimetype;
            String renditionName = TransformDefinition.convertToRenditionName(transformName);
            TransformDefinition transformDefinition = (TransformDefinition)this.renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
            if (transformDefinition == null) {
                transformDefinition = new TransformDefinition(transformName, targetMimetype, options, null, null, null, this.renditionDefinitionRegistry2);
            }
            if (AbstractMappingMetadataExtracter.logger.isTraceEnabled()) {
                StringJoiner sj = new StringJoiner("\n");
                sj.add("Request " + embedOrExtract + " transform on " + nodeRef);
                options.forEach((k, v) -> {
                    StringJoiner stringJoiner2 = sj.add("  " + k + "=" + v);
                });
                AbstractMappingMetadataExtracter.logger.trace((Object)sj);
            }
            try {
                this.renditionService2.transform(nodeRef, transformDefinition);
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().endsWith("The supplied sourceNodeRef " + nodeRef + " does not exist.")) break block4;
                throw new ConcurrencyFailureException("The original transaction may not have finished. " + e.getMessage());
            }
        }
    }

    public void setMetadata(NodeRef nodeRef, InputStream transformInputStream) {
        Map<String, Serializable> metadata;
        if (AbstractMappingMetadataExtracter.logger.isTraceEnabled()) {
            AbstractMappingMetadataExtracter.logger.trace((Object)("Update metadata on " + nodeRef));
        }
        if ((metadata = this.readMetadata(transformInputStream)) == null) {
            return;
        }
        MetadataExtracter.OverwritePolicy overwritePolicy = this.removeOverwritePolicy(metadata, "sys:overwritePolicy", MetadataExtracter.OverwritePolicy.PRAGMATIC);
        Boolean enableStringTagging = this.removeBoolean(metadata, (Serializable)((Object)"sys:enableStringTagging"), false);
        Boolean carryAspectProperties = this.removeBoolean(metadata, (Serializable)((Object)"sys:carryAspectProperties"), true);
        List<String> stringTaggingSeparators = this.removeTaggingSeparators(metadata, "sys:stringTaggingSeparators", ContentMetadataExtracter.DEFAULT_STRING_TAGGING_SEPARATORS);
        if (overwritePolicy == null || enableStringTagging == null || carryAspectProperties == null || stringTaggingSeparators == null) {
            return;
        }
        AuthenticationUtil.runAsSystem(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map nodeProperties = this.nodeService.getProperties(nodeRef);
            Map<QName, Serializable> systemProperties = this.convertKeysToQNames(metadata);
            Map<QName, Serializable> changedProperties = overwritePolicy.applyProperties(systemProperties = this.convertSystemPropertyValues(systemProperties), nodeProperties);
            if (changedProperties.size() == 0) {
                return null;
            }
            boolean transformerDebugEnabled = this.transformerDebug.isEnabled();
            boolean debugEnabled = AbstractMappingMetadataExtracter.logger.isDebugEnabled();
            if (transformerDebugEnabled || debugEnabled) {
                for (Map.Entry<QName, Serializable> entry : changedProperties.entrySet()) {
                    QName qname = entry.getKey();
                    Serializable value = entry.getValue();
                    String prefixString = qname.toPrefixString(this.namespacePrefixResolver);
                    String debugMessage = String.valueOf(prefixString) + "=" + (value == null ? "" : value);
                    if (transformerDebugEnabled) {
                        this.transformerDebug.debugUsingPreviousReference("  " + debugMessage);
                    }
                    if (!debugEnabled) continue;
                    AbstractMappingMetadataExtracter.logger.debug((Object)debugMessage);
                }
            }
            ContentMetadataExtracter.addExtractedMetadataToNode(nodeRef, nodeProperties, changedProperties, this.nodeService, this.dictionaryService, this.taggingService, enableStringTagging, carryAspectProperties, stringTaggingSeparators);
            if (AbstractMappingMetadataExtracter.logger.isTraceEnabled()) {
                AbstractMappingMetadataExtracter.logger.trace((Object)("Extraction of Metadata from " + nodeRef + " complete " + changedProperties));
            }
            return null;
        }, false, true));
    }

    private Map<String, Serializable> readMetadata(InputStream transformInputStream) {
        try {
            TypeReference<HashMap<String, Serializable>> typeRef = new TypeReference<HashMap<String, Serializable>>(){};
            return (Map)this.jsonObjectMapper.readValue(transformInputStream, (TypeReference)typeRef);
        }
        catch (IOException e) {
            AbstractMappingMetadataExtracter.logger.error((Object)"Failed to read metadata from transform result", (Throwable)e);
            return null;
        }
    }

    private String metadataToString(Map<String, Serializable> metadata) {
        try {
            return this.jsonObjectMapper.writeValueAsString(metadata);
        }
        catch (JsonProcessingException e) {
            AbstractMappingMetadataExtracter.logger.error((Object)"Failed to save metadata as Json", (Throwable)e);
            return null;
        }
    }

    private MetadataExtracter.OverwritePolicy removeOverwritePolicy(Map<String, Serializable> map, String key, MetadataExtracter.OverwritePolicy defaultValue) {
        Serializable value = map.remove(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return MetadataExtracter.OverwritePolicy.valueOf((String)((Object)value));
        }
        catch (ClassCastException | IllegalArgumentException runtimeException) {
            AbstractMappingMetadataExtracter.logger.error((Object)(String.valueOf(key) + "=" + value + " is invalid"));
            return null;
        }
    }

    private Boolean removeBoolean(Map<String, Serializable> map, Serializable key, boolean defaultValue) {
        Serializable value = map.remove(key);
        if (!(value == null || value instanceof String && (Boolean.FALSE.toString().equals(value) || Boolean.TRUE.toString().equals(value)))) {
            AbstractMappingMetadataExtracter.logger.error((Object)(key + "=" + value + " is invalid. Must be " + Boolean.TRUE + " or " + Boolean.FALSE));
            return null;
        }
        return value == null ? defaultValue : Boolean.parseBoolean((String)((Object)value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> removeTaggingSeparators(Map<String, Serializable> map, String key, List<String> defaultValue) {
        Serializable value = map.remove(key);
        if (value == null) {
            return defaultValue;
        }
        if (!(value instanceof String)) {
            AbstractMappingMetadataExtracter.logger.error((Object)(String.valueOf(key) + "=" + value + " is invalid."));
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (CSVParser parser = CSVParser.parse((String)((String)((Object)value)), (CSVFormat)CSVFormat.RFC4180);){
                Iterator iterator = parser.iterator();
                CSVRecord record = (CSVRecord)iterator.next();
                if (iterator.hasNext()) {
                    AbstractMappingMetadataExtracter.logger.error((Object)(String.valueOf(key) + "=" + value + " is invalid. Should only have one record"));
                    return null;
                }
                record.forEach(list::add);
                return list;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | NoSuchElementException exception) {
            AbstractMappingMetadataExtracter.logger.error((Object)(String.valueOf(key) + "=" + value + " is invalid. Must be a CSV using CSVFormat.RFC4180"));
            return null;
        }
    }

    private Map<QName, Serializable> convertKeysToQNames(Map<String, Serializable> documentMetadata) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        for (Map.Entry<String, Serializable> entry : documentMetadata.entrySet()) {
            String key = entry.getKey();
            Serializable value = entry.getValue();
            try {
                QName qName = QName.createQName((String)key);
                try {
                    qName.toPrefixString(this.namespacePrefixResolver);
                    properties.put(qName, value);
                }
                catch (NamespaceException namespaceException) {
                    AbstractMappingMetadataExtracter.logger.error((Object)("Error unregistered namespace in " + qName));
                }
            }
            catch (NamespaceException namespaceException) {
                AbstractMappingMetadataExtracter.logger.error((Object)("Error creating qName from " + key));
            }
        }
        return properties;
    }

    public void setEmbeddedMetadata(NodeRef nodeRef, InputStream transformInputStream) {
        if (AbstractMappingMetadataExtracter.logger.isDebugEnabled()) {
            AbstractMappingMetadataExtracter.logger.debug((Object)("Update of content to include metadata on " + nodeRef));
        }
        AuthenticationUtil.runAsSystem(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            try {
                ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
                String mimetype = reader.getMimetype();
                String encoding = reader.getEncoding();
                ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(mimetype);
                writer.setEncoding(encoding);
                writer.putContent(transformInputStream);
                if (AbstractMappingMetadataExtracter.logger.isTraceEnabled()) {
                    AbstractMappingMetadataExtracter.logger.trace((Object)("Embedded Metadata on " + nodeRef + " complete"));
                }
            }
            catch (Exception e) {
                AbstractMappingMetadataExtracter.logger.error((Object)("Failed to copy embedded metadata transform InputStream into " + nodeRef));
                throw e;
            }
            return null;
        }, false, true));
    }
}

