/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.content.transform.AbstractLocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.RemoteTransformerClient;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.transform.client.model.config.TransformOption;
import org.alfresco.util.Pair;

public class LocalTransformImpl
extends AbstractLocalTransform {
    private RemoteTransformerClient remoteTransformerClient;
    private boolean available = false;

    public LocalTransformImpl(String name, TransformerDebug transformerDebug, MimetypeService mimetypeService, boolean strictMimeTypeCheck, Map<String, Set<String>> strictMimetypeExceptions, boolean retryTransformOnDifferentMimeType, Set<TransformOption> transformsTransformOptions, LocalTransformServiceRegistry localTransformServiceRegistry, String baseUrl, int startupRetryPeriodSeconds) {
        super(name, transformerDebug, mimetypeService, strictMimeTypeCheck, strictMimetypeExceptions, retryTransformOnDifferentMimeType, transformsTransformOptions, localTransformServiceRegistry);
        this.remoteTransformerClient = new RemoteTransformerClient(name, baseUrl);
        this.remoteTransformerClient.setStartupRetryPeriodSeconds(startupRetryPeriodSeconds);
        this.checkAvailability();
    }

    public boolean remoteTransformerClientConfigured() {
        return this.remoteTransformerClient.getBaseUrl() != null;
    }

    @Override
    public boolean isAvailable() {
        if (this.remoteTransformerClientConfigured() && !this.remoteTransformerClient.isAvailable()) {
            this.checkAvailability();
        }
        return this.available;
    }

    private void setAvailable(boolean available) {
        this.available = available;
    }

    private void checkAvailability() {
        block6: {
            if (this.remoteTransformerClientConfigured()) {
                try {
                    String msg;
                    Pair<Boolean, String> result = this.remoteTransformerClient.check(AbstractLocalTransform.log);
                    Boolean isAvailable = (Boolean)result.getFirst();
                    String string = msg = result.getSecond() == null ? "" : (String)result.getSecond();
                    if (isAvailable != null && isAvailable.booleanValue()) {
                        this.setAvailable(true);
                        AbstractLocalTransform.log.debug((Object)this.getAvailableMessage(true, null));
                        AbstractLocalTransform.log.trace((Object)msg);
                        break block6;
                    }
                    this.setAvailable(false);
                    String message = this.getAvailableMessage(false, msg);
                    if (isAvailable == null) {
                        AbstractLocalTransform.log.debug((Object)message);
                        break block6;
                    }
                    AbstractLocalTransform.log.error((Object)message);
                }
                catch (Throwable e) {
                    this.setAvailable(false);
                    AbstractLocalTransform.log.error((Object)this.getAvailableMessage(false, e.getMessage()));
                    AbstractLocalTransform.log.debug((Object)e);
                }
            } else {
                this.setAvailable(false);
            }
        }
    }

    private String getAvailableMessage(boolean available, String suffix) {
        return "Local transformer " + this.name + " on " + this.remoteTransformerClient.getBaseUrl() + " is " + (available ? "" : "not ") + "available" + (suffix == null ? "." : ": " + suffix);
    }

    @Override
    protected void transformImpl(ContentReader reader, ContentWriter writer, Map<String, String> transformOptions, String sourceMimetype, String targetMimetype, String sourceExtension, String targetExtension, String renditionName, NodeRef sourceNodeRef) {
        transformOptions = new HashMap<String, String>(transformOptions);
        String sourceEncoding = reader.getEncoding();
        transformOptions.put("sourceEncoding", sourceEncoding);
        if (transformOptions.containsKey("sourceNodeRef") && transformOptions.get("sourceNodeRef") == null) {
            transformOptions.put("sourceNodeRef", sourceNodeRef.toString());
        }
        long timeoutMs = 0L;
        int nonOptions = transformOptions.containsKey("timeout") ? 1 : 0;
        int size = (transformOptions.size() - nonOptions + 3) * 2;
        String[] args = new String[size];
        int i = 0;
        for (Map.Entry<String, String> option : transformOptions.entrySet()) {
            String name = option.getKey();
            String value = option.getValue();
            if ("timeout".equals(name)) {
                if (value == null) continue;
                timeoutMs = Long.parseLong(value);
                continue;
            }
            args[i++] = name;
            args[i++] = value;
        }
        args[i++] = "sourceMimetype";
        args[i++] = sourceMimetype;
        args[i++] = "sourceExtension";
        args[i++] = sourceExtension;
        args[i++] = "targetMimetype";
        args[i++] = targetMimetype;
        targetExtension = AsynchronousExtractor.getExtension(targetMimetype, sourceExtension, targetExtension);
        this.remoteTransformerClient.request(reader, writer, sourceMimetype, sourceExtension, targetExtension, timeoutMs, AbstractLocalTransform.log, args);
    }
}

