/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class ReferenceablePropertiesEntity {
    private static final Set<QName> REFERENCEABLE_PROP_QNAMES = new HashSet<QName>(8);

    static {
        REFERENCEABLE_PROP_QNAMES.add(ContentModel.PROP_STORE_PROTOCOL);
        REFERENCEABLE_PROP_QNAMES.add(ContentModel.PROP_STORE_IDENTIFIER);
        REFERENCEABLE_PROP_QNAMES.add(ContentModel.PROP_NODE_UUID);
        REFERENCEABLE_PROP_QNAMES.add(ContentModel.PROP_NODE_DBID);
    }

    public static boolean isReferenceableProperty(QName qname) {
        return REFERENCEABLE_PROP_QNAMES.contains(qname);
    }

    public static void removeReferenceableProperties(Node node, Map<QName, Serializable> properties) {
        properties.keySet().removeAll(REFERENCEABLE_PROP_QNAMES);
        String name = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_NAME));
        if (name != null && name.equals(node.getUuid())) {
            properties.remove(ContentModel.PROP_NAME);
        }
    }

    public static void removeReferenceableProperties(Set<QName> propertyQNames) {
        propertyQNames.removeAll(REFERENCEABLE_PROP_QNAMES);
    }

    public static void addReferenceableProperties(Node node, Map<QName, Serializable> properties) {
        Long nodeId = node.getId();
        NodeRef nodeRef = node.getNodeRef();
        properties.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
        properties.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        properties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)nodeRef.getId()));
        properties.put(ContentModel.PROP_NODE_DBID, nodeId);
        String name = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_NAME));
        if (name == null) {
            properties.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeRef.getId()));
        }
    }

    public static Serializable getReferenceableProperty(Node node, QName qname) {
        NodeRef nodeRef = node.getNodeRef();
        if (qname.equals((Object)ContentModel.PROP_STORE_PROTOCOL)) {
            return nodeRef.getStoreRef().getProtocol();
        }
        if (qname.equals((Object)ContentModel.PROP_STORE_IDENTIFIER)) {
            return nodeRef.getStoreRef().getIdentifier();
        }
        if (qname.equals((Object)ContentModel.PROP_NODE_UUID)) {
            return nodeRef.getId();
        }
        if (qname.equals((Object)ContentModel.PROP_NODE_DBID)) {
            return node.getId();
        }
        throw new IllegalArgumentException("Not sys:referenceable property: " + qname);
    }

    public static void addReferenceableProperties(Long nodeId, NodeRef nodeRef, Map<QName, Serializable> properties) {
        properties.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
        properties.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        properties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)nodeRef.getId()));
        properties.put(ContentModel.PROP_NODE_DBID, nodeId);
        String name = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_NAME));
        if (name == null) {
            properties.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeRef.getId()));
        }
    }
}

