/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.alfresco.repo.domain.schema.script.DeleteNotExistsExecutor;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySQLDeleteNotExistsExecutor
extends DeleteNotExistsExecutor {
    private static final Log logger = LogFactory.getLog(MySQLDeleteNotExistsExecutor.class);
    private final DataSource dataSource;

    public MySQLDeleteNotExistsExecutor(Connection connection, String sql, int line, File scriptFile, Properties globalProperties, DataSource dataSource) {
        super(connection, sql, line, scriptFile, globalProperties);
        this.dataSource = dataSource;
    }

    @Override
    protected void process(Pair<String, String>[] tableColumn, Long[] tableUpperLimits, String[] optionalWhereClauses) throws SQLException {
        String primaryTableName = (String)tableColumn[0].getFirst();
        String primaryColumnName = (String)tableColumn[0].getSecond();
        String primaryWhereClause = optionalWhereClauses[0];
        Long primaryId = 0L;
        PreparedStatement primaryPrepStmt = null;
        Statement[] secondaryPrepStmts = null;
        PreparedStatement deletePrepStmt = null;
        HashSet<Long> deleteIds = new HashSet<Long>();
        this.deletedCount = 0L;
        this.startTime = new Date();
        long defaultOffset = 0L;
        try {
            this.connection.setAutoCommit(false);
            primaryPrepStmt = this.connection.prepareStatement(this.createLimitPreparedSelectStatement(primaryTableName, primaryColumnName, primaryWhereClause));
            primaryPrepStmt.setLong(1, primaryId);
            primaryPrepStmt.setLong(2, tableUpperLimits[0]);
            primaryPrepStmt.setInt(3, this.batchSize);
            primaryPrepStmt.setLong(4, defaultOffset);
            boolean hasResults = primaryPrepStmt.execute();
            if (hasResults) {
                Statement secStmt;
                secondaryPrepStmts = new PreparedStatement[tableColumn.length];
                int i = 1;
                while (i < tableColumn.length) {
                    secStmt = this.connection.prepareStatement(this.createLimitPreparedSelectStatement((String)tableColumn[i].getFirst(), (String)tableColumn[i].getSecond(), optionalWhereClauses[i]));
                    secStmt.setLong(1, primaryId);
                    secStmt.setLong(2, tableUpperLimits[i]);
                    secStmt.setInt(3, this.batchSize);
                    secStmt.setLong(4, defaultOffset);
                    secondaryPrepStmts[i] = secStmt;
                    ++i;
                }
                deletePrepStmt = this.connection.prepareStatement(this.createPreparedDeleteStatement(primaryTableName, primaryColumnName, this.deleteBatchSize, primaryWhereClause));
                while (hasResults && !this.isTimeoutExceeded()) {
                    primaryId = this.processPrimaryTableResultSet(primaryPrepStmt, (PreparedStatement[])secondaryPrepStmts, deletePrepStmt, deleteIds, primaryTableName, primaryColumnName, tableColumn);
                    this.connection.commit();
                    if (primaryId == null) break;
                    primaryPrepStmt.setLong(1, primaryId);
                    primaryPrepStmt.setLong(2, tableUpperLimits[0]);
                    primaryPrepStmt.setInt(3, this.batchSize);
                    primaryPrepStmt.setLong(4, defaultOffset);
                    i = 1;
                    while (i < tableColumn.length) {
                        secStmt = secondaryPrepStmts[i];
                        secStmt.setLong(1, primaryId);
                        secStmt.setLong(2, tableUpperLimits[i]);
                        secStmt.setInt(3, this.batchSize);
                        secStmt.setLong(4, defaultOffset);
                        ++i;
                    }
                    hasResults = primaryPrepStmt.execute();
                }
            }
            if (!deleteIds.isEmpty()) {
                this.deleteFromPrimaryTable(deletePrepStmt, deleteIds, primaryTableName);
                this.connection.commit();
            }
            if (logger.isDebugEnabled()) {
                String msg = String.valueOf(this.readOnly ? "Script would have" : "Script") + " deleted a total of " + this.deletedCount + " items from table " + primaryTableName + ".";
                logger.debug((Object)msg);
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(deletePrepStmt);
            this.closeQuietly(secondaryPrepStmts);
            this.closeQuietly(primaryPrepStmt);
            this.connection.setAutoCommit(true);
            throw throwable;
        }
        this.closeQuietly(deletePrepStmt);
        this.closeQuietly(secondaryPrepStmts);
        this.closeQuietly(primaryPrepStmt);
        this.connection.setAutoCommit(true);
    }

    @Override
    protected Long processPrimaryTableResultSet(PreparedStatement primaryPrepStmt, PreparedStatement[] secondaryPrepStmts, PreparedStatement deletePrepStmt, Set<Long> deleteIds, String primaryTableName, String primaryColumnName, Pair<String, String>[] tableColumn) throws SQLException {
        int rowsProcessed = 0;
        Long primaryId = null;
        ResultSet[] secondaryResultSets = null;
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try (ResultSet resultSet = primaryPrepStmt.getResultSet();){
                secondaryResultSets = this.getSecondaryResultSets(secondaryPrepStmts);
                Long[] secondaryIds = this.getSecondaryIds(secondaryResultSets, tableColumn);
                Long[] secondaryOffsets = new Long[tableColumn.length];
                int i = 1;
                while (i < tableColumn.length) {
                    secondaryOffsets[i] = 0L;
                    ++i;
                }
                while (resultSet.next()) {
                    ++rowsProcessed;
                    primaryId = resultSet.getLong(primaryColumnName);
                    while (this.isLess(primaryId, secondaryIds)) {
                        deleteIds.add(primaryId);
                        if (deleteIds.size() == this.deleteBatchSize) {
                            this.deleteFromPrimaryTable(deletePrepStmt, deleteIds, primaryTableName);
                            this.connection.commit();
                        }
                        if (!resultSet.next()) break;
                        ++rowsProcessed;
                        primaryId = resultSet.getLong(primaryColumnName);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("RowsProcessed " + rowsProcessed + " from primary table " + primaryTableName));
                    }
                    this.updateSecondaryIds(primaryId, secondaryIds, secondaryPrepStmts, secondaryOffsets, secondaryResultSets, tableColumn);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(secondaryResultSets);
            throw throwable;
        }
        this.closeQuietly(secondaryResultSets);
        return primaryId;
    }

    private void updateSecondaryIds(Long primaryId, Long[] secondaryIds, PreparedStatement[] secondaryPrepStmts, Long[] secondaryOffsets, ResultSet[] secondaryResultSets, Pair<String, String>[] tableColumn) throws SQLException {
        int i = 1;
        while (i < tableColumn.length) {
            Long secondaryId = secondaryIds[i];
            while (secondaryId != null && primaryId >= secondaryId) {
                ResultSet resultSet = secondaryResultSets[i];
                String columnId = (String)tableColumn[i].getSecond();
                secondaryId = this.getColumnValueById(resultSet, columnId);
                if (secondaryId == null) {
                    this.closeQuietly(resultSet);
                    long offset = secondaryOffsets[i] + (long)this.batchSize;
                    secondaryOffsets[i] = offset;
                    PreparedStatement secStmt = secondaryPrepStmts[i];
                    secStmt.setLong(4, offset);
                    boolean secHasResults = secStmt.execute();
                    secondaryResultSets[i] = secHasResults ? secStmt.getResultSet() : null;
                    secondaryId = this.getColumnValueById(secondaryResultSets[i], columnId);
                }
                secondaryIds[i] = secondaryId;
            }
            ++i;
        }
    }

    private String createLimitPreparedSelectStatement(String tableName, String columnName, String whereClause) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + columnName + " FROM " + tableName + " WHERE ");
        if (whereClause != null && !whereClause.isEmpty()) {
            sqlBuilder.append(String.valueOf(whereClause) + " AND ");
        }
        sqlBuilder.append(String.valueOf(columnName) + " > ? AND " + columnName + " <= ? ORDER BY " + columnName + " ASC LIMIT ? OFFSET ?");
        return sqlBuilder.toString();
    }
}

