/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentModelMessage
extends AbstractMimeMessage {
    private Log logger = LogFactory.getLog(ContentModelMessage.class);
    protected static final String DEFAULT_EMAIL_FROM = "alfresco@alfresco.org";
    protected static final String DEFAULT_EMAIL_TO = "alfresco@alfresco.org";

    public ContentModelMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry, boolean generateBody) throws MessagingException {
        super(fileInfo, serviceRegistry, generateBody);
    }

    @Override
    public void buildMessageInternal() throws MessagingException {
        if (this.generateBody) {
            this.setMessageHeaders();
            this.buildContentModelMessage();
        }
    }

    private void buildContentModelMessage() throws MessagingException {
        Map<QName, Serializable> properties = this.messageFileInfo.getProperties();
        String prop = null;
        this.setSentDate(this.messageFileInfo.getModifiedDate());
        InternetAddress[] addressList = this.buildSenderFromAddress();
        this.addFrom((Address[])addressList);
        addressList = this.buildRecipientToAddress();
        this.addRecipients(Message.RecipientType.TO, (Address[])addressList);
        prop = (String)((Object)properties.get(ContentModel.PROP_TITLE));
        try {
            prop = prop == null || prop.equals("") ? this.messageFileInfo.getName() : prop;
            prop = MimeUtility.encodeText((String)prop, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        this.setSubject(prop);
        this.setContent(this.buildContentModelMultipart());
    }

    private Multipart buildContentModelMultipart() throws MessagingException {
        AlfrescoMimeMultipart rootMultipart = new AlfrescoMimeMultipart("alternative", this.messageFileInfo);
        if (this.isMessageInSitesLibrary) {
            String bodyTxt = this.getEmailBodyText(ImapService.EmailBodyFormat.SHARE_TEXT_PLAIN);
            rootMultipart.addBodyPart((BodyPart)this.getTextBodyPart(bodyTxt, ImapService.EmailBodyFormat.SHARE_TEXT_PLAIN.getSubtype(), ImapService.EmailBodyFormat.SHARE_TEXT_PLAIN.getMimeType()));
            String bodyHtml = this.getEmailBodyText(ImapService.EmailBodyFormat.SHARE_TEXT_HTML);
            rootMultipart.addBodyPart((BodyPart)this.getTextBodyPart(bodyHtml, ImapService.EmailBodyFormat.SHARE_TEXT_HTML.getSubtype(), ImapService.EmailBodyFormat.SHARE_TEXT_HTML.getMimeType()));
        } else {
            String bodyTxt = this.getEmailBodyText(ImapService.EmailBodyFormat.ALFRESCO_TEXT_PLAIN);
            rootMultipart.addBodyPart((BodyPart)this.getTextBodyPart(bodyTxt, ImapService.EmailBodyFormat.ALFRESCO_TEXT_PLAIN.getSubtype(), ImapService.EmailBodyFormat.ALFRESCO_TEXT_PLAIN.getMimeType()));
            String bodyHtml = this.getEmailBodyText(ImapService.EmailBodyFormat.ALFRESCO_TEXT_HTML);
            rootMultipart.addBodyPart((BodyPart)this.getTextBodyPart(bodyHtml, ImapService.EmailBodyFormat.ALFRESCO_TEXT_HTML.getSubtype(), ImapService.EmailBodyFormat.ALFRESCO_TEXT_HTML.getMimeType()));
        }
        return rootMultipart;
    }

    private MimeBodyPart getTextBodyPart(String bodyText, String subtype, String mimeType) throws MessagingException {
        MimeBodyPart result = new MimeBodyPart();
        result.setText(bodyText, "UTF-8", subtype);
        result.addHeader("Content-Type", String.valueOf(mimeType) + ";charset=utf-8");
        result.addHeader("Content-Transfer-Encoding", "base64");
        return result;
    }

    private InternetAddress[] buildRecipientToAddress() throws AddressException {
        InternetAddress[] result = null;
        Map<QName, Serializable> properties = this.messageFileInfo.getProperties();
        if (properties.containsKey(ContentModel.PROP_ADDRESSEE)) {
            String addressee = (String)((Object)properties.get(ContentModel.PROP_ADDRESSEE));
            try {
                result = InternetAddress.parse((String)addressee);
                return result;
            }
            catch (AddressException addressException) {}
        }
        String defaultToAddress = this.imapService.getDefaultToAddress();
        try {
            result = InternetAddress.parse((String)defaultToAddress);
            return result;
        }
        catch (AddressException e) {
            this.logger.warn((Object)String.format("Wrong email address '%s'.", defaultToAddress), (Throwable)e);
            result = InternetAddress.parse((String)"alfresco@alfresco.org");
            return result;
        }
    }

    private InternetAddress[] buildSenderFromAddress() throws AddressException {
        String author;
        InternetAddress[] result = null;
        Map<QName, Serializable> properties = this.messageFileInfo.getProperties();
        String defaultFromAddress = this.imapService.getDefaultFromAddress();
        if (properties.containsKey(ContentModel.PROP_ORIGINATOR)) {
            String addressee = (String)((Object)properties.get(ContentModel.PROP_ORIGINATOR));
            try {
                result = InternetAddress.parse((String)addressee);
                return result;
            }
            catch (AddressException addressException) {}
        }
        if (properties.containsKey(ContentModel.PROP_AUTHOR)) {
            author = (String)((Object)properties.get(ContentModel.PROP_AUTHOR));
            try {
                if (author != null && !author.isEmpty()) {
                    StringBuilder contentAuthor = new StringBuilder();
                    contentAuthor.append("\"").append(author).append("\" <").append(defaultFromAddress).append(">");
                    result = InternetAddress.parse((String)contentAuthor.toString());
                    return result;
                }
            }
            catch (AddressException addressException) {}
        }
        if (properties.containsKey(ContentModel.PROP_CREATOR)) {
            author = (String)((Object)properties.get(ContentModel.PROP_CREATOR));
            try {
                StringBuilder contentAuthor = new StringBuilder();
                contentAuthor.append("\"").append(author).append("\" <").append(defaultFromAddress).append(">");
                result = InternetAddress.parse((String)contentAuthor.toString());
                return result;
            }
            catch (AddressException addressException) {}
        }
        try {
            result = InternetAddress.parse((String)defaultFromAddress);
            return result;
        }
        catch (AddressException e) {
            this.logger.warn((Object)String.format("Wrong email address '%s'.", defaultFromAddress), (Throwable)e);
            result = InternetAddress.parse((String)"alfresco@alfresco.org");
            return result;
        }
    }

    class AlfrescoMimeMultipart
    extends MimeMultipart {
        public AlfrescoMimeMultipart(String subtype, FileInfo messageFileInfo) {
            String boundary = this.getBoundaryValue(messageFileInfo);
            ContentType cType = new ContentType("multipart", subtype, null);
            cType.setParameter("boundary", boundary);
            this.contentType = cType.toString();
        }

        public String getBoundaryValue(FileInfo messageFileInfo) {
            StringBuffer s = new StringBuffer();
            s.append("----=_Part_").append(messageFileInfo.getNodeRef().getId());
            return s.toString();
        }
    }
}

