/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.List;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

public class AssocTargetRoleIntegrityEvent
extends AbstractIntegrityEvent {
    public AssocTargetRoleIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef sourceNodeRef, QName assocTypeQName, QName assocName) {
        super(nodeService, dictionaryService, sourceNodeRef, assocTypeQName, assocName);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        QName assocTypeQName = this.getTypeQName();
        QName assocQName = this.getQName();
        NodeRef sourceNodeRef = this.getNodeRef();
        AssociationDefinition assocDef = this.getAssocDef(eventResults, assocTypeQName);
        if (assocDef == null) {
            IntegrityRecord result = new IntegrityRecord("Association type does not exist: \n   Association Type: " + assocTypeQName);
            eventResults.add(result);
            return;
        }
        if (assocQName == null) {
            throw new IllegalArgumentException("The association qualified name must be supplied");
        }
        if (!assocDef.isChild()) {
            throw new UnsupportedOperationException("This operation is only relevant to child associations");
        }
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        this.checkAssocQNameRegex(eventResults, childAssocDef, assocQName, sourceNodeRef);
    }

    protected void checkAssocQNameRegex(List<IntegrityRecord> eventResults, ChildAssociationDefinition assocDef, QName assocQName, NodeRef sourceNodeRef) {
        RegexQNamePattern rolePattern;
        QName assocRoleQName = assocDef.getTargetRoleName();
        if (assocRoleQName != null && !(rolePattern = new RegexQNamePattern(assocRoleQName.getNamespaceURI(), assocRoleQName.getLocalName())).isMatch(assocQName)) {
            IntegrityRecord result = new IntegrityRecord("The association name does not match the allowed role names: \n   Source Node: " + sourceNodeRef + "\n" + "   Association: " + assocDef + "\n" + "   Allowed roles: " + rolePattern + "\n" + "   Name assigned: " + assocRoleQName);
            eventResults.add(result);
        }
    }
}

