/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.SealedObject;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(PropertiesIntegrityEvent.class);

    protected PropertiesIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef) {
        super(nodeService, dictionaryService, nodeRef, null, null);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        NodeRef nodeRef = this.getNodeRef();
        if (!this.nodeService.exists(nodeRef)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event ignored - node gone: " + this));
            }
            eventResults.clear();
            return;
        }
        this.checkAllProperties(this.getNodeRef(), eventResults);
    }

    private void checkAllProperties(NodeRef nodeRef, List<IntegrityRecord> eventResults) {
        Map nodeProperties = this.nodeService.getProperties(nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
        if (typeDef == null) {
            return;
        }
        Collection<Object> propertyDefs = typeDef.getProperties().values();
        this.checkAllProperties(nodeRef, nodeTypeQName, propertyDefs, nodeProperties, eventResults);
        Set aspectTypeQNames = this.nodeService.getAspects(nodeRef);
        for (QName aspectTypeQName : aspectTypeQNames) {
            AspectDefinition aspectDef;
            if (aspectTypeQName.equals((Object)ContentModel.ASPECT_REFERENCEABLE) || aspectTypeQName.equals((Object)ContentModel.ASPECT_AUDITABLE) || (aspectDef = this.dictionaryService.getAspect(aspectTypeQName)) == null) continue;
            propertyDefs = aspectDef.getProperties().values();
            this.checkAllProperties(nodeRef, aspectTypeQName, propertyDefs, nodeProperties, eventResults);
        }
    }

    private void checkAllProperties(NodeRef nodeRef, QName typeQName, Collection<PropertyDefinition> propertyDefs, Map<QName, Serializable> nodeProperties, Collection<IntegrityRecord> eventResults) {
        if (propertyDefs == null || propertyDefs.isEmpty()) {
            return;
        }
        for (PropertyDefinition propertyDef : propertyDefs) {
            QName propertyQName = propertyDef.getName();
            if (propertyDef.isMandatory() && propertyDef.isMandatoryEnforced() && (!nodeProperties.containsKey(propertyQName) || nodeProperties.get(propertyQName) == null)) {
                String nameProp = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                IntegrityRecord result = new IntegrityRecord("Mandatory property not set: \n   Node: " + nodeRef + "\n" + (nameProp != null ? "   Name: " + nameProp + "\n" : "") + "   Type: " + typeQName + "\n" + "   Property: " + propertyQName);
                eventResults.add(result);
                continue;
            }
            Serializable propertyValue = nodeProperties.get(propertyQName);
            if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.ENCRYPTED) && propertyValue != null && !(propertyValue instanceof SealedObject)) {
                String nameProp = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                IntegrityRecord result = new IntegrityRecord("Property must be encrypted: \n   Node: " + nodeRef + "\n" + (nameProp != null ? "   Name: " + nameProp + "\n" : "") + "   Type: " + typeQName + "\n" + "   Property: " + propertyQName);
                eventResults.add(result);
            }
            List constraintDefs = propertyDef.getConstraints();
            for (ConstraintDefinition constraintDef : constraintDefs) {
                Constraint constraint = constraintDef.getConstraint();
                try {
                    constraint.evaluate((Object)propertyValue);
                }
                catch (ConstraintException e) {
                    String nameProp = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    IntegrityRecord result = new IntegrityRecord("Invalid property value: \n   Node: " + nodeRef + "\n" + (nameProp != null ? "   Name: " + nameProp + "\n" : "") + "   Type: " + typeQName + "\n" + "   Property: " + propertyQName + "\n" + "   Constraint: " + e.getMessage());
                    eventResults.add(result);
                }
            }
        }
    }
}

