/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.springframework.beans.factory.FactoryBean;

public class AuthenticatorAuthzClientFactoryBean
implements FactoryBean<AuthzClient> {
    private static Log logger = LogFactory.getLog(AuthenticatorAuthzClientFactoryBean.class);
    private IdentityServiceConfig identityServiceConfig;
    private boolean enabled;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIdentityServiceConfig(IdentityServiceConfig identityServiceConfig) {
        this.identityServiceConfig = identityServiceConfig;
    }

    public AuthzClient getObject() throws Exception {
        if (!this.enabled) {
            return null;
        }
        int conTimeout = this.identityServiceConfig.getClientConnectionTimeout();
        int socTimeout = this.identityServiceConfig.getClientSocketTimeout();
        HttpClient client = new HttpClientBuilder().establishConnectionTimeout((long)conTimeout, TimeUnit.MILLISECONDS).socketTimeout((long)socTimeout, TimeUnit.MILLISECONDS).build((AdapterHttpClientConfig)this.identityServiceConfig);
        HashMap<String, String> credentials = this.identityServiceConfig.getCredentials();
        if (credentials == null || !credentials.containsKey("secret")) {
            credentials = credentials == null ? new HashMap<String, String>() : new HashMap(credentials);
            credentials.put("secret", "");
        }
        String authServerUrl = this.identityServiceConfig.getAuthServerUrl();
        String realm = this.identityServiceConfig.getRealm();
        String resource = this.identityServiceConfig.getResource();
        Configuration authzConfig = new Configuration(authServerUrl, realm, resource, credentials, client);
        AuthzClient authzClient = AuthzClient.create((Configuration)authzConfig);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" Created Keycloak AuthzClient");
            logger.debug((Object)(" Keycloak AuthzClient server URL: " + authzClient.getConfiguration().getAuthServerUrl()));
            logger.debug((Object)(" Keycloak AuthzClient realm: " + authzClient.getConfiguration().getRealm()));
            logger.debug((Object)(" Keycloak AuthzClient resource: " + authzClient.getConfiguration().getResource()));
        }
        return authzClient;
    }

    public Class<?> getObjectType() {
        return AuthenticatorAuthzClientFactoryBean.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

