/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.net.ConnectException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.util.HttpResponseException;

public class IdentityServiceAuthenticationComponent
extends AbstractAuthenticationComponent
implements ActivateableBean {
    private final Log logger = LogFactory.getLog(IdentityServiceAuthenticationComponent.class);
    private AuthzClient authzClient;
    private boolean active;
    private boolean allowGuestLogin;

    public void setAuthenticatorAuthzClient(AuthzClient authenticatorAuthzClient) {
        this.authzClient = authenticatorAuthzClient;
    }

    public void setAllowGuestLogin(boolean allowGuestLogin) {
        this.allowGuestLogin = allowGuestLogin;
    }

    @Override
    public void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        if (this.authzClient == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"AuthzClient was not set, possibly due to the 'identity-service.authentication.enable-username-password-authentication=false' property. ");
            }
            throw new AuthenticationException("User not authenticated because AuthzClient was not set.");
        }
        try {
            this.authzClient.obtainAccessToken(userName, new String(password));
            this.setCurrentUser(userName);
        }
        catch (HttpResponseException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to authenticate user against Keycloak. Status: " + e.getStatusCode() + " Reason: " + e.getReasonPhrase()));
            }
            throw new AuthenticationException("Failed to authenticate user against Keycloak.", (Throwable)e);
        }
        catch (RuntimeException e) {
            Throwable cause = ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{ConnectException.class});
            if (cause != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Couldn't connect to Keycloak server to authenticate user. Reason: " + cause.getMessage()));
                }
                throw new AuthenticationException("Couldn't connect to Keycloak server to authenticate user.", cause);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Error occurred while authenticating user against Keycloak. Reason: " + e.getMessage()));
            }
            throw new AuthenticationException("Error occurred while authenticating user against Keycloak.", (Throwable)e);
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return this.allowGuestLogin;
    }
}

