/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.template.BaseContentNode;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.template.TemplateProperties;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameMap;
import org.springframework.extensions.surf.util.URLEncoder;

public class VersionHistoryNode
extends BaseContentNode
implements NamespacePrefixResolverProvider {
    private QNameMap<String, Serializable> properties;
    private boolean propsRetrieved = false;
    private Version version;
    private TemplateNode parent;
    private Set<QName> aspects = null;

    public VersionHistoryNode(Version version, TemplateNode parent, ServiceRegistry services) {
        if (version == null) {
            throw new IllegalArgumentException("Version history descriptor is mandatory.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent TemplateNode is mandatory.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.version = version;
        this.parent = parent;
        this.services = services;
        this.properties = new QNameMap((NamespacePrefixResolverProvider)this);
    }

    @Override
    public String getId() {
        return this.version.getFrozenStateNodeRef().getId();
    }

    @Override
    public NodeRef getNodeRef() {
        return this.version.getFrozenStateNodeRef();
    }

    @Override
    public QName getType() {
        return this.parent.services.getNodeService().getType(this.version.getFrozenStateNodeRef());
    }

    @Override
    public String getName() {
        return (String)((Object)this.getProperties().get(ContentModel.PROP_NAME));
    }

    public String getTitle() {
        return (String)((Object)this.getProperties().get(ContentModel.PROP_TITLE));
    }

    public Date getCreatedDate() {
        return this.version.getCreatedDate();
    }

    public String getCreator() {
        return this.version.getCreator();
    }

    public String getVersionLabel() {
        return this.version.getVersionLabel();
    }

    public boolean getIsMajorVersion() {
        return this.version.getVersionType() == VersionType.MAJOR;
    }

    public String getDescription() {
        return this.version.getDescription();
    }

    @Override
    public Map<String, Serializable> getProperties() {
        if (!this.propsRetrieved) {
            Map props = this.parent.services.getNodeService().getProperties(this.version.getFrozenStateNodeRef());
            for (QName qname : props.keySet()) {
                Serializable propValue = new TemplateNode.TemplatePropertyConverter(this.parent).convertProperty((Serializable)props.get(qname), qname, this.parent.services, this.parent.imageResolver);
                this.properties.put((Object)qname.toString(), (Object)propValue);
            }
            this.propsRetrieved = true;
        }
        return this.properties;
    }

    @Override
    public Set<QName> getAspects() {
        if (this.aspects == null) {
            this.aspects = this.parent.services.getNodeService().getAspects(this.version.getFrozenStateNodeRef());
        }
        return this.aspects;
    }

    @Override
    public boolean hasAspect(String aspect) {
        if (this.aspects == null) {
            this.getAspects();
        }
        if (aspect.startsWith("{")) {
            return this.aspects.contains(QName.createQName((String)aspect));
        }
        boolean found = false;
        for (QName qname : this.aspects) {
            if (!qname.toPrefixString((NamespacePrefixResolver)this.parent.services.getNamespaceService()).equals(aspect)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public List<TemplateProperties> getChildren() {
        return null;
    }

    @Override
    public TemplateProperties getParent() {
        return null;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.services.getNamespaceService();
    }

    @Override
    public String getUrl() {
        NodeRef nodeRef = this.version.getFrozenStateNodeRef();
        return MessageFormat.format("/d/d/{0}/{1}/{2}/{3}", nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId(), URLEncoder.encode((String)this.getName()));
    }
}

