/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.ref.VirtualProtocol;

public enum Protocols {
    NODE(new NodeProtocol()),
    VIRTUAL(new VirtualProtocol()),
    VANILLA(new VanillaProtocol());

    private static volatile Map<String, Protocol> protocolsMap;
    public final Protocol protocol;

    public static synchronized Protocol fromName(String name) {
        return protocolsMap.get(name);
    }

    private static synchronized void register(Protocol protocol) {
        if (protocolsMap == null) {
            protocolsMap = new HashMap<String, Protocol>();
        }
        protocolsMap.put(protocol.name, protocol);
    }

    private Protocols(Protocol protocol) {
        this.protocol = protocol;
        Protocols.register(protocol);
    }
}

