/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.AbstractBulkImportTests;
import org.alfresco.repo.bulkimport.impl.StreamingNodeImporterFactory;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.util.ResourceUtils;

@Category(value={OwnJVMTestsCategory.class})
public class BulkImportTest
extends AbstractBulkImportTests {
    private StreamingNodeImporterFactory streamingNodeImporterFactory;

    @BeforeClass
    public static void beforeTests() {
        BulkImportTest.startContext();
    }

    @Override
    @Before
    public void setup() throws SystemException, NotSupportedException {
        super.setup();
        this.streamingNodeImporterFactory = (StreamingNodeImporterFactory)AbstractBulkImportTests.ctx.getBean("streamingNodeImporterFactory");
    }

    @Test
    public void testMNT8470() throws Throwable {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        try {
            NodeImporter nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport1"));
            BulkImportParameters bulkImportParameters = new BulkImportParameters();
            bulkImportParameters.setTarget(folderNode);
            bulkImportParameters.setReplaceExisting(true);
            bulkImportParameters.setDisableRulesService(true);
            bulkImportParameters.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        List<FileInfo> folders = this.getFolders(folderNode, null);
        Assert.assertEquals((long)1L, (long)folders.size());
        FileInfo folder1 = folders.get(0);
        Assert.assertEquals((Object)"folder1", (Object)folder1.getName());
        Assert.assertEquals((Object)"", folder1.getProperties().get(ContentModel.PROP_TITLE));
    }

    @Test
    public void testCopyImportStriping() throws Throwable {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        try {
            NodeImporter nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport"));
            BulkImportParameters bulkImportParameters = new BulkImportParameters();
            bulkImportParameters.setTarget(folderNode);
            bulkImportParameters.setReplaceExisting(true);
            bulkImportParameters.setDisableRulesService(true);
            bulkImportParameters.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        System.out.println(this.bulkImporter.getStatus());
        this.checkFiles(folderNode, null, 2, 9, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quickImg1.xls", "application/vnd.ms-excel"), new AbstractBulkImportTests.ExpectedFile("quickImg1.doc", "application/msword"), new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1"), new AbstractBulkImportTests.ExpectedFolder("folder2")});
        List<FileInfo> folders = this.getFolders(folderNode, "folder1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1, null, 1, 0, null, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1")});
        folders = this.getFolders(folderNode, "folder2");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2 = folders.get(0).getNodeRef();
        this.checkFiles(folder2, null, 1, 0, new AbstractBulkImportTests.ExpectedFile[0], new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder2.1")});
        folders = this.getFolders(folder1, "folder1.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1_1, null, 2, 12, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog"), new AbstractBulkImportTests.ExpectedFile("quick.sxw", "application/vnd.sun.xml.writer"), new AbstractBulkImportTests.ExpectedFile("quick.tar", "application/x-gtar")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1.1"), new AbstractBulkImportTests.ExpectedFolder("folder1.1.2")});
        folders = this.getFolders(folder2, "folder2.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder2_1, null, 0, 17, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.png", "image/png"), new AbstractBulkImportTests.ExpectedFile("quick.pdf", "application/pdf"), new AbstractBulkImportTests.ExpectedFile("quick.odt", "application/vnd.oasis.opendocument.text")}, new AbstractBulkImportTests.ExpectedFolder[0]);
    }

    protected Rule createCopyRule(NodeRef targetNode, boolean isAppliedToChildren) {
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        String title = "rule title " + System.currentTimeMillis();
        rule.setTitle(title);
        rule.setDescription(title);
        rule.applyToChildren(isAppliedToChildren);
        HashMap<String, NodeRef> params = new HashMap<String, NodeRef>(1);
        params.put("destination-folder", targetNode);
        Action action = this.actionService.createAction("copy", params);
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(condition);
        rule.setAction(action);
        return rule;
    }

    @Test
    public void testImportWithRules() throws Throwable {
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        NodeImporter nodeImporter = null;
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef targetNode = this.fileFolderService.create(this.top, "target", ContentModel.TYPE_FOLDER).getNodeRef();
        Rule newRule = this.createCopyRule(targetNode, false);
        this.ruleService.saveRule(folderNode, newRule);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport"));
        BulkImportParameters bulkImportParameters = new BulkImportParameters();
        bulkImportParameters.setTarget(folderNode);
        bulkImportParameters.setReplaceExisting(true);
        bulkImportParameters.setDisableRulesService(false);
        bulkImportParameters.setBatchSize(Integer.valueOf(40));
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((long)74L, (long)this.bulkImporter.getStatus().getNumberOfContentNodesCreated());
        this.checkFiles(folderNode, null, 2, 9, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quickImg1.xls", "application/vnd.ms-excel"), new AbstractBulkImportTests.ExpectedFile("quickImg1.doc", "application/msword"), new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1"), new AbstractBulkImportTests.ExpectedFolder("folder2")});
        List<FileInfo> folders = this.getFolders(folderNode, "folder1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1, null, 1, 0, null, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1")});
        folders = this.getFolders(folderNode, "folder2");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2 = folders.get(0).getNodeRef();
        this.checkFiles(folder2, null, 1, 0, new AbstractBulkImportTests.ExpectedFile[0], new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder2.1")});
        folders = this.getFolders(folder1, "folder1.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1_1, null, 2, 12, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog"), new AbstractBulkImportTests.ExpectedFile("quick.sxw", "application/vnd.sun.xml.writer"), new AbstractBulkImportTests.ExpectedFile("quick.tar", "application/x-gtar")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1.1"), new AbstractBulkImportTests.ExpectedFolder("folder1.1.2")});
        folders = this.getFolders(folder2, "folder2.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder2_1, null, 0, 17, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.png", "image/png"), new AbstractBulkImportTests.ExpectedFile("quick.pdf", "application/pdf"), new AbstractBulkImportTests.ExpectedFile("quick.odt", "application/vnd.oasis.opendocument.text")}, new AbstractBulkImportTests.ExpectedFolder[0]);
    }

    @Test
    public void testMNT18275_ai_eps() throws Throwable {
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        NodeImporter nodeImporter = null;
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport5"));
        BulkImportParameters bulkImportParameters = new BulkImportParameters();
        bulkImportParameters.setTarget(folderNode);
        bulkImportParameters.setReplaceExisting(true);
        bulkImportParameters.setDisableRulesService(true);
        bulkImportParameters.setBatchSize(Integer.valueOf(40));
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        System.out.println(this.bulkImporter.getStatus());
        this.checkFiles(folderNode, null, 0, 3, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.gif", "image/gif"), new AbstractBulkImportTests.ExpectedFile("Amazing.ai", "application/illustrator"), new AbstractBulkImportTests.ExpectedFile("quick.eps", "application/eps")}, new AbstractBulkImportTests.ExpectedFolder[0]);
    }

    @Test
    public void testMNT9076() throws Throwable {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        try {
            NodeImporter nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport2"));
            BulkImportParameters bulkImportParameters = new BulkImportParameters();
            bulkImportParameters.setTarget(folderNode);
            bulkImportParameters.setReplaceExisting(true);
            bulkImportParameters.setDisableRulesService(true);
            bulkImportParameters.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        List<FileInfo> files = this.getFiles(folderNode, null);
        Assert.assertEquals((String)"One file is expected to be imported:", (long)1L, (long)files.size());
        FileInfo file = files.get(0);
        Assert.assertEquals((String)"File name is not equal:", (Object)"fileWithVersions.txt", (Object)file.getName());
        NodeRef file0NodeRef = file.getNodeRef();
        Assert.assertTrue((String)"Imported file should be versioned:", (boolean)this.versionService.isVersioned(file0NodeRef));
        VersionHistory history = this.versionService.getVersionHistory(file0NodeRef);
        Assert.assertEquals((String)"Imported file should have 4 versions:", (long)4L, (long)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[4]);
        ContentReader contentReader = this.contentService.getReader(versions[0].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is the final version of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[1].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 3 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[2].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 2 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[3].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 1 of fileWithVersions.txt.", (Object)contentReader.getContentString());
    }

    @Test
    public void testMNT9067() throws Throwable {
        BulkImportParameters bulkImportParameters;
        NodeImporter nodeImporter;
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        try {
            NodeImporter nodeImporter2 = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport3/initial"));
            BulkImportParameters bulkImportParameters2 = new BulkImportParameters();
            bulkImportParameters2.setTarget(folderNode);
            bulkImportParameters2.setReplaceExisting(true);
            bulkImportParameters2.setDisableRulesService(true);
            bulkImportParameters2.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters2, nodeImporter2);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        List<FileInfo> files = this.getFiles(folderNode, null);
        Assert.assertEquals((String)"One file is expected to be imported:", (long)1L, (long)files.size());
        FileInfo file = files.get(0);
        Assert.assertEquals((String)"File name is not equal:", (Object)"fileWithVersions.txt", (Object)file.getName());
        NodeRef fileNodeRef = file.getNodeRef();
        Assert.assertTrue((String)"Imported file should be versioned:", (boolean)this.versionService.isVersioned(fileNodeRef));
        VersionHistory history = this.versionService.getVersionHistory(fileNodeRef);
        Assert.assertEquals((String)"Imported file should have 4 versions:", (long)4L, (long)history.getAllVersions().size());
        try {
            NodeImporter nodeImporter3 = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport3/replace_with_versioned"));
            BulkImportParameters bulkImportParameters3 = new BulkImportParameters();
            bulkImportParameters3.setTarget(folderNode);
            bulkImportParameters3.setReplaceExisting(true);
            bulkImportParameters3.setDisableRulesService(true);
            bulkImportParameters3.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters3, nodeImporter3);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        files = this.getFiles(folderNode, null);
        Assert.assertEquals((String)"One file is expected to be imported:", (long)1L, (long)files.size());
        file = files.get(0);
        Assert.assertEquals((String)"File name is not equal:", (Object)"fileWithVersions.txt", (Object)file.getName());
        fileNodeRef = file.getNodeRef();
        Assert.assertTrue((String)"Imported file should be versioned:", (boolean)this.versionService.isVersioned(fileNodeRef));
        history = this.versionService.getVersionHistory(fileNodeRef);
        Assert.assertNotNull((Object)history);
        Assert.assertEquals((String)"Imported file should have 9 versions:", (long)9L, (long)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[9]);
        ContentReader contentReader = this.contentService.getReader(versions[0].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is the final version of replaced on import fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[1].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 4 of replaced on import fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[2].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 3 of replaced on import fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[3].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 2 of replaced on import fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[4].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 1 of replaced on import fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[5].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is the final version of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[6].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 3 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[7].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 2 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[8].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 1 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        try {
            nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport3/replace_with_non_versioned"));
            bulkImportParameters = new BulkImportParameters();
            bulkImportParameters.setTarget(folderNode);
            bulkImportParameters.setReplaceExisting(true);
            bulkImportParameters.setDisableRulesService(true);
            bulkImportParameters.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        files = this.getFiles(folderNode, null);
        Assert.assertEquals((String)"One file is expected to be imported:", (long)1L, (long)files.size());
        file = files.get(0);
        Assert.assertEquals((String)"File name is not equal:", (Object)"fileWithVersions.txt", (Object)file.getName());
        fileNodeRef = file.getNodeRef();
        Assert.assertTrue((String)"Imported file should be non versioned:", (!this.versionService.isVersioned(fileNodeRef) ? 1 : 0) != 0);
        contentReader = this.contentService.getReader(fileNodeRef, ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is non versioned fileWithVersions.txt.", (Object)contentReader.getContentString());
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        try {
            nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport3/initial"));
            bulkImportParameters = new BulkImportParameters();
            bulkImportParameters.setTarget(folderNode);
            bulkImportParameters.setReplaceExisting(true);
            bulkImportParameters.setDisableRulesService(true);
            bulkImportParameters.setBatchSize(Integer.valueOf(40));
            this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        files = this.getFiles(folderNode, null);
        Assert.assertEquals((String)"One file is expected to be imported:", (long)1L, (long)files.size());
        file = files.get(0);
        Assert.assertEquals((String)"File name is not equal:", (Object)"fileWithVersions.txt", (Object)file.getName());
        fileNodeRef = file.getNodeRef();
        Assert.assertTrue((String)"Imported file should be versioned:", (boolean)this.versionService.isVersioned(fileNodeRef));
        history = this.versionService.getVersionHistory(fileNodeRef);
        Assert.assertNotNull((Object)history);
        Assert.assertEquals((String)"Imported file should have 4 versions:", (long)4L, (long)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[4]);
        contentReader = this.contentService.getReader(versions[0].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is the final version of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[1].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 3 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[2].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 2 of fileWithVersions.txt.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[3].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"This is version 1 of fileWithVersions.txt.", (Object)contentReader.getContentString());
    }

    @Test
    public void testImportFilesWithSpecialCharacters() throws Throwable {
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        NodeImporter nodeImporter = null;
        File source = ResourceUtils.getFile((String)"classpath:bulkimport4");
        String fileName = new String("135 Carbon\u00d4\u00c7\u00f413 NMR spectroscopy_DS_NS_final_cau.txt".getBytes(Charset.forName("ISO-8859-1")), Charset.forName("UTF-8"));
        Path dest = source.toPath().resolve("encoding");
        try {
            dest = Files.createDirectory(dest, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        Path destFile = dest.resolve(fileName);
        this.unpack(source.toPath(), destFile);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport4/encoding"));
        BulkImportParameters bulkImportParameters = new BulkImportParameters();
        bulkImportParameters.setTarget(folderNode);
        bulkImportParameters.setReplaceExisting(true);
        bulkImportParameters.setDisableRulesService(true);
        bulkImportParameters.setBatchSize(Integer.valueOf(40));
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        Assert.assertEquals((long)1L, (long)this.bulkImporter.getStatus().getNumberOfContentNodesCreated());
        this.checkFiles(folderNode, null, 0, 1, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile(fileName, "text/plain")}, null);
        Files.deleteIfExists(destFile);
        Files.deleteIfExists(dest);
    }

    @Test
    public void testImportFilesWithVersionLabel() throws Throwable {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        NodeImporter nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport6"));
        BulkImportParameters bulkImportParameters = new BulkImportParameters();
        bulkImportParameters.setTarget(folderNode);
        bulkImportParameters.setDisableRulesService(true);
        bulkImportParameters.setExistingFileMode(BulkImportParameters.ExistingFileMode.REPLACE);
        bulkImportParameters.setBatchSize(Integer.valueOf(1));
        bulkImportParameters.setNumThreads(Integer.valueOf(1));
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        List<FileInfo> files = this.getFiles(folderNode, null);
        Assert.assertNotNull(files);
        FileInfo file = files.get(0);
        Assert.assertNotNull((Object)file);
        VersionHistory history = this.versionService.getVersionHistory(file.getNodeRef());
        Assert.assertEquals((long)1L, (long)this.bulkImporter.getStatus().getNumberOfContentNodesCreated());
        Assert.assertEquals((String)"Imported file should have 3 versions:", (long)3L, (long)history.getAllVersions().size());
    }

    private File resourceAsFile(String resourceName) {
        try {
            return ResourceUtils.getFile((String)resourceName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Resource " + resourceName + " not found", e);
        }
    }

    @Test
    public void canVersionDocsWithoutSpecialInputFileNameExtension() throws HeuristicMixedException, IOException, SystemException, HeuristicRollbackException, NotSupportedException, RollbackException {
        this.testCanVersionDocsWithoutSpecialInputFileNameExtension(file -> this.streamingNodeImporterFactory.getNodeImporter(this.resourceAsFile("classpath:bulkimport-autoversion/" + file)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unpack(Path source, Path destFile) {
        Path archive = source.resolve("testbulk.gz");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                GZIPInputStream gzis = new GZIPInputStream(Files.newInputStream(archive, new OpenOption[0]));
                try {
                    try (OutputStream out = Files.newOutputStream(destFile, StandardOpenOption.CREATE);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = gzis.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                    if (gzis == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (gzis == null) throw throwable;
                    gzis.close();
                    throw throwable;
                }
                gzis.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

