/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.node.ContentPropertyRestrictionInterceptor;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class RoutingContentServiceTest
extends TestCase {
    private ApplicationContext ctx;
    private static final String SOME_CONTENT = "ABC";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/RoutingContentServiceTest";
    private TransactionService transactionService;
    private ContentService contentService;
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private CopyService copyService;
    private AuthenticationComponent authenticationComponent;
    private UserTransaction txn;
    private NodeRef rootNodeRef;
    private NodeRef contentNodeRef;
    private boolean policyFired = false;
    private boolean readPolicyFired = false;
    private boolean newContent = true;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.contentService = (ContentService)this.ctx.getBean(ServiceRegistry.CONTENT_SERVICE.getLocalName());
        this.copyService = (CopyService)this.ctx.getBean("CopyService");
        this.policyComponent = (PolicyComponent)this.ctx.getBean("policyComponent");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.txn = this.getUserTransaction();
        this.txn.begin();
        StoreRef storeRef = new StoreRef("workspace", this.getName());
        if (!this.nodeService.exists(storeRef)) {
            storeRef = this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_CONTENT);
        this.contentNodeRef = assocRef.getChildRef();
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-16");
        writer.setLocale(Locale.CHINESE);
        writer.setMimetype("text/plain");
        writer.putContent("sample content");
    }

    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {}
        try {
            if (this.txn != null) {
                this.txn.rollback();
            }
        }
        catch (Throwable throwable) {}
    }

    private UserTransaction getUserTransaction() {
        return this.transactionService.getUserTransaction();
    }

    public void testSetUp() throws Exception {
        RoutingContentServiceTest.assertNotNull((Object)this.contentService);
        RoutingContentServiceTest.assertNotNull((Object)this.nodeService);
        RoutingContentServiceTest.assertNotNull((Object)this.rootNodeRef);
        RoutingContentServiceTest.assertNotNull((Object)this.contentNodeRef);
        RoutingContentServiceTest.assertNotNull((Object)this.getUserTransaction());
        RoutingContentServiceTest.assertFalse((this.getUserTransaction() == this.getUserTransaction() ? 1 : 0) != 0);
    }

    public void testSimpleNonTempWriter() throws Exception {
        ContentWriter writer = this.contentService.getWriter(null, null, false);
        RoutingContentServiceTest.assertNotNull((String)"Writer should not be null", (Object)writer);
        RoutingContentServiceTest.assertNotNull((String)"Content URL should not be null", (Object)writer.getContentUrl());
        writer.putContent(SOME_CONTENT);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-16");
        writer.setLocale(Locale.CHINESE);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Reader should not be null", (Object)reader);
        RoutingContentServiceTest.assertNotNull((String)"Content URL should not be null", (Object)reader.getContentUrl());
        RoutingContentServiceTest.assertEquals((String)"Content Encoding was not set", (String)"UTF-16", (String)reader.getEncoding());
        RoutingContentServiceTest.assertEquals((String)"Content Locale was not set", (Object)Locale.CHINESE, (Object)reader.getLocale());
    }

    public void testAutoSettingOfProperties() throws Exception {
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNotNull((String)"Writer should not be null", (Object)writer);
        RoutingContentServiceTest.assertNotNull((String)"Content URL should not be null", (Object)writer.getContentUrl());
        RoutingContentServiceTest.assertNotNull((String)"Content mimetype should not be null", (Object)writer.getMimetype());
        RoutingContentServiceTest.assertNotNull((String)"Content encoding should not be null", (Object)writer.getEncoding());
        RoutingContentServiceTest.assertNotNull((String)"Content locale should not be null", (Object)writer.getLocale());
        writer.putContent(SOME_CONTENT);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Reader should not be null", (Object)reader);
        RoutingContentServiceTest.assertNotNull((String)"Content URL should not be null", (Object)reader.getContentUrl());
        RoutingContentServiceTest.assertNotNull((String)"Content mimetype should not be null", (Object)reader.getMimetype());
        RoutingContentServiceTest.assertNotNull((String)"Content encoding should not be null", (Object)reader.getEncoding());
        RoutingContentServiceTest.assertNotNull((String)"Content locale should not be null", (Object)reader.getLocale());
        long length = SOME_CONTENT.getBytes(reader.getEncoding()).length;
        long checkLength = reader.getSize();
        RoutingContentServiceTest.assertEquals((String)"Content length incorrect", (long)length, (long)checkLength);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content incorrect", (String)SOME_CONTENT, (String)contentCheck);
    }

    public void testWriteToNodeWithoutAnyContentProperties() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNull((Object)writer.getMimetype());
        RoutingContentServiceTest.assertEquals((String)"UTF-8", (String)writer.getEncoding());
        RoutingContentServiceTest.assertEquals((Object)Locale.getDefault(), (Object)writer.getLocale());
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-16");
        writer.setLocale(Locale.FRENCH);
        String content = "The quick brown fox ...";
        writer.putContent(content);
        ContentData contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertEquals((String)"metadata didn't get onto node", (Object)writer.getContentData(), (Object)contentData);
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertEquals((String)"Metadata didn't get set on reader", (Object)writer.getContentData(), (Object)reader.getContentData());
    }

    public void ignoreTestNullReaderForNullUrl() throws Exception {
        ContentData contentData = new ContentData(null, null, 0L, null);
        this.nodeService.setProperty(this.contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Reader must be null if the content URL is null", (Object)reader);
    }

    public void testContentStoreSizes() throws Exception {
        this.contentService.getStoreFreeSpace();
        this.contentService.getStoreTotalSpace();
    }

    public void testGetRawReader() throws Exception {
        ContentReader reader = this.contentService.getRawReader("test://non-existence");
        RoutingContentServiceTest.assertNotNull((String)"A reader is expected with content URL referencing no content", (Object)reader);
        RoutingContentServiceTest.assertFalse((String)"Reader should not have any content", (boolean)reader.exists());
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
        writer.putContent("ABC from " + this.getName());
        String contentUrl = writer.getContentUrl();
        reader = this.contentService.getRawReader(contentUrl);
        RoutingContentServiceTest.assertNotNull((String)"Expected reader for live, raw content", (Object)reader);
        RoutingContentServiceTest.assertEquals((String)"Content sizes don't match", (long)writer.getSize(), (long)reader.getSize());
    }

    public void testMissingContent() throws Exception {
        ContentPropertyRestrictionInterceptor contentPropertyRestrictionInterceptor = (ContentPropertyRestrictionInterceptor)this.ctx.getBean("contentPropertyRestrictionInterceptor");
        contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList(((Object)((Object)this)).getClass().getName());
        try {
            File tempFile = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
            FileContentWriter writer = new FileContentWriter(tempFile);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent("What about the others?  Buckwheats!");
            RoutingContentServiceTest.assertTrue((String)"File does not exist", (boolean)tempFile.exists());
            RoutingContentServiceTest.assertTrue((String)"File not written to", (tempFile.length() > 0L ? 1 : 0) != 0);
            ContentData contentData = writer.getContentData();
            this.nodeService.setProperty(this.contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
            tempFile.delete();
            RoutingContentServiceTest.assertFalse((String)"File not deleted", (boolean)tempFile.exists());
            ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
            RoutingContentServiceTest.assertFalse((String)"Reader should indicate that content is missing", (boolean)reader.exists());
            this.txn.commit();
            this.txn = null;
            this.txn = this.getUserTransaction();
            this.txn.begin();
            this.nodeService.deleteNode(this.contentNodeRef);
            this.txn.commit();
            this.txn = null;
        }
        finally {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList("");
        }
    }

    public void testSimpleWrite() throws Exception {
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
        RoutingContentServiceTest.assertNotNull((String)"Writer should not be null", (Object)writer);
        writer.putContent(SOME_CONTENT);
    }

    public void testOnContentUpdatePolicy() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onContentUpdate"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour((Object)this, "onContentUpdateBehaviourTest"));
        ContentWriter contentWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent("content update one");
        RoutingContentServiceTest.assertFalse((boolean)this.policyFired);
        this.newContent = false;
        this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.putContent("content update two");
        RoutingContentServiceTest.assertTrue((boolean)this.policyFired);
        this.policyFired = false;
        ContentWriter contentWriter3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
        contentWriter3.putContent("content update three");
        RoutingContentServiceTest.assertFalse((boolean)this.policyFired);
    }

    public void onContentUpdateBehaviourTest(NodeRef nodeRef, boolean newContent) {
        RoutingContentServiceTest.assertEquals((Object)this.contentNodeRef, (Object)nodeRef);
        RoutingContentServiceTest.assertEquals((boolean)this.newContent, (boolean)newContent);
        RoutingContentServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.policyFired = true;
    }

    public void testOnContentReadPolicy() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onContentRead"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour((Object)this, "onContentReadBehaviourTest"));
        this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertFalse((boolean)this.readPolicyFired);
        ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.putContent("content update two");
        this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertFalse((boolean)this.readPolicyFired);
        this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertTrue((boolean)this.readPolicyFired);
    }

    public void onContentReadBehaviourTest(NodeRef nodeRef) {
        this.readPolicyFired = true;
    }

    public void testTempWrite() throws Exception {
        ContentWriter writer1 = this.contentService.getTempWriter();
        ContentWriter writer2 = this.contentService.getTempWriter();
        RoutingContentServiceTest.assertNotSame((String)"Temp URLs must be different", (Object)writer1.getContentUrl(), (Object)writer2.getContentUrl());
    }

    public void testUpdatingWrite() throws Exception {
        ContentData contentData = (ContentData)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_CONTENT);
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNotNull((String)"No writer received", (Object)writer);
        writer.putContent(SOME_CONTENT);
        try {
            writer.putContent("DEF");
            RoutingContentServiceTest.fail((String)"Failed to prevent repeated use of the content writer");
        }
        catch (ContentIOException contentIOException) {}
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"No reader available for node", (Object)reader);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content fetched doesn't match that written", (String)SOME_CONTENT, (String)contentCheck);
        contentData = (ContentData)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Content data not set", (Object)contentData);
        RoutingContentServiceTest.assertEquals((String)"Mismatched URL between writer and node", (String)writer.getContentUrl(), (String)contentData.getContentUrl());
        RoutingContentServiceTest.assertEquals((String)"Reader content length and node content length different", (long)reader.getSize(), (long)contentData.getSize());
        RoutingContentServiceTest.assertEquals((String)"Mimetype not set on content data", (String)"text/plain", (String)contentData.getMimetype());
        RoutingContentServiceTest.assertEquals((String)"Encoding not set", (String)"UTF-16", (String)contentData.getEncoding());
    }

    public void testConcurrentWritesNoTxn() throws Exception {
        this.txn.commit();
        this.txn = null;
        ContentWriter writer1 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer1.putContent("writer1 wrote this");
        writer2.putContent("writer2 wrote this");
        writer3.putContent("writer3 wrote this");
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)"writer3 wrote this", (String)contentCheck);
    }

    public void testConcurrentWritesWithSingleTxn() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
        this.txn.commit();
        this.txn = null;
        UserTransaction txn = this.getUserTransaction();
        txn.begin();
        txn.setRollbackOnly();
        ContentWriter writer1 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer2 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer3 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer1.putContent("writer1 wrote this");
        writer2.putContent("writer2 wrote this");
        writer3.putContent("writer3 wrote this");
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)"writer3 wrote this", (String)contentCheck);
        try {
            txn.commit();
            RoutingContentServiceTest.fail((String)"Transaction has been marked for rollback");
        }
        catch (RollbackException rollbackException) {}
        txn.rollback();
        txn = this.getUserTransaction();
        txn.begin();
        txn.setRollbackOnly();
        reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Transaction was rolled back - no content should be visible", (Object)reader);
        txn.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void testConcurrentWritesWithMultipleTxns() throws Exception {
        nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/RoutingContentServiceTest", (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
        reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Reader should not be available", (Object)reader);
        this.txn.commit();
        this.txn = null;
        threadContent = "Thread content";
        writeThreads = new WriteThread[5];
        i = 0;
        while (i < writeThreads.length) {
            threadWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            writeThreads[i] = new WriteThread(threadWriter, threadContent);
            writeThreads[i].start();
            ++i;
        }
        block4: while (true) {
            i = 0;
            while (i < writeThreads.length) {
                if (!writeThreads[i].isWaiting()) {
                    this.wait(10L);
                    continue block4;
                }
                ++i;
            }
            break;
        }
        i = 0;
        while (i < writeThreads.length) {
            var6_7 = writeThreads[i];
            synchronized (var6_7) {
                writeThreads[i].notifyAll();
            }
            ++i;
        }
        i = 0;
        ** GOTO lbl40
        {
            this.wait(10L);
            do {
                if (!writeThreads[i].isDone()) continue block7;
                ++i;
lbl40:
                // 2 sources

            } while (i < writeThreads.length);
        }
        reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Reader should now be available", (Object)reader);
        checkContent = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)threadContent, (String)checkContent);
    }

    public void testUnknownMimetype() throws Exception {
        String bogusMimetype = "text/bamboozle";
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(bogusMimetype);
        writer.putContent(SOME_CONTENT);
        this.txn.commit();
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Should be able to get reader", (Object)reader);
        RoutingContentServiceTest.assertEquals((String)"Unknown mimetype was changed", (String)bogusMimetype, (String)reader.getMimetype());
    }

    public void testPostCopyContentRetrieval() throws Exception {
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("Some content");
        ContentData writerContentData = writer.getContentData();
        ContentData nodeContentData = (ContentData)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((Object)nodeContentData);
        RoutingContentServiceTest.assertEquals((String)"ContentData not the same from NodeService and from ContentWriter", (Object)writerContentData, (Object)nodeContentData);
        Map copyProperties = this.nodeService.getProperties(this.contentNodeRef);
        copyProperties.remove(ContentModel.PROP_NODE_UUID);
        NodeRef contentCopyNodeRef = this.copyService.copy(this.contentNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()));
        ContentData copyNodeContentData = (ContentData)this.nodeService.getProperty(contentCopyNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((Object)copyNodeContentData);
        RoutingContentServiceTest.assertEquals((String)"Copied node's cm:content ContentData was different", (Object)writerContentData, (Object)copyNodeContentData);
        this.nodeService.deleteNode(this.contentNodeRef);
        copyNodeContentData = (ContentData)this.nodeService.getProperty(contentCopyNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((Object)copyNodeContentData);
        RoutingContentServiceTest.assertEquals((String)"Post-delete value didn't remain the same", (Object)writerContentData, (Object)copyNodeContentData);
        ContentReader copyNodeContentReader = this.contentService.getReader(contentCopyNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertTrue((String)"Physical content was removed", (boolean)copyNodeContentReader.exists());
        this.txn.commit();
        this.txn = null;
    }

    public void testRollbackCleanup_ALF2890() throws Exception {
        ContentPropertyRestrictionInterceptor contentPropertyRestrictionInterceptor = (ContentPropertyRestrictionInterceptor)this.ctx.getBean("contentPropertyRestrictionInterceptor");
        contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList(((Object)((Object)this)).getClass().getName());
        try {
            ContentReader[] readers;
            block8: {
                ContentReader readerStep3;
                ContentReader readerStep2;
                ContentWriter simpleWriter;
                block7: {
                    ContentWriter updatingWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                    updatingWriter.putContent("STEP 1");
                    this.txn.commit();
                    this.txn = null;
                    ContentReader readerStep1 = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
                    RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 1", (String)readerStep1.getContentString());
                    simpleWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
                    simpleWriter.putContent("STEP 2");
                    readerStep1 = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
                    RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 1", (String)readerStep1.getContentString());
                    this.nodeService.setProperty(this.contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)simpleWriter.getContentData());
                    readerStep2 = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
                    RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 2", (String)readerStep2.getContentString());
                    simpleWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
                    simpleWriter.putContent("STEP 3");
                    readerStep3 = simpleWriter.getReader();
                    RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 3", (String)readerStep3.getContentString());
                    readerStep2 = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
                    RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 2", (String)readerStep2.getContentString());
                    final ContentData simpleWriterData = simpleWriter.getContentData();
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> failToSetPropCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            RoutingContentServiceTest.this.nodeService.setProperty(RoutingContentServiceTest.this.contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)simpleWriterData);
                            throw new RuntimeException("aaa");
                        }
                    };
                    try {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)failToSetPropCallback);
                    }
                    catch (RuntimeException e) {
                        if (e.getMessage().equals("aaa")) break block7;
                        throw e;
                    }
                }
                readerStep3 = simpleWriter.getReader();
                RoutingContentServiceTest.assertTrue((String)"Content was cleaned up when it originated outside of the transaction", (boolean)readerStep3.exists());
                RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 3", (String)readerStep3.getContentString());
                readerStep2 = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
                RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"STEP 2", (String)readerStep2.getContentString());
                readers = new ContentReader[1];
                RetryingTransactionHelper.RetryingTransactionCallback<Void> rollbackCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        ContentWriter writer = RoutingContentServiceTest.this.contentService.getWriter(RoutingContentServiceTest.this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                        writer.putContent("UNLUCKY CONTENT");
                        ContentReader reader = RoutingContentServiceTest.this.contentService.getReader(RoutingContentServiceTest.this.contentNodeRef, ContentModel.PROP_CONTENT);
                        RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"UNLUCKY CONTENT", (String)reader.getContentString());
                        RoutingContentServiceTest.assertEquals((String)"Incorrect content", (String)"UNLUCKY CONTENT", (String)writer.getReader().getContentString());
                        readers[0] = reader;
                        throw new RuntimeException("aaa");
                    }
                };
                try {
                    this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)rollbackCallback);
                }
                catch (RuntimeException e) {
                    if (e.getMessage().equals("aaa")) break block8;
                    throw e;
                }
            }
            RoutingContentServiceTest.assertFalse((String)"Content was not cleaned up after having been created in-transaction", (boolean)readers[0].exists());
        }
        finally {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList("");
        }
    }

    private class WriteThread
    extends Thread {
        private ContentWriter writer;
        private String content;
        private volatile boolean isWaiting;
        private volatile boolean isDone;
        private volatile Throwable error;

        public WriteThread(ContentWriter writer, String content) {
            this.writer = writer;
            this.content = content;
            this.isWaiting = false;
            this.isDone = false;
            this.error = null;
        }

        public boolean isWaiting() {
            return this.isWaiting;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public Throwable getError() {
            return this.error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RoutingContentServiceTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            WriteThread writeThread = this;
            synchronized (writeThread) {
                this.isWaiting = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            final OutputStream os = this.writer.getContentOutputStream();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    try {
                        if (WriteThread.this.writer.getEncoding() == null) {
                            os.write(WriteThread.this.content.getBytes());
                        } else {
                            os.write(WriteThread.this.content.getBytes(WriteThread.this.writer.getEncoding()));
                        }
                        os.close();
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return null;
                }
            };
            try {
                try {
                    RoutingContentServiceTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.error = e;
                    this.isDone = true;
                }
            }
            finally {
                this.isDone = true;
            }
        }
    }
}

