/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Deque;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.TransformerLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TransformerLoggerTest {
    @Mock
    private TransformerDebug transformerDebug;
    private Properties properties = new Properties();
    private TransformerLogger<String> log;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.log = this.newLogger(new AtomicInteger(1), this.transformerDebug, this.properties);
    }

    private TransformerLogger<String> newLogger(final AtomicInteger numberOfMessagesToAdd, TransformerDebug transformerDebug, Properties properties) {
        TransformerLogger<String> log = new TransformerLogger<String>(){

            protected void addOrModify(Deque<String> entries, Object message) {
                int i = numberOfMessagesToAdd.get();
                if (i > 0) {
                    while (i > 0) {
                        entries.add((String)message);
                        --i;
                    }
                } else if (i < 0) {
                    while (i < 0) {
                        entries.removeLast();
                        ++i;
                    }
                } else {
                    entries.removeLast();
                    entries.add((String)message);
                }
            }

            protected int getUpperMaxEntries() {
                return 176;
            }

            protected String getPropertyName() {
                return "property.name";
            }
        };
        log.setTransformerDebug(transformerDebug);
        log.setProperties(properties);
        return log;
    }

    @Test
    public void isDebugEnabled0EntriesTest() {
        Assert.assertFalse((boolean)this.log.isDebugEnabled());
    }

    @Test
    public void isDebugEnabled5EntriesTest() {
        this.properties.setProperty("property.name", "5");
        Assert.assertTrue((boolean)this.log.isDebugEnabled());
    }

    @Test
    public void isDebugEnabledHasStringBuilderTest() {
        Mockito.when((Object)this.transformerDebug.getStringBuilder()).thenReturn((Object)new StringBuilder());
        this.properties.setProperty("property.name", "5");
        Assert.assertFalse((boolean)this.log.isDebugEnabled());
    }

    @Test
    public void noEntriesTest() {
        this.properties.setProperty("property.name", "3");
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.log.getEntries(10));
    }

    @Test
    public void noEntriesDisabledTest() {
        Assert.assertArrayEquals((Object[])new String[]{"No entries are available. property.name must be set to a number between 1 and 176"}, (Object[])this.log.getEntries(10));
    }

    @Test
    public void oneEntryTest() {
        this.properties.setProperty("property.name", "3");
        this.log.debug((Object)"one");
        Assert.assertArrayEquals((Object[])new String[]{"one"}, (Object[])this.log.getEntries(10));
    }

    @Test
    public void fiveEntryTest() {
        this.properties.setProperty("property.name", "3");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        this.log.debug((Object)"four");
        this.log.debug((Object)"five");
        Assert.assertArrayEquals((Object[])new String[]{"five", "four", "three"}, (Object[])this.log.getEntries(10));
    }

    @Test
    public void limit0Test() {
        this.properties.setProperty("property.name", "3");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        Assert.assertArrayEquals((Object[])new String[]{"three", "two", "one"}, (Object[])this.log.getEntries(0));
    }

    @Test
    public void limitAllTest() {
        this.properties.setProperty("property.name", "3");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        Assert.assertArrayEquals((Object[])new String[]{"three", "two", "one"}, (Object[])this.log.getEntries(-1));
    }

    @Test
    public void limit1Test() {
        this.properties.setProperty("property.name", "3");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        Assert.assertArrayEquals((Object[])new String[]{"three"}, (Object[])this.log.getEntries(1));
    }

    @Test
    public void limitMoreThanEntriesTest() {
        this.properties.setProperty("property.name", "3");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        Assert.assertArrayEquals((Object[])new String[]{"three", "two", "one"}, (Object[])this.log.getEntries(5));
    }

    @Test
    public void addTwoEntriesTest() {
        AtomicInteger numberOfMessagesToAdd = new AtomicInteger(2);
        this.log = this.newLogger(numberOfMessagesToAdd, this.transformerDebug, this.properties);
        this.properties.setProperty("property.name", "5");
        this.log.debug((Object)"one");
        Assert.assertArrayEquals((Object[])new String[]{"one", "one"}, (Object[])this.log.getEntries(10));
        this.log.debug((Object)"two");
        Assert.assertArrayEquals((Object[])new String[]{"two", "two", "one", "one"}, (Object[])this.log.getEntries(10));
        this.log.debug((Object)"three");
        Assert.assertArrayEquals((Object[])new String[]{"three", "three", "two", "two", "one"}, (Object[])this.log.getEntries(10));
    }

    @Test
    public void addRemoveModifyTest() {
        AtomicInteger numberOfMessagesToAdd = new AtomicInteger(2);
        this.log = this.newLogger(numberOfMessagesToAdd, this.transformerDebug, this.properties);
        this.properties.setProperty("property.name", "10");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        Assert.assertArrayEquals((Object[])new String[]{"three", "three", "two", "two", "one", "one"}, (Object[])this.log.getEntries(10));
        numberOfMessagesToAdd.set(-3);
        this.log.debug((Object)"four");
        Assert.assertArrayEquals((Object[])new String[]{"two", "one", "one"}, (Object[])this.log.getEntries(10));
        numberOfMessagesToAdd.set(1);
        this.log.debug((Object)"five");
        Assert.assertArrayEquals((Object[])new String[]{"five", "two", "one", "one"}, (Object[])this.log.getEntries(10));
        numberOfMessagesToAdd.set(0);
        this.log.debug((Object)"six");
        Assert.assertArrayEquals((Object[])new String[]{"six", "two", "one", "one"}, (Object[])this.log.getEntries(10));
    }
}

