/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.People;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.ScriptPagingDetails;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class PeopleTest
extends TestCase {
    private static final String SIMPLE_FILTER = "a";
    private static final String CQ_SIMPLE_FILTER = "a [hint:useCQ]";
    private static final String DEFAULT_SORT_BY_FIELD = "PeopleTestUsername";
    private static final List<NodeRef> userNodeRefs = new ArrayList<NodeRef>();
    private static final UserInfo[] userInfos = new UserInfo[]{new UserInfo("PeopleTestUser0", "john junior", "lewis second"), new UserInfo("PeopleTestUser1", "john senior", "lewis second"), new UserInfo("PeopleTestUser2", "john junior", "lewis third"), new UserInfo("PeopleTestUser3", "john", "lewis third"), new UserInfo("PeopleTestUser4", "mike", "doe first"), new UserInfo("PeopleTestUser5", "sam", "doe first"), new UserInfo("PeopleTestUser6", "sara jones", "doe"), new UserInfo("PeopleTestUser7", "sara", "doe")};
    private ApplicationContext ctx;
    private TransactionService transactionService;
    private UserTransaction txn;
    private ServiceRegistry serviceRegistry;
    private People people;
    private PersonService personService;
    @Mock
    private SearchService mockSearchService;
    @Mock
    private ResultSet mockResultSet;
    private List<NodeRef> mockResultSetNodeRefs = new ArrayList<NodeRef>();
    private int callCount = 0;

    protected void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.people = (People)this.ctx.getBean("peopleScript");
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.personService = this.serviceRegistry.getPersonService();
        ServiceRegistry mockServiceRegistry = (ServiceRegistry)Mockito.spy((Object)this.serviceRegistry);
        this.people.setServiceRegistry(mockServiceRegistry);
        ((ServiceRegistry)Mockito.doReturn((Object)this.mockSearchService).when((Object)mockServiceRegistry)).getSearchService();
        Mockito.when((Object)this.mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)this.mockResultSet);
        Mockito.when((Object)this.mockResultSet.getNodeRefs()).thenReturn(this.mockResultSetNodeRefs);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.createUsers();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    protected void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        this.people.setServiceRegistry(this.serviceRegistry);
    }

    public void testGetPeople() {
        this.assertPeopleImpl("john junior", "There are two users who have \"john junior\" as their first name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*john*\" \"*junior*\" OR lastName:\"*john*\" \"*junior*\")", 0, 2);
        this.assertPeopleImpl("john junior lewis sec*", "There is one user with the name: \"john junior lewis second\".", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*john*\" \"*junior*\"\"*lewis*\"\"*sec*\" OR lastName:\"*john*\" \"*junior*\"\"*lewis*\"\"*sec*\")", 0);
        this.assertPeopleImpl("john senior", "There is one user who has \"john senior\" as his first name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*john*\" \"*senior*\" OR lastName:\"*john*\" \"*senior*\")", 1);
        this.assertPeopleImpl("john*", "There are four users with \"john\" as their first name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (\"*john**\")", 0, 1, 2, 3);
        this.assertPeopleImpl("lewis third", "There are two users who have \"lewis third\" as their last name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*lewis*\" \"*third*\" OR lastName:\"*lewis*\" \"*third*\")", 2, 3);
        this.assertPeopleImpl("doe fi*", "There are two users who have \"doe first\" as their last name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*doe*\" \"*fi*\" OR lastName:\"*doe*\" \"*fi*\")", 4, 5);
        this.assertPeopleImpl("lewi*", "There are four users with \"lewis\" as their last name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (\"*lewi**\")", 0, 1, 2, 3);
        this.assertPeopleImpl("thir*", "There are two users with \"lewis third\" as their last name.", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (\"*thir**\")", 2, 3);
        this.assertPeopleImpl("sam doe first", "There is one user with the name: \"sam doe first\".", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*sam*\" \"*doe*\"\"*first*\" OR lastName:\"*sam*\" \"*doe*\"\"*first*\")", 5);
        this.assertPeopleImpl("sara jones doe", "There is one user with the name: \"sara jones doe\".", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*sara*\" \"*jones*\"\"*doe*\" OR lastName:\"*sara*\" \"*jones*\"\"*doe*\")", 6);
        this.assertPeopleImpl("sara doe", "There are two users with the name: \"sara doe\".", "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (firstName:\"*sara*\" \"*doe*\" OR lastName:\"*sara*\" \"*doe*\")", 6, 7);
    }

    private void assertPeopleImpl(String filter, String sizeMessage, String expectedQuery, int ... userIds) {
        String expectedSort = "[]";
        int expectedMaxItems = -1;
        int expectedSkipCount = 0;
        this.mockResultSetNodeRefs.clear();
        int[] nArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            NodeRef nodeRef = userNodeRefs.get(i);
            this.mockResultSetNodeRefs.add(nodeRef);
            ++n2;
        }
        ArgumentCaptor searchParametersCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        ScriptPagingDetails paging = new ScriptPagingDetails(0, 0);
        List persons = this.people.getPeopleImpl(filter, paging, null, null);
        ((SearchService)Mockito.verify((Object)this.mockSearchService, (VerificationMode)Mockito.times((int)(++this.callCount)))).query((SearchParameters)searchParametersCaptor.capture());
        SearchParameters parameters = (SearchParameters)searchParametersCaptor.getValue();
        PeopleTest.assertEquals((String)"Query", (String)expectedQuery, (String)parameters.getQuery().toString());
        PeopleTest.assertEquals((String)"Sort", (String)expectedSort, (String)parameters.getSortDefinitions().toString());
        PeopleTest.assertEquals((String)"maxItems", (int)expectedMaxItems, (int)parameters.getMaxItems());
        PeopleTest.assertEquals((String)"SkipCount", (int)expectedSkipCount, (int)parameters.getSkipCount());
        PeopleTest.assertEquals((String)sizeMessage, (int)userIds.length, (int)persons.size());
        int n3 = 0;
        int[] nArray2 = userIds;
        int n4 = userIds.length;
        int n5 = 0;
        while (n5 < n4) {
            int i = nArray2[n5];
            UserInfo userInfo = userInfos[i];
            PeopleTest.assertEquals((String)("PeopleTestUser " + i + " firstName "), (String)userInfo.getFirstName(), (String)((PersonService.PersonInfo)persons.get(n3)).getFirstName());
            PeopleTest.assertEquals((String)("PeopleTestUser " + i + " lastName "), (String)userInfo.getLastName(), (String)((PersonService.PersonInfo)persons.get(n3)).getLastName());
            ++n3;
            ++n5;
        }
    }

    @Category(value={RedundantTests.class})
    public void testGetPeopleByPatternIndexedAndCQ() throws Exception {
        ScriptPagingDetails paging = new ScriptPagingDetails(0, 0);
        List unsortedPeople = this.people.getPeopleImpl(CQ_SIMPLE_FILTER, paging, null, null);
        PeopleTest.assertNotNull((String)"Not one person was found!", (Object)unsortedPeople);
        HashSet<NodeRef> expectedUsers = new HashSet<NodeRef>();
        for (PersonService.PersonInfo person : unsortedPeople) {
            expectedUsers.add(person.getNodeRef());
        }
        List sortedPeople = this.people.getPeopleImpl(SIMPLE_FILTER, paging, DEFAULT_SORT_BY_FIELD, null);
        PeopleTest.assertNotNull((String)"No one person is found and sorted!", (Object)sortedPeople);
        PeopleTest.assertEquals((int)expectedUsers.size(), (int)sortedPeople.size());
        for (PersonService.PersonInfo person : sortedPeople) {
            PeopleTest.assertTrue((String)("Unexpected person: '" + person.getUserName() + "[" + person.getNodeRef() + "]'"), (boolean)expectedUsers.contains(person.getNodeRef()));
        }
    }

    private void createUsers() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException, NotSupportedException {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        UserInfo[] userInfoArray = userInfos;
        int n = userInfos.length;
        int n2 = 0;
        while (n2 < n) {
            boolean create;
            UserInfo user = userInfoArray[n2];
            String username = user.getUserName();
            NodeRef nodeRef = this.personService.getPersonOrNull(username);
            boolean bl = create = nodeRef == null;
            if (create) {
                PropertyMap testUser = new PropertyMap();
                testUser.put((Object)ContentModel.PROP_USERNAME, (Object)username);
                testUser.put((Object)ContentModel.PROP_FIRSTNAME, (Object)user.getFirstName());
                testUser.put((Object)ContentModel.PROP_LASTNAME, (Object)user.getLastName());
                testUser.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(user.getUserName()) + "@acme.test"));
                testUser.put((Object)ContentModel.PROP_PASSWORD, (Object)"password");
                nodeRef = this.personService.createPerson((Map)testUser);
            }
            userNodeRefs.add(nodeRef);
            ++n2;
        }
        this.txn.commit();
    }

    static class UserInfo {
        private final String userName;
        private final String firstName;
        private final String lastName;

        public UserInfo(String userName, String firstName, String lastName) {
            this.userName = userName;
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String toString() {
            return "PeopleTestUserInfo [userName=" + this.userName + ", firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }
    }
}

