/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.jscript.ScriptLogger;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.experimental.categories.Category;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class RhinoScriptTest
extends TestCase {
    private ApplicationContext ctx;
    private ContentService contentService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private ScriptService scriptService;
    private static final String TESTSCRIPT_CLASSPATH1 = "org/alfresco/repo/jscript/test_script1.js";
    private static final String TESTSCRIPT_CLASSPATH2 = "org/alfresco/repo/jscript/test_script2.js";
    private static final String TESTSCRIPT_CLASSPATH3 = "org/alfresco/repo/jscript/test_script3.js";
    private static final String TESTSCRIPT1 = "var id = root.id;\r\nlogger.log(id);\r\nvar name = root.name;\r\nlogger.log(name);\r\nvar type = root.type;\r\nlogger.log(type);\r\nvar childList = root.children;\r\nlogger.log(\"zero index node name: \" + childList[0].name);\r\nlogger.log(\"name property access: \" + childList[0].properties.name);\r\nvar childByNameNode = root.childByNamePath(\"/\" + childList[0].name);\r\nlogger.log(\"child by name path: \" + childByNameNode.name);\r\nvar xpathResults = root.childrenByXPath(\"/*\");\r\nlogger.log(\"children of root from xpath: \" + xpathResults.length);\r\n";
    private static final String TESTSCRIPT2 = "var exec = new org.alfresco.util.exec.RuntimeExec();\r\nexec.setCommand([\"/bin/ls\"]);\r\nvar res = exec.execute();\r\njava.lang.System.err.println(res.getStdOut());\r\n";
    private static final String BASIC_JAVA = "var list = com.google.common.collect.Lists.newArrayList();\nroot.nodeRef.getClass().forName(\"java.lang.ProcessBuilder\")";
    private static final String REFLECTION_GET_CLASS = "root.nodeRef.getClass().forName(\"java.lang.ProcessBuilder\")";

    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.transactionService = (TransactionService)this.ctx.getBean("transactionComponent");
        this.contentService = (ContentService)this.ctx.getBean("contentService");
        this.nodeService = (NodeService)this.ctx.getBean("nodeService");
        this.scriptService = (ScriptService)this.ctx.getBean("scriptService");
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        RhinoScriptTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        RhinoScriptTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        BaseNodeServiceTest.loadModel(this.ctx);
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testRhinoIntegration() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                Context cx = Context.enter();
                try {
                    ScriptableObject scope = cx.initStandardObjects();
                    Object result = cx.evaluateString((Scriptable)scope, "obj = {a:1, b:['x','y']}", "TestJS1", 1, null);
                    Scriptable obj = (Scriptable)scope.get("obj", (Scriptable)scope);
                    RhinoScriptTest.assertNotNull((Object)obj.get("a", obj));
                    RhinoScriptTest.assertEquals((Object)new Double(1.0), (Object)obj.get("a", obj));
                    result = cx.evaluateString((Scriptable)scope, "function f(x) {return x+1} f(7)", "TestJS2", 1, null);
                    RhinoScriptTest.assertEquals((Object)8.0, (Object)Context.toNumber((Object)result));
                }
                finally {
                    Context.exit();
                }
                return null;
            }
        });
    }

    public void testJSObjectWrapping() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(RhinoScriptTest.this.nodeService, root);
                Context cx = Context.enter();
                try {
                    ScriptableObject scope = cx.initStandardObjects();
                    ScriptableObject.putProperty((Scriptable)scope, (String)"logger", (Object)new ScriptLogger());
                    List childAssocs = RhinoScriptTest.this.nodeService.getChildAssocs(root);
                    NodeRef ref1 = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
                    Object wrappedNodeRef = Context.javaToJS((Object)ref1, (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)"rootref", (Object)wrappedNodeRef);
                    Object result = cx.evaluateString((Scriptable)scope, "obj = rootref.getId()", "TestJS3", 1, null);
                    RhinoScriptTest.assertEquals((String)ref1.getId(), (String)Context.toString((Object)result));
                    ScriptNode node1 = new ScriptNode(root, RhinoScriptTest.this.serviceRegistry, (Scriptable)scope);
                    Object wrappedNode = Context.javaToJS((Object)node1, (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)"root", (Object)wrappedNode);
                    result = cx.evaluateString((Scriptable)scope, RhinoScriptTest.TESTSCRIPT1, "TestJS4", 1, null);
                }
                finally {
                    Context.exit();
                }
                return null;
            }
        });
    }

    public void testScriptService() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(RhinoScriptTest.this.nodeService, root);
                HashMap<String, PrintStream> model = new HashMap<String, PrintStream>();
                model.put("out", System.out);
                ScriptNode rootNode = new ScriptNode(root, RhinoScriptTest.this.serviceRegistry, null);
                model.put("root", (PrintStream)rootNode);
                Object result = RhinoScriptTest.this.scriptService.executeScript(RhinoScriptTest.TESTSCRIPT_CLASSPATH1, model);
                System.out.println("Result from TESTSCRIPT_CLASSPATH1: " + result.toString());
                RhinoScriptTest.assertTrue((boolean)((Boolean)result));
                ChildAssociationRef childRef = RhinoScriptTest.this.nodeService.createNode(root, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"script_content"), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT, null);
                NodeRef contentNodeRef = childRef.getChildRef();
                ContentWriter writer = RhinoScriptTest.this.contentService.getWriter(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, true);
                writer.setMimetype("application/x-javascript");
                writer.putContent(RhinoScriptTest.TESTSCRIPT1);
                RhinoScriptTest.this.scriptService.executeScript(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, model);
                RhinoScriptTest.this.scriptService.executeScriptString("javascript", RhinoScriptTest.TESTSCRIPT1, model);
                return null;
            }
        });
    }

    public void testScriptActions() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                ChildAssociationRef childRef = RhinoScriptTest.this.nodeService.createNode(root, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"script_content"), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT, null);
                NodeRef contentNodeRef = childRef.getChildRef();
                ContentWriter writer = RhinoScriptTest.this.contentService.getWriter(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, true);
                writer.setMimetype("application/x-javascript");
                writer.putContent(RhinoScriptTest.TESTSCRIPT1);
                HashMap<String, ScriptNode> model = new HashMap<String, ScriptNode>();
                model.put("doc", new ScriptNode(childRef.getChildRef(), RhinoScriptTest.this.serviceRegistry, null));
                model.put("root", new ScriptNode(root, RhinoScriptTest.this.serviceRegistry, null));
                Object result = RhinoScriptTest.this.scriptService.executeScript(RhinoScriptTest.TESTSCRIPT_CLASSPATH2, model);
                System.out.println("Result from TESTSCRIPT_CLASSPATH2: " + result.toString());
                RhinoScriptTest.assertTrue((boolean)((Boolean)result));
                RhinoScriptTest.assertTrue((boolean)RhinoScriptTest.this.nodeService.hasAspect(childRef.getChildRef(), ContentModel.ASPECT_LOCKABLE));
                return null;
            }
        });
    }

    public void xtestScriptActionsMail() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                ChildAssociationRef childRef = RhinoScriptTest.this.nodeService.createNode(root, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"script_content"), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT, null);
                NodeRef contentNodeRef = childRef.getChildRef();
                ContentWriter writer = RhinoScriptTest.this.contentService.getWriter(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, true);
                writer.setMimetype("application/x-javascript");
                writer.putContent(RhinoScriptTest.TESTSCRIPT1);
                HashMap<String, ScriptNode> model = new HashMap<String, ScriptNode>();
                model.put("doc", new ScriptNode(childRef.getChildRef(), RhinoScriptTest.this.serviceRegistry, null));
                model.put("root", new ScriptNode(root, RhinoScriptTest.this.serviceRegistry, null));
                Object result = RhinoScriptTest.this.scriptService.executeScript(RhinoScriptTest.TESTSCRIPT_CLASSPATH3, model);
                System.out.println("Result from TESTSCRIPT_CLASSPATH3: " + result.toString());
                RhinoScriptTest.assertTrue((boolean)((Boolean)result));
                return null;
            }
        });
    }

    public void testUnsecureScriptAddedOnRepoNode() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(RhinoScriptTest.this.nodeService, root);
                HashMap<String, PrintStream> model = new HashMap<String, PrintStream>();
                model.put("out", System.out);
                ScriptNode rootNode = new ScriptNode(root, RhinoScriptTest.this.serviceRegistry, null);
                model.put("root", (PrintStream)rootNode);
                ChildAssociationRef childRef = RhinoScriptTest.this.nodeService.createNode(root, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"script_content"), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT, null);
                NodeRef contentNodeRef = childRef.getChildRef();
                ContentWriter writer = RhinoScriptTest.this.contentService.getWriter(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, true);
                writer.setMimetype("application/x-javascript");
                writer.putContent(RhinoScriptTest.BASIC_JAVA);
                try {
                    RhinoScriptTest.this.scriptService.executeScript(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, model);
                    RhinoScriptTest.fail((String)"execution of nonsecure script on nodeRef is not allowed.");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                ChildAssociationRef childRef1 = RhinoScriptTest.this.nodeService.createNode(root, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"script_content"), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT, null);
                NodeRef contentNodeRef1 = childRef1.getChildRef();
                ContentWriter writer1 = RhinoScriptTest.this.contentService.getWriter(contentNodeRef1, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, true);
                writer1.setMimetype("application/x-javascript");
                writer1.putContent(RhinoScriptTest.REFLECTION_GET_CLASS);
                try {
                    RhinoScriptTest.this.scriptService.executeScript(contentNodeRef1, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, model);
                    RhinoScriptTest.fail((String)"execution of nonsecure script on nodeRef is not allowed.");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                return null;
            }
        });
    }

    public void testSecureScriptString() {
        boolean executed = this.executeSecureScriptString(TESTSCRIPT2, false);
        RhinoScriptTest.assertFalse((String)"Script shouldn't have been executed (secure = false)", (boolean)executed);
        executed = this.executeSecureScriptString(TESTSCRIPT2, null);
        RhinoScriptTest.assertFalse((String)"Script shouldn't have been executed (secure = null)", (boolean)executed);
        executed = this.executeSecureScriptString(TESTSCRIPT2, true);
        RhinoScriptTest.assertTrue((String)"Script should have been executed (secure = true)", (boolean)executed);
    }

    public void testScopeData() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                Context cx = Context.enter();
                try {
                    ImporterTopLevel sharedScope = new ImporterTopLevel(cx, true);
                    Scriptable scope = cx.newObject((Scriptable)sharedScope);
                    scope.setPrototype((Scriptable)sharedScope);
                    scope.setParentScope(null);
                    Object result = cx.evaluateString(scope, "var a = 10; var b = 20; var sum = a+b;", "TestJS1", 1, null);
                    RhinoScriptTest.assertTrue((boolean)Undefined.isUndefined((Object)result));
                    Object sum = scope.get("sum", scope);
                    RhinoScriptTest.assertEquals((Object)30.0, (Object)Context.toNumber((Object)sum));
                    sum = sharedScope.get("sum", (Scriptable)sharedScope);
                    RhinoScriptTest.assertEquals((Object)sum, (Object)UniqueTag.NOT_FOUND);
                    Object b = ScriptableObject.getProperty((Scriptable)sharedScope, (String)"b");
                    RhinoScriptTest.assertEquals((Object)b, (Object)UniqueTag.NOT_FOUND);
                    RhinoScriptTest.this.unsetScope(scope);
                    result = cx.evaluateString(scope, "var test = 'test';", "TestJS2", 1, null);
                    sum = scope.get("sum", scope);
                    RhinoScriptTest.assertNull((Object)sum);
                    scope = cx.newObject((Scriptable)sharedScope);
                    scope.setPrototype((Scriptable)sharedScope);
                    scope.setParentScope(null);
                    Object test = scope.get("test", scope);
                    RhinoScriptTest.assertEquals((Object)test, (Object)UniqueTag.NOT_FOUND);
                }
                finally {
                    Context.exit();
                }
                return null;
            }
        });
    }

    private boolean executeSecureScriptString(final String script, final Boolean secure) {
        return (Boolean)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            public Boolean execute() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(RhinoScriptTest.this.nodeService, root);
                try {
                    HashMap<String, PrintStream> model = new HashMap<String, PrintStream>();
                    model.put("out", System.out);
                    ScriptNode rootNode = new ScriptNode(root, RhinoScriptTest.this.serviceRegistry, null);
                    model.put("root", (PrintStream)rootNode);
                    RhinoScriptTest.this.scriptService.executeScriptString("javascript", script, model, secure.booleanValue());
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
        });
    }

    private void unsetScope(Scriptable scope) {
        Object[] ids;
        if (scope != null && (ids = scope.getIds()) != null) {
            Object[] objectArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = objectArray[n2];
                try {
                    this.deleteProperty(scope, id.toString());
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
    }

    private void deleteProperty(Scriptable scope, String name) {
        if (scope != null && name != null) {
            if (!ScriptableObject.deleteProperty((Scriptable)scope, (String)name)) {
                ScriptableObject.putProperty((Scriptable)scope, (String)name, null);
            }
            scope.delete(name);
        }
    }
}

