/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLClusterNDBDialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.ibatis.NodeDAOImpl;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.cleanup.NodeCleanupRegistry;
import org.alfresco.repo.node.db.DbNodeServiceImpl;
import org.alfresco.repo.node.db.NodeStringLengthWorker;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class DbNodeServiceImplTest
extends BaseNodeServiceTest {
    private TransactionService txnService;
    private NodeDAO nodeDAO;
    private DictionaryService dictionaryService;

    @Override
    protected NodeService getNodeService() {
        DbNodeServiceImpl cfr_ignored_0 = (DbNodeServiceImpl)this.applicationContext.getBean("dbNodeServiceImpl");
        return (NodeService)this.applicationContext.getBean("dbNodeService");
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.txnService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.nodeDAO = (NodeDAO)this.applicationContext.getBean("nodeDAO");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
    }

    public void testCallWithoutTxn() {
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.nodeService.getAllRootNodes(this.rootNodeRef.getStoreRef());
    }

    public void testNodeCleanupRegistry() throws Exception {
        TestTransaction.flagForCommit();
        TestTransaction.end();
        NodeCleanupRegistry cleanupRegistry = (NodeCleanupRegistry)this.applicationContext.getBean("nodeCleanupRegistry");
        cleanupRegistry.doClean();
    }

    public synchronized void testTxnCommitTime() throws Exception {
        String currentTxn = AlfrescoTransactionSupport.getTransactionId();
        DbNodeServiceImplTest.assertNotNull((Object)"Must have a txn change UUID for all transactions.");
        long start = System.currentTimeMillis();
        ((Object)((Object)this)).wait(10L);
        TestTxnCommitTimeTxnListener listener = new TestTxnCommitTimeTxnListener();
        AlfrescoTransactionSupport.bindListener((TransactionListener)listener);
        long currentTxnCommitTime = listener.getTxnCommitTime(currentTxn, start);
        DbNodeServiceImplTest.assertEquals((String)"Should not have found a written txn", (long)0L, (long)currentTxnCommitTime);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        long recordedCommitTimeMs = listener.getTxnCommitTime(currentTxn, start);
        DbNodeServiceImplTest.assertTrue((String)"DAO txn write time must be greater than last listener write time", (recordedCommitTimeMs > listener.lastWriteTime ? 1 : 0) != 0);
    }

    public void testLazyLoadIssue() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        TestTransaction.flagForCommit();
        TestTransaction.end();
        UserTransaction userTransaction = this.txnService.getUserTransaction();
        try {
            userTransaction.begin();
            ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n6_p_n8"));
            NodeRef n6Ref = n6pn8Ref.getParentRef();
            NodeRef n8Ref = n6pn8Ref.getChildRef();
            this.nodeService.deleteNode(n8Ref);
            List assocs = this.nodeService.getChildAssocs(n6Ref);
            Iterator iterator = assocs.iterator();
            while (iterator.hasNext()) {
                ChildAssociationRef cfr_ignored_0 = (ChildAssociationRef)iterator.next();
            }
            userTransaction.commit();
        }
        catch (Exception e) {
            try {
                userTransaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void testNodeStatus() throws Throwable {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n6_p_n8"));
        final NodeRef n6Ref = n6pn8Ref.getParentRef();
        final NodeRef n8Ref = n6pn8Ref.getChildRef();
        final Map properties = this.nodeService.getProperties(n6Ref);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> changePropertiesWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.setProperty(n6Ref, ContentModel.PROP_CREATED, (Serializable)new Date());
                return null;
            }
        };
        this.executeAndCheck(n6Ref, changePropertiesWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> addAspectWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.addAspect(n6Ref, BaseNodeServiceTest.ASPECT_QNAME_TEST_MARKER, null);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, addAspectWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> removeAspectWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.removeAspect(n6Ref, BaseNodeServiceTest.ASPECT_QNAME_TEST_MARKER);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, removeAspectWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> moveNodeWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.moveNode(n6Ref, DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"moved"));
                return null;
            }
        };
        this.executeAndCheck(n6Ref, moveNodeWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteNodeWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.deleteNode(n6Ref);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, deleteNodeWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkCascadeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                NodeRef.Status n6Status = DbNodeServiceImplTest.this.nodeDAO.getNodeRefStatus(n6Ref);
                if (!n6Status.isDeleted()) {
                    throw new RuntimeException("Deleted node does not have deleted status");
                }
                NodeRef.Status n8Status = DbNodeServiceImplTest.this.nodeDAO.getNodeRefStatus(n8Ref);
                if (!n8Status.isDeleted()) {
                    throw new RuntimeException("Cascade-deleted node does not have deleted status");
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkCascadeCallback);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkRecreateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                properties.put(ContentModel.PROP_STORE_PROTOCOL, n6Ref.getStoreRef().getProtocol());
                properties.put(ContentModel.PROP_STORE_IDENTIFIER, n6Ref.getStoreRef().getIdentifier());
                properties.put(ContentModel.PROP_NODE_UUID, n6Ref.getId());
                DbNodeServiceImplTest.this.nodeService.createNode(DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"recreated-n6"), ContentModel.TYPE_CONTAINER, properties);
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkRecreateCallback);
    }

    private void executeAndCheck(NodeRef nodeRef, RetryingTransactionHelper.RetryingTransactionCallback<Object> callback) throws Throwable {
        UserTransaction txn = this.txnService.getUserTransaction();
        txn.begin();
        NodeRef.Status currentStatus = this.nodeService.getNodeStatus(nodeRef);
        DbNodeServiceImplTest.assertNotNull((Object)currentStatus);
        String currentTxnId = AlfrescoTransactionSupport.getTransactionId();
        DbNodeServiceImplTest.assertNotNull((Object)currentTxnId);
        DbNodeServiceImplTest.assertNotSame((Object)currentTxnId, (Object)currentStatus.getChangeTxnId());
        try {
            callback.execute();
            NodeRef.Status newStatus = this.nodeService.getNodeStatus(nodeRef);
            DbNodeServiceImplTest.assertNotNull((Object)newStatus);
            DbNodeServiceImplTest.assertEquals((String)"Change didn't update status", (String)currentTxnId, (String)newStatus.getChangeTxnId());
            Long nodeId = newStatus.getDbId();
            this.nodeDAO.getParentAssocs(nodeId, null, null, null, (NodeDAO.ChildAssocRefQueryCallback)new DummyChildAssocRefQueryCallback());
            this.nodeDAO.cacheNodesById(Collections.singletonList(nodeId));
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {}
            throw e;
        }
    }

    public void testMLTextValues() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.ENGLISH, "Very good!");
        mlTextProperty.addValue(Locale.FRENCH, "Tr\u00e8s bon!");
        mlTextProperty.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
        Serializable textValueDirect = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertEquals((String)"MLText type not returned direct", (Object)mlTextProperty, (Object)textValueDirect);
        Map propertiesDirect = this.nodeService.getProperties(this.rootNodeRef);
        DbNodeServiceImplTest.assertEquals((String)"MLText type not returned direct in Map", (Object)mlTextProperty, propertiesDirect.get(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    public void testStringIntoMLTextProperty() throws Exception {
        String text = "Hello";
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)text));
        Serializable mlTextCheck = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertTrue((String)"Plain string insertion should be returned as MLText", (boolean)(mlTextCheck instanceof MLText));
        I18NUtil.getLocale();
        MLText mlTextCheck2 = (MLText)mlTextCheck;
        String mlTextDefaultCheck = mlTextCheck2.getDefaultValue();
        DbNodeServiceImplTest.assertEquals((String)"Default MLText value was not set correctly", (String)text, (String)mlTextDefaultCheck);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
        this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)text));
        MLText mlText = new MLText();
        mlText.addValue(Locale.ENGLISH, "Very good!");
        mlText.addValue(Locale.FRENCH, "Tr\u00e8s bon!");
        mlText.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
        mlTextCheck = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertEquals((String)"Setting of MLText over String failed.", (Object)mlText, (Object)mlTextCheck);
    }

    public void testSingleStringMLTextProperty() throws Exception {
        MLText mlText = new MLText();
        mlText.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
        MLText mlTextCheck = (MLText)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertEquals((String)"Setting of MLText over String failed.", (Object)mlText, (Object)mlTextCheck);
    }

    public void testInTransactionCreateAndDelete() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)this.getName()), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT).getChildRef();
        this.nodeService.deleteNode(nodeRef);
    }

    public void testAspectRemovalWithCommit() throws Throwable {
        NodeRef sourceNodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"testAspectRemoval-source"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef targetNodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"testAspectRemoval-target"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addAspect(sourceNodeRef, BaseNodeServiceTest.ASPECT_WITH_ASSOCIATIONS, null);
        this.nodeService.addChild(sourceNodeRef, targetNodeRef, BaseNodeServiceTest.ASSOC_ASPECT_CHILD_ASSOC, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-child"));
        this.nodeService.createAssociation(sourceNodeRef, targetNodeRef, BaseNodeServiceTest.ASSOC_ASPECT_NORMAL_ASSOC);
        DbNodeServiceImplTest.assertEquals((String)"Expected exactly one child", (int)1, (int)this.nodeService.getChildAssocs(sourceNodeRef).size());
        DbNodeServiceImplTest.assertEquals((String)"Expected exactly one target", (int)1, (int)this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL).size());
        TestTransaction.flagForCommit();
        TestTransaction.end();
        UserTransaction txn = this.txnService.getUserTransaction();
        txn.begin();
        try {
            Set aspects = this.nodeService.getAspects(sourceNodeRef);
            int noAspectsBefore = aspects.size();
            this.nodeService.removeAspect(sourceNodeRef, BaseNodeServiceTest.ASPECT_WITH_ASSOCIATIONS);
            DbNodeServiceImplTest.assertEquals((String)"Expected exactly zero child", (int)0, (int)this.nodeService.getChildAssocs(sourceNodeRef).size());
            DbNodeServiceImplTest.assertEquals((String)"Expected exactly zero target", (int)0, (int)this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL).size());
            aspects = this.nodeService.getAspects(sourceNodeRef);
            DbNodeServiceImplTest.assertEquals((String)"Expected exactly one less aspect", (int)(noAspectsBefore - 1), (int)aspects.size());
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {}
            throw e;
        }
    }

    public void testGetChildAssocsByPropertyValue() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root"));
        ChildAssociationRef n1Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n1"));
        ChildAssociationRef n2Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n2"));
        NodeRef parentNodeRef = n1Ref.getParentRef();
        NodeRef childNodeRef = n1Ref.getChildRef();
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(parentNodeRef));
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(childNodeRef));
        String subject = "Hello World";
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        List refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        this.nodeService.setProperty(n2Ref.getChildRef(), ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        DbNodeServiceImplTest.assertTrue((String)"failed to read two assocs", (refs.size() == 2 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n2Ref));
        parentNodeRef = n1Ref.getParentRef();
        childNodeRef = n1Ref.getChildRef();
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(parentNodeRef));
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(childNodeRef));
        int count = 123;
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_COUNTER, (Serializable)Integer.valueOf(count));
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_COUNTER, (Serializable)Integer.valueOf(count));
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        Double alfLat = new Double(51.5216666);
        new Double(0.43);
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_LATITUDE, (Serializable)alfLat);
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_LATITUDE, (Serializable)alfLat);
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        Boolean beauty = Boolean.TRUE;
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED)));
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        beauty = Boolean.FALSE;
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue(((Boolean)this.nodeService.getProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED) == false ? 1 : 0) != 0);
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        try {
            this.nodeService.getChildAssocsByPropertyValue(n1Ref.getParentRef(), ContentModel.PROP_NODE_DBID, (Serializable)((Object)"Fail"));
            DbNodeServiceImplTest.fail((String)"sys:node-dbid not rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            String title = (String)((Object)this.nodeService.getProperty(n1Ref.getChildRef(), ContentModel.PROP_TITLE));
            this.nodeService.getChildAssocsByPropertyValue(n1Ref.getParentRef(), ContentModel.PROP_NAME, (Serializable)((Object)title));
            DbNodeServiceImplTest.fail((String)"MLText type not rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testMySQLInnoDBNodeStringLengthWorker() throws Exception {
        TestTransaction.flagForCommit();
        TestTransaction.end();
        Dialect dialect = (Dialect)this.applicationContext.getBean("dialect");
        if (dialect instanceof MySQLClusterNDBDialect || !(dialect instanceof MySQLInnoDBDialect)) {
            return;
        }
        SchemaBootstrap schemaBootstrap = (SchemaBootstrap)this.applicationContext.getBean("schemaBootstrap");
        DbNodeServiceImplTest.assertEquals((String)"Expected max string length to be MAX", (int)Integer.MAX_VALUE, (int)SchemaBootstrap.getMaxStringLength());
        NodeStringLengthWorker worker = (NodeStringLengthWorker)this.applicationContext.getBean("nodeStringLengthWorker");
        NodeStringLengthWorker.NodeStringLengthWorkResult result = worker.execute();
        DbNodeServiceImplTest.assertTrue((result.getPropertiesProcessed() > 0 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertEquals((int)0, (int)result.getErrors());
        schemaBootstrap.setMaximumStringLength(1024);
        schemaBootstrap.onApplicationEvent((ApplicationEvent)new ContextRefreshedEvent(this.applicationContext));
        result = worker.execute();
        int firstPassChanged = result.getPropertiesChanged();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 1025) {
            sb.append("A");
            ++i;
        }
        final String longString = sb.toString();
        schemaBootstrap.setMaximumStringLength(Integer.MAX_VALUE);
        schemaBootstrap.onApplicationEvent((ApplicationEvent)new ContextRefreshedEvent(this.applicationContext));
        this.txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                DbNodeServiceImplTest.this.nodeService.setProperty(DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_STRING_VALUE, (Serializable)((Object)longString));
                return null;
            }
        });
        result = worker.execute();
        DbNodeServiceImplTest.assertEquals((int)firstPassChanged, (int)result.getPropertiesChanged());
        schemaBootstrap.setMaximumStringLength(1024);
        schemaBootstrap.onApplicationEvent((ApplicationEvent)new ContextRefreshedEvent(this.applicationContext));
        result = worker.execute();
        DbNodeServiceImplTest.assertEquals((int)(firstPassChanged + 1), (int)result.getPropertiesChanged());
        schemaBootstrap.setMaximumStringLength(Integer.MAX_VALUE);
        schemaBootstrap.onApplicationEvent((ApplicationEvent)new ContextRefreshedEvent(this.applicationContext));
        result = worker.execute();
        DbNodeServiceImplTest.assertEquals((int)(firstPassChanged + 1), (int)result.getPropertiesChanged());
        String checkLongString = (String)this.txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                return (String)((Object)DbNodeServiceImplTest.this.nodeService.getProperty(DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_STRING_VALUE));
            }
        });
        DbNodeServiceImplTest.assertEquals((String)"String manipulation corrupted the long string value. ", (String)longString, (String)checkLongString);
    }

    @Test
    public void testMNT15655() throws Exception {
        class TestData {
            NodeRef rootFolderNodeRef;
            NodeRef folder1NodeRef;
            NodeRef folder2NodeRef;
            String folder1Name;
            String folder2Name;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){
                    {
                    }

                    public Void doWork() throws Exception {
                        HashMap<QName, String> properties = new HashMap<QName, String>();
                        StoreRef storeRef = DbNodeServiceImplTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                        NodeRef rootNodeRef = DbNodeServiceImplTest.this.nodeService.getRootNode(storeRef);
                        testData.rootFolderNodeRef = DbNodeServiceImplTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"rootFolder"), ContentModel.TYPE_FOLDER, properties).getChildRef();
                        properties.clear();
                        properties.put(ContentModel.PROP_NAME, "folder");
                        testData.folder1NodeRef = DbNodeServiceImplTest.this.nodeService.createNode(testData.rootFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"folder"), ContentModel.TYPE_FOLDER, properties).getChildRef();
                        properties.clear();
                        properties.put(ContentModel.PROP_NAME, "folder1");
                        testData.folder2NodeRef = DbNodeServiceImplTest.this.nodeService.createNode(testData.rootFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"folder1"), ContentModel.TYPE_FOLDER, properties).getChildRef();
                        String name1 = (String)((Object)DbNodeServiceImplTest.this.nodeService.getProperty(testData.folder1NodeRef, ContentModel.PROP_NAME));
                        String name2 = (String)((Object)DbNodeServiceImplTest.this.nodeService.getProperty(testData.folder2NodeRef, ContentModel.PROP_NAME));
                        DbNodeServiceImplTest.assertEquals((String)"folder", (String)name1);
                        DbNodeServiceImplTest.assertEquals((String)"folder1", (String)name2);
                        return null;
                    }
                }, (String)"System");
                return null;
            }
        }, false, true);
        try {
            this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
                {
                }

                public Void execute() throws Throwable {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){
                        {
                        }

                        public Void doWork() throws Exception {
                            HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
                            aspectProperties.put(ContentModel.PROP_NAME, "folder");
                            DbNodeServiceImplTest.this.nodeService.addAspect(testData.folder2NodeRef, ContentModel.ASPECT_AUTHOR, aspectProperties);
                            DbNodeServiceImplTest.fail((String)"Should have generated a DuplicateChildNodeNameException");
                            return null;
                        }
                    }, (String)"System");
                    return null;
                }
            }, false, true);
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
    }

    public static class DummyChildAssocRefQueryCallback
    implements NodeDAO.ChildAssocRefQueryCallback {
        public boolean preLoadNodes() {
            return true;
        }

        public boolean orderResults() {
            return false;
        }

        public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
            return true;
        }

        public void done() {
        }
    }

    private class TestTxnCommitTimeTxnListener
    extends TransactionListenerAdapter {
        private String txnIdStr;
        private long lastWriteTime = 0L;

        private TestTxnCommitTimeTxnListener() {
        }

        public boolean equals(Object obj) {
            return false;
        }

        public synchronized void beforeCommit(boolean readOnly) {
            if (this.txnIdStr == null) {
                this.txnIdStr = AlfrescoTransactionSupport.getTransactionId();
                DbNodeServiceImplTest.this.nodeService.setProperty(DbNodeServiceImplTest.this.rootNodeRef, ContentModel.PROP_COUNTER, (Serializable)new Integer(5));
                AlfrescoTransactionSupport.bindListener((TransactionListener)this);
            } else {
                DbNodeServiceImplTest.this.nodeService.removeProperty(DbNodeServiceImplTest.this.rootNodeRef, ContentModel.PROP_COUNTER);
            }
            this.lastWriteTime = System.currentTimeMillis();
            try {
                ((Object)((Object)this)).wait(20L);
            }
            catch (InterruptedException interruptedException) {}
        }

        public long getTxnCommitTime(String txnId, long fromTime) {
            List startTxns = ((NodeDAOImpl)DbNodeServiceImplTest.this.nodeDAO).selectTxns(Long.valueOf(fromTime), null, Integer.valueOf(Integer.MAX_VALUE), null, null, Boolean.valueOf(true));
            long time = 0L;
            for (Transaction txn : startTxns) {
                if (!txnId.equals(txn.getChangeTxnId())) continue;
                time = txn.getCommitTimeMs();
            }
            return time;
        }
    }
}

