/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.time.Instant;
import java.util.Map;
import java.util.Vector;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceRemoteUserMapper;
import org.alfresco.service.cmr.security.PersonService;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;

public class IdentityServiceRemoteUserMapperTest
extends TestCase {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";

    public void testValidToken() {
        IdentityServiceRemoteUserMapper mapper = this.givenMapper(Map.of("VaLiD-ToKeN", () -> "johny"));
        HttpServletRequest mockRequest = this.createMockTokenRequest("VaLiD-ToKeN");
        String user = mapper.getRemoteUser(mockRequest);
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"johny", (String)user);
    }

    public void testWrongTokenWithSilentValidation() {
        IdentityServiceRemoteUserMapper mapper = this.givenMapper(Map.of("WrOnG-ToKeN", () -> {
            throw new IdentityServiceFacade.TokenDecodingException("Expected ");
        }));
        mapper.setValidationFailureSilent(true);
        HttpServletRequest mockRequest = this.createMockTokenRequest("WrOnG-ToKeN");
        String user = mapper.getRemoteUser(mockRequest);
        IdentityServiceRemoteUserMapperTest.assertNull((Object)user);
    }

    public void testWrongTokenWithoutSilentValidation() {
        IdentityServiceRemoteUserMapper mapper = this.givenMapper(Map.of("WrOnG-ToKeN", () -> {
            throw new IdentityServiceFacade.TokenDecodingException("Expected");
        }));
        mapper.setValidationFailureSilent(false);
        HttpServletRequest mockRequest = this.createMockTokenRequest("WrOnG-ToKeN");
        Assertions.assertThatExceptionOfType(AuthenticationException.class).isThrownBy(() -> {
            String string = mapper.getRemoteUser(mockRequest);
        }).havingCause().withNoCause().withMessage("Expected");
    }

    private IdentityServiceRemoteUserMapper givenMapper(Map<String, Supplier<String>> tokenToUser) {
        IdentityServiceFacade facade = (IdentityServiceFacade)Mockito.mock(IdentityServiceFacade.class);
        Mockito.when((Object)facade.decodeToken(ArgumentMatchers.anyString())).thenAnswer(i -> new TestDecodedToken((Supplier)tokenToUser.get(i.getArgument(0, String.class))));
        PersonService personService = (PersonService)Mockito.mock(PersonService.class);
        Mockito.when((Object)personService.getUserIdentifier(ArgumentMatchers.anyString())).thenAnswer(i -> i.getArgument(0, String.class));
        IdentityServiceRemoteUserMapper mapper = new IdentityServiceRemoteUserMapper();
        mapper.setIdentityServiceFacade(facade);
        mapper.setPersonService(personService);
        mapper.setActive(true);
        mapper.setBearerTokenResolver((BearerTokenResolver)new DefaultBearerTokenResolver());
        return mapper;
    }

    private HttpServletRequest createMockTokenRequest(String token) {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Vector<String> authHeaderValues = new Vector<String>(1);
        if (token != null) {
            authHeaderValues.add(BEARER_PREFIX + token);
        }
        Mockito.when((Object)mockRequest.getHeaders(AUTHORIZATION_HEADER)).thenReturn(authHeaderValues.elements());
        Mockito.when((Object)mockRequest.getHeader(AUTHORIZATION_HEADER)).thenReturn(authHeaderValues.isEmpty() ? null : (String)authHeaderValues.get(0));
        return mockRequest;
    }

    private static class TestDecodedToken
    implements IdentityServiceFacade.DecodedAccessToken {
        private final Supplier<String> usernameSupplier;

        public TestDecodedToken(Supplier<String> usernameSupplier) {
            this.usernameSupplier = usernameSupplier;
        }

        public String getTokenValue() {
            return "TEST";
        }

        public Instant getExpiresAt() {
            return Instant.now();
        }

        public Object getClaim(String claim) {
            return "preferred_username".equals(claim) ? this.usernameSupplier.get() : null;
        }
    }
}

