/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.repo.usage.UserUsageTrackingComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class UserUsageTrackingComponentTest
extends TestCase {
    private ApplicationContext applicationContext;
    private static Log logger = LogFactory.getLog(UserUsageTrackingComponentTest.class);
    private boolean clean = true;
    private MutableAuthenticationService authenticationService;
    private ContentService contentService;
    private TransactionService transactionService;
    private PersonService personService;
    private NodeService nodeService;
    private UserUsageTrackingComponent userUsageTrackingComponent;
    private ContentUsageService contentUsageService;
    private UserTransaction testTX;
    public static StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private static final String TEST_RUN = String.valueOf(System.currentTimeMillis());
    private static final String TEST_USER_PREFIX = "user-" + TEST_RUN + "-";
    private static final int MAX_USERS = 5;
    private static final int BATCH_SIZE = 5;
    private static final int PROGRESS_SIZE = 100;

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        if (AlfrescoTransactionSupport.isActualTransactionActive()) {
            UserUsageTrackingComponentTest.fail((String)"Test started with transaction in progress");
        }
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.contentUsageService = (ContentUsageService)this.applicationContext.getBean("ContentUsageService");
        this.userUsageTrackingComponent = (UserUsageTrackingComponent)this.applicationContext.getBean("userUsageTrackingComponent");
        ContentUsageImpl contentUsage = (ContentUsageImpl)this.applicationContext.getBean("contentUsageImpl");
        contentUsage.setEnabled(true);
        contentUsage.init();
        this.userUsageTrackingComponent.setEnabled(true);
        this.userUsageTrackingComponent.init();
        this.userUsageTrackingComponent.bootstrapInternal();
        AuthenticationUtil.setRunAsUserSystem();
    }

    protected void tearDown() throws Exception {
        ContentUsageImpl contentUsage = (ContentUsageImpl)this.applicationContext.getBean("contentUsageImpl");
        contentUsage.setEnabled(false);
        contentUsage.init();
        this.userUsageTrackingComponent.setEnabled(false);
        this.userUsageTrackingComponent.bootstrapInternal();
        if (this.clean) {
            this.deleteUsersAndContent(true);
        }
        super.tearDown();
    }

    private Map<String, Long> createUsersAndContent(String namePrefix) {
        long start = System.currentTimeMillis();
        long progressStart = System.currentTimeMillis();
        HashMap<String, Long> personContent = new HashMap<String, Long>(5);
        try {
            int count = 0;
            int i = 1;
            while (i <= 5) {
                if (count == 0) {
                    this.testTX = this.transactionService.getUserTransaction();
                    this.testTX.begin();
                }
                ++count;
                String userName = String.valueOf(TEST_USER_PREFIX) + i;
                if (!this.authenticationService.authenticationExists(userName)) {
                    HashMap<QName, String> props = new HashMap<QName, String>();
                    props.put(ContentModel.PROP_USERNAME, userName);
                    this.personService.createPerson(props);
                    this.authenticationService.createAuthentication(userName, userName.toCharArray());
                    this.authenticationService.setAuthenticationEnabled(userName, false);
                    Long contentSize = null;
                    NodeRef homeFolder = this.getHomeSpaceFolderNode(userName);
                    StringBuilder sb = new StringBuilder();
                    int j = 1;
                    while (j <= i) {
                        int k = j % 10;
                        sb.append(k);
                        ++j;
                    }
                    AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
                    NodeRef content = this.addTextContent(homeFolder, String.valueOf(namePrefix) + "-" + userName + "-1.txt", sb.toString());
                    contentSize = this.contentService.getReader(content, ContentModel.PROP_CONTENT).getSize();
                    content = this.addTextContent(homeFolder, String.valueOf(namePrefix) + "-" + userName + "-2.txt", sb.toString());
                    contentSize = contentSize + this.contentService.getReader(content, ContentModel.PROP_CONTENT).getSize();
                    personContent.put(userName, contentSize);
                }
                AuthenticationUtil.setRunAsUserSystem();
                if (count == 5 || i == 5) {
                    this.testTX.commit();
                    count = 0;
                }
                if (i % 100 == 0 && i != 5) {
                    logger.debug((Object)("Progress: 100 users created in " + (System.currentTimeMillis() - progressStart) / 1000L + " secs"));
                    progressStart = System.currentTimeMillis();
                }
                ++i;
            }
            logger.debug((Object)("Total: 5 users created in " + (System.currentTimeMillis() - start) / 1000L + " secs"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                this.testTX.rollback();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return personContent;
    }

    public void test1EnableDisableCollapse() {
        NodeRef homeFolder;
        String userName;
        String fileNamePrefix = "TEST";
        this.createUsersAndContent(fileNamePrefix);
        logger.debug((Object)("Test: " + this.getName()));
        this.userUsageTrackingComponent.setEnabled(false);
        this.userUsageTrackingComponent.bootstrapInternal();
        logger.debug((Object)"Cleared usages");
        this.checkCleared(true);
        this.userUsageTrackingComponent.setEnabled(true);
        this.userUsageTrackingComponent.bootstrapInternal();
        logger.debug((Object)"Recalculated usages");
        this.userUsageTrackingComponent.execute();
        this.checkCalculated(2L);
        this.checkUsage(2L);
        int i = 1;
        while (i <= 5) {
            userName = String.valueOf(TEST_USER_PREFIX) + i;
            homeFolder = this.getHomeSpaceFolderNode(userName);
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            StringBuilder sb = new StringBuilder();
            int j = 1;
            while (j <= i) {
                int k = j % 10;
                sb.append(k);
                ++j;
            }
            this.addTextContent(homeFolder, "c-" + userName + ".txt", sb.toString());
            this.addTextContent(homeFolder, "d-" + userName + ".txt", sb.toString());
            AuthenticationUtil.setRunAsUserSystem();
            ++i;
        }
        logger.debug((Object)"Added content");
        this.checkUsage(4L);
        this.userUsageTrackingComponent.execute();
        logger.debug((Object)"Collapsed usages");
        this.checkUsage(4L);
        i = 1;
        while (i <= 5) {
            userName = String.valueOf(TEST_USER_PREFIX) + i;
            homeFolder = this.getHomeSpaceFolderNode(userName);
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            NodeRef childNodeRef = this.nodeService.getChildByName(homeFolder, ContentModel.ASSOC_CONTAINS, String.valueOf(fileNamePrefix) + "-" + userName + "-1.txt");
            this.nodeService.deleteNode(childNodeRef);
            childNodeRef = this.nodeService.getChildByName(homeFolder, ContentModel.ASSOC_CONTAINS, String.valueOf(fileNamePrefix) + "-" + userName + "-2.txt");
            this.nodeService.deleteNode(childNodeRef);
            AuthenticationUtil.setRunAsUserSystem();
            ++i;
        }
        logger.debug((Object)"Deleted content");
        this.checkUsage(2L);
        this.userUsageTrackingComponent.execute();
        logger.debug((Object)"Collapsed usages");
        this.checkUsage(2L);
        this.userUsageTrackingComponent.setEnabled(false);
        this.userUsageTrackingComponent.bootstrapInternal();
        logger.debug((Object)"Cleared usages");
        this.checkCleared(false);
    }

    public void test2RecalculateUserUsage() throws Exception {
        Map<String, Long> expectedResultsA = this.createUsersAndContent("A");
        this.deleteUsersAndContent(false);
        Map<String, Long> expectedResultsB = this.createUsersAndContent("B");
        int i = 1;
        while (i <= 5) {
            String userName = String.valueOf(TEST_USER_PREFIX) + i;
            Long totalExpected = expectedResultsA.get(userName) + expectedResultsB.get(userName);
            UserUsageTrackingComponentTest.assertEquals((Object)totalExpected, (Object)this.contentUsageService.getUserUsage(userName));
            ++i;
        }
    }

    private void checkCalculated(long factor) {
        int i = 1;
        while (i <= 5) {
            String userName = String.valueOf(TEST_USER_PREFIX) + i;
            NodeRef personNodeRef = this.personService.getPerson(userName);
            Long sizeProp = (Long)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT);
            UserUsageTrackingComponentTest.assertNotNull((String)("Property " + ContentModel.PROP_SIZE_CURRENT + "does not exist, yet"), (Object)sizeProp);
            UserUsageTrackingComponentTest.assertEquals((String)userName, (long)((long)i * factor), (long)sizeProp);
            ++i;
        }
    }

    private void checkUsage(long factor) {
        int i = 1;
        while (i <= 5) {
            String userName = String.valueOf(TEST_USER_PREFIX) + i;
            UserUsageTrackingComponentTest.assertEquals((String)userName, (long)((long)i * factor), (long)this.contentUsageService.getUserUsage(userName));
            ++i;
        }
    }

    private void checkCleared(boolean isCleared) {
        int i = 1;
        while (i <= 5) {
            String userName = String.valueOf(TEST_USER_PREFIX) + i;
            NodeRef personNodeRef = this.personService.getPerson(userName);
            Long sizeCurrent = (Long)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT);
            if (isCleared) {
                UserUsageTrackingComponentTest.assertTrue((sizeCurrent == null || new Long(0L).equals(sizeCurrent) ? 1 : 0) != 0);
            } else {
                UserUsageTrackingComponentTest.assertFalse((sizeCurrent == null || new Long(0L).equals(sizeCurrent) ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    private void deleteUsersAndContent(boolean deleteContent) {
        long start = System.currentTimeMillis();
        try {
            int count = 0;
            int deleteCount = 0;
            int i = 1;
            while (i <= 5) {
                if (count == 0) {
                    this.testTX = this.transactionService.getUserTransaction();
                    this.testTX.begin();
                }
                ++count;
                String userName = String.valueOf(TEST_USER_PREFIX) + i;
                if (this.authenticationService.authenticationExists(userName)) {
                    if (deleteContent) {
                        NodeRef homeFolder = this.getHomeSpaceFolderNode(userName);
                        this.nodeService.deleteNode(homeFolder);
                    }
                    this.personService.deletePerson(userName);
                    ++deleteCount;
                }
                if (count == 5 || i == 5) {
                    this.testTX.commit();
                    count = 0;
                }
                ++i;
            }
            logger.debug((Object)("Total: " + deleteCount + " users deleted in " + (System.currentTimeMillis() - start) / 1000L + " secs"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                this.testTX.rollback();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private NodeRef getHomeSpaceFolderNode(String userName) {
        return (NodeRef)this.nodeService.getProperty(this.personService.getPerson(userName), ContentModel.PROP_HOMEFOLDER);
    }

    private NodeRef addTextContent(NodeRef spaceRef, String fileName, String textData) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, fileName);
        ChildAssociationRef association = this.nodeService.createNode(spaceRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)fileName), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, fileName);
        titledProps.put(ContentModel.PROP_DESCRIPTION, fileName);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        return content;
    }
}

