/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.util.HashMap;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@Category(value={LuceneTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class VirtualPreferenceServiceExtensionTest
extends VirtualizationIntegrationTest {
    private static final String DOCUMENTS_FAVOURITES_KEY = "org.alfresco.share.documents.favourites";
    private static final String EXT_DOCUMENTS_FAVOURITES = "org.alfresco.ext.documents.favourites.";
    private static final String FOLDERS_FAVOURITES_KEY = "org.alfresco.share.folders.favourites";
    private static final String EXT_FOLDERS_FAVOURITES = "org.alfresco.ext.folders.favourites.";
    private static final String CREATED_AT = ".createdAt";
    private PreferenceService preferenceService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.preferenceService = (PreferenceService)this.ctx.getBean("preferenceService", PreferenceService.class);
    }

    @Test
    public void testSetFavoritesPreferencesForDocuments() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, "testfile.txt");
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"testfile.txt"));
        this.nodeService.createNode(node2, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, properties);
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        this.nodeService.createNode(node2_1, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, properties);
        NodeRef testfile1 = this.nodeService.getChildByName(node2_1, ContentModel.ASSOC_CONTAINS, "testfile-1.txt");
        NodeRef physicalTestfile1 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "testfile-1.txt");
        TreeMap<String, String> preferences = new TreeMap<String, String>();
        String key = EXT_DOCUMENTS_FAVOURITES + testfile1.toString() + CREATED_AT;
        preferences.put(key, "CREATED");
        preferences.put(DOCUMENTS_FAVOURITES_KEY, testfile1.toString());
        this.preferenceService.setPreferences("admin", preferences);
        String preference = (String)((Object)this.preferenceService.getPreference("admin", DOCUMENTS_FAVOURITES_KEY));
        Assert.assertFalse((boolean)preference.contains(testfile1.toString()));
        Assert.assertTrue((boolean)preference.contains(physicalTestfile1.toString()));
        Assert.assertNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_DOCUMENTS_FAVOURITES + testfile1.toString() + CREATED_AT))));
        Assert.assertNotNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_DOCUMENTS_FAVOURITES + physicalTestfile1.toString() + CREATED_AT))));
        preferences = new TreeMap();
        key = EXT_DOCUMENTS_FAVOURITES + testfile1.toString() + CREATED_AT;
        preferences.put(key, null);
        preferences.put(DOCUMENTS_FAVOURITES_KEY, physicalTestfile1.toString());
        this.preferenceService.setPreferences("admin", preferences);
        preference = (String)((Object)this.preferenceService.getPreference("admin", DOCUMENTS_FAVOURITES_KEY));
        Assert.assertTrue((boolean)preference.isEmpty());
        Assert.assertNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_DOCUMENTS_FAVOURITES + testfile1.toString() + CREATED_AT))));
        Assert.assertNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_DOCUMENTS_FAVOURITES + physicalTestfile1.toString() + CREATED_AT))));
    }

    @Test
    public void testSetFavoritesPreferencesForFolders() throws Exception {
        NodeRef physicalFolder = this.createFolder(this.testRootFolder.getNodeRef(), "FOLDER").getChildRef();
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate6.json");
        NodeRef node1 = this.nodeService.getChildByName(virtualFolder, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)node1);
        this.prepareMocks("FOLDER", physicalFolder);
        try {
            NodeRef physicalFolderInVirtualContext = this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, "FOLDER");
            Assert.assertNotNull((Object)physicalFolderInVirtualContext);
            TreeMap<String, String> preferences = new TreeMap<String, String>();
            String key = EXT_FOLDERS_FAVOURITES + physicalFolderInVirtualContext.toString() + CREATED_AT;
            preferences.put(key, "CREATED");
            preferences.put(FOLDERS_FAVOURITES_KEY, physicalFolderInVirtualContext.toString());
            this.preferenceService.setPreferences("admin", preferences);
            String preference = (String)((Object)this.preferenceService.getPreference("admin", FOLDERS_FAVOURITES_KEY));
            Assert.assertFalse((boolean)preference.contains(physicalFolderInVirtualContext.toString()));
            Assert.assertTrue((boolean)preference.contains(physicalFolder.toString()));
            Assert.assertNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_FOLDERS_FAVOURITES + physicalFolderInVirtualContext.toString() + CREATED_AT))));
            Assert.assertNotNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_FOLDERS_FAVOURITES + physicalFolder.toString() + CREATED_AT))));
            preferences = new TreeMap();
            key = EXT_FOLDERS_FAVOURITES + physicalFolderInVirtualContext.toString() + CREATED_AT;
            preferences.put(key, null);
            preferences.put(FOLDERS_FAVOURITES_KEY, physicalFolder.toString());
            this.preferenceService.setPreferences("admin", preferences);
            preference = (String)((Object)this.preferenceService.getPreference("admin", FOLDERS_FAVOURITES_KEY));
            Assert.assertTrue((boolean)preference.isEmpty());
            Assert.assertNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_FOLDERS_FAVOURITES + physicalFolderInVirtualContext.toString() + CREATED_AT))));
            Assert.assertNull((Object)((String)((Object)this.preferenceService.getPreference("admin", EXT_FOLDERS_FAVOURITES + physicalFolder.toString() + CREATED_AT))));
        }
        finally {
            this.resetMocks();
        }
    }
}

