/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={OwnJVMTestsCategory.class})
public class TemporarySitesTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath:sites/test-" + TemporarySitesTest.class.getSimpleName() + "-context.xml");
    public static TemporaryNodes STATIC_TEST_SITES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)STATIC_TEST_SITES);
    public TemporarySites testSites = new TemporarySites(APP_CONTEXT_INIT);
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    @Rule
    public RuleChain nonStaticRules = RuleChain.outerRule((TestRule)this.runAsRule).around((TestRule)this.testSites);
    private static NamespaceService NAMESPACE_SERVICE;
    private static NodeService NODE_SERVICE;
    private static SiteService SITE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private SiteInfo testSite1;
    private SiteInfo testSite2;
    private TemporarySites.TestSiteAndMemberInfo testSiteWithMembers;

    @BeforeClass
    public static void initStaticData() throws Exception {
        NAMESPACE_SERVICE = (NamespaceService)APP_CONTEXT_INIT.getApplicationContext().getBean("namespaceService", NamespaceService.class);
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeService", NodeService.class);
        SITE_SERVICE = (SiteService)APP_CONTEXT_INIT.getApplicationContext().getBean("siteService", SiteService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
    }

    @Before
    public void createTestContent() {
        String guid = GUID.generate();
        this.testSite1 = this.testSites.createSite("sitePreset", "testSite1_" + guid, "t", "d", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName());
        QName subSiteType = QName.createQName((String)"testsite", (String)"testSubsite", (NamespacePrefixResolver)NAMESPACE_SERVICE);
        this.testSite2 = this.testSites.createSite("sitePreset", "testSite2_" + guid, "T", "D", SiteVisibility.PUBLIC, subSiteType, AuthenticationUtil.getAdminUserName());
        this.testSiteWithMembers = this.testSites.createTestSiteWithUserPerRole(GUID.generate(), "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName());
    }

    @Test
    public void ensureTestSitesWereCreatedOk() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteInfo recoveredSite1 = SITE_SERVICE.getSite(TemporarySitesTest.this.testSite1.getShortName());
                SiteInfo recoveredSite2 = SITE_SERVICE.getSite(TemporarySitesTest.this.testSite2.getShortName());
                Assert.assertNotNull((String)"Test site does not exist", (Object)recoveredSite1);
                Assert.assertNotNull((String)"Test site does not exist", (Object)recoveredSite2);
                Assert.assertEquals((String)"cm:title was wrong", (Object)"t", (Object)recoveredSite1.getTitle());
                Assert.assertEquals((String)"cm:description was wrong", (Object)"d", (Object)recoveredSite1.getDescription());
                Assert.assertEquals((String)"preset was wrong", (Object)"sitePreset", (Object)recoveredSite1.getSitePreset());
                Assert.assertEquals((String)"site visibility was wrong", (Object)SiteVisibility.PUBLIC, (Object)recoveredSite1.getVisibility());
                String[] stringArray = new String[]{TemporarySitesTest.this.testSite1.getShortName(), TemporarySitesTest.this.testSite2.getShortName()};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String siteShortName = stringArray[n2];
                    Assert.assertNotNull((String)"site had no doclib container node", (Object)SITE_SERVICE.getContainer(siteShortName, "documentLibrary"));
                    ++n2;
                }
                return null;
            }
        });
    }

    @Test
    public void ensureUsersWithShareRolesArePresentAndCorrect() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String shortName = ((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.siteInfo.getShortName();
                SiteInfo recoveredSite = SITE_SERVICE.getSite(shortName);
                Assert.assertNotNull((String)"Test site does not exist", (Object)recoveredSite);
                Assert.assertEquals((Object)"SiteManager", (Object)SITE_SERVICE.getMembersRole(shortName, ((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.siteManager));
                Assert.assertEquals((Object)"SiteCollaborator", (Object)SITE_SERVICE.getMembersRole(shortName, ((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.siteCollaborator));
                Assert.assertEquals((Object)"SiteContributor", (Object)SITE_SERVICE.getMembersRole(shortName, ((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.siteContributor));
                Assert.assertEquals((Object)"SiteConsumer", (Object)SITE_SERVICE.getMembersRole(shortName, ((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.siteConsumer));
                Assert.assertNotNull((Object)((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.doclib);
                Assert.assertTrue((String)"Site doclib was not pre-created.", (boolean)NODE_SERVICE.exists(((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.doclib));
                Assert.assertEquals((String)"Site doclib was in wrong place.", (Object)((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.siteInfo.getNodeRef(), (Object)NODE_SERVICE.getPrimaryParent(((TemporarySitesTest)TemporarySitesTest.this).testSiteWithMembers.doclib).getParentRef());
                return null;
            }
        });
    }
}

