/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import org.alfresco.repo.content.transform.AdminUiTransformerDebug;
import org.alfresco.repo.content.transform.LogEntries;
import org.alfresco.repo.content.transform.TransformerConfigMBean;
import org.alfresco.service.cmr.repository.MimetypeService;

public class TransformerConfigMBeanImpl
implements TransformerConfigMBean {
    private static final String NO_TRANSFORMATIONS_TO_REPORT = "No transformations to report";
    private AdminUiTransformerDebug transformerDebug;
    private MimetypeService mimetypeService;
    private LogEntries transformerLog;
    private LogEntries transformerDebugLog;

    public void setTransformerDebug(AdminUiTransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setTransformerLog(LogEntries transformerLog) {
        this.transformerLog = transformerLog;
    }

    public void setTransformerDebugLog(LogEntries transformerDebugLog) {
        this.transformerDebugLog = transformerDebugLog;
    }

    @Override
    public String[] getExtensionsAndMimetypes() {
        ArrayList<String> extensionsAndMimetypes = new ArrayList<String>();
        for (String mimetype : this.mimetypeService.getMimetypes(null)) {
            String extension = this.mimetypeService.getExtension(mimetype);
            extensionsAndMimetypes.add(String.valueOf(extension) + " - " + mimetype);
        }
        return extensionsAndMimetypes.toArray(new String[extensionsAndMimetypes.size()]);
    }

    @Override
    public String getTransformationsByExtension(String sourceExtension, String targetExtension) {
        try {
            return this.transformerDebug.transformationsByExtension(this.nullDefaultLowerParam(sourceExtension), this.nullDefaultLowerParam(targetExtension), true);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String[] getTransformationLog(int n) {
        String[] stringArray;
        String[] entries = this.transformerLog.getEntries(n);
        if (entries.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = NO_TRANSFORMATIONS_TO_REPORT;
        } else {
            stringArray = entries;
        }
        return stringArray;
    }

    @Override
    public String[] getTransformationDebugLog(int n) {
        String[] stringArray;
        String[] entries = this.transformerDebugLog.getEntries(n);
        if (entries.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = NO_TRANSFORMATIONS_TO_REPORT;
        } else {
            stringArray = entries;
        }
        return stringArray;
    }

    @Override
    public String testTransform(String sourceExtension, String targetExtension) {
        try {
            return this.transformerDebug.testTransform(sourceExtension, targetExtension);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String[] getTestFileExtensionsAndMimetypes() {
        return this.transformerDebug.getTestFileExtensionsAndMimetypes();
    }

    private String nullDefaultLowerParam(String parameter) {
        if ((parameter = this.nullDefaultParam(parameter)) != null) {
            parameter = parameter.toLowerCase();
        }
        return parameter;
    }

    private String nullDefaultParam(String parameter) {
        if ("String".equals(parameter) || "".equals(parameter) || parameter == null) {
            parameter = null;
        }
        return parameter;
    }

    @Override
    public String help() {
        return "getTransformationDebugLog(n)\n   Lists the latest entries in the transformation debug log.\n   - n the number of entries to include. If blank all available entries are listed\n\ngetTransformationLog(n)\n   Lists the latest entries in the transformation log.\n   - n the number of entries to include. If blank all available entries are listed\n\ngetExtensionsAndMimetypes()\n   Lists all configured mimetypes and the primary file extension\n\ntestTransform(sourceExtension, targetExtension, use)\n   Transforms a small test file from one mimetype to another and then shows the \n   debug of the transform, which would indicate if it was successful or even if \n   it was possible.\n   - sourceExtension used to identify the mimetype\n   - targetExtension used to identify the mimetype\n   - use or context in which to test the transformation (\"doclib\",\n     \"index\", \"webpreview\", \"syncRule\", \"asyncRule\"...) or blank for\n     the default.\n\ngetTransformationsByExtension(sourceExtension, targetExtension, use)\n   Lists all possible transformations sorted by source and then target mimetype\n   extension.\n   - sourceExtension to be checked. If blank all source mimetypes are included\n   - targetExtension to be checked. If blank all target mimetypes are included.\n   - use or context in which the transformation will be used (\"doclib\",\n     \"index\", \"webpreview\", \"syncRule\", \"asyncRule\"...) or blank for\n     the default.\n\ngetTestFileExtensionsAndMimetypes()\n   Lists the extensions of available test files";
    }
}

