/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.ModelInUseException;
import org.alfresco.repo.dictionary.ModelNotInUseException;
import org.alfresco.repo.dictionary.ModelValidator;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelException;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataIntegrityViolationException;

public class ModelValidatorImpl
implements ModelValidator {
    private static final Log logger = LogFactory.getLog(ModelValidatorImpl.class);
    private DictionaryDAO dictionaryDAO;
    private DictionaryService dictionaryService;
    private QNameDAO qnameDAO;
    private NamespaceService namespaceService;
    private TransactionService transactionService;
    private WorkflowService workflowService;
    private TenantService tenantService;
    private TenantAdminService tenantAdminService;
    private CustomModelService customModelService;
    private boolean enforceTenantInNamespace = false;

    public void setEnforceTenantInNamespace(boolean enforceTenantInNamespace) {
        this.enforceTenantInNamespace = enforceTenantInNamespace;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setCustomModelService(CustomModelService customModelService) {
        this.customModelService = customModelService;
    }

    private void checkCustomModelNamespace(M2Model model, String tenantDomain) {
        if (tenantDomain != null && !tenantDomain.equals("") && this.enforceTenantInNamespace) {
            for (M2Namespace namespace : model.getNamespaces()) {
                String namespaceURI = namespace.getUri();
                if (namespaceURI.indexOf(tenantDomain) != -1) continue;
                throw new DictionaryException("Namespace " + namespaceURI + " does not contain the tenant " + tenantDomain);
            }
        }
    }

    private boolean canDeleteModel(Collection<NamespaceDefinition> namespaceDefs, Collection<TypeDefinition> typeDefs, Collection<AspectDefinition> aspectDefs, Tenant tenant) {
        boolean canDelete = true;
        String tenantDomain = "for tenant [" + (tenant == null ? "" : tenant.getTenantDomain()) + "]";
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        if (workflowDefs.size() > 0 && namespaceDefs.size() > 0) {
            for (WorkflowDefinition workflowDef : workflowDefs) {
                String workflowDefName = workflowDef.getName();
                String workflowNamespaceURI = null;
                try {
                    workflowNamespaceURI = QName.createQName((String)BPMEngineRegistry.getLocalId(workflowDefName), (NamespacePrefixResolver)this.namespaceService).getNamespaceURI();
                }
                catch (NamespaceException ne) {
                    logger.warn((Object)("Skipped workflow when validating model delete - unknown namespace: " + (Object)((Object)ne)));
                    continue;
                }
                for (NamespaceDefinition namespaceDef : namespaceDefs) {
                    if (!workflowNamespaceURI.equals(namespaceDef.getUri())) continue;
                    logger.warn((Object)("Failed to validate model delete" + tenantDomain + " - found workflow process definition " + workflowDefName + " using model namespace '" + namespaceDef.getUri() + "'"));
                    canDelete = false;
                }
            }
        }
        for (TypeDefinition type : typeDefs) {
            try {
                this.validateDeleteClass(tenant, (ClassDefinition)type);
            }
            catch (ModelInUseException modelInUseException) {
                canDelete = false;
                break;
            }
            catch (ModelNotInUseException modelNotInUseException) {}
        }
        for (AspectDefinition aspect : aspectDefs) {
            try {
                this.validateDeleteClass(tenant, (ClassDefinition)aspect);
            }
            catch (ModelInUseException modelInUseException) {
                canDelete = false;
                break;
            }
            catch (ModelNotInUseException modelNotInUseException) {}
        }
        return canDelete;
    }

    private void validateDeleteClass(Tenant tenant, ClassDefinition classDef) {
        final QName className = classDef.getName();
        String tenantDomain = "for tenant [" + (tenant == null ? "" : tenant.getTenantDomain()) + "]";
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    if (ModelValidatorImpl.this.qnameDAO.getQName(className) != null) {
                        ModelValidatorImpl.this.qnameDAO.deleteQName(className);
                    }
                    throw new ModelNotInUseException("Class " + className + " not in use");
                }
                catch (DataIntegrityViolationException e) {
                    logger.debug((Object)e);
                    throw new ModelInUseException("Cannot delete model, class " + className + " is in use");
                }
            }
        }, false, true);
        for (WorkflowDefinition workflowDef : this.workflowService.getDefinitions()) {
            for (WorkflowTaskDefinition workflowTaskDef : this.workflowService.getTaskDefinitions(workflowDef.getId())) {
                TypeDefinition workflowTypeDef = workflowTaskDef.metadata;
                if (!workflowTypeDef.getName().equals((Object)className)) continue;
                throw new AlfrescoRuntimeException("Failed to validate model delete" + tenantDomain + " - found task definition in workflow " + workflowDef.getName() + " with " + "TYPE" + " '" + className + "'");
            }
        }
    }

    private void validateDeleteProperty(QName modelName, QName propertyQName, boolean sharedModel) {
        PropertyDefinition prop;
        String tenantDomain = "";
        if (sharedModel) {
            tenantDomain = " for tenant [" + this.tenantService.getCurrentUserDomain() + "]";
        }
        if ((prop = this.dictionaryDAO.getProperty(propertyQName)) == null || !prop.getName().equals((Object)propertyQName) || !prop.getModel().getName().equals((Object)modelName)) {
            throw new AlfrescoRuntimeException("Cannot delete model " + modelName + " in tenant " + tenantDomain + " - property definition '" + propertyQName + "' not defined in model '" + modelName + "'");
        }
        this.validateDeleteProperty(tenantDomain, prop);
    }

    private void validateDeleteProperty(final String tenantDomain, PropertyDefinition propDef) {
        final QName propName = propDef.getName();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                return (Void)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        try {
                            if (ModelValidatorImpl.this.qnameDAO.getQName(propName) != null) {
                                ModelValidatorImpl.this.qnameDAO.deleteQName(propName);
                            }
                        }
                        catch (DataIntegrityViolationException e) {
                            logger.debug((Object)e);
                            throw new ModelInUseException("Failed to validate property delete, property " + propName + " is in use");
                        }
                        return null;
                    }
                }, (String)tenantDomain);
            }
        }, false, true);
    }

    private void validateDeleteConstraint(CompiledModel compiledModel, QName constraintName, boolean sharedModel) {
        String tenantDomain = "";
        if (sharedModel) {
            tenantDomain = " for tenant [" + this.tenantService.getCurrentUserDomain() + "]";
        }
        HashSet<QName> referencedBy = new HashSet<QName>(0);
        Collection allModels = this.dictionaryDAO.getModels();
        for (QName model : allModels) {
            Collection propDefs = null;
            propDefs = compiledModel.getModelDefinition().getName().equals((Object)model) ? compiledModel.getProperties() : this.dictionaryDAO.getProperties(model);
            for (PropertyDefinition propDef : propDefs) {
                for (ConstraintDefinition conDef : propDef.getConstraints()) {
                    if (!constraintName.equals((Object)conDef.getRef())) continue;
                    referencedBy.add(conDef.getName());
                }
            }
        }
        if (referencedBy.size() == 1) {
            throw new AlfrescoRuntimeException("Failed to validate constraint delete" + tenantDomain + " - constraint definition '" + constraintName + "' is being referenced by '" + referencedBy.toArray()[0] + "' property constraint");
        }
        if (referencedBy.size() > 1) {
            throw new AlfrescoRuntimeException("Failed to validate constraint delete" + tenantDomain + " - constraint definition '" + constraintName + "' is being referenced by " + referencedBy.size() + " property constraints");
        }
    }

    @Override
    public boolean canDeleteModel(QName modelName) {
        boolean canDeleteModel;
        block5: {
            canDeleteModel = true;
            try {
                final Collection namespaceDefs = this.dictionaryDAO.getNamespaces(modelName);
                final Collection typeDefs = this.dictionaryDAO.getTypes(modelName);
                final Collection aspectDefs = this.dictionaryDAO.getAspects(modelName);
                if (!(canDeleteModel &= this.canDeleteModel(namespaceDefs, typeDefs, aspectDefs, null)) || !this.tenantService.isEnabled() || this.tenantService.isTenantUser()) break block5;
                List<Tenant> tenants = this.tenantAdminService.getAllTenants();
                for (final Tenant tenant : tenants) {
                    if (canDeleteModel &= ((Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

                        public Boolean doWork() {
                            boolean canDelete = ModelValidatorImpl.this.canDeleteModel(namespaceDefs, typeDefs, aspectDefs, tenant);
                            return canDelete;
                        }
                    }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenant.getTenantDomain()))).booleanValue()) {
                        continue;
                    }
                    break;
                }
            }
            catch (DictionaryException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dictionary model '" + modelName + "' does not exist ... skip delete validation : " + (Object)((Object)e)));
                }
                canDeleteModel = true;
            }
        }
        return canDeleteModel;
    }

    @Override
    public void validateModel(CompiledModel compiledModel) {
        ModelDefinition modelDef = compiledModel.getModelDefinition();
        QName modelName = modelDef.getName();
        M2Model model = compiledModel.getM2Model();
        this.checkCustomModelNamespace(model, TenantUtil.getCurrentDomain());
        List modelDiffs = this.dictionaryDAO.diffModel(model);
        for (M2ModelDiff modelDiff : modelDiffs) {
            ModelDefinition importedModel;
            if (modelDiff.getDiffType().equals("deleted")) {
                if (modelDiff.getElementType().equals("PROPERTY")) {
                    this.validateDeleteProperty(modelName, modelDiff.getElementName(), false);
                } else if (modelDiff.getElementType().equals("TYPE_CONSTRAINT")) {
                    this.validateDeleteConstraint(compiledModel, modelDiff.getElementName(), false);
                } else if (!modelDiff.getElementType().equals("TYPE_NAMESPACE")) {
                    throw new AlfrescoRuntimeException("Failed to validate model update - found deleted " + modelDiff.getElementType() + " '" + modelDiff.getElementName() + "'");
                }
            }
            if (modelDiff.getDiffType().equals("updated")) {
                throw new AlfrescoRuntimeException("Failed to validate model update - found non-incrementally updated " + modelDiff.getElementType() + " '" + modelDiff.getElementName() + "'");
            }
            if (!modelDiff.getDiffType().equals("created") || !modelDiff.getElementType().equals("TYPE_NAMESPACE") || (importedModel = this.dictionaryService.getModelByNamespaceUri(modelDiff.getNamespaceDefinition().getUri())) == null || model.getNamespaces().isEmpty()) continue;
            this.checkCircularDependency(importedModel, model, importedModel.getName().getLocalName());
        }
    }

    private void checkCircularDependency(ModelDefinition model, M2Model existingModel, String parentPrefixedName) throws AlfrescoRuntimeException {
        for (NamespaceDefinition importedNamespace : model.getImportedNamespaces()) {
            ModelDefinition md = null;
            md = this.dictionaryService.getModelByNamespaceUri(importedNamespace.getUri());
            if (md == null) continue;
            if (existingModel.getNamespace(importedNamespace.getUri()) != null) {
                throw new AlfrescoRuntimeException("Failed to validate model update - found circular dependency. You can't set parent " + parentPrefixedName + " as it's model already depends on " + existingModel.getName());
            }
            this.checkCircularDependency(md, existingModel, parentPrefixedName);
        }
    }

    @Override
    public void validateModelNamespacePrefix(NodeRef modelNodeRef) {
        String errorMsg = "Namespace error: ";
        try {
            M2Model m2Model = this.customModelService.getM2Model(modelNodeRef);
            if (m2Model != null) {
                errorMsg = "Duplicate namespace prefix: ";
                this.customModelService.validateModelNamespacePrefix(modelNodeRef);
            }
        }
        catch (CustomModelException ce) {
            logger.error((Object)(String.valueOf(errorMsg) + (Object)((Object)ce)));
            throw ce;
        }
    }
}

